/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.navigation.GotoImplementationHandler;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.actions.ListTemplatesAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

public final class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(@NotNull List<? extends IntentionAction> actions, @NonNls @NotNull String text) {
        for (IntentionAction intentionAction : actions) {
            String s = intentionAction.getText();
            if (!s.equals(text)) continue;
            return intentionAction;
        }
        return null;
    }

    @Nullable
    public static IntentionAction findIntentionByPartialText(@NotNull List<? extends IntentionAction> actions, @NonNls @NotNull String text) {
        for (IntentionAction intentionAction : actions) {
            String s = intentionAction.getText();
            if (!s.contains(text)) continue;
            return intentionAction;
        }
        return null;
    }

    @TestOnly
    public static void doIntentionTest(CodeInsightTestFixture fixture, @NonNls String file2, @NonNls String actionText) {
        String extension = FileUtilRt.getExtension((String)file2);
        file2 = FileUtilRt.getNameWithoutExtension((String)file2);
        if (extension.isEmpty()) {
            extension = "xml";
        }
        CodeInsightTestUtil.doIntentionTest(fixture, actionText, file2 + "." + extension, file2 + "_after." + extension);
    }

    @TestOnly
    public static void doIntentionTest(@NotNull CodeInsightTestFixture fixture, @NonNls String action, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        List<IntentionAction> availableIntentions = fixture.getAvailableIntentions();
        IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(availableIntentions, action);
        if (intentionAction == null) {
            PsiElement element = fixture.getFile().findElementAt(fixture.getCaretOffset());
            Assert.fail((String)("Action not found: " + action + " in place: " + element + " among " + availableIntentions));
        }
        fixture.launchAction(intentionAction);
        fixture.checkResultByFile(after2, false);
    }

    public static void doWordSelectionTest(@NotNull CodeInsightTestFixture fixture, @TestDataFile @NotNull String before, String ... after2) {
        EdtTestUtil.runInEdtAndWait(() -> {
            assert (after2 != null && after2.length > 0);
            fixture.configureByFile(before);
            for (String file2 : after2) {
                fixture.performEditorAction("EditorSelectWord");
                fixture.checkResultByFile(file2, false);
            }
        });
    }

    public static void doWordSelectionTestOnDirectory(@NotNull CodeInsightTestFixture fixture, @TestDataFile @NotNull String directoryName, @NotNull String filesExtension) {
        EdtTestUtil.runInEdtAndWait(() -> {
            fixture.copyDirectoryToProject(directoryName, directoryName);
            fixture.configureByFile(directoryName + "/before." + filesExtension);
            int i2 = 1;
            while (true) {
                String fileName = directoryName + "/after" + i2 + "." + filesExtension;
                if (!new File(fixture.getTestDataPath() + "/" + fileName).exists()) break;
                fixture.performEditorAction("EditorSelectWord");
                fixture.checkResultByFile(fileName);
                ++i2;
            }
            junit.framework.Assert.assertTrue((String)"At least one 'after'-file required", (i2 > 1 ? 1 : 0) != 0);
        });
    }

    public static void doSurroundWithTest(@NotNull CodeInsightTestFixture fixture, @NotNull Surrounder surrounder, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> SurroundWithHandler.invoke((Project)fixture.getProject(), (Editor)fixture.getEditor(), (PsiFile)fixture.getFile(), (Surrounder)surrounder));
        fixture.checkResultByFile(after2, false);
    }

    public static void doLiveTemplateTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        new ListTemplatesAction().actionPerformedImpl(fixture.getProject(), fixture.getEditor());
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)fixture.getEditor());
        assert (lookup != null);
        lookup.finishLookup('\n');
        fixture.checkResultByFile(after2, false);
    }

    public static void doSmartEnterTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        List processors = SmartEnterProcessors.INSTANCE.allForLanguage(fixture.getFile().getLanguage());
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> {
            Editor editor = fixture.getEditor();
            for (SmartEnterProcessor processor : processors) {
                processor.process(fixture.getProject(), editor, fixture.getFile());
            }
        });
        fixture.checkResultByFile(after2, false);
    }

    public static void doFormattingTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> CodeStyleManager.getInstance((Project)fixture.getProject()).reformat((PsiElement)fixture.getFile()));
        fixture.checkResultByFile(after2, false);
    }

    @TestOnly
    public static void doInlineRename(VariableInplaceRenameHandler handler, String newName, CodeInsightTestFixture fixture) {
        CodeInsightTestUtil.doInlineRename(handler, newName, fixture.getEditor(), fixture.getElementAtCaret());
    }

    public static void doInlineRename(VariableInplaceRenameHandler handler, String newName, @NotNull Editor editor, PsiElement elementAtCaret) {
        if (!CodeInsightTestUtil.tryInlineRename(handler, newName, editor, elementAtCaret)) {
            Assert.fail((String)"Inline refactoring wasn't performed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static boolean tryInlineRename(VariableInplaceRenameHandler handler, String newName, @NotNull Editor editor, PsiElement elementAtCaret) {
        Project project2 = editor.getProject();
        Disposable disposable = Disposer.newDisposable();
        try {
            TemplateState state;
            TemplateManagerImpl.setTemplateTesting((Disposable)disposable);
            InplaceRefactoring renamer = handler.doRename(elementAtCaret, editor, DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            if ((state = TemplateManagerImpl.getTemplateState((Editor)editor)) == null) {
                if (renamer != null) {
                    renamer.finish(false);
                }
                boolean bl = false;
                return bl;
            }
            TextRange range = state.getCurrentVariableRange();
            assert (range != null);
            Editor finalEditor = editor;
            WriteCommandAction.writeCommandAction((Project)project2).run(() -> finalEditor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newName));
            state = TemplateManagerImpl.getTemplateState((Editor)editor);
            assert (state != null);
            state.gotoEnd(false);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        return true;
    }

    @TestOnly
    public static void doInlineRenameTest(VariableInplaceRenameHandler handler, String file2, String extension, String newName, CodeInsightTestFixture fixture) {
        fixture.configureByFile(file2 + "." + extension);
        CodeInsightTestUtil.doInlineRename(handler, newName, fixture);
        fixture.checkResultByFile(file2 + "_after." + extension);
    }

    public static void doActionTest(AnAction action, String file2, CodeInsightTestFixture fixture) {
        String extension = FileUtilRt.getExtension((String)file2);
        String name = FileUtilRt.getNameWithoutExtension((String)file2);
        fixture.configureByFile(file2);
        fixture.testAction(action);
        fixture.checkResultByFile(name + "_after." + extension);
    }

    public static void addTemplate(final Template template, Disposable parentDisposable) {
        final TemplateSettings settings = TemplateSettings.getInstance();
        settings.addTemplate(template);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                settings.removeTemplate(template);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @TestOnly
    public static GotoTargetHandler.GotoData gotoImplementation(Editor editor, PsiFile file2) {
        GotoTargetHandler.GotoData data = new GotoImplementationHandler().getSourceAndTargetElements(editor, file2);
        data.initPresentations();
        if (data.listUpdaterTask != null) {
            JBList list = new JBList();
            CollectionListModel model = new CollectionListModel(new ArrayList());
            list.setModel((ListModel)new NameFilteringListModel((ListModel)model, Functions.identity(), Conditions.alwaysFalse(), String::new));
            JBPopup popup = new ComponentPopupBuilderImpl((JComponent)list, null).createPopup();
            data.listUpdaterTask.init(popup, (GenericListComponentUpdater)new JBListUpdater(list), new Ref());
            data.listUpdaterTask.queue();
            try {
                while (!data.listUpdaterTask.isFinished()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
            }
            finally {
                Disposer.dispose((Disposable)popup);
            }
        }
        return data;
    }

    @NotNull
    public static <In, Out> List<Annotation> runExternalAnnotator(@NotNull ExternalAnnotator<In, Out> annotator, @NotNull PsiFile psiFile, In in, @NotNull Consumer<? super Out> resultChecker) {
        Object result2 = annotator.doAnnotate(in);
        resultChecker.accept(result2);
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(psiFile), false);
        ApplicationManager.getApplication().runReadAction(() -> annotationHolder.applyExternalAnnotatorWithContext(psiFile, annotator, result2));
        annotationHolder.assertAllAnnotationsCreated();
        return ContainerUtil.immutableList((List)annotationHolder);
    }

    @NotNull
    public static List<Annotation> testAnnotator(@NotNull Annotator annotator, PsiElement ... elements) {
        PsiFile file2 = elements[0].getContainingFile();
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2), false);
        for (PsiElement element : elements) {
            annotationHolder.runAnnotatorWithContext(element, annotator);
        }
        annotationHolder.assertAllAnnotationsCreated();
        return ContainerUtil.immutableList((List)annotationHolder);
    }
}

