/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.builders.EmptyModuleFixtureBuilder;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CodeInsightFixtureTestCase<T extends ModuleFixtureBuilder<?>>
extends UsefulTestCase {
    protected CodeInsightTestFixture myFixture;
    protected Module myModule;

    @Override
    protected final void runBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        TestApplicationManager.getInstance();
        super.runBare(testRunnable);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String name = ((Object)((Object)this)).getClass().getName() + "." + this.getName();
        TestFixtureBuilder<IdeaProjectTestFixture> projectBuilder = IdeaTestFixtureFactory.getFixtureFactory().createFixtureBuilder(name);
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(projectBuilder.getFixture());
        T moduleFixtureBuilder = projectBuilder.addModule(this.getModuleBuilderClass());
        moduleFixtureBuilder.addSourceContentRoot(this.myFixture.getTempDirPath());
        this.tuneFixture(moduleFixtureBuilder);
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myFixture.setUp();
        this.myModule = moduleFixtureBuilder.getFixture().getModule();
    }

    protected Class<T> getModuleBuilderClass() {
        return EmptyModuleFixtureBuilder.class;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myModule = null;
        try {
            this.myFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myFixture = null;
            super.tearDown();
        }
    }

    protected void tuneFixture(T moduleBuilder) {
    }

    @NonNls
    protected String getBasePath() {
        return "";
    }

    @NonNls
    protected final String getTestDataPath() {
        String path = this.isCommunity() ? PlatformTestUtil.getCommunityPath() : IdeaTestExecutionPolicy.getHomePathWithPolicy();
        return path.replace(File.separatorChar, '/') + this.getBasePath();
    }

    protected boolean isCommunity() {
        return false;
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected Editor getEditor() {
        return this.myFixture.getEditor();
    }

    protected PsiFile getFile() {
        return this.myFixture.getFile();
    }
}

