/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public abstract class BasePlatformTestCase
extends UsefulTestCase {
    protected CodeInsightTestFixture myFixture;

    @Override
    @NotNull
    public Disposable getTestRootDisposable() {
        return this.myFixture == null ? super.getTestRootDisposable() : this.myFixture.getTestRootDisposable();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IdeaTestFixtureFactory factory = IdeaTestFixtureFactory.getFixtureFactory();
        TestFixtureBuilder<IdeaProjectTestFixture> fixtureBuilder = factory.createLightFixtureBuilder(this.getProjectDescriptor(), this.getTestName(false));
        IdeaProjectTestFixture fixture = fixtureBuilder.getFixture();
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, this.createTempDirTestFixture());
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myFixture.setUp();
    }

    protected TempDirTestFixture createTempDirTestFixture() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        return policy != null ? policy.createTempDirTestFixture() : new LightTempDirTestFixtureImpl(true);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myFixture = null;
            super.tearDown();
        }
    }

    protected String getBasePath() {
        return "";
    }

    protected LightProjectDescriptor getProjectDescriptor() {
        return null;
    }

    protected String getTestDataPath() {
        String path = this.isCommunity() ? PlatformTestUtil.getCommunityPath() : IdeaTestExecutionPolicy.getHomePathWithPolicy();
        return StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (String)"/") + "/" + StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)this.getBasePath()), (String)"/");
    }

    protected boolean isCommunity() {
        return false;
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (this.isWriteActionRequired()) {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> super.runTestRunnable(testRunnable));
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    protected boolean isWriteActionRequired() {
        return false;
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    protected PsiFile createLightFile(FileType fileType, String text) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("a." + fileType.getDefaultExtension(), fileType, (CharSequence)text);
    }

    public PsiFile createLightFile(String fileName, Language language, String text) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, language, (CharSequence)text, false, true);
    }

    @NotNull
    protected Module getModule() {
        return this.myFixture.getModule();
    }
}

