/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import java.net.URL;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@TestOnly
@ApiStatus.Internal
public final class PlatformPrefix {
    private static final String[] PREFIX_CANDIDATES = new String[]{"AndroidStudio", "Idea"};
    private static boolean ourPlatformPrefixInitialized;

    private PlatformPrefix() {
    }

    public static void autodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        if (System.getProperty("idea.platform.prefix") != null) {
            ourPlatformPrefixInitialized = true;
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            Object markerPath = candidate == null ? "idea/ApplicationInfo.xml" : "META-INF/" + candidate + "Plugin.xml";
            URL resource = PlatformPrefix.class.getClassLoader().getResource((String)markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            PlatformPrefix.setPlatformPrefix(candidate);
            break;
        }
    }

    private static void setPlatformPrefix(@NotNull String prefix) {
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }
}

