/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.util.MemoryDumpHelper;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a8\u0006\u0003"}, d2={"publishHeapDump", "", "fileNamePrefix", "intellij.platform.testFramework.common"})
public final class DumpKt {
    @TestOnly
    @NotNull
    public static final String publishHeapDump(@NotNull String fileNamePrefix) {
        String uuid = StringsKt.substring((String)UUID.randomUUID().toString(), (IntRange)new IntRange(1, 4));
        String fileName = fileNamePrefix + "-" + uuid + ".hprof.zip";
        String[] stringArray = new String[]{fileName};
        Path dumpFile = Paths.get(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), stringArray);
        try {
            Files.deleteIfExists(dumpFile);
            MemoryDumpHelper.captureMemoryDumpZipped((Path)dumpFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dumpPath = ((Object)dumpFile.toAbsolutePath()).toString();
        System.out.println((Object)("##teamcity[publishArtifacts '" + dumpPath + "']"));
        return dumpPath;
    }
}

