/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.codeInsight.daemon.DaemonAnalyzerTestCase;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.codeInsight.hierarchy.HierarchyViewTestFixture;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyViewTestBase
extends DaemonAnalyzerTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String groovyJar = PathManager.getJarPathForClass(GroovyObject.class);
        if (groovyJar != null) {
            VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{groovyJar});
        }
    }

    protected abstract String getBasePath();

    protected void doHierarchyTest(@NotNull Supplier<? extends HierarchyTreeStructure> treeStructure, @Nullable Comparator<? super NodeDescriptor<?>> comparator, String ... fileNames) throws IOException {
        this.configure(fileNames);
        String verificationFilePath = this.getTestDataPath() + "/" + this.getBasePath() + "/verification.xml";
        HierarchyViewTestFixture.doHierarchyTest(treeStructure.get(), comparator, new File(verificationFilePath));
    }

    private void configure(String @NotNull [] fileNames) {
        String[] relFilePaths = new String[fileNames.length];
        for (int i2 = 0; i2 < fileNames.length; ++i2) {
            relFilePaths[i2] = "/" + this.getBasePath() + "/" + fileNames[i2];
        }
        this.configureByFiles(null, relFilePaths);
        ExpectedHighlightingData expectedHighlightingData = new ExpectedHighlightingData(this.myEditor.getDocument(), false, false, false);
        this.checkHighlighting(expectedHighlightingData);
    }
}

