/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath) {
        return VfsTestUtil.createFile(root, relativePath, (byte[])null);
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, @Nullable String text) {
        try {
            return VfsTestUtil.createFileOrDir(root, relativePath, text == null ? null : VfsUtil.toByteArray((VirtualFile)root, (String)text), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, byte @Nullable [] data) {
        return VfsTestUtil.createFileOrDir(root, relativePath, data, false);
    }

    @NotNull
    public static VirtualFile createDir(@NotNull VirtualFile root, @NotNull String relativePath) {
        return VfsTestUtil.createFileOrDir(root, relativePath, null, true);
    }

    @NotNull
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, byte @Nullable [] data, boolean dir) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile file2;
                VirtualFile parent = root;
                for (String name : StringUtil.tokenize((String)PathUtil.getParentPath((String)relativePath), (String)"/")) {
                    VirtualFile child = parent.findChild(name);
                    if (child == null || !child.isValid()) {
                        child = parent.createChildDirectory(VfsTestUtil.class, name);
                    }
                    parent = child;
                }
                parent.getChildren();
                String name = PathUtil.getFileName((String)relativePath);
                if (dir) {
                    file2 = parent.createChildDirectory(VfsTestUtil.class, name);
                } else {
                    FileDocumentManager manager = FileDocumentManager.getInstance();
                    file2 = parent.findChild(name);
                    if (file2 == null) {
                        file2 = parent.createChildData(VfsTestUtil.class, name);
                    } else {
                        Document document = manager.getCachedDocument(file2);
                        if (document != null) {
                            manager.saveDocument(document);
                        }
                    }
                    if (data != null) {
                        file2.setBinaryContent(data);
                    }
                    manager.reloadFiles(new VirtualFile[]{file2});
                }
                return file2;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(@NotNull VirtualFile file2) {
        try {
            WriteAction.runAndWait(() -> file2.delete((Object)file2));
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    public static void clearContent(@NotNull VirtualFile file2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VfsUtil.saveText((VirtualFile)file2, (String)"");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void overwriteTestData(@NotNull String filePath, @NotNull String actual) {
        VfsTestUtil.overwriteTestData(filePath, actual, false);
    }

    public static void overwriteTestData(@NotNull String filePath, @NotNull String actual, boolean preserveSpaces) {
        try {
            File file2 = new File(filePath);
            if (preserveSpaces) {
                try {
                    actual = VfsTestUtil.preserveSpacesFromFile(file2, actual);
                }
                catch (Throwable e) {
                    System.err.println("Failed to preserve spaces: " + e.getMessage());
                }
            }
            FileUtil.writeToFile((File)file2, (String)actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String preserveSpacesFromFile(@NotNull File file2, @NotNull String actual) throws IOException {
        int trail;
        int lead;
        if (!file2.exists()) {
            return actual;
        }
        String existing = FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8);
        int eLen = existing.length();
        for (lead = 0; lead < eLen && Character.isWhitespace(existing.charAt(lead)); ++lead) {
        }
        if (lead != eLen) {
            for (trail = eLen; trail > 0 && Character.isWhitespace(existing.charAt(trail - 1)); --trail) {
            }
        }
        actual = existing.substring(0, lead) + ((String)actual).trim() + existing.substring(trail, eLen);
        return actual;
    }

    @NotNull
    public static VirtualFile findFileByCaseSensitivePath(@NotNull String absolutePath) {
        String vfsPath = FileUtil.toSystemIndependentName((String)absolutePath);
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(vfsPath);
        Assert.assertNotNull((String)("file " + absolutePath + " not found"), (Object)vFile);
        String realVfsPath = vFile.getPath();
        if (!vFile.isCaseSensitive() && !vfsPath.equals(realVfsPath) && vfsPath.equalsIgnoreCase(realVfsPath)) {
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + vfsPath + "\nreal path " + realVfsPath));
        }
        return vFile;
    }

    public static void assertFilePathEndsWithCaseSensitivePath(@NotNull VirtualFile file2, @NotNull String suffixPath) {
        String vfsSuffixPath = FileUtil.toSystemIndependentName((String)suffixPath);
        String vfsPath = file2.getPath();
        if (!file2.isCaseSensitive() && !vfsPath.endsWith(vfsSuffixPath) && StringUtil.endsWithIgnoreCase((String)vfsPath, (String)vfsSuffixPath)) {
            String realSuffixPath = vfsPath.substring(vfsPath.length() - vfsSuffixPath.length());
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + suffixPath + "\nreal path " + realSuffixPath));
        }
    }

    @NotNull
    public static List<VFileEvent> getEvents(@NotNull Runnable action) {
        final List<VFileEvent> allEvents = Collections.synchronizedList(new ArrayList());
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                allEvents.addAll(events);
            }
        });
        try {
            action.run();
        }
        finally {
            connection.disconnect();
        }
        return allEvents;
    }

    @NotNull
    public static List<String> print(@NotNull List<? extends VFileEvent> events) {
        return ContainerUtil.map(events, VfsTestUtil::print);
    }

    private static String print(VFileEvent e) {
        int type = 63;
        if (e instanceof VFileCreateEvent) {
            type = 67;
        } else if (e instanceof VFileDeleteEvent) {
            type = 68;
        } else if (e instanceof VFileContentChangeEvent) {
            type = 85;
        } else if (e instanceof VFilePropertyChangeEvent) {
            type = 80;
        }
        return (char)type + " : " + e.getPath();
    }
}

