/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.analytics.NullAndroidStudioAnalytics;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.GlobalState;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UITestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.common.Cleanup;
import com.intellij.testFramework.common.TestApplicationKt;
import com.intellij.testFramework.common.TestEnvironmentKt;
import com.intellij.testFramework.common.ThreadUtil;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.ui.CoreIconManager;
import com.intellij.ui.IconManager;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class UsefulTestCase
extends TestCase {
    @ApiStatus.Internal
    public static final boolean IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
    @ApiStatus.Internal
    public static final boolean IS_UNDER_SAFE_PUSH = IS_UNDER_TEAMCITY && "true".equals(System.getenv("SAFE_PUSH"));
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
    private static final String ORIGINAL_TEMP_DIR = FileUtilRt.getTempDirectory();
    private static final ObjectIntMap<String> TOTAL_SETUP_COST_MILLIS = new ObjectIntHashMap();
    private static final ObjectIntMap<String> TOTAL_SETUP_COUNT = new ObjectIntHashMap();
    private static final ObjectIntMap<String> TOTAL_TEARDOWN_COST_MILLIS = new ObjectIntHashMap();
    private static final ObjectIntMap<String> TOTAL_TEARDOWN_COUNT = new ObjectIntHashMap();
    protected static final Logger LOG = Logger.getInstance(UsefulTestCase.class);
    @Nullable
    private Disposable myTestRootDisposable;
    @Nullable
    private List<Path> myPathsToKeep;
    @Nullable
    private Path myTempDir;
    private static final CodeInsightSettings defaultSettings = new CodeInsightSettings();
    @Rule
    @NotNull
    public TestRule runBareTestRule = (base, description) -> new Statement(){

        public void evaluate() throws Throwable {
            String name = description.getMethodName();
            name = StringUtil.notNullize((String)StringUtil.substringBefore((String)name, (String)"["), (String)name);
            UsefulTestCase.this.setName(name);
            UsefulTestCase.this.checkShouldRunTest();
            UsefulTestCase.this.runBare((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> ((Statement)base).evaluate()));
        }
    };
    private List<Throwable> mySuppressedExceptions;

    @NotNull
    protected <R extends TestRule> R asOuterRule(@NotNull R rule) {
        this.runBareTestRule = RuleChain.outerRule(rule).around(this.runBareTestRule);
        return rule;
    }

    protected void addSuppressedException(@NotNull Throwable e) {
        SmartList list = this.mySuppressedExceptions;
        if (list == null) {
            this.mySuppressedExceptions = list = new SmartList();
        }
        list.add((Throwable)e);
    }

    public UsefulTestCase() {
    }

    public UsefulTestCase(@NotNull String name) {
        super(name);
    }

    protected void checkShouldRunTest() throws AssumptionViolatedException {
        Assume.assumeTrue((String)"skipped: shouldRunTest() returned false", (boolean)this.shouldRunTest());
    }

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        GlobalState.checkSystemStreams();
        this.setupTempDir();
        AndroidStudioAnalytics.initialize((AndroidStudioAnalytics)new NullAndroidStudioAnalytics());
        boolean isStressTest = this.isStressTest();
        ApplicationManagerEx.setInStressTest((boolean)isStressTest);
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        Disposer.setDebugMode((!isStressTest ? 1 : 0) != 0);
        if (this.isIconRequired()) {
            try {
                IconManager.activate((IconManager)new CoreIconManager());
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final void setupTempDir() throws IOException {
        if (this.myTempDir == null && this.shouldContainTempFiles()) {
            this.myTempDir = this.createGlobalTempDirectory();
        }
    }

    @ApiStatus.Internal
    @NotNull
    Path createGlobalTempDirectory() throws IOException {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        String testName2 = null;
        if (policy != null) {
            testName2 = policy.getPerTestTempDirName();
        }
        if (testName2 == null) {
            testName2 = FileUtil.sanitizeFileName((String)this.getTestName(true));
        }
        Path result2 = TemporaryDirectory.generateTemporaryPath(TEMP_DIR_MARKER + testName2);
        Files.createDirectories(result2, new FileAttribute[0]);
        FileUtil.resetCanonicalTempPathCache((String)result2.toString());
        return result2;
    }

    @ApiStatus.Internal
    void removeGlobalTempDirectory(@NotNull Path dir) throws Exception {
        if (this.myPathsToKeep == null || this.myPathsToKeep.isEmpty()) {
            PathKt.delete((Path)dir);
        } else {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
                for (Path file2 : directoryStream) {
                    if (this.shouldKeepTmpFile(file2)) continue;
                    FileUtil.delete((Path)file2);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
    }

    protected boolean isIconRequired() {
        return false;
    }

    protected void tearDown() throws Exception {
        new RunAll(() -> {
            if (this.isIconRequired()) {
                IconManager.deactivate();
                IconLoader.clearCacheInTests();
            }
        }, () -> this.disposeRootDisposable(), () -> GlobalState.checkSystemStreams(), () -> Cleanup.cleanupSwingDataStructures(), () -> Disposer.setDebugMode((boolean)true), () -> {
            if (this.myTempDir != null) {
                FileUtil.resetCanonicalTempPathCache((String)ORIGINAL_TEMP_DIR);
                try {
                    this.removeGlobalTempDirectory(this.myTempDir);
                }
                catch (Throwable e) {
                    UsefulTestCase.printThreadDump();
                    throw e;
                }
            }
        }, () -> UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS), () -> UsefulTestCase.clearFields((Object)this)).run(this.mySuppressedExceptions);
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull Path file2) {
        if (this.myPathsToKeep == null) {
            this.myPathsToKeep = new ArrayList<Path>();
        }
        this.myPathsToKeep.add(file2.toAbsolutePath());
    }

    private boolean shouldKeepTmpFile(@NotNull Path file2) {
        if (this.myPathsToKeep == null || this.myPathsToKeep.isEmpty()) {
            return false;
        }
        for (Path pathToKeep : this.myPathsToKeep) {
            if (!file2.equals(pathToKeep)) continue;
            return true;
        }
        return false;
    }

    static void doCheckForSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(() -> {
            try {
                UsefulTestCase.checkCodeInsightSettingsNotOverwritten(settings);
            }
            catch (AssertionError error2) {
                UsefulTestCase.restoreCodeInsightSettingsToAvoidInducedErrors(settings);
                throw error2;
            }
        }, () -> {
            currentCodeStyleSettings.getIndentOptions(FileTypeManager.getInstance().getStdFileType("JAVA"));
            try {
                UsefulTestCase.checkCodeStyleSettingsEqual(oldCodeStyleSettings, currentCodeStyleSettings);
            }
            finally {
                currentCodeStyleSettings.clearCodeStyleSettings();
            }
        }).run();
    }

    private static void restoreCodeInsightSettingsToAvoidInducedErrors(@NotNull CodeInsightSettings settings) {
        CodeInsightSettings clean = new CodeInsightSettings();
        for (Field field : clean.getClass().getFields()) {
            try {
                ReflectionUtil.copyFieldValue((Object)clean, (Object)settings, (Field)field);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable = this.myTestRootDisposable;
        if (disposable == null) {
            this.myTestRootDisposable = disposable = new TestDisposable();
        }
        return disposable;
    }

    @Deprecated
    protected final void runTest() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Use runTestRunnable() to override the way tests are executed");
    }

    protected boolean shouldRunTest() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && !policy.canRun(((Object)((Object)this)).getClass())) {
            return false;
        }
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        testRunnable.run();
    }

    protected void defaultRunBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        try (AutoCloseable ignored = this::invokeTearDown;){
            this.invokeSetUp();
            this.runTestRunnable(testRunnable);
        }
    }

    protected final void invokeSetUp() throws Exception {
        long setupStart = System.nanoTime();
        this.setUp();
        long setupCost = (System.nanoTime() - setupStart) / 1000000L;
        this.logPerClassCost((int)setupCost, TOTAL_SETUP_COST_MILLIS, TOTAL_SETUP_COUNT);
    }

    protected void invokeTearDown() throws Exception {
        long teardownStart = System.nanoTime();
        this.tearDown();
        long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
        this.logPerClassCost((int)teardownCost, TOTAL_TEARDOWN_COST_MILLIS, TOTAL_TEARDOWN_COUNT);
    }

    private void logPerClassCost(int cost, @NotNull ObjectIntMap<String> costMap, @NotNull ObjectIntMap<String> countMap) {
        String name;
        int storedCost = costMap.get((Object)(name = ((Object)((Object)this)).getClass().getSuperclass().getName()));
        costMap.put((Object)name, (storedCost == -1 ? 0 : storedCost) + cost);
        int storedCount = countMap.get((Object)name);
        countMap.put((Object)name, storedCount == -1 ? 1 : storedCount + 1);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long totalSetup = 0L;
        for (ObjectIntMap.Entry entry : TOTAL_SETUP_COST_MILLIS.entries()) {
            String name = (String)entry.getKey();
            int cost = entry.getValue();
            long count = TOTAL_SETUP_COUNT.get((Object)name);
            System.out.printf("  %s: %d ms for %d executions%n", name, cost, count);
            totalSetup += (long)cost;
        }
        System.out.println("Teardown costs");
        long totalTeardown = 0L;
        for (ObjectIntMap.Entry entry : TOTAL_TEARDOWN_COST_MILLIS.entries()) {
            String name = (String)entry.getKey();
            int cost = entry.getValue();
            long count = TOTAL_TEARDOWN_COUNT.get((Object)name);
            System.out.printf("  %s: %d ms for %d executions%n", name, cost, count);
            totalTeardown += (long)cost;
        }
        System.out.printf("Total overhead: setup %d ms, teardown %d ms%n", totalSetup, totalTeardown);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']%n", totalSetup);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']%n", totalTeardown);
    }

    public final void runBare() throws Throwable {
        if (this.shouldRunTest()) {
            this.runBare((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> super.runTest()));
        }
    }

    protected void runBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        ThrowableRunnable<Throwable> wrappedRunnable = this.wrapTestRunnable(testRunnable);
        if (this.runInDispatchThread()) {
            UITestUtil.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait(() -> this.defaultRunBare(wrappedRunnable));
        } else {
            this.defaultRunBare(wrappedRunnable);
        }
    }

    @NotNull
    protected ThrowableRunnable<Throwable> wrapTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) {
        Description testDescription = Description.createTestDescription(((Object)((Object)this)).getClass(), (String)this.getName());
        return () -> {
            boolean success = false;
            TestLoggerFactory.onTestStarted();
            try {
                testRunnable.run();
                success = true;
            }
            catch (AssumptionViolatedException e) {
                success = true;
                throw e;
            }
            catch (Throwable t) {
                TestLoggerFactory.logTestFailure(t);
                throw t;
            }
            finally {
                TestLoggerFactory.onTestFinished(success, testDescription);
            }
        };
    }

    protected boolean runInDispatchThread() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            return policy.runInDispatchThread();
        }
        return true;
    }

    protected static <T extends Throwable> void edt(@NotNull ThrowableRunnable<T> runnable) throws T {
        EdtTestUtil.runInEdtAndWait(runnable);
    }

    @NotNull
    public static String toString(@NotNull Iterable<?> collection) {
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof Set) {
                builder.append(new TreeSet((Set)o));
            } else {
                builder.append(o);
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(T @NotNull [] actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static void assertOrderedEquals(byte @NotNull [] actual, byte @NotNull [] expected) {
        UsefulTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i2 = 0; i2 < actual.length; ++i2) {
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (byte)expected[i2], (byte)actual[i2]);
        }
    }

    public static void assertOrderedEquals(int @NotNull [] actual, int @NotNull [] expected) {
        if (actual.length != expected.length) {
            UsefulTestCase.fail((String)("Expected size: " + expected.length + "; actual: " + actual.length + "\nexpected: " + Arrays.toString(expected) + "\nactual  : " + Arrays.toString(actual)));
        }
        for (int i2 = 0; i2 < actual.length; ++i2) {
            int a = actual[i2];
            int e = expected[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (int)e, (int)a);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, expected, Objects::equals);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected, @NotNull BiPredicate<? super T, ? super T> predicate) {
        if (!UsefulTestCase.equals(actual, expected, predicate)) {
            String expectedString = UsefulTestCase.toString(expected);
            String actualString = UsefulTestCase.toString(actual);
            Assert.assertEquals((String)errorMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    private static <T> boolean equals(@NotNull Iterable<? extends T> a1, @NotNull Iterable<? extends T> a2, @NotNull BiPredicate<? super T, ? super T> predicate) {
        Iterator<T> it1 = a1.iterator();
        Iterator<T> it2 = a2.iterator();
        while (it1.hasNext() || it2.hasNext()) {
            if (it1.hasNext() && it2.hasNext() && predicate.test(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(T @NotNull [] collection, Consumer<? super T> ... checkers) {
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(T @NotNull [] actual, T ... expected) {
        UsefulTestCase.assertSameElements(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, T ... expected) {
        UsefulTestCase.assertSameElements(actual, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        UsefulTestCase.assertSameElements("", actual, expected);
    }

    public static <T> void assertSameElements(@NotNull String message, @NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        if (actual.size() != expected.size() || !new LinkedHashSet<T>(expected).equals(new LinkedHashSet<T>(actual))) {
            Assert.assertEquals((String)message, new LinkedHashSet<T>(expected), new LinkedHashSet<T>(actual));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        PeekableIteratorWrapper expectedIt = new PeekableIteratorWrapper(expected.iterator());
        PeekableIteratorWrapper actualIt = new PeekableIteratorWrapper(collection.iterator());
        while (actualIt.hasNext() && expectedIt.hasNext()) {
            Object actualElem;
            Object expectedElem = expectedIt.peek();
            if (expectedElem.equals(actualElem = actualIt.peek())) {
                expectedIt.next();
            }
            actualIt.next();
        }
        if (expectedIt.hasNext()) {
            throw new ComparisonFailure("", UsefulTestCase.toString(expected), UsefulTestCase.toString(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), copy, expected);
    }

    @NotNull
    public static String toString(Object @NotNull [] collection, @NotNull String separator) {
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(notExpected));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> notExpected) {
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        UsefulTestCase.assertSameElements(collection, expected);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        List list = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        return builder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<? super T> ... checkers) {
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i2 = 0;
        for (T actual : collection) {
            try {
                checkers[i2].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i2 + ": " + actual);
                throw e;
            }
            ++i2;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(T @NotNull [] collection, Consumer<? super T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<? super T> ... checkers) {
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        Set checkerSet = ContainerUtil.set((Object[])checkers);
        int i2 = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer condition : checkerSet) {
                Throwable error2 = UsefulTestCase.accepts(condition, actual);
                if (error2 == null) {
                    checkerSet.remove(condition);
                    flag = false;
                    break;
                }
                lastError = error2;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i2 + "): " + actual));
            }
            ++i2;
        }
    }

    private static <T> Throwable accepts(@NotNull Consumer<? super T> condition, T actual) {
        try {
            condition.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: null"), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object t = o;
        return (T)t;
    }

    public static <T> T assertOneElement(@NotNull Collection<? extends T> collection) {
        if (collection.size() != 1) {
            Assert.assertEquals((String)collection.toString(), (long)1L, (long)collection.size());
        }
        return collection.iterator().next();
    }

    public static <T> T assertOneElement(T @NotNull [] ts) {
        if (ts.length != 1) {
            Assert.assertEquals((String)Arrays.toString(ts), (long)1L, (long)ts.length);
        }
        return ts[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value, T ... values) {
        for (T v : values) {
            if (!Objects.equals(value, v)) continue;
            return;
        }
        Assert.fail((String)(value + " should be equal to one of " + Arrays.toString(values)));
    }

    @Deprecated
    public static void printThreadDump() {
        ThreadUtil.printThreadDump();
    }

    public static void assertEmpty(Object @NotNull [] array) {
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        UsefulTestCase.assertNotNull(collection);
        UsefulTestCase.assertFalse((boolean)collection.isEmpty());
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        if (!collection.isEmpty()) {
            UsefulTestCase.assertEmpty(collection.toString(), collection);
        }
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty("", collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static <T> void assertEmpty(@NotNull String errorMsg, @NotNull Collection<? extends T> collection) {
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, Collections.emptyList());
    }

    public static void assertSize(int expectedSize, Object @NotNull [] array) {
        if (array.length != expectedSize) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
        }
    }

    public static void assertSize(int expectedSize, @NotNull Collection<?> c) {
        if (c.size() != expectedSize) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(c), (int)expectedSize, (int)c.size());
        }
    }

    @NotNull
    protected <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        Disposer.register((Disposable)this.getTestRootDisposable(), disposable);
        return disposable;
    }

    public static void assertSameLines(@NotNull String expected, @NotNull String actual) {
        UsefulTestCase.assertSameLines(null, expected, actual);
    }

    public static void assertSameLines(@Nullable String message, @NotNull String expected, @NotNull String actual) {
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual.trim());
        Assert.assertEquals((String)message, (Object)expectedText, (Object)actualText);
    }

    public static void assertExists(@NotNull File file2) {
        UsefulTestCase.assertTrue((String)("File should exist " + file2), (boolean)file2.exists());
    }

    public static void assertDoesntExist(@NotNull File file2) {
        UsefulTestCase.assertFalse((String)("File should not exist " + file2), (boolean)file2.exists());
    }

    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        return UsefulTestCase.getTestName(this.getName(), lowercaseFirstLetter);
    }

    @NotNull
    public static String getTestName(@Nullable String name, boolean lowercaseFirstLetter) {
        return name == null ? "" : PlatformTestUtil.getTestName(name, lowercaseFirstLetter);
    }

    @NotNull
    protected String getTestDirectoryName() {
        return this.getTestName(true).replaceAll("_.*", "");
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText) {
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, @NotNull Supplier<String> messageProducer) {
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true, messageProducer);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing) {
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, trimBeforeComparing, null);
    }

    protected static void checkCaseSensitiveFS(@NotNull String fullOrRelativePath, @NotNull File ioFile) throws IOException {
        fullOrRelativePath = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)fullOrRelativePath));
        String canonicalPath = ioFile.getCanonicalPath();
        if (!canonicalPath.endsWith(fullOrRelativePath) && StringUtil.endsWithIgnoreCase((String)canonicalPath, (String)fullOrRelativePath)) {
            throw new RuntimeException("Queried for: " + fullOrRelativePath + "; but found: " + canonicalPath);
        }
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing, @Nullable Supplier<String> messageProducer) {
        String fileText;
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(filePath, actualText, trimBeforeComparing);
                System.out.println("File " + filePath + " created.");
            }
            File file2 = new File(filePath);
            UsefulTestCase.checkCaseSensitiveFS(filePath, file2);
            fileText = FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData(filePath, actualText);
            throw new AssertionFailedError("No output text found. File " + filePath + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? fileText.trim() : fileText));
        String actual = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? actualText.trim() : actualText));
        if (!Objects.equals(expected, actual)) {
            throw new FileComparisonFailure(messageProducer == null ? null : messageProducer.get(), expected, actual, filePath);
        }
    }

    protected static void clearFields(@NotNull Object test) throws IllegalAccessException {
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(@NotNull Object test, @NotNull Class<?> aClass) throws IllegalAccessException {
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getDeclaringClass().getName();
            if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    private static void checkCodeStyleSettingsEqual(@NotNull CodeStyleSettings expected, @NotNull CodeStyleSettings settings) {
        if (!expected.equals((Object)settings)) {
            Element oldS = new Element("temp");
            expected.writeExternal(oldS);
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            String newString = JDOMUtil.writeElement((Element)newS);
            String oldString = JDOMUtil.writeElement((Element)oldS);
            Assert.assertEquals((String)"Code style settings damaged", (Object)oldString, (Object)newString);
        }
    }

    private static void checkCodeInsightSettingsNotOverwritten(@NotNull CodeInsightSettings settings) {
        if (!settings.equals((Object)defaultSettings)) {
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            String DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement((Element)oldS);
            Assert.assertEquals((String)"Code insight settings damaged", (Object)DEFAULT_SETTINGS_EXTERNALIZED, (Object)JDOMUtil.writeElement((Element)newS));
        }
    }

    public final boolean isPerformanceTest() {
        return TestFrameworkUtil.isPerformanceTest(this.getName(), ((Object)((Object)this)).getClass().getSimpleName());
    }

    public final boolean isStressTest() {
        String className;
        String testName2 = this.getName();
        return TestFrameworkUtil.isPerformanceTest(testName2, className = ((Object)((Object)this)).getClass().getSimpleName()) || UsefulTestCase.containsStressWords(testName2) || UsefulTestCase.containsStressWords(className);
    }

    private static boolean containsStressWords(@Nullable String name) {
        return name != null && (name.contains("Stress") || name.contains("Slow"));
    }

    public static void doPostponedFormatting(@NotNull Project project2) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
        });
    }

    public static void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<?> runnable) {
        UsefulTestCase.assertThrows(exceptionClass, null, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsgPart, @NotNull ThrowableRunnable<?> runnable) {
        boolean wasThrown = false;
        try {
            runnable.run();
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause instanceof TestLoggerFactory.TestLoggerAssertionError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            wasThrown = true;
            if (!exceptionClass.isInstance(cause)) {
                throw new AssertionError("Expected instance of: " + exceptionClass + " actual: " + cause.getClass(), cause);
            }
            if (expectedErrorMsgPart != null) {
                UsefulTestCase.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains(expectedErrorMsgPart));
            }
        }
        finally {
            if (!wasThrown) {
                UsefulTestCase.fail((String)("'" + exceptionClass.getName() + "' must have been thrown, but the computation completed successfully instead"));
            }
        }
    }

    protected static <T extends Throwable> void assertNoException(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable) throws T {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause instanceof TestLoggerFactory.TestLoggerAssertionError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (exceptionClass.equals(cause.getClass())) {
                System.out.println();
                e.printStackTrace(System.out);
                UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + cause.getMessage()));
            }
            throw e;
        }
    }

    protected void assertNoThrowable(@NotNull Runnable closure) {
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        String methodName = (String)ObjectUtils.notNull((Object)this.getName(), (Object)"");
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method = ReflectionUtil.getDeclaredMethod(aClass, (String)methodName, (Class[])new Class[0])) == null) continue;
            if (method.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    @NotNull
    protected String getHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    public static void refreshRecursively(@NotNull VirtualFile file2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                file2.getChildren();
                return true;
            }
        });
        file2.refresh(false, true);
    }

    public static VirtualFile refreshAndFindFile(@NotNull File file2) {
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
    }

    public static void waitForAppLeakingThreads(long timeout, @NotNull TimeUnit timeUnit) {
        EdtTestUtil.runInEdtAndWait(() -> {
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isDisposed()) {
                TestApplicationKt.waitForAppLeakingThreads(app, timeout, timeUnit);
            }
        });
    }

    protected void setRegistryPropertyForTest(@NotNull String property, @NotNull String value) {
        Registry.get((String)property).setValue(value);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> Registry.get((String)property).resetToDefault());
    }

    protected void allowAccessToDirsIfExists(String ... dirNames) {
        for (String dirName : dirNames) {
            Path usrShareDir = Paths.get(dirName, new String[0]);
            if (Files.exists(usrShareDir, new LinkOption[0])) {
                String absolutePath = usrShareDir.toAbsolutePath().toString();
                LOG.debug(usrShareDir.toString(), new Object[]{" exists, adding to the list of allowed root: ", absolutePath});
                VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{absolutePath});
                continue;
            }
            LOG.debug(usrShareDir.toString(), new Object[]{" does not exists"});
        }
    }

    static {
        TestEnvironmentKt.initializeTestEnvironment();
    }

    protected final class TestDisposable
    implements Disposable {
        private volatile boolean myDisposed;

        public void dispose() {
            this.myDisposed = true;
        }

        public boolean isDisposed() {
            return this.myDisposed;
        }

        public String toString() {
            String testName2 = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (String)(StringUtil.isEmpty((String)testName2) ? "" : ".test" + testName2);
        }
    }
}

