/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AssumptionViolatedException;
import org.junit.ComparisonFailure;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public final class TestLoggerFactory
implements Logger.Factory {
    private static final String LOG_DIR = "testlog";
    private static final String LOG_FILE_NAME = "idea.log";
    private static final String SPLIT_LOGS_SUBDIR = "splitTestLogs";
    private static final long LOG_SIZE_LIMIT = 0x6400000L;
    private static final long LOG_SEEK_WINDOW = 102400L;
    private static final char FAILED_TEST_DEBUG_OUTPUT_MARKER = '\u2003';
    private static final int MAX_BUFFER_LENGTH = Integer.getInteger("idea.single.test.log.max.length", 10000000);
    private final StringBuilder myBuffer = new StringBuilder();
    private long myTestStartedMillis;
    private boolean myInitialized;
    private boolean mySplitTestLogs = Boolean.getBoolean("idea.split.test.logs");

    private TestLoggerFactory() {
    }

    @Nullable
    private static TestLoggerFactory getTestLoggerFactory() {
        Logger.Factory factory = Logger.getFactory();
        return factory instanceof TestLoggerFactory ? (TestLoggerFactory)factory : null;
    }

    @NotNull
    public synchronized Logger getLoggerInstance(@NotNull String category) {
        if (!this.myInitialized && TestLoggerFactory.reconfigure()) {
            this.myInitialized = true;
        }
        java.util.logging.Logger julLogger = java.util.logging.Logger.getLogger(category);
        if (System.getenv("TEAMCITY_VERSION") != null) {
            TestLoggerFactory.configureLogToStdoutIfDebug(julLogger);
        }
        return new TestLogger(julLogger, this);
    }

    private static void configureLogToStdoutIfDebug(@NotNull java.util.logging.Logger julLogger) {
        if (julLogger.isLoggable(Level.FINE) && ContainerUtil.findInstance((Object[])julLogger.getHandlers(), LogToStdoutJulHandler.class) == null) {
            julLogger.addHandler(new LogToStdoutJulHandler());
        }
    }

    public static boolean reconfigure() {
        try {
            Path logProperties;
            String customConfigPath = System.getProperty("idea.log.config.properties.file");
            Path path = logProperties = customConfigPath != null ? Path.of(customConfigPath, new String[0]) : Path.of(PathManager.getHomePath(), "test-log.properties");
            if (Files.exists(logProperties, new LinkOption[0])) {
                if (customConfigPath != null) {
                    System.out.println("Configuring j.u.l.LogManager from file: " + logProperties);
                }
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(logProperties, new OpenOption[0]));){
                    LogManager.getLogManager().readConfiguration(in);
                }
            } else {
                System.err.println("Configuration file for j.u.l.LogManager does not exist: " + logProperties);
            }
            Path logDir = TestLoggerFactory.getTestLogDir();
            Files.createDirectories(logDir, new FileAttribute[0]);
            Path logFile = logDir.resolve(LOG_FILE_NAME);
            JulLogger.clearHandlers();
            JulLogger.configureLogFileAndConsole((Path)logFile, (boolean)false, (boolean)false, (boolean)true, null);
            if (Files.exists(logFile, new LinkOption[0]) && Files.size(logFile) >= 0x6400000L) {
                Files.writeString(logFile, (CharSequence)"", new OpenOption[0]);
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public static Path getTestLogDir() {
        String property = System.getProperty("idea.log.path");
        return property != null ? Path.of(property, new String[0]) : Path.of(PathManager.getSystemPath(), LOG_DIR);
    }

    public static void dumpLogToStdout(@NotNull String testStartMarker) {
        TestLoggerFactory.dumpLogTo(testStartMarker, System.out);
    }

    public static void dumpLogTo(@NotNull String testStartMarker, PrintStream out) {
        Path logFile = TestLoggerFactory.getTestLogDir().resolve(LOG_FILE_NAME);
        if (Files.exists(logFile, new LinkOption[0])) {
            try {
                String logText;
                long length = Files.size(logFile);
                if (length > 102400L) {
                    try (RandomAccessFile file2 = new RandomAccessFile(logFile.toFile(), "r");){
                        file2.seek(length - 102400L);
                        byte[] bytes = new byte[102400];
                        int read = file2.read(bytes);
                        logText = new String(bytes, 0, read, StandardCharsets.UTF_8);
                    }
                } else {
                    logText = Files.readString(logFile);
                }
                out.println("\n\nIdea Log:");
                Pattern logStart = Pattern.compile("[\\d\\-, :\\[\\]]+(DEBUG|INFO|ERROR) - ");
                for (String line : StringUtil.splitByLines((String)logText.substring(Math.max(0, logText.lastIndexOf(testStartMarker))))) {
                    Matcher matcher = logStart.matcher(line);
                    int lineStart = matcher.lookingAt() ? matcher.end() : 0;
                    out.println(line.substring(lineStart));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void enableDebugLogging(@NotNull Disposable parentDisposable, String ... categories) {
        for (String category : categories) {
            Logger logger = Logger.getInstance((String)category);
            if (logger.isDebugEnabled()) continue;
            logger.setLevel(LogLevel.DEBUG);
            Disposer.register((Disposable)parentDisposable, () -> logger.setLevel(LogLevel.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buffer(@NotNull LogLevel level, @NotNull String category, @Nullable String message, @Nullable Throwable t) {
        String source = category.substring(Math.max(category.length() - 30, 0));
        String format = String.format("%1$tH:%1$tM:%1$tS,%1$tL %2$-6s %3$30s - ", System.currentTimeMillis(), level.getLevelName(), source);
        StringBuilder stringBuilder = this.myBuffer;
        synchronized (stringBuilder) {
            this.myBuffer.append(format);
            if (message != null) {
                this.myBuffer.append(message);
            }
            this.myBuffer.append(System.lineSeparator());
            if (t != null) {
                StringWriter writer = new StringWriter(4096);
                t.printStackTrace(new PrintWriter(writer));
                this.myBuffer.append(writer.getBuffer());
                this.myBuffer.append(System.lineSeparator());
            }
            if (this.myBuffer.length() > MAX_BUFFER_LENGTH) {
                this.myBuffer.delete(0, this.myBuffer.length() - MAX_BUFFER_LENGTH + MAX_BUFFER_LENGTH / 4);
            }
        }
    }

    @Nullable
    private static String dumpComparisonFailures(@Nullable Throwable t) {
        if (t == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ExceptionUtil.findCauseAndSuppressed((Throwable)t, ComparisonFailure.class).forEach(e -> TestLoggerFactory.logComparisonFailure(sb, e.getExpected(), e.getActual()));
        ExceptionUtil.findCauseAndSuppressed((Throwable)t, junit.framework.ComparisonFailure.class).forEach(e -> TestLoggerFactory.logComparisonFailure(sb, e.getExpected(), e.getActual()));
        return sb.length() != 0 ? sb.toString() : null;
    }

    private static void logComparisonFailure(@NotNull StringBuilder sb, @Nullable String expected, @Nullable String actual) {
        if (expected == null && actual == null) {
            return;
        }
        sb.append("Comparison Failure");
        sb.append(System.lineSeparator());
        if (actual == null) {
            sb.append("Actual [null]");
        } else {
            sb.append("Actual [[");
            sb.append(actual);
            sb.append("]]");
        }
        sb.append(System.lineSeparator());
        if (expected == null) {
            sb.append("Expected [null]");
        } else {
            sb.append("Expected [[");
            sb.append(expected);
            sb.append("]]");
        }
        sb.append(System.lineSeparator());
    }

    public static void onTestStarted() {
        TestLoggerFactory factory = TestLoggerFactory.getTestLoggerFactory();
        if (factory != null) {
            factory.clearLogBuffer();
            factory.myTestStartedMillis = System.currentTimeMillis();
        }
    }

    @Deprecated
    public static void onTestFinished(boolean success) {
        TestLoggerFactory.onTestFinished(success, "unnamed_test");
    }

    public static void onTestFinished(boolean success, @NotNull Description description) {
        TestLoggerFactory.onTestFinished(success, description.getDisplayName());
    }

    public static void onTestFinished(boolean success, @NotNull String testName2) {
        TestLoggerFactory factory = TestLoggerFactory.getTestLoggerFactory();
        if (factory != null) {
            factory.myTestStartedMillis = 0L;
            factory.dumpLogBuffer(success, testName2);
        }
    }

    public static void logTestFailure(@NotNull Throwable t) {
        TestLoggerFactory factory = TestLoggerFactory.getTestLoggerFactory();
        if (factory != null) {
            String comparisonFailures = TestLoggerFactory.dumpComparisonFailures(t);
            Object message = comparisonFailures != null ? "test failed: " + comparisonFailures : "Test failed";
            factory.buffer(LogLevel.ERROR, "#TestFramework", (String)message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLogBuffer() {
        StringBuilder stringBuilder = this.myBuffer;
        synchronized (stringBuilder) {
            this.myBuffer.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLogBuffer(boolean success, @NotNull String testName2) {
        Object buffer;
        StringBuilder stringBuilder = this.myBuffer;
        synchronized (stringBuilder) {
            buffer = success || this.myBuffer.length() == 0 ? null : this.myBuffer.toString();
            this.myBuffer.setLength(0);
        }
        if (buffer != null) {
            if (this.mySplitTestLogs) {
                Path logDir = TestLoggerFactory.getTestLogDir().resolve(SPLIT_LOGS_SUBDIR);
                Path logFile = FileUtil.findSequentNonexistentFile((File)logDir.toFile(), (String)FileUtil.sanitizeFileName((String)testName2), (String)"log").toPath();
                try {
                    Files.createDirectories(logDir, new FileAttribute[0]);
                    Files.writeString(logFile, (CharSequence)buffer, new OpenOption[0]);
                    String headerFooter = StringUtil.repeat((String)"=", (int)80);
                    buffer = "\n" + headerFooter + "\nLog saved to: " + logFile.getFileName() + "\n    (" + logFile + ")\n" + headerFooter + "\n";
                }
                catch (IOException e) {
                    buffer = (String)buffer + "\nError writing split log, disabling splitting: " + logFile + "\n" + e;
                    this.mySplitTestLogs = false;
                }
            }
            if (System.getenv("TEAMCITY_VERSION") != null) {
                String finalBuffer = buffer;
                TeamCityLogger.block("DEBUG log", () -> System.out.println(finalBuffer));
            } else {
                List lines2 = LineTokenizer.tokenizeIntoList((CharSequence)buffer, (boolean)false, (boolean)false);
                if (!((String)lines2.get(0)).startsWith("\n")) {
                    lines2.set(0, "\n" + (String)lines2.get(0));
                }
                System.err.println(String.join((CharSequence)"\u2003\n", lines2));
            }
        }
    }

    @NotNull
    public static TestRule createTestWatcher() {
        return new TestWatcher(){

            protected void succeeded(Description description) {
                TestLoggerFactory.onTestFinished(true, description);
            }

            protected void failed(Throwable e, Description description) {
                TestLoggerFactory.logTestFailure(e);
                TestLoggerFactory.onTestFinished(false, description);
            }

            protected void skipped(AssumptionViolatedException e, Description description) {
                TestLoggerFactory.onTestFinished(true, description);
            }

            protected void starting(@NotNull Description d) {
                TestLoggerFactory.onTestStarted();
            }
        };
    }

    private static final class TestLogger
    extends JulLogger {
        private final TestLoggerFactory myFactory;

        private TestLogger(@NotNull java.util.logging.Logger julLogger, @NotNull TestLoggerFactory factory) {
            super(julLogger);
            this.myFactory = factory;
        }

        public void error(String message, @Nullable Throwable t, String ... details) {
            Set<LoggedErrorProcessor.Action> actions = LoggedErrorProcessor.getInstance().processError(this.myLogger.getName(), Objects.requireNonNullElse(message, ""), details, t);
            if (actions.contains((Object)LoggedErrorProcessor.Action.LOG)) {
                if (t instanceof TestLoggerAssertionError && ((String)message).equals(t.getMessage()) && details.length == 0) {
                    throw (TestLoggerAssertionError)((Object)t);
                }
                message = (String)message + DefaultLogger.detailsToString((String[])details) + DefaultLogger.attachmentsToString((Throwable)t);
                t = TestLogger.ensureNotControlFlow((Throwable)t);
                if (this.myFactory.mySplitTestLogs) {
                    this.myFactory.buffer(LogLevel.ERROR, this.myLogger.getName(), (String)message, t);
                }
                super.info((String)message, t);
            }
            if (actions.contains((Object)LoggedErrorProcessor.Action.STDERR)) {
                DefaultLogger.dumpExceptionsToStderr((String)message, (Throwable)t, (String[])new String[0]);
            }
            if (actions.contains((Object)LoggedErrorProcessor.Action.RETHROW)) {
                throw new TestLoggerAssertionError((String)message, t);
            }
        }

        public void warn(String message, @Nullable Throwable t) {
            if (LoggedErrorProcessor.getInstance().processWarn(this.myLogger.getName(), Objects.requireNonNullElse(message, ""), t)) {
                message = (String)message + DefaultLogger.attachmentsToString((Throwable)t);
                t = TestLogger.ensureNotControlFlow((Throwable)t);
                if (this.myFactory.mySplitTestLogs) {
                    this.myFactory.buffer(LogLevel.WARNING, this.myLogger.getName(), (String)message, t);
                }
                super.warn((String)message, t);
            }
        }

        public void info(String message) {
            this.info(message, null);
        }

        public void info(String message, @Nullable Throwable t) {
            super.info(message, t);
            this.myFactory.buffer(LogLevel.INFO, this.myLogger.getName(), message, t);
        }

        public void debug(String message) {
            this.debug(message, null);
        }

        public void debug(@Nullable Throwable t) {
            this.debug(null, t);
        }

        public void debug(String message, @Nullable Throwable t) {
            if (this.isDebugEnabled()) {
                super.debug(message, t);
                this.myFactory.buffer(LogLevel.DEBUG, this.myLogger.getName(), message, t);
            }
        }

        public void trace(String message) {
            if (this.isTraceEnabled()) {
                super.trace(message);
                this.myFactory.buffer(LogLevel.TRACE, this.myLogger.getName(), message, null);
            }
        }

        public void trace(@Nullable Throwable t) {
            if (this.isTraceEnabled()) {
                super.trace(t);
                this.myFactory.buffer(LogLevel.TRACE, this.myLogger.getName(), null, t);
            }
        }

        public boolean isDebugEnabled() {
            return !Accessor.isInStressTest() || super.isDebugEnabled();
        }

        private static class Accessor {
            @Nullable
            private static final MethodHandle isInStressTest = Accessor.getMethodHandle();

            private Accessor() {
            }

            private static MethodHandle getMethodHandle() {
                try {
                    Class<?> clazz = Class.forName("com.intellij.openapi.application.ex.ApplicationManagerEx");
                    return MethodHandles.publicLookup().findStatic(clazz, "isInStressTest", MethodType.methodType(Boolean.TYPE));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            private static boolean isInStressTest() {
                try {
                    return isInStressTest != null && isInStressTest.invokeExact();
                }
                catch (Throwable ignored) {
                    return false;
                }
            }
        }
    }

    private static class LogToStdoutJulHandler
    extends StreamHandler {
        private boolean initialized;

        LogToStdoutJulHandler() {
            super(System.out, (Formatter)((Object)new WithTimeSinceTestStartedJulFormatter()));
            this.setLevel(Level.ALL);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        @Override
        protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
            if (this.initialized) {
                throw new UnsupportedOperationException("TestLoggerFactory.setOutputStream");
            }
            super.setOutputStream(out);
            this.initialized = true;
        }

        @Override
        public synchronized void close() {
            this.flush();
        }
    }

    private static class WithTimeSinceTestStartedJulFormatter
    extends IdeaLogRecordFormatter {
        WithTimeSinceTestStartedJulFormatter() {
            super(false);
        }

        protected long getStartedMillis() {
            TestLoggerFactory factory = TestLoggerFactory.getTestLoggerFactory();
            return factory == null ? 0L : factory.myTestStartedMillis;
        }
    }

    static final class TestLoggerAssertionError
    extends AssertionError {
        private TestLoggerAssertionError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

