/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.testFramework.EmptyFileBasedIndex;
import com.intellij.testFramework.NeedsIndex;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.junit.internal.MethodSorter;
import org.junit.runner.Describable;
import org.junit.runner.Description;

public interface TestIndexingModeSupporter {
    public void setIndexingMode(@NotNull IndexingMode var1);

    @NotNull
    public IndexingMode getIndexingMode();

    public static void addTest(@NotNull Class<? extends TestIndexingModeSupporter> aClass, @NotNull IndexingModeTestHandler handler, @NotNull TestSuite parentSuite) {
        if (handler.shouldIgnore(aClass)) {
            return;
        }
        try {
            TestSuite suite = handler.createTestSuite();
            suite.setName(aClass.getSimpleName());
            boolean foundTests = false;
            Constructor<? extends TestIndexingModeSupporter> constructor = aClass.getConstructor(new Class[0]);
            for (Method declaredMethod : MethodSorter.getDeclaredMethods(aClass)) {
                String methodName;
                if (!Modifier.isPublic(declaredMethod.getModifiers()) || !(methodName = declaredMethod.getName()).startsWith("test") || TestFrameworkUtil.isPerformanceTest(methodName, aClass.getName()) || handler.shouldIgnore(declaredMethod)) continue;
                TestIndexingModeSupporter aCase = constructor.newInstance(new Object[0]);
                aCase.setIndexingMode(handler.getIndexingMode());
                if (aCase instanceof TestCase) {
                    TestCase testCase2 = (TestCase)aCase;
                    testCase2.setName(methodName);
                    if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                        Test wrapper = IndexingModeTestHandler.wrapForTeamCity(testCase2, handler.getIndexingMode());
                        suite.addTest(wrapper);
                    } else {
                        suite.addTest((Test)testCase2);
                    }
                } else {
                    parentSuite.addTest(TestSuite.warning((String)(aClass.getName() + "is not a TestSuite")));
                }
                foundTests = true;
            }
            if (foundTests) {
                parentSuite.addTest((Test)suite);
            }
        }
        catch (NoSuchMethodException e) {
            parentSuite.addTest(TestSuite.warning((String)("Failed to find default constructor for " + aClass.getName() + ", see log")));
            e.printStackTrace();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            parentSuite.addTest(TestSuite.warning((String)("Failed to instantiate " + aClass.getName() + ", see log")));
            e.printStackTrace();
        }
    }

    public static abstract class IndexingModeTestHandler {
        public final String myTestSuiteName;
        public final String myTestNamePrefix;
        private final IndexingMode myIndexingMode;

        protected IndexingModeTestHandler(@NotNull String testSuiteName, @NotNull String testNamePrefix, @NotNull IndexingMode mode) {
            this.myTestSuiteName = testSuiteName;
            this.myTestNamePrefix = testNamePrefix;
            this.myIndexingMode = mode;
        }

        public TestSuite createTestSuite() {
            return new NamedTestSuite(this.myTestNamePrefix);
        }

        public abstract boolean shouldIgnore(@NotNull AnnotatedElement var1);

        @NotNull
        public IndexingMode getIndexingMode() {
            return this.myIndexingMode;
        }

        private static boolean shouldIgnoreInFullIndexSuite(@NotNull AnnotatedElement element) {
            return element.isAnnotationPresent(NeedsIndex.SmartMode.class);
        }

        private static boolean shouldIgnoreInRuntimeOnlyIndexSuite(@NotNull AnnotatedElement element) {
            return IndexingModeTestHandler.shouldIgnoreInFullIndexSuite(element) || element.isAnnotationPresent(NeedsIndex.Full.class);
        }

        private static boolean shouldIgnoreInEmptyIndexSuite(@NotNull AnnotatedElement element) {
            return IndexingModeTestHandler.shouldIgnoreInRuntimeOnlyIndexSuite(element) || element.isAnnotationPresent(NeedsIndex.ForStandardLibrary.class);
        }

        private static Test wrapForTeamCity(@NotNull TestCase testCase2, @NotNull IndexingMode mode) {
            return new MyHackyJUnitTaskMirrorImpl.VmExitErrorTest(testCase2, mode);
        }

        private static final class NamedTestSuite
        extends TestSuite {
            private final String myPrefix;

            private NamedTestSuite(@NotNull String prefix) {
                this.myPrefix = prefix;
            }

            public void setName(String name) {
                super.setName(this.myPrefix + name);
            }
        }

        private static class MyHackyJUnitTaskMirrorImpl {
            private MyHackyJUnitTaskMirrorImpl() {
            }

            private static class VmExitErrorTest
            implements Test,
            Describable {
                private final TestCase myTestCase;
                private final IndexingMode myMode;

                private VmExitErrorTest(@NotNull TestCase testCase2, @NotNull IndexingMode mode) {
                    this.myTestCase = testCase2;
                    this.myMode = mode;
                }

                public int countTestCases() {
                    return this.myTestCase.countTestCases();
                }

                public void run(TestResult result2) {
                    result2.startTest((Test)this);
                    Protectable p = new Protectable(){

                        public void protect() throws Throwable {
                            myTestCase.runBare();
                        }
                    };
                    result2.runProtected((Test)this, p);
                    result2.endTest((Test)this);
                }

                public String toString() {
                    return this.myTestCase.getClass().getName() + "." + this.myTestCase.getName() + " with IndexingMode " + this.myMode.name();
                }

                public Description getDescription() {
                    return Description.createTestDescription(this.myTestCase.getClass(), (String)(this.myTestCase.getName() + "[" + this.myMode.name() + "]"));
                }
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IndexingMode {
        SMART{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
            }

            @Override
            public void tearDownTest(@NotNull Project project2) {
            }
        }
        ,
        DUMB_FULL_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                IndexingMode.indexEverythingAndBecomeDumb(project2);
                RecursionManager.disableMissedCacheAssertions((Disposable)testRootDisposable);
            }

            @Override
            public void ensureIndexingStatus(@NotNull Project project2) {
                DumbServiceImpl dumbService = DumbServiceImpl.getInstance((Project)project2);
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    dumbService.setDumb(false);
                    new UnindexedFilesUpdater(project2).queue();
                    dumbService.setDumb(true);
                });
            }
        }
        ,
        DUMB_RUNTIME_ONLY_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                IndexingMode.becomeDumb(project2);
                RecursionManager.disableMissedCacheAssertions((Disposable)testRootDisposable);
            }
        }
        ,
        DUMB_EMPTY_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                ServiceContainerUtil.replaceService((ComponentManager)ApplicationManager.getApplication(), FileBasedIndex.class, new EmptyFileBasedIndex(), testRootDisposable);
                IndexingMode.becomeDumb(project2);
                RecursionManager.disableMissedCacheAssertions((Disposable)testRootDisposable);
            }
        };


        public abstract void setUpTest(@NotNull Project var1, @NotNull Disposable var2);

        public void tearDownTest(@NotNull Project project2) {
            ApplicationManager.getApplication().invokeAndWait(() -> DumbServiceImpl.getInstance((Project)project2).setDumb(false));
        }

        public void ensureIndexingStatus(@NotNull Project project2) {
        }

        private static void becomeDumb(@NotNull Project project2) {
            ApplicationManager.getApplication().invokeAndWait(() -> DumbServiceImpl.getInstance((Project)project2).setDumb(true));
        }

        private static void indexEverythingAndBecomeDumb(@NotNull Project project2) {
            DumbServiceImpl dumbService = DumbServiceImpl.getInstance((Project)project2);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                dumbService.setDumb(false);
                new UnindexedFilesUpdater(project2).queue();
                dumbService.setDumb(true);
            });
        }
    }

    public static class EmptyIndexSuite
    extends IndexingModeTestHandler {
        public EmptyIndexSuite() {
            super("Empty index", "Empty index ", IndexingMode.DUMB_EMPTY_INDEX);
        }

        @Override
        public boolean shouldIgnore(@NotNull AnnotatedElement aClass) {
            return IndexingModeTestHandler.shouldIgnoreInEmptyIndexSuite(aClass);
        }
    }

    public static class RuntimeOnlyIndexSuite
    extends IndexingModeTestHandler {
        public RuntimeOnlyIndexSuite() {
            super("RuntimeOnlyIndex", "Runtime only index ", IndexingMode.DUMB_RUNTIME_ONLY_INDEX);
        }

        @Override
        public boolean shouldIgnore(@NotNull AnnotatedElement aClass) {
            return IndexingModeTestHandler.shouldIgnoreInRuntimeOnlyIndexSuite(aClass);
        }
    }

    public static class FullIndexSuite
    extends IndexingModeTestHandler {
        public FullIndexSuite() {
            super("Full index", "Full index ", IndexingMode.DUMB_FULL_INDEX);
        }

        @Override
        public boolean shouldIgnore(@NotNull AnnotatedElement aClass) {
            return IndexingModeTestHandler.shouldIgnoreInFullIndexSuite(aClass);
        }
    }
}

