/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.io.Ksuid;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b*\u00020\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b*\u00020\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"generateName", "", "fileName", "refreshVfs", "", "Ljava/nio/file/Path;", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "relativePath", "data", "", "intellij.platform.testFramework"})
public final class TemporaryDirectoryKt {
    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile $this$writeChild, @NotNull String relativePath, @NotNull String data) {
        return VfsTestUtil.createFile($this$writeChild, relativePath, data);
    }

    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile $this$writeChild, @NotNull String relativePath, @NotNull byte[] data) {
        return VfsTestUtil.createFile($this$writeChild, relativePath, data);
    }

    public static final void refreshVfs(@NotNull Path $this$refreshVfs) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem == null) {
            return;
        }
        VirtualFile virtualFile = localFileSystem.refreshAndFindFileByNioFile($this$refreshVfs);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile2};
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
    }

    private static final String generateName(String fileName) {
        StringBuilder nameBuilder = new StringBuilder(fileName.length() + 1 + 27);
        int extIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (((CharSequence)fileName).length() > 0 && extIndex != 0) {
            if (extIndex == -1) {
                nameBuilder.append(fileName);
            } else {
                nameBuilder.append(fileName, 0, extIndex);
            }
            nameBuilder.append('_');
        }
        nameBuilder.append(Ksuid.generate());
        if (extIndex != -1) {
            nameBuilder.append(fileName, extIndex, fileName.length());
        }
        return nameBuilder.toString();
    }

    public static final /* synthetic */ String access$generateName(String fileName) {
        return TemporaryDirectoryKt.generateName(fileName);
    }
}

