/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.UrlReference;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.MapDataContext;
import com.intellij.testFramework.OpenProjectTaskBuilder;
import com.intellij.testFramework.OpenProjectTaskBuilderKt;
import com.intellij.testFramework.PerformanceTestInfo;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.common.TestApplicationKt;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.junit.Assert;

public final class PlatformTestUtil {
    private static final Logger LOG = Logger.getInstance(PlatformTestUtil.class);
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));
    private static final List<Runnable> ourProjectCleanups = new CopyOnWriteArrayList<Runnable>();
    private static final long MAX_WAIT_TIME = TimeUnit.MINUTES.toMillis(2L);

    @NotNull
    public static String getTestName(@NotNull String name, boolean lowercaseFirstLetter) {
        return StringUtil.isEmpty((String)(name = StringUtil.trimStart((String)name, (String)"test"))) ? "" : PlatformTestUtil.lowercaseFirstLetter(name, lowercaseFirstLetter);
    }

    @NotNull
    public static String lowercaseFirstLetter(@NotNull String name, boolean lowercaseFirstLetter) {
        if (lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName((String)name)) {
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        return name;
    }

    public static boolean isAllUppercaseName(@NotNull String name) {
        int uppercaseChars = 0;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            if (Character.isLowerCase(name.charAt(i2))) {
                return false;
            }
            if (!Character.isUpperCase(name.charAt(i2))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    @Deprecated
    static void loadApp(@NotNull Runnable setupEventQueue) {
        TestApplicationKt.loadApp(setupEventQueue);
    }

    public static <T> void maskExtensions(@NotNull ProjectExtensionPointName<T> pointName, @NotNull Project project2, @NotNull List<? extends T> newExtensions, @NotNull Disposable parentDisposable) {
        ((ExtensionPointImpl)pointName.getPoint((AreaInstance)project2)).maskAll(newExtensions, parentDisposable, true);
    }

    @Nullable
    public static String toString(@Nullable Object node2, @Nullable Queryable.PrintInfo printInfo) {
        if (node2 instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)node2).toTestString(printInfo);
            }
            return ((AbstractTreeNode)node2).getTestPresentation();
        }
        return String.valueOf(node2);
    }

    @NotNull
    public static String print(@NotNull JTree tree, boolean withSelection) {
        return PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, null);
    }

    @NotNull
    public static String print(@NotNull JTree tree, @NotNull TreePath path, @Nullable Queryable.PrintInfo printInfo, boolean withSelection) {
        return PlatformTestUtil.print(tree, path, withSelection, printInfo, null);
    }

    @NotNull
    public static String print(@NotNull JTree tree, boolean withSelection, @Nullable Predicate<? super String> nodePrintCondition) {
        return PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, nodePrintCondition);
    }

    private static String print(JTree tree, TreePath path, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        ArrayList strings = new ArrayList();
        PlatformTestUtil.printImpl(tree, path, strings, 0, withSelection, printInfo, nodePrintCondition);
        return String.join((CharSequence)"\n", strings);
    }

    private static void printImpl(JTree tree, TreePath path, Collection<? super String> strings, int level, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        Object pathComponent = path.getLastPathComponent();
        Object userObject = TreeUtil.getUserObject((Object)pathComponent);
        String nodeText = PlatformTestUtil.toString(userObject, printInfo);
        if (nodePrintCondition != null && !nodePrintCondition.test(nodeText)) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buff, (char)' ', (int)level);
        boolean expanded = tree.isExpanded(path);
        int childCount = tree.getModel().getChildCount(pathComponent);
        if (childCount > 0) {
            buff.append(expanded ? (char)'-' : '+');
        }
        boolean selected = tree.getSelectionModel().isPathSelected(path);
        if (withSelection && selected) {
            buff.append('[');
        }
        buff.append(nodeText);
        if (withSelection && selected) {
            buff.append(']');
        }
        strings.add(buff.toString());
        if (expanded) {
            for (int i2 = 0; i2 < childCount; ++i2) {
                TreePath childPath = path.pathByAddingChild(tree.getModel().getChild(pathComponent, i2));
                PlatformTestUtil.printImpl(tree, childPath, strings, level + 1, withSelection, printInfo, nodePrintCondition);
            }
        }
    }

    public static void assertTreeEqual(@NotNull JTree tree, @NonNls String expected) {
        PlatformTestUtil.assertTreeEqual(tree, expected, false);
    }

    public static void assertTreeEqual(@NotNull JTree tree, String expected, boolean checkSelected) {
        PlatformTestUtil.assertTreeEqual(tree, expected, checkSelected, false);
    }

    public static void assertTreeEqual(@NotNull JTree tree, @NotNull String expected, boolean checkSelected, boolean ignoreOrder) {
        String treeStringPresentation = PlatformTestUtil.print(tree, checkSelected);
        if (ignoreOrder) {
            List actualLines = ContainerUtil.sorted((Collection)ContainerUtil.map2List((Object[])StringUtil.splitByLines((String)treeStringPresentation), String::trim));
            List expectedLines = ContainerUtil.sorted((Collection)ContainerUtil.map2List((Object[])StringUtil.splitByLines((String)expected), String::trim));
            Assert.assertEquals((String)("Expected:\n" + expected + "\nActual:\n" + treeStringPresentation), (Object)expectedLines, (Object)actualLines);
        } else {
            UsefulTestCase.assertSameLines(expected.trim(), treeStringPresentation.trim());
        }
    }

    public static void expand(@NotNull JTree tree, int ... rows) {
        for (int row : rows) {
            tree.expandRow(row);
            PlatformTestUtil.waitWhileBusy(tree);
        }
    }

    public static void expandAll(@NotNull JTree tree) {
        PlatformTestUtil.waitForPromise(TreeUtil.promiseExpandAll((JTree)tree));
    }

    private static long getMillisSince(long startTimeMillis) {
        return System.currentTimeMillis() - startTimeMillis;
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis) {
        PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis, MAX_WAIT_TIME);
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis, long timeout) {
        long took = PlatformTestUtil.getMillisSince(startTimeMillis);
        if (took > timeout) assert (false) : String.format("the waiting takes too long. Expected to take no more than: %d ms but took: %d ms\nThread dump: %s", timeout, took, ThreadDumper.dumpThreadsToString());
    }

    private static void assertDispatchThreadWithoutWriteAccess() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            PlatformTestUtil.assertEventQueueDispatchThread();
        } else {
            assert (!application.isWriteAccessAllowed()) : "do not wait under write action to avoid possible deadlock";
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
    }

    private static void assertEventQueueDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Must be called from EDT but got: " + Thread.currentThread());
        }
    }

    private static boolean isBusy(@NotNull JTree tree, TreeModel model) {
        UIUtil.dispatchAllInvocationEvents();
        if (model instanceof AsyncTreeModel) {
            AsyncTreeModel async = (AsyncTreeModel)model;
            if (async.isProcessing()) {
                return true;
            }
            UIUtil.dispatchAllInvocationEvents();
            return async.isProcessing();
        }
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor((JTree)tree);
        if (builder == null) {
            return false;
        }
        AbstractTreeUi ui = builder.getUi();
        if (ui == null) {
            return false;
        }
        return ui.hasPendingWork();
    }

    public static void waitWhileBusy(@NotNull JTree tree) {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long startTimeMillis = System.currentTimeMillis();
        while (PlatformTestUtil.isBusy(tree, tree.getModel())) {
            PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis);
            TimeoutUtil.sleep((long)5L);
        }
    }

    public static void waitForCallback(@NotNull ActionCallback callback) {
        AsyncPromise promise = new AsyncPromise();
        callback.doWhenDone(() -> promise.setResult(null)).doWhenRejected(() -> ((AsyncPromise)promise).cancel());
        PlatformTestUtil.waitForPromise(promise);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME, false);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise, long timeout) {
        return PlatformTestUtil.waitForPromise(promise, timeout, false);
    }

    @Nullable
    public static <T> T assertPromiseSucceeds(@NotNull Promise<T> promise) {
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME, true);
    }

    @Nullable
    private static <T> T waitForPromise(@NotNull Promise<T> promise, long timeout, boolean assertSucceeded) {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long start = System.currentTimeMillis();
        while (true) {
            if (promise.getState() == Promise.State.PENDING) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                return (T)promise.blockingGet(20, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                if (assertSucceeded) {
                    throw new AssertionError((Object)e);
                }
                return null;
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeout);
        }
    }

    public static <T> T waitForFuture(@NotNull Future<T> future, long timeoutMillis) {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long start = System.currentTimeMillis();
        while (true) {
            if (!future.isDone()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeoutMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAlarm(int delay) {
        @NotNull Application app = ApplicationManager.getApplication();
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        Disposable tempDisposable = Disposer.newDisposable();
        AtomicBoolean runnableInvoked = new AtomicBoolean();
        AtomicBoolean pooledRunnableInvoked = new AtomicBoolean();
        AtomicBoolean alarmInvoked1 = new AtomicBoolean();
        AtomicBoolean alarmInvoked2 = new AtomicBoolean();
        Alarm alarm = new Alarm();
        Alarm pooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, tempDisposable);
        ModalityState initialModality = ModalityState.current();
        alarm.addRequest(() -> {
            alarmInvoked1.set(true);
            app.invokeLater(() -> {
                runnableInvoked.set(true);
                alarm.addRequest(() -> alarmInvoked2.set(true), delay);
            });
        }, delay);
        pooledAlarm.addRequest(() -> pooledRunnableInvoked.set(true), delay);
        UIUtil.dispatchAllInvocationEvents();
        long start = System.currentTimeMillis();
        try {
            boolean sleptAlready = false;
            while (!alarmInvoked2.get()) {
                AtomicBoolean laterInvoked = new AtomicBoolean();
                app.invokeLater(() -> laterInvoked.set(true));
                UIUtil.dispatchAllInvocationEvents();
                Assert.assertTrue((boolean)laterInvoked.get());
                TimeoutUtil.sleep((long)(sleptAlready ? 10L : (long)delay));
                sleptAlready = true;
                if (PlatformTestUtil.getMillisSince(start) <= MAX_WAIT_TIME) continue;
                String queue = ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).dumpQueue();
                throw new AssertionError((Object)("Couldn't await alarm; alarm passed=" + alarmInvoked1.get() + "; modality1=" + initialModality + "; modality2=" + ModalityState.current() + "; non-modal=" + (initialModality == ModalityState.NON_MODAL) + "; invokeLater passed=" + runnableInvoked.get() + "; pooled alarm passed=" + pooledRunnableInvoked.get() + "; app.disposed=" + app.isDisposed() + "; alarm.disposed=" + alarm.isDisposed() + "; alarm.requests=" + alarm.getActiveRequestCount() + "\n delayQueue=" + StringUtil.trimLog((String)queue, (int)1000) + "\n invocatorEdtQueue=" + LaterInvocator.getLaterInvocatorEdtQueue()));
            }
        }
        finally {
            Disposer.dispose((Disposable)tempDisposable);
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void dispatchAllInvocationEventsInIdeEventQueue() {
        AWTEvent event;
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (!(event instanceof InvocationEvent)) continue;
                eventQueue.dispatchEvent(event);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void dispatchAllEventsInIdeEventQueue() {
        PlatformTestUtil.assertEventQueueDispatchThread();
        try {
            while (PlatformTestUtil.dispatchNextEventIfAny() != null) {
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static AWTEvent dispatchNextEventIfAny() throws InterruptedException {
        PlatformTestUtil.assertEventQueueDispatchThread();
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        AWTEvent event = eventQueue.peekEvent();
        if (event == null) {
            return null;
        }
        AWTEvent event1 = eventQueue.getNextEvent();
        eventQueue.dispatchEvent(event1);
        return event1;
    }

    @NotNull
    public static StringBuilder print(@NotNull AbstractTreeStructure structure, @NotNull Object node2, int currentLevel, @Nullable Comparator<?> comparator, int maxRowCount, char paddingChar, @Nullable Queryable.PrintInfo printInfo) {
        return PlatformTestUtil.print(structure, node2, currentLevel, comparator, maxRowCount, paddingChar, (Object o) -> PlatformTestUtil.toString(o, printInfo));
    }

    @NotNull
    public static String print(@NotNull AbstractTreeStructure structure, @NotNull Object node2, @NotNull Function<Object, String> nodePresenter) {
        return PlatformTestUtil.print(structure, node2, 0, Comparator.comparing(nodePresenter), -1, ' ', nodePresenter).toString();
    }

    @NotNull
    private static StringBuilder print(AbstractTreeStructure structure, Object node2, int currentLevel, @Nullable Comparator<?> comparator, int maxRowCount, char paddingChar, Function<Object, String> nodePresenter) {
        StringBuilder buffer = new StringBuilder();
        PlatformTestUtil.doPrint(buffer, currentLevel, node2, structure, comparator, maxRowCount, 0, paddingChar, nodePresenter);
        return buffer;
    }

    private static int doPrint(StringBuilder buffer, int currentLevel, Object node2, AbstractTreeStructure structure, @Nullable Comparator<?> comparator, int maxRowCount, int currentLine, char paddingChar, Function<Object, String> nodePresenter) {
        if (currentLine >= maxRowCount && maxRowCount != -1) {
            return currentLine;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)paddingChar, (int)currentLevel);
        buffer.append(nodePresenter.apply(node2)).append("\n");
        ++currentLine;
        Object[] children = structure.getChildElements(node2);
        if (comparator != null) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(children));
            Comparator<?> c = comparator;
            list.sort(c);
            children = ArrayUtil.toObjectArray(list);
        }
        for (Object child : children) {
            currentLine = PlatformTestUtil.doPrint(buffer, currentLevel + 1, child, structure, comparator, maxRowCount, currentLine, paddingChar, nodePresenter);
        }
        return currentLine;
    }

    @NotNull
    public static String print(Object @NotNull [] objects) {
        return PlatformTestUtil.print(Arrays.asList(objects));
    }

    @NotNull
    public static String print(@NotNull Collection<?> c) {
        return c.stream().map(each -> PlatformTestUtil.toString(each, null)).collect(Collectors.joining("\n"));
    }

    @NotNull
    public static String print(@NotNull ListModel<?> model) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            result2.append(PlatformTestUtil.toString(model.getElementAt(i2), null));
            result2.append("\n");
        }
        return result2.toString();
    }

    @NotNull
    public static String print(@NotNull JTree tree) {
        return PlatformTestUtil.print(tree, false);
    }

    public static void invokeNamedAction(@NotNull String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Assert.assertNotNull((Object)action);
        DataContext context2 = DataManager.getInstance().getDataContext();
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)context2);
        Assert.assertTrue((boolean)ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false));
        Assert.assertTrue((boolean)event.getPresentation().isEnabled());
        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)event);
    }

    public static void assertTiming(@NotNull String message, long expectedMs, long actual) {
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long expectedOnMyMachine = Math.max(1L, expectedMs * Timings.CPU_TIMING / 200L);
        Object logMessage = message;
        if (actual > expectedOnMyMachine) {
            int percentage = (int)(100.0 * (double)(actual - expectedOnMyMachine) / (double)expectedOnMyMachine);
            logMessage = (String)logMessage + ". Operation took " + percentage + "% longer than expected";
        }
        logMessage = (String)logMessage + ". Expected on my machine: " + expectedOnMyMachine + ". Actual: " + actual + ". Expected on Standard machine: " + expectedMs + "; Timings: CPU=" + Timings.CPU_TIMING + ", I/O=" + Timings.IO_TIMING + ".";
        double acceptableChangeFactor = 1.1;
        if (actual < expectedOnMyMachine) {
            System.out.println((String)logMessage);
            TeamCityLogger.info((String)logMessage);
        } else if ((double)actual < (double)expectedOnMyMachine * acceptableChangeFactor) {
            TeamCityLogger.warning((String)logMessage, null);
        } else {
            throw new AssertionFailedError((String)logMessage);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static PerformanceTestInfo startPerformanceTest(@NonNls @NotNull String what, int expectedMs, @NotNull ThrowableRunnable<?> test) {
        return PlatformTestUtil.startPerformanceTestWithVariableInputSize(what, expectedMs, 1, () -> {
            test.run();
            return 1;
        });
    }

    @Contract(pure=true)
    @NotNull
    public static PerformanceTestInfo startPerformanceTestWithVariableInputSize(@NonNls @NotNull String what, int expectedMs, int expectedInputSize, @NotNull ThrowableComputable<Integer, ?> test) {
        return new PerformanceTestInfo(test, expectedMs, expectedInputSize, what);
    }

    public static void assertPathsEqual(@Nullable String expected, @Nullable String actual) {
        if (expected != null) {
            expected = FileUtil.toSystemIndependentName((String)expected);
        }
        if (actual != null) {
            actual = FileUtil.toSystemIndependentName((String)actual);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @NotNull
    public static String getJavaExe() {
        return SystemProperties.getJavaHome() + (SystemInfo.isWindows ? "\\bin\\java.exe" : "/bin/java");
    }

    @NotNull
    public static URL getRtJarURL() {
        String home = SystemProperties.getJavaHome();
        try {
            return JavaVersion.current().feature >= 9 ? new URL("jrt:" + home) : new File(home + "/lib/rt.jar").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void forceCloseProjectWithoutSaving(@NotNull Project project2) {
        if (!project2.isDisposed()) {
            ApplicationManager.getApplication().invokeAndWait(() -> ProjectManagerEx.getInstanceEx().forceCloseProject(project2));
        }
    }

    public static void saveProject(@NotNull Project project2) {
        OpenProjectTaskBuilderKt.saveProject(project2, false);
    }

    public static void saveProject(@NotNull Project project2, boolean isForceSavingAllSettings) {
        OpenProjectTaskBuilderKt.saveProject(project2, isForceSavingAllSettings);
    }

    static void waitForAllBackgroundActivityToCalmDown() {
        CpuUsageData data;
        for (int i2 = 0; i2 < 50 && (data = CpuUsageData.measureCpuUsage(() -> TimeoutUtil.sleep((long)100L))).hasAnyActivityBesides(Thread.currentThread()); ++i2) {
        }
    }

    public static void assertTiming(@NotNull String message, long expected, @NotNull Runnable actionToMeasure) {
        PlatformTestUtil.assertTiming(message, expected, 4, actionToMeasure);
    }

    public static void assertTiming(@NotNull String message, long expected, int attempts, @NotNull Runnable actionToMeasure) {
        while (true) {
            --attempts;
            PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
            long duration = TimeoutUtil.measureExecutionTime(actionToMeasure::run);
            try {
                PlatformTestUtil.assertTiming(message, expected, duration);
            }
            catch (AssertionFailedError e) {
                if (attempts == 0) {
                    throw e;
                }
                System.gc();
                System.gc();
                System.gc();
                String s = e.getMessage() + "\n  " + attempts + " " + StringUtil.pluralize((String)"attempt", (int)attempts) + " remain";
                TeamCityLogger.warning(s, null);
                System.err.println(s);
                continue;
            }
            break;
        }
    }

    @NotNull
    private static Map<String, VirtualFile> buildNameToFileMap(VirtualFile @NotNull [] files, @Nullable VirtualFileFilter filter) {
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        for (VirtualFile file2 : files) {
            if (filter != null && !filter.accept(file2)) continue;
            map.put(file2.getName(), file2);
        }
        return map;
    }

    public static void assertDirectoriesEqual(@NotNull VirtualFile dirExpected, @NotNull VirtualFile dirActual) throws IOException {
        PlatformTestUtil.assertDirectoriesEqual(dirExpected, dirActual, null);
    }

    public static void assertDirectoriesEqual(@NotNull VirtualFile dirExpected, @NotNull VirtualFile dirActual, @Nullable VirtualFileFilter fileFilter) throws IOException {
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] childrenAfter = dirExpected.getChildren();
        PlatformTestUtil.shallowCompare(dirExpected, childrenAfter);
        VirtualFile[] childrenBefore = dirActual.getChildren();
        PlatformTestUtil.shallowCompare(dirActual, childrenBefore);
        Map<String, VirtualFile> mapAfter = PlatformTestUtil.buildNameToFileMap(childrenAfter, fileFilter);
        Map<String, VirtualFile> mapBefore = PlatformTestUtil.buildNameToFileMap(childrenBefore, fileFilter);
        Set<String> keySetAfter = mapAfter.keySet();
        Set<String> keySetBefore = mapBefore.keySet();
        Assert.assertEquals((String)dirExpected.getPath(), keySetAfter, keySetBefore);
        for (String name : keySetAfter) {
            VirtualFile fileAfter = mapAfter.get(name);
            VirtualFile fileBefore = mapBefore.get(name);
            if (fileAfter.isDirectory()) {
                PlatformTestUtil.assertDirectoriesEqual(fileAfter, fileBefore, fileFilter);
                continue;
            }
            PlatformTestUtil.assertFilesEqual(fileAfter, fileBefore);
        }
    }

    private static void shallowCompare(@NotNull VirtualFile dir, VirtualFile @NotNull [] vfs) {
        if (dir.isInLocalFileSystem() && dir.getFileSystem() != TempFileSystem.getInstance()) {
            String vfsPaths = Stream.of(vfs).map(VirtualFile::getPath).sorted().collect(Collectors.joining("\n"));
            File[] io = Objects.requireNonNull(new File(dir.getPath()).listFiles());
            String ioPaths = Stream.of(io).map(f -> FileUtil.toSystemIndependentName((String)f.getPath())).sorted().collect(Collectors.joining("\n"));
            Assert.assertEquals((Object)vfsPaths, (Object)ioPaths);
        }
    }

    public static void assertFilesEqual(@NotNull VirtualFile fileExpected, @NotNull VirtualFile fileActual) throws IOException {
        block3: {
            try {
                PlatformTestUtil.assertJarFilesEqual(VfsUtilCore.virtualToIoFile((VirtualFile)fileExpected), VfsUtilCore.virtualToIoFile((VirtualFile)fileActual));
            }
            catch (IOException e) {
                String actual = PlatformTestUtil.fileText(fileActual);
                String expected = PlatformTestUtil.fileText(fileExpected);
                if (expected == null || actual == null) {
                    Assert.assertArrayEquals((String)fileExpected.getPath(), (byte[])fileExpected.contentsToByteArray(), (byte[])fileActual.contentsToByteArray());
                }
                if (StringUtil.equals((CharSequence)expected, (CharSequence)actual)) break block3;
                throw new FileComparisonFailure("Text mismatch in the file " + fileExpected.getName(), expected, actual, fileExpected.getPath());
            }
        }
    }

    private static String fileText(@NotNull VirtualFile file2) throws IOException {
        Document doc = FileDocumentManager.getInstance().getDocument(file2);
        if (doc != null) {
            return doc.getText();
        }
        if (!file2.getFileType().isBinary() || FileTypeRegistry.getInstance().isFileOfType(file2, FileTypes.UNKNOWN)) {
            return LoadTextUtil.getTextByBinaryPresentation((byte[])file2.contentsToByteArray(false), (VirtualFile)file2).toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertJarFilesEqual(File file1, File file2) throws IOException {
        Path tempDir = Files.createTempDirectory("assert_jar_tmp_", new FileAttribute[0]);
        try (JarFile jarFile1 = new JarFile(file1);
             JarFile jarFile2 = new JarFile(file2);){
            Path tempDirectory1 = Files.createDirectory(tempDir.resolve("tmp1"), new FileAttribute[0]);
            Path tempDirectory2 = Files.createDirectory(tempDir.resolve("tmp2"), new FileAttribute[0]);
            new Decompressor.Zip(new File(jarFile1.getName())).extract(tempDirectory1);
            new Decompressor.Zip(new File(jarFile2.getName())).extract(tempDirectory2);
            VirtualFile dirAfter = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(tempDirectory1);
            Assert.assertNotNull((String)tempDirectory1.toString(), (Object)dirAfter);
            VirtualFile dirBefore = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(tempDirectory2);
            Assert.assertNotNull((String)tempDirectory2.toString(), (Object)dirBefore);
            ApplicationManager.getApplication().runWriteAction(() -> {
                dirAfter.refresh(false, true);
                dirBefore.refresh(false, true);
            });
            PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore);
        }
        finally {
            NioFiles.deleteRecursively((Path)tempDir);
        }
    }

    @NotNull
    public static String getCommunityPath() {
        Object homePath = IdeaTestExecutionPolicy.getHomePathWithPolicy();
        if (new File((String)homePath, "community/.idea").isDirectory()) {
            homePath = (String)homePath + File.separatorChar + "community";
        }
        return homePath;
    }

    @NotNull
    public static String getPlatformTestDataPath() {
        return PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/') + "/platform/platform-tests/testData/";
    }

    @Contract(pure=true)
    @NotNull
    public static Comparator<AbstractTreeNode<?>> createComparator(Queryable.PrintInfo printInfo) {
        return (o1, o2) -> {
            String displayText1 = o1.toTestString(printInfo);
            String displayText2 = o2.toTestString(printInfo);
            return Comparing.compare((Comparable)((Object)displayText1), (Comparable)((Object)displayText2));
        };
    }

    @NotNull
    public static String loadFileText(@NotNull String fileName) throws IOException {
        return StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(fileName)));
    }

    public static void withEncoding(@NotNull String encoding, @NotNull ThrowableRunnable<?> r) {
        Charset.forName(encoding);
        try {
            Charset oldCharset = Charset.defaultCharset();
            try {
                PlatformTestUtil.patchSystemFileEncoding(encoding);
                r.run();
            }
            finally {
                PlatformTestUtil.patchSystemFileEncoding(oldCharset.name());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void patchSystemFileEncoding(@NotNull String encoding) {
        ReflectionUtil.resetField(Charset.class, Charset.class, (String)"defaultCharset");
        System.setProperty("file.encoding", encoding);
    }

    public static void withStdErrSuppressed(@NotNull Runnable r) {
        PrintStream std = System.err;
        System.setErr(new PrintStream(OutputStream.nullOutputStream()));
        try {
            r.run();
        }
        finally {
            System.setErr(std);
        }
    }

    public static void assertSuccessful(@NotNull GeneralCommandLine command) {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command.withRedirectErrorStream(true));
            Assert.assertEquals((String)output.getStdout(), (long)0L, (long)output.getExitCode());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static List<WebReference> collectWebReferences(@NotNull PsiElement element) {
        final ArrayList<WebReference> refs = new ArrayList<WebReference>();
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                for (PsiReference ref : element.getReferences()) {
                    if (!(ref instanceof WebReference)) continue;
                    refs.add((WebReference)ref);
                }
                super.visitElement(element);
            }
        });
        return refs;
    }

    @NotNull
    public static List<UrlReference> collectUrlReferences(@NotNull PsiElement element) {
        SmartList result2 = new SmartList();
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)result2){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public void visitElement(@NotNull PsiElement element) {
                this.val$result.addAll(PsiSymbolReferenceService.getService().getReferences(element, UrlReference.class));
                super.visitElement(element);
            }
        });
        return result2;
    }

    @NotNull
    public static <T extends PsiReference> T getReferenceOfTypeWithAssertion(@Nullable PsiReference reference, @NotNull Class<T> refType) {
        if (refType.isInstance(reference)) {
            return (T)reference;
        }
        if (reference instanceof PsiMultiReference) {
            PsiReference[] psiReferences;
            for (PsiReference psiReference : psiReferences = ((PsiMultiReference)reference).getReferences()) {
                if (!refType.isInstance(psiReference)) continue;
                return (T)psiReference;
            }
        }
        throw new AssertionError((Object)("given reference should be " + refType + " but " + (reference != null ? reference.getClass() : null) + " was given"));
    }

    public static void registerProjectCleanup(@NotNull Runnable cleanup) {
        ourProjectCleanups.add(cleanup);
    }

    public static void cleanupAllProjects() {
        for (Runnable each : ourProjectCleanups) {
            each.run();
        }
        ourProjectCleanups.clear();
    }

    public static <T> void assertComparisonContractNotViolated(@NotNull List<? extends T> values, @NotNull Comparator<? super T> comparator, @NotNull BiPredicate<? super T, ? super T> equality) {
        for (int i1 = 0; i1 < values.size(); ++i1) {
            for (int i2 = i1; i2 < values.size(); ++i2) {
                T value1 = values.get(i1);
                T value2 = values.get(i2);
                int result12 = comparator.compare(value1, value2);
                int result21 = comparator.compare(value2, value1);
                if (equality.test(value1, value2)) {
                    if (result12 != 0) {
                        Assert.fail((String)String.format("Equal, but not 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 != 0) {
                        Assert.fail((String)String.format("Equal, but not 0: '%s' - '%s'", value2, value1));
                    }
                } else {
                    if (result12 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value2, value1));
                    }
                    if (Integer.signum(result12) == Integer.signum(result21)) {
                        Assert.fail((String)String.format("Not symmetrical: '%s' - '%s'", value1, value2));
                    }
                }
                for (int i3 = i2; i3 < values.size(); ++i3) {
                    int result31;
                    T value3 = values.get(i3);
                    int result23 = comparator.compare(value2, value3);
                    if (PlatformTestUtil.isTransitive(result12, result23, result31 = comparator.compare(value3, value1))) continue;
                    Assert.fail((String)String.format("Not transitive: '%s' - '%s' - '%s'", value1, value2, value3));
                }
            }
        }
    }

    private static boolean isTransitive(int result12, int result23, int result31) {
        if (result12 == 0 && result23 == 0 && result31 == 0) {
            return true;
        }
        if (result12 > 0 && result23 > 0 && result31 > 0) {
            return false;
        }
        if (result12 < 0 && result23 < 0 && result31 < 0) {
            return false;
        }
        if (result12 == 0 && Integer.signum(result23) * Integer.signum(result31) >= 0) {
            return false;
        }
        if (result23 == 0 && Integer.signum(result12) * Integer.signum(result31) >= 0) {
            return false;
        }
        return result31 != 0 || Integer.signum(result23) * Integer.signum(result12) < 0;
    }

    public static void setLongMeaninglessFileIncludeTemplateTemporarilyFor(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        FileTemplateManagerImpl templateManager = (FileTemplateManagerImpl)FileTemplateManager.getInstance((Project)project2);
        templateManager.setDefaultFileIncludeTemplateTextTemporarilyForTest("File Header", "/**\n * Created by ${USER} on ${DATE}.\n */\n", parentDisposable);
    }

    @NotNull
    public static VirtualFile getOrCreateProjectBaseDir(@NotNull Project project2) {
        return HeavyTestHelper.getOrCreateProjectBaseDir(project2);
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(@NotNull PsiElement element, @NotNull RunConfigurationProducer<?> producer) {
        MapDataContext dataContext = new MapDataContext();
        dataContext.put(CommonDataKeys.PROJECT, element.getProject());
        dataContext.put(PlatformCoreDataKeys.MODULE, ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
        Location location = PsiLocation.fromPsiElement((PsiElement)element);
        dataContext.put(Location.DATA_KEY, location);
        ConfigurationContext cc = ConfigurationContext.getFromContext((DataContext)dataContext, (String)"unknown");
        ConfigurationFromContext configuration = producer.createConfigurationFromContext(cc);
        return configuration != null ? configuration.getConfiguration() : null;
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration) throws InterruptedException {
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, "Run");
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, long timeoutInSeconds) throws InterruptedException {
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, "Run", timeoutInSeconds);
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, @NotNull String executorId) throws InterruptedException {
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, executorId, 60L);
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, @NotNull String executorId, long timeoutInSeconds) throws InterruptedException {
        Pair<@NotNull ExecutionEnvironment, RunContentDescriptor> result2 = PlatformTestUtil.executeConfiguration(runConfiguration, executorId, null);
        ProcessHandler processHandler = ((RunContentDescriptor)result2.second).getProcessHandler();
        Assert.assertNotNull((String)"Process handler must not be null!", (Object)processHandler);
        PlatformTestUtil.waitWithEventsDispatching("Process failed to finish in " + timeoutInSeconds + " seconds: " + processHandler, () -> ((ProcessHandler)processHandler).isProcessTerminated(), Math.toIntExact(timeoutInSeconds));
        return (ExecutionEnvironment)result2.first;
    }

    @NotNull
    public static @NotNull Pair<@NotNull ExecutionEnvironment, RunContentDescriptor> executeConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull String executorId, @Nullable Consumer<? super RunContentDescriptor> contentDescriptorProcessor) throws InterruptedException {
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        Assert.assertNotNull((String)("Unable to find executor: " + executorId), (Object)executor);
        return PlatformTestUtil.executeConfiguration(runConfiguration, executor, contentDescriptorProcessor);
    }

    @NotNull
    public static @NotNull Pair<@NotNull ExecutionEnvironment, RunContentDescriptor> executeConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull Executor executor, @Nullable Consumer<? super RunContentDescriptor> descriptorProcessor) throws InterruptedException {
        Project project2 = runConfiguration.getProject();
        ConfigurationFactory factory = runConfiguration.getFactory();
        if (factory == null) {
            Assert.fail((String)("No factory found for: " + runConfiguration));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project2).createConfiguration(runConfiguration, factory);
        ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConfiguration);
        if (runner == null) {
            Assert.fail((String)("No runner found for: " + executor.getId() + " and " + runConfiguration));
        }
        Ref refRunContentDescriptor = new Ref();
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment(executor, runner, runnerAndConfigurationSettings, project2);
        ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)executionEnvironment, (boolean)false, (boolean)false, descriptor -> {
            LOG.debug("Process started");
            if (descriptorProcessor != null) {
                descriptorProcessor.accept(descriptor);
            }
            ProcessHandler processHandler = descriptor.getProcessHandler();
            Assert.assertNotNull((Object)processHandler);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    LOG.debug("Process notified");
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    LOG.debug("Process terminated: exitCode: " + event.getExitCode() + "; text: " + event.getText());
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    LOG.debug(outputType + ": " + event.getText());
                }
            });
            refRunContentDescriptor.set((Object)descriptor);
        });
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        PlatformTestUtil.waitWithEventsDispatching("Process failed to start in 60 seconds", () -> !refRunContentDescriptor.isNull(), 60);
        return Pair.create((Object)executionEnvironment, (Object)((RunContentDescriptor)refRunContentDescriptor.get()));
    }

    public static void waitWithEventsDispatching(@NotNull String errorMessage, @NotNull BooleanSupplier condition, int timeoutInSeconds) {
        PlatformTestUtil.waitWithEventsDispatching(() -> errorMessage, condition, timeoutInSeconds);
    }

    public static void waitWithEventsDispatching(@NotNull Supplier<String> errorMessageSupplier, @NotNull BooleanSupplier condition, int timeoutInSeconds) {
        PlatformTestUtil.waitWithEventsDispatching(errorMessageSupplier, condition, timeoutInSeconds, null);
    }

    public static void waitWithEventsDispatching(@NotNull Supplier<String> errorMessageSupplier, @NotNull BooleanSupplier condition, int timeoutInSeconds, @Nullable Runnable callback) {
        long start = System.currentTimeMillis();
        try {
            while (true) {
                if (System.currentTimeMillis() - start > (long)timeoutInSeconds * 1000L) {
                    ObjectUtils.consumeIfNotNull((Object)callback, Runnable::run);
                    Assert.fail((String)errorMessageSupplier.get());
                }
                if (condition.getAsBoolean()) {
                    ObjectUtils.consumeIfNotNull((Object)callback, Runnable::run);
                    break;
                }
                PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static PsiElement findElementBySignature(@NotNull String signature, @NotNull String fileRelativePath, @NotNull Project project2) {
        String filePath = project2.getBasePath() + File.separator + fileRelativePath;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null || !virtualFile.exists()) {
            throw new IllegalArgumentException(String.format("File '%s' doesn't exist", filePath));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        int offset = psiFile.getText().indexOf(signature);
        return psiFile.findElementAt(offset);
    }

    public static void useAppConfigDir(@NotNull ThrowableRunnable<? extends Exception> task) throws Exception {
        Path configCopy;
        Path configDir = PathManager.getConfigDir();
        if (Files.exists(configDir, new LinkOption[0])) {
            configCopy = Files.move(configDir, Paths.get(configDir + "_bak", new String[0]), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        } else {
            FileUtil.delete((Path)configDir);
            configCopy = null;
        }
        try {
            task.run();
        }
        catch (Throwable throwable) {
            FileUtil.delete((Path)configDir);
            if (configCopy != null) {
                Files.move(configCopy, configDir, StandardCopyOption.ATOMIC_MOVE);
            }
            throw throwable;
        }
        FileUtil.delete((Path)configDir);
        if (configCopy != null) {
            Files.move(configCopy, configDir, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    @NotNull
    public static Project loadAndOpenProject(@NotNull Path path, @NotNull Disposable parent) {
        Project project2 = Objects.requireNonNull(ProjectManagerEx.getInstanceEx().openProject(path, new OpenProjectTaskBuilder().build()));
        Disposer.register((Disposable)parent, () -> PlatformTestUtil.forceCloseProjectWithoutSaving(project2));
        return project2;
    }

    public static boolean isUnderCommunityClassPath() {
        return StdFileTypes.JSPX == FileTypes.PLAIN_TEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> void withSystemProperty(@NotNull String key, String value, @NotNull ThrowableRunnable<E> task) throws E {
        String original = System.setProperty(key, value);
        try {
            task.run();
        }
        finally {
            SystemProperties.setProperty((String)key, (String)original);
        }
    }
}

