/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.StorageLockContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PerformanceTestInfo {
    private final ThrowableComputable<Integer, ?> test;
    private final int expectedMs;
    private final int expectedInputSize;
    private ThrowableRunnable<?> setup;
    private int usedReferenceCpuCores = 1;
    private int maxRetries = 4;
    private final String what;
    private boolean adjustForIO;
    private boolean adjustForCPU = true;
    private boolean useLegacyScaling;
    private int warmupIterations = Integer.MIN_VALUE;
    private long lastJitUsage;
    private long lastJitStamp = -1L;

    PerformanceTestInfo(@NotNull ThrowableComputable<Integer, ?> test, int expectedMs, int expectedInputSize, @NotNull String what) {
        this.test = test;
        this.expectedMs = expectedMs;
        this.expectedInputSize = expectedInputSize;
        assert (expectedMs > 0) : "Expected must be > 0. Was: " + expectedMs;
        assert (expectedInputSize > 0) : "Expected input size must be > 0. Was: " + expectedInputSize;
        this.what = what;
    }

    @Contract(pure=true)
    public PerformanceTestInfo setup(@NotNull ThrowableRunnable<?> setup) {
        assert (this.setup == null);
        this.setup = setup;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesAllCPUCores() {
        return this.usesMultipleCPUCores(8);
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesMultipleCPUCores(int maxCores) {
        assert (this.adjustForCPU) : "This test configured to be io-bound, it cannot use all cores";
        this.usedReferenceCpuCores = maxCores;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo ioBound() {
        this.adjustForIO = true;
        this.adjustForCPU = false;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo attempts(int attempts) {
        this.maxRetries = attempts;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo warmupIterations(int iterations) {
        assert (this.warmupIterations == Integer.MIN_VALUE) : "Already called warmupIterations()";
        assert (iterations >= 1) : "invalid argument: " + iterations + "; must be >= 1";
        this.warmupIterations = iterations;
        return this;
    }

    @Deprecated
    @Contract(pure=true)
    public PerformanceTestInfo useLegacyScaling() {
        this.useLegacyScaling = true;
        return this;
    }

    public void assertTiming() {
        if (PlatformTestUtil.COVERAGE_ENABLED_BUILD) {
            return;
        }
        Timings.getStatistics();
        this.updateJitUsage();
        if (this.maxRetries == 1) {
            System.gc();
        }
        int initialMaxRetries = this.maxRetries;
        for (int attempt = 1; attempt <= this.maxRetries; ++attempt) {
            CpuUsageData data;
            AtomicInteger actualInputSize;
            try {
                if (this.setup != null) {
                    this.setup.run();
                }
                PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
                actualInputSize = new AtomicInteger(this.expectedInputSize);
                if (this.warmupIterations != Integer.MIN_VALUE) {
                    for (int i2 = 0; i2 < this.warmupIterations; ++i2) {
                        this.test.compute();
                    }
                }
                data = CpuUsageData.measureCpuUsage(() -> actualInputSize.set((Integer)this.test.compute()));
            }
            catch (Throwable throwable) {
                ExceptionUtil.rethrowUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            int expectedOnMyMachine = this.getExpectedTimeOnThisMachine(actualInputSize.get());
            IterationResult iterationResult = data.getIterationResult(expectedOnMyMachine);
            boolean testPassed = iterationResult == IterationResult.ACCEPTABLE || iterationResult == IterationResult.BORDERLINE;
            String logMessage = this.formatMessage(data, expectedOnMyMachine, actualInputSize.get(), iterationResult, initialMaxRetries);
            if (testPassed) {
                TeamCityLogger.info(logMessage);
                System.out.println("\nSUCCESS: " + logMessage);
                return;
            }
            TeamCityLogger.warning(logMessage, null);
            if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                System.out.println("\nWARNING: " + logMessage);
            }
            JitUsageResult jitUsage = this.updateJitUsage();
            if (attempt == this.maxRetries) {
                throw new AssertionFailedError(logMessage);
            }
            if ((iterationResult == IterationResult.DISTRACTED || jitUsage == JitUsageResult.UNCLEAR) && attempt < initialMaxRetries + 30 && this.maxRetries != 1) {
                ++this.maxRetries;
            }
            String s = "  " + (this.maxRetries - attempt) + " " + StringUtil.pluralize((String)"attempt", (int)(this.maxRetries - attempt)) + " remain" + (String)(jitUsage == JitUsageResult.UNCLEAR ? " (waiting for JITc; its usage was " + jitUsage + " in this iteration)" : "");
            TeamCityLogger.warning(s, null);
            if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                System.out.println(s);
            }
            System.gc();
            StorageLockContext.forceDirectMemoryCache();
        }
    }

    @NotNull
    private String formatMessage(@NotNull CpuUsageData data, int expectedOnMyMachine, int actualInputSize, @NotNull IterationResult iterationResult, int initialMaxRetries) {
        long duration = data.durationMs;
        int percentage = (int)(100.0 * (double)(duration - (long)expectedOnMyMachine) / (double)expectedOnMyMachine);
        String colorCode = iterationResult == IterationResult.ACCEPTABLE ? "32;1m" : (iterationResult == IterationResult.BORDERLINE ? "33;1m" : "31;1m");
        return this.what + " took \u001b[" + colorCode + Math.abs(percentage) + "% " + (percentage > 0 ? "more" : "less") + " time\u001b[0m than expected" + (iterationResult == IterationResult.DISTRACTED && initialMaxRetries != 1 ? " (but JIT compilation took too long, will retry anyway)" : "") + "\n  Expected: " + expectedOnMyMachine + "ms" + (String)(expectedOnMyMachine < 1000 ? "" : " (" + StringUtil.formatDuration((long)expectedOnMyMachine) + ")") + "\n  Actual:   " + duration + "ms" + (String)(duration < 1000L ? "" : " (" + StringUtil.formatDuration((long)duration) + ")") + (String)(this.expectedInputSize != actualInputSize ? "\n  (Expected time was adjusted accordingly to input size: expected " + this.expectedInputSize + ", actual " + actualInputSize + ".)" : "") + "\n  Timings:  " + Timings.getStatistics() + "\n  Threads:  " + data.getThreadStats() + "\n  GC stats: " + data.getGcStats() + "\n  Process:  " + data.getProcessCpuStats();
    }

    private JitUsageResult updateJitUsage() {
        long timeNow = System.nanoTime();
        long jitNow = CpuUsageData.getTotalCompilationMillis();
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(timeNow - this.lastJitStamp);
        if (this.lastJitStamp >= 0L) {
            if (elapsedMillis >= 3000L) {
                if (jitNow - this.lastJitUsage <= elapsedMillis / 10L) {
                    return JitUsageResult.DEFINITELY_LOW;
                }
            } else {
                return JitUsageResult.UNCLEAR;
            }
        }
        this.lastJitStamp = timeNow;
        this.lastJitUsage = jitNow;
        return JitUsageResult.UNCLEAR;
    }

    private int getExpectedTimeOnThisMachine(int actualInputSize) {
        int expectedOnMyMachine = (int)((long)this.expectedMs * (long)actualInputSize / (long)this.expectedInputSize);
        if (this.adjustForCPU) {
            int coreCountUsedHere = this.usedReferenceCpuCores < 8 ? Math.min(JobSchedulerImpl.getJobPoolParallelism(), this.usedReferenceCpuCores) : JobSchedulerImpl.getJobPoolParallelism();
            expectedOnMyMachine *= this.usedReferenceCpuCores;
            expectedOnMyMachine = PerformanceTestInfo.adjust(expectedOnMyMachine, Timings.CPU_TIMING, 200L, this.useLegacyScaling);
            expectedOnMyMachine /= coreCountUsedHere;
        }
        if (this.adjustForIO) {
            expectedOnMyMachine = PerformanceTestInfo.adjust(expectedOnMyMachine, Timings.IO_TIMING, 100L, this.useLegacyScaling);
        }
        return expectedOnMyMachine;
    }

    private static int adjust(int expectedOnMyMachine, long thisTiming, long referenceTiming, boolean useLegacyScaling) {
        if (useLegacyScaling) {
            double speed = 1.0 * (double)thisTiming / (double)referenceTiming;
            double delta = speed < 1.0 ? 0.9 + Math.pow(speed - 0.7, 2.0) : 0.45 + Math.pow(speed - 0.25, 2.0);
            expectedOnMyMachine = (int)((double)expectedOnMyMachine * delta);
            return expectedOnMyMachine;
        }
        return (int)((long)expectedOnMyMachine * thisTiming / referenceTiming);
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
    }

    private static enum JitUsageResult {
        DEFINITELY_LOW,
        UNCLEAR;

    }

    static enum IterationResult {
        ACCEPTABLE,
        BORDERLINE,
        SLOW,
        DISTRACTED;

    }
}

