/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParsingTestUtil {
    private static final String SEPARATOR = "---------------";
    private static final String NL_SEPARATOR_NL = "\n---------------\n";

    private ParsingTestUtil() {
    }

    public static void ensureNoErrorElementsInAllSubTrees(@NotNull PsiFile file2) {
        for (PsiFile subTree : file2.getViewProvider().getAllFiles()) {
            ParsingTestUtil.ensureNoErrorElements(subTree);
        }
    }

    public static void ensureNoErrorElements(final @NotNull PsiFile file2) {
        file2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            private static final int TAB_WIDTH = 8;

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                String text = file2.getText();
                String[] lines2 = StringUtil.splitByLinesKeepSeparators((String)text);
                int offset = element.getTextOffset();
                LineColumn position = StringUtil.offsetToLineColumn((CharSequence)text, (int)offset);
                int lineNumber = position != null ? position.line : -1;
                int column = position != null ? position.column : 0;
                String line = StringUtil.trimTrailing((String)lines2[lineNumber]);
                int numIndentTabs = StringUtil.countChars((CharSequence)line.subSequence(0, column), (char)'\t', (int)0, (boolean)true);
                int indentedColumn = column + numIndentTabs * 7;
                String lineWithNoTabs = StringUtil.repeat((String)" ", (int)(numIndentTabs * 8)) + line.substring(numIndentTabs).replace('\t', ' ');
                String errorUnderline = StringUtil.repeat((String)" ", (int)indentedColumn) + StringUtil.repeat((String)"^", (int)Math.max(1, element.getTextLength()));
                TestCase.fail((String)String.format("Unexpected error element: %s:%d:%d\n\n%s\n%s\n%s", file2.getName(), lineNumber + 1, column, lineWithNoTabs, errorUnderline, element.getErrorDescription()));
            }
        });
    }

    @NotNull
    public static String psiFileToString(@NotNull PsiFile psiFile) {
        StringBuilder result2 = new StringBuilder();
        for (PsiFile subTree : psiFile.getViewProvider().getAllFiles()) {
            result2.append("Language: ").append(subTree.getLanguage()).append("\n").append(DebugUtil.psiToString((PsiElement)subTree, (boolean)true, (boolean)false));
        }
        return result2.toString();
    }

    public static void testIncrementalParsing(@NotNull PsiFile psiFile, @NotNull CharSequence newFileText, @NotNull String answersFilePath, boolean checkInitialTreeForErrors, boolean checkFinalTreeForErrors) {
        if (checkInitialTreeForErrors) {
            ParsingTestUtil.ensureNoErrorElements(psiFile);
        }
        Project project2 = psiFile.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        Document fileDocument = psiDocumentManager.getDocument(psiFile);
        TestCase.assertNotNull((Object)fileDocument);
        psiDocumentManager.commitDocument(fileDocument);
        CharSequence originalText = fileDocument.getCharsSequence();
        StringBuilder result2 = new StringBuilder("Original text:").append(NL_SEPARATOR_NL).append(originalText).append(NL_SEPARATOR_NL);
        List allFiles = psiFile.getViewProvider().getAllFiles();
        ContainerUtil.sort((List)allFiles, Comparator.comparing(it -> it.getLanguage().getID()));
        for (PsiFile subTree : allFiles) {
            UsefulTestCase.assertInstanceOf(subTree, PsiFileImpl.class);
            PsiFileImpl subTreeFile = (PsiFileImpl)subTree;
            TextRange changedRange = ChangedPsiRangeUtil.getChangedPsiRange((PsiFile)subTreeFile, (FileElement)Objects.requireNonNull(subTreeFile.getTreeElement()), (CharSequence)newFileText);
            TestCase.assertNotNull((String)"No changes found", (Object)changedRange);
            Couple reparseableRoots = BlockSupportImpl.findReparseableRoots((PsiFileImpl)subTreeFile, (FileASTNode)subTree.getNode(), (TextRange)changedRange, (CharSequence)newFileText);
            result2.append("Subtree: ").append(subTree.getLanguage()).append(NL_SEPARATOR_NL);
            ParsingTestUtil.serializeReparseableRoots((Couple<ASTNode>)reparseableRoots, result2, newFileText);
            result2.append(NL_SEPARATOR_NL);
        }
        WriteAction.run(() -> fileDocument.setText(newFileText));
        psiDocumentManager.commitDocument(fileDocument);
        String psiBeforeCommit = ParsingTestUtil.psiFileToString(psiFile);
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            fileDocument.setText((CharSequence)"");
            psiDocumentManager.commitDocument(fileDocument);
            fileDocument.setText(newFileText);
            psiDocumentManager.commitDocument(fileDocument);
        });
        TestCase.assertEquals((String)"Reparsing error", (String)ParsingTestUtil.psiFileToString(psiFile), (String)psiBeforeCommit);
        if (checkFinalTreeForErrors) {
            ParsingTestUtil.ensureNoErrorElementsInAllSubTrees(psiFile);
        }
        UsefulTestCase.assertSameLinesWithFile(answersFilePath, result2.toString(), false);
    }

    private static void serializeReparseableRoots(@Nullable Couple<ASTNode> reparseableRoots, @NotNull StringBuilder result2, @NotNull CharSequence newText) {
        TextRange reparsedRange = reparseableRoots == null ? TextRange.create((int)0, (int)newText.length()) : TextRange.from((int)((ASTNode)reparseableRoots.first).getStartOffset(), (int)((ASTNode)reparseableRoots.second).getTextLength());
        result2.append(newText, 0, reparsedRange.getStartOffset());
        result2.append("<reparse>");
        result2.append(newText, reparsedRange.getStartOffset(), reparsedRange.getEndOffset());
        result2.append("</reparse>");
        result2.append(newText, reparsedRange.getEndOffset(), newText.length());
    }
}

