/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.testFramework.AbstractMockGlyphVector;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.function.IntToDoubleFunction;
import org.jetbrains.annotations.NotNull;

public class MockFontLayoutService
extends FontLayoutService {
    private final IntToDoubleFunction myCharWidthFunction;
    private final int myCharWidth;
    private final int myLineHeight;
    private final int myDescent;

    public MockFontLayoutService(int charWidth, int lineHeight, int descent) {
        this.myCharWidthFunction = null;
        this.myCharWidth = charWidth;
        this.myLineHeight = lineHeight;
        this.myDescent = descent;
    }

    public MockFontLayoutService(IntToDoubleFunction charWidthFunction, int lineHeight, int descent) {
        this.myCharWidthFunction = charWidthFunction;
        this.myCharWidth = -1;
        this.myLineHeight = lineHeight;
        this.myDescent = descent;
    }

    @NotNull
    public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, char @NotNull [] chars, int start, int end, boolean isRtl) {
        return new MockGlyphVector(Arrays.copyOfRange(chars, start, end), isRtl);
    }

    private double getCharWidth(int codePoint) {
        return this.myCharWidthFunction == null ? (double)this.myCharWidth : (double)((float)this.myCharWidthFunction.applyAsDouble(codePoint));
    }

    public int charWidth(@NotNull FontMetrics fontMetrics, char c) {
        return (int)this.getCharWidth(c);
    }

    public int charWidth(@NotNull FontMetrics fontMetrics, int codePoint) {
        return (int)this.getCharWidth(codePoint);
    }

    public float charWidth2D(@NotNull FontMetrics fontMetrics, int codePoint) {
        return (float)this.getCharWidth(codePoint);
    }

    public int stringWidth(@NotNull FontMetrics fontMetrics, @NotNull String str) {
        if (this.myCharWidthFunction == null) {
            return this.myCharWidth * str.codePointCount(0, str.length());
        }
        float width = 0.0f;
        int pos = 0;
        while (pos < str.length()) {
            width = (float)((double)width + this.myCharWidthFunction.applyAsDouble(str.codePointAt(pos)));
            pos = str.offsetByCodePoints(pos, 1);
        }
        return Math.round(width);
    }

    public int getHeight(@NotNull FontMetrics fontMetrics) {
        return this.myLineHeight;
    }

    public int getDescent(@NotNull FontMetrics fontMetrics) {
        return this.myDescent;
    }

    private final class MockGlyphVector
    extends AbstractMockGlyphVector {
        private final char[] myChars;
        private final boolean myIsRtl;

        private MockGlyphVector(char[] chars, boolean isRtl) {
            this.myChars = chars;
            this.myIsRtl = isRtl;
        }

        @Override
        public int getNumGlyphs() {
            return this.myChars.length;
        }

        @Override
        public int getGlyphCharIndex(int glyphIndex) {
            return this.myIsRtl ? this.myChars.length - 1 - glyphIndex : glyphIndex;
        }

        @Override
        public Point2D getGlyphPosition(int glyphIndex) {
            double x = 0.0;
            if (MockFontLayoutService.this.myCharWidthFunction == null) {
                x = glyphIndex * MockFontLayoutService.this.myCharWidth;
            } else {
                for (int i2 = 0; i2 < glyphIndex; ++i2) {
                    x += MockFontLayoutService.this.myCharWidthFunction.applyAsDouble(this.myChars[this.getGlyphCharIndex(i2)]);
                }
            }
            return new Point2D.Double(x, 0.0);
        }

        @Override
        public Shape getGlyphLogicalBounds(int glyphIndex) {
            Point2D position = this.getGlyphPosition(glyphIndex);
            return new Rectangle2D.Double(position.getX(), position.getY() - (double)MockFontLayoutService.this.myDescent, MockFontLayoutService.this.myCharWidth, MockFontLayoutService.this.myLineHeight);
        }

        @Override
        public int getGlyphCode(int glyphIndex) {
            return this.myChars[glyphIndex];
        }
    }
}

