/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.ThrowableRunnable;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class LoggedErrorProcessor {
    private static LoggedErrorProcessor ourInstance = new LoggedErrorProcessor();

    @NotNull
    static LoggedErrorProcessor getInstance() {
        return ourInstance;
    }

    public static <T extends Throwable> void executeWith(@NotNull LoggedErrorProcessor newInstance, @NotNull ThrowableRunnable<T> runnable) throws T {
        LoggedErrorProcessor oldInstance = LoggedErrorProcessor.getInstance();
        ourInstance = newInstance;
        try {
            runnable.run();
        }
        finally {
            ourInstance = oldInstance;
        }
    }

    @NotNull
    public static Throwable executeAndReturnLoggedError(@NotNull Runnable runnable) {
        final AtomicReference error2 = new AtomicReference();
        LoggedErrorProcessor.executeWith(new LoggedErrorProcessor(){

            @Override
            public boolean processError(@NotNull String category, @NotNull String message, Throwable t, String @NotNull [] details) {
                Assert.assertNotNull((String)("Unexpected error without Throwable: " + message), (Object)t);
                if (!error2.compareAndSet(null, t)) {
                    Assert.fail((String)("Multiple errors were reported: " + ((Throwable)error2.get()).getMessage() + " and " + t.getMessage()));
                }
                return false;
            }
        }, () -> runnable.run());
        Throwable result2 = (Throwable)error2.get();
        Assert.assertNotNull((String)"No errors were logged", (Object)result2);
        return result2;
    }

    public boolean processWarn(@NotNull String category, @NotNull String message, @Nullable Throwable t) {
        return true;
    }

    @NotNull
    public Set<Action> processError(@NotNull String category, @NotNull String message, String @NotNull [] details, @Nullable Throwable t) {
        boolean process = this.processError(category, message, t, details);
        return process ? Action.ALL : Action.NONE;
    }

    @Deprecated(forRemoval=true)
    public boolean processError(@NotNull String category, @NotNull String message, @Nullable Throwable t, String @NotNull [] details) {
        return true;
    }

    public static enum Action {
        LOG,
        STDERR,
        RETHROW;

        public static final EnumSet<Action> ALL;
        public static final EnumSet<Action> NONE;

        static {
            ALL = EnumSet.allOf(Action.class);
            NONE = EnumSet.noneOf(Action.class);
        }
    }
}

