/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.FileBasedTestCaseHelper;
import com.intellij.testFramework.FileBasedTestCaseHelperEx;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.TestDataPath;
import com.intellij.testFramework.TestIndexingModeSupporter;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Before;
import org.junit.runners.Parameterized;

public abstract class LightPlatformCodeInsightTestCase
extends LightPlatformTestCase
implements TestIndexingModeSupporter {
    private Editor myEditor;
    private PsiFile myFile;
    private VirtualFile myVFile;
    private TestIndexingModeSupporter.IndexingMode myIndexingMode = TestIndexingModeSupporter.IndexingMode.SMART;
    @Parameterized.Parameter
    public String myFileSuffix;
    @Parameterized.Parameter(value=1)
    public String myTestDataPath;

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (this.isRunInCommand()) {
            Ref e = new Ref();
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
                try {
                    super.runTestRunnable(testRunnable);
                }
                catch (Throwable throwable) {
                    e.set((Object)throwable);
                }
            }, null, null);
            if (!e.isNull()) {
                throw (Throwable)e.get();
            }
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    protected boolean isRunInCommand() {
        return true;
    }

    protected void configureByFile(@TestDataFile @NonNls @NotNull String relativePath) {
        try {
            String fullPath = this.getTestDataPath() + relativePath;
            File ioFile = new File(fullPath);
            LightPlatformCodeInsightTestCase.checkCaseSensitiveFS(fullPath, ioFile);
            String fileText = FileUtilRt.loadFile((File)ioFile, (String)"UTF-8", (boolean)true);
            this.configureFromFileText(ioFile.getName(), fileText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected String getAnswerFilePath() {
        return this.getTestDataPath() + this.myFileSuffix + ".txt";
    }

    @NonNls
    @NotNull
    protected String getTestDataPath() {
        if (this.myTestDataPath != null) {
            return this.myTestDataPath;
        }
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    protected VirtualFile getVirtualFile(@NonNls @NotNull String filePath) {
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        LightPlatformCodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        return vFile;
    }

    @NotNull
    protected Document configureFromFileText(@NonNls @NotNull String fileName, @NonNls @NotNull String fileText) {
        return this.configureFromFileText(fileName, fileText, false);
    }

    @NotNull
    protected Document configureFromFileText(@NonNls @NotNull String fileName, @NonNls @NotNull String fileText, boolean checkCaret) {
        return (Document)WriteCommandAction.writeCommandAction(null).compute(() -> {
            Document document;
            DocumentImpl fakeDocument = new DocumentImpl(fileText);
            EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers((Document)fakeDocument);
            if (checkCaret) {
                LightPlatformCodeInsightTestCase.assertTrue((String)("No caret specified in " + fileName), (boolean)caretsState.hasExplicitCaret());
            }
            String newFileText = fakeDocument.getText();
            try {
                document = this.setupFileEditorAndDocument(fileName, newFileText);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EditorTestUtil.setCaretsAndSelection(this.getEditor(), caretsState);
            this.setupEditorForInjectedLanguage();
            this.getIndexingMode().ensureIndexingStatus(this.getProject());
            return document;
        });
    }

    @NotNull
    protected Editor configureFromFileTextWithoutPSI(@NonNls @NotNull String fileText) {
        return (Editor)WriteCommandAction.writeCommandAction((Project)this.getProject()).compute(() -> {
            Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            String newFileText = fakeDocument.getText();
            Document document = EditorFactory.getInstance().createDocument((CharSequence)newFileText);
            Editor editor = EditorFactory.getInstance().createEditor(document, this.getProject());
            ((EditorImpl)editor).setCaretActive();
            EditorTestUtil.setCaretsAndSelection(editor, caretsState);
            this.getIndexingMode().ensureIndexingStatus(this.getProject());
            return editor;
        });
    }

    @NotNull
    protected Editor createEditor(@NotNull VirtualFile file2) {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor = FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(new OpenFileDescriptor(this.getProject(), file2, 0), false);
        DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        LightPlatformCodeInsightTestCase.assertNotNull((Object)editor);
        ((EditorImpl)editor).setCaretActive();
        this.getIndexingMode().ensureIndexingStatus(this.getProject());
        return editor;
    }

    @NotNull
    private Document setupFileEditorAndDocument(@NotNull String relativePath, @NotNull String fileText) throws IOException {
        EncodingProjectManager.getInstance((Project)this.getProject()).setEncoding(null, StandardCharsets.UTF_8);
        PostprocessReformattingAspect.getInstance((Project)this.getProject()).doPostponedFormatting();
        this.deleteVFile();
        this.myEditor = this.createSaveAndOpenFile(relativePath, fileText);
        this.myVFile = FileDocumentManager.getInstance().getFile(this.getEditor().getDocument());
        this.myFile = this.getPsiManager().findFile(this.myVFile);
        this.getIndexingMode().ensureIndexingStatus(this.getProject());
        return this.getEditor().getDocument();
    }

    @NotNull
    protected Editor createSaveAndOpenFile(@NotNull String relativePath, @NotNull String fileText) {
        Editor editor = this.createEditor(VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), relativePath, fileText));
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        this.getIndexingMode().ensureIndexingStatus(this.getProject());
        return editor;
    }

    @NotNull
    protected static VirtualFile createAndSaveFile(@NotNull String relativePath, @NotNull String fileText) {
        return VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), relativePath, fileText);
    }

    protected void setupEditorForInjectedLanguage() {
        if (this.getEditor() != null) {
            Editor hostEditor = this.getEditor() instanceof EditorWindow ? ((EditorWindow)this.getEditor()).getDelegate() : this.getEditor();
            PsiFile hostFile = this.myFile == null ? null : InjectedLanguageManager.getInstance((Project)this.getProject()).getTopLevelFile((PsiElement)this.myFile);
            Ref editorWindowRef = new Ref();
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)hostEditor, (PsiFile)hostFile);
                if (caret == hostEditor.getCaretModel().getPrimaryCaret() && editor instanceof EditorWindow) {
                    editorWindowRef.set((Object)((EditorWindow)editor));
                }
            });
            if (!editorWindowRef.isNull()) {
                this.myEditor = (Editor)editorWindowRef.get();
                this.myFile = ((EditorWindow)editorWindowRef.get()).getInjectedFile();
                this.myVFile = this.myFile.getVirtualFile();
            }
        }
    }

    private void deleteVFile() throws IOException {
        if (this.myVFile != null) {
            if (this.myVFile instanceof VirtualFileWindow) {
                this.myVFile = ((VirtualFileWindow)this.myVFile).getDelegate();
            }
            if (this.myVFile.isWritable() && !this.myVFile.getFileSystem().isReadOnly()) {
                WriteAction.run(() -> {
                    PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                    FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.myVFile);
                    this.myVFile.delete((Object)this.getProject());
                });
            }
            this.getIndexingMode().ensureIndexingStatus(this.getProject());
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getIndexingMode().setUpTest(this.getProject(), this.getTestRootDisposable());
    }

    @Before
    public void before() throws Throwable {
        this.getIndexingMode().ensureIndexingStatus(this.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            Project project2 = this.getProject();
            if (this.myIndexingMode != null && project2 != null) {
                this.myIndexingMode.tearDownTest(project2);
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project2);
                for (VirtualFile openFile : editorManager.getOpenFiles()) {
                    editorManager.closeFile(openFile);
                }
            }
            this.deleteVFile();
            this.myEditor = null;
            this.myFile = null;
            this.myVFile = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkResultByFile(@TestDataFile @NonNls @NotNull String expectedFilePath) {
        this.checkResultByFile(null, expectedFilePath, false);
    }

    protected void checkResultByFile(@Nullable String message, @TestDataFile @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) {
        String fileText;
        this.bringRealEditorBack();
        PostprocessReformattingAspect.getInstance((Project)this.getProject()).doPostponedFormatting();
        if (ignoreTrailingSpaces) {
            Editor editor = this.getEditor();
            TrailingSpacesStripper.strip((Document)editor.getDocument(), (boolean)false, (boolean)true);
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)editor);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        String fullPath = this.getTestDataPath() + expectedFilePath;
        File ioFile = new File(fullPath);
        LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.getMessage("Cannot find file " + fullPath, message), (boolean)ioFile.exists());
        try {
            LightPlatformCodeInsightTestCase.checkCaseSensitiveFS(fullPath, ioFile);
            fileText = FileUtil.loadFile((File)ioFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.checkResultByText(message, StringUtil.convertLineSeparators((String)fileText), ignoreTrailingSpaces, this.getTestDataPath() + "/" + expectedFilePath);
    }

    protected void checkResultByText(@NonNls @NotNull String expectedFileText) {
        this.checkResultByText(null, expectedFileText, false, null);
    }

    protected void checkResultByText(@Nullable String message, @NotNull String expectedFileText, boolean ignoreTrailingSpaces) {
        this.checkResultByText(message, expectedFileText, ignoreTrailingSpaces, null);
    }

    protected void checkResultByText(@Nullable String message, @NotNull String expectedFileText, boolean ignoreTrailingSpaces, @Nullable String filePath) {
        this.bringRealEditorBack();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = EditorFactory.getInstance().createDocument((CharSequence)expectedFileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            PostprocessReformattingAspect.getInstance((Project)this.getProject()).doPostponedFormatting();
            String newFileText = document.getText();
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            String fileText1 = this.myFile.getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
            if (filePath != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(this.getEditor(), carets, message);
        });
    }

    protected void checkResultByTextWithoutPSI(@Nullable String message, @NotNull Editor editor, @NotNull String fileText, boolean ignoreTrailingSpaces, @Nullable String filePath) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)fakeDocument).stripTrailingSpaces(this.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            String newFileText = fakeDocument.getText();
            String fileText1 = editor.getDocument().getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
            if (filePath != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(editor, carets, message);
        });
    }

    @NotNull
    private static String getMessage(@NonNls @NotNull String engineMessage, @Nullable String userMessage) {
        if (userMessage == null) {
            return engineMessage;
        }
        return userMessage + " [" + engineMessage + "]";
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    protected PsiFile getFile() {
        return this.myFile;
    }

    protected VirtualFile getVFile() {
        return this.myVFile;
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (this.getEditor() instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.getEditor().getDocument()).getDelegate();
            this.myFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
            this.myEditor = ((EditorWindow)this.getEditor()).getDelegate();
            this.myVFile = this.myFile.getVirtualFile();
        }
    }

    protected void caretRight() {
        this.caretRight(this.getEditor());
    }

    public void caretRight(@NotNull Editor editor) {
        this.executeAction("EditorRight", editor);
    }

    protected void caretUp() {
        this.caretUp(this.getEditor());
    }

    public void caretUp(@NotNull Editor editor) {
        this.executeAction("EditorUp", editor);
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine(this.getEditor(), this.getProject());
    }

    public static void deleteLine(@NotNull Editor editor, @Nullable Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteLine", editor, project2);
    }

    protected void type(@NonNls @NotNull String s) {
        for (char c : s.toCharArray()) {
            this.type(c);
        }
    }

    protected void type(char c) {
        LightPlatformCodeInsightTestCase.type(c, this.getEditor(), this.getProject());
    }

    public static void type(char c, @NotNull Editor editor, @Nullable Project project2) {
        if (c == '\n') {
            LightPlatformCodeInsightTestCase.executeAction("EditorEnter", editor, project2);
        } else {
            DataContext dataContext = DataManager.getInstance().getDataContext();
            TypedAction action = TypedAction.getInstance();
            action.actionPerformed(editor, c, dataContext);
        }
    }

    protected void backspace() {
        LightPlatformCodeInsightTestCase.backspace(this.getEditor(), this.getProject());
    }

    public static void backspace(@NotNull Editor editor, @Nullable Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorBackSpace", editor, project2);
    }

    protected void ctrlShiftF7() {
        HighlightUsagesHandler.invoke((Project)this.getProject(), (Editor)this.getEditor(), (PsiFile)this.getFile());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW(this.getEditor(), this.getProject());
    }

    public static void ctrlW(@NotNull Editor editor, Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectWord", editor, project2);
    }

    public void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD(this.getEditor(), this.getProject());
    }

    public static void ctrlD(@NotNull Editor editor, Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorDuplicate", editor, project2);
    }

    protected void delete() {
        LightPlatformCodeInsightTestCase.delete(this.getEditor(), this.getProject());
    }

    public static void delete(@NotNull Editor editor, Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorDelete", editor, project2);
    }

    protected void home() {
        this.executeAction("EditorLineStart");
    }

    protected void end() {
        this.executeAction("EditorLineEnd");
    }

    protected void homeWithSelection() {
        this.executeAction("EditorLineStartWithSelection");
    }

    protected void endWithSelection() {
        this.executeAction("EditorLineEndWithSelection");
    }

    protected void copy() {
        this.executeAction("EditorCopy");
    }

    protected void paste() {
        this.executeAction("EditorPaste");
    }

    protected void moveCaretToPreviousWordWithSelection() {
        this.executeAction("EditorPreviousWordWithSelection");
    }

    protected void moveCaretToNextWordWithSelection() {
        this.executeAction("EditorNextWordWithSelection");
    }

    protected void previousWord() {
        this.executeAction("EditorPreviousWord");
    }

    protected void nextWord() {
        this.executeAction("EditorNextWord");
    }

    protected void cutLineBackward() {
        this.executeAction("EditorCutLineBackward");
    }

    protected void cutToLineEnd() {
        this.executeAction("EditorCutLineEnd");
    }

    protected void deleteToLineStart() {
        this.executeAction("EditorDeleteToLineStart");
    }

    protected void deleteToLineEnd() {
        this.executeAction("EditorDeleteToLineEnd");
    }

    protected void killToWordStart() {
        this.executeAction("EditorKillToWordStart");
    }

    protected void killToWordEnd() {
        this.executeAction("EditorKillToWordEnd");
    }

    protected void killRegion() {
        this.executeAction("EditorKillRegion");
    }

    protected void killRingSave() {
        this.executeAction("EditorKillRingSave");
    }

    protected void unindent() {
        this.executeAction("EditorUnindentSelection");
    }

    protected void selectLine() {
        this.executeAction("EditorSelectLine");
    }

    protected void left() {
        this.executeAction("EditorLeft");
    }

    protected void right() {
        this.executeAction("EditorRight");
    }

    protected void leftWithSelection() {
        this.executeAction("EditorLeftWithSelection");
    }

    protected void rightWithSelection() {
        this.executeAction("EditorRightWithSelection");
    }

    protected void up() {
        this.executeAction("EditorUp");
    }

    protected void down() {
        this.executeAction("EditorDown");
    }

    protected void lineComment() {
        this.executeAction("CommentByLineComment");
    }

    protected void executeAction(@NonNls @NotNull String actionId) {
        this.executeAction(actionId, this.getEditor());
    }

    protected void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.executeAction(actionId, editor, this.getProject());
    }

    public static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor, @Nullable Project project2) {
        CommandProcessor.getInstance().executeCommand(project2, () -> EditorTestUtil.executeAction(editor, actionId, true), "", null, editor.getDocument());
    }

    @NotNull
    protected DataContext getCurrentEditorDataContext() {
        DataContext defaultContext = DataManager.getInstance().getDataContext();
        return dataId -> {
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return this.getEditor();
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.getProject();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                return this.getFile();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                PsiFile file2 = this.getFile();
                if (file2 == null) {
                    return null;
                }
                Editor editor = this.getEditor();
                if (editor == null) {
                    return null;
                }
                return file2.findElementAt(editor.getCaretModel().getOffset());
            }
            return defaultContext.getData(dataId);
        };
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params() {
        return Collections.emptyList();
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params(@NotNull Class<?> klass) throws Throwable {
        Object testDataPath;
        Object testCase2 = klass.newInstance();
        if (!(testCase2 instanceof FileBasedTestCaseHelper)) {
            LightPlatformCodeInsightTestCase.fail((String)"Parameterized test should implement FileBasedTestCaseHelper");
        }
        try {
            PathManagerEx.replaceLookupStrategy(klass, Parameterized.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FileBasedTestCaseHelper fileBasedTestCase = (FileBasedTestCaseHelper)testCase2;
        if (testCase2 instanceof LightPlatformCodeInsightTestCase) {
            testDataPath = ((LightPlatformCodeInsightTestCase)testCase2).getTestDataPath();
        } else {
            try {
                Method dataPath = klass.getDeclaredMethod("getTestDataPath", new Class[0]);
                dataPath.setAccessible(true);
                testDataPath = (String)dataPath.invoke((Object)fileBasedTestCase, new Object[0]);
            }
            catch (Throwable e) {
                testDataPath = PathManagerEx.getTestDataPath();
            }
        }
        File testDir = null;
        if (fileBasedTestCase instanceof FileBasedTestCaseHelperEx) {
            testDir = new File((String)testDataPath, ((FileBasedTestCaseHelperEx)fileBasedTestCase).getRelativeBasePath());
        } else {
            TestDataPath annotation = klass.getAnnotation(TestDataPath.class);
            if (annotation == null) {
                LightPlatformCodeInsightTestCase.fail((String)"TestCase should implement com.intellij.testFramework.FileBasedTestCaseHelperEx or be annotated with com.intellij.testFramework.TestDataPath");
            } else {
                String trimmedRoot = StringUtil.trimStart((String)StringUtil.trimStart((String)annotation.value(), (String)"$CONTENT_ROOT"), (String)"$PROJECT_ROOT");
                String lastPathComponent = new File((String)testDataPath).getName();
                int idx = trimmedRoot.indexOf(lastPathComponent);
                testDataPath = ((String)testDataPath).replace(File.separatorChar, '/') + (idx > 0 ? trimmedRoot.substring(idx + lastPathComponent.length()) : trimmedRoot);
                testDir = new File((String)testDataPath);
            }
        }
        File[] files = testDir.listFiles();
        if (files == null) {
            LightPlatformCodeInsightTestCase.fail((String)("Test files not found in " + testDir.getPath()));
        }
        HashSet<String> beforeFileSuffixes = new HashSet<String>();
        HashSet<String> afterFileSuffixes = new HashSet<String>();
        ArrayList<Object[]> result2 = new ArrayList<Object[]>();
        for (File file2 : files) {
            String fileSuffix = fileBasedTestCase.getFileSuffix(file2.getName());
            String fileAfterSuffix = fileBasedTestCase.getBaseName(file2.getName());
            if (fileAfterSuffix != null) {
                afterFileSuffixes.add(fileAfterSuffix);
            }
            if (fileSuffix == null) continue;
            beforeFileSuffixes.add(fileSuffix);
            result2.add(new Object[]{fileSuffix, testDataPath});
        }
        afterFileSuffixes.removeAll(beforeFileSuffixes);
        if (!afterFileSuffixes.isEmpty()) {
            LightPlatformCodeInsightTestCase.fail((String)("'After' file has no corresponding 'before' file: " + String.join((CharSequence)", ", afterFileSuffixes)));
        }
        return result2;
    }

    public String getName() {
        if (this.myFileSuffix != null) {
            return "test" + this.myFileSuffix;
        }
        return super.getName();
    }

    protected void setEditor(@NotNull Editor editor) {
        this.myEditor = editor;
    }

    protected void setFile(@NotNull PsiFile file2) {
        this.myFile = file2;
    }

    protected void setVFile(@NotNull VirtualFile virtualFile) {
        this.myVFile = virtualFile;
    }

    @Override
    public void setIndexingMode(@NotNull TestIndexingModeSupporter.IndexingMode mode) {
        this.myIndexingMode = mode;
    }

    @Override
    @NotNull
    public TestIndexingModeSupporter.IndexingMode getIndexingMode() {
        return this.myIndexingMode;
    }
}

