/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(String text) {
        this.doTest(text, null);
    }

    protected void doTest(String text, @Nullable String expected) {
        this.doTest(text, expected, this.createLexer());
    }

    protected void doTest(String text, @Nullable String expected, @NotNull Lexer lexer) {
        String result2 = this.printTokens(lexer, text, 0);
        if (expected != null) {
            LexerTestCase.assertSameLines(expected, result2);
        } else {
            LexerTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), result2);
        }
    }

    protected String printTokens(Lexer lexer, CharSequence text, int start) {
        return LexerTestCase.printTokens(text, start, lexer);
    }

    @NotNull
    protected String getPathToTestDataFile(String extension) {
        return IdeaTestExecutionPolicy.getHomePathWithPolicy() + "/" + this.getDirPath() + "/" + this.getTestName(true) + extension;
    }

    @NotNull
    protected String getExpectedFileExtension() {
        return ".txt";
    }

    protected void checkZeroState(String text, TokenSet tokenTypes) {
        IElementType type;
        Lexer lexer = this.createLexer();
        lexer.start((CharSequence)text);
        while ((type = lexer.getTokenType()) != null) {
            if (tokenTypes.contains(type) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + type + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected String printTokens(String text, int start) {
        return LexerTestCase.printTokens(text, start, this.createLexer());
    }

    protected void checkCorrectRestart(String text) {
        this.checkCorrectRestart(text, false);
    }

    protected void checkCorrectRestartOnEveryToken(@NotNull String text) {
        this.checkCorrectRestart(text, true);
    }

    private void checkCorrectRestart(@NotNull String text, boolean everyToken) {
        IElementType type;
        Lexer mainLexer = this.createLexer();
        List<Trinity<IElementType, Integer, Integer>> allTokens = LexerTestCase.tokenize(text, 0, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start((CharSequence)text);
        int index = 0;
        while ((type = auxLexer.getTokenType()) != null) {
            int state = auxLexer.getState();
            if (everyToken || state == 0) {
                int tokenStart = auxLexer.getTokenStart();
                List<Trinity<IElementType, Integer, Integer>> expectedTokens = allTokens.subList(index, allTokens.size());
                List<Trinity<IElementType, Integer, Integer>> restartedTokens = LexerTestCase.tokenize(text, tokenStart, state, mainLexer);
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + tokenStart + " - " + auxLexer.getTokenText() + "\nAll tokens <type, offset, lexer state>: " + allTokens + "\n"), (String)expectedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")), (String)restartedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")));
            }
            ++index;
            auxLexer.advance();
        }
    }

    @NotNull
    private static List<Trinity<IElementType, Integer, Integer>> tokenize(@NotNull String text, int start, int state, @NotNull Lexer lexer) {
        ArrayList<Trinity<IElementType, Integer, Integer>> allTokens = new ArrayList<Trinity<IElementType, Integer, Integer>>();
        try {
            lexer.start((CharSequence)text, start, text.length(), state);
        }
        catch (Throwable t) {
            LOG.error("Restarting impossible from offset " + start, t);
            throw new RuntimeException(t);
        }
        while (lexer.getTokenType() != null) {
            allTokens.add((Trinity<IElementType, Integer, Integer>)Trinity.create((Object)lexer.getTokenType(), (Object)lexer.getTokenStart(), (Object)lexer.getState()));
            lexer.advance();
        }
        return allTokens;
    }

    public static String printTokens(CharSequence text, int start, Lexer lexer) {
        IElementType tokenType;
        lexer.start(text, start, text.length());
        StringBuilder result2 = new StringBuilder();
        while ((tokenType = lexer.getTokenType()) != null) {
            result2.append(LexerTestCase.printSingleToken(text, tokenType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        return result2.toString();
    }

    @NotNull
    public static String printTokens(@NotNull HighlighterIterator iterator) {
        CharSequence text = iterator.getDocument().getCharsSequence();
        StringBuilder result2 = new StringBuilder();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            result2.append(LexerTestCase.printSingleToken(text, tokenType, iterator.getStart(), iterator.getEnd()));
            iterator.advance();
        }
        return result2.toString();
    }

    public static String printSingleToken(CharSequence fileText, IElementType tokenType, int start, int end) {
        return tokenType + " ('" + LexerTestCase.getTokenText(tokenType, fileText, start, end) + "')\n";
    }

    protected void doFileTest(String fileExt) {
        this.doTest(this.loadTestDataFile("." + fileExt));
    }

    @NotNull
    protected String loadTestDataFile(String fileExt) {
        String fileName = this.getPathToTestDataFile(fileExt);
        String text = "";
        try {
            String fileText = FileUtil.loadFile((File)new File(fileName));
            text = StringUtil.convertLineSeparators((String)(this.shouldTrim() ? fileText.trim() : fileText));
        }
        catch (IOException e) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e.getMessage()));
        }
        return text;
    }

    protected boolean shouldTrim() {
        return true;
    }

    @NotNull
    private static String getTokenText(IElementType tokenType, CharSequence sequence, int start, int end) {
        return tokenType instanceof TokenWrapper ? ((TokenWrapper)tokenType).getValue() : StringUtil.replace((String)sequence.subSequence(start, end).toString(), (String)"\n", (String)"\\n");
    }

    protected abstract Lexer createLexer();

    protected abstract String getDirPath();
}

