/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.common.ThreadLeakTracker;
import com.intellij.testFramework.common.ThreadUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorCache;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class LeakHunter {
    @TestOnly
    @NotNull
    public static String getCreationPlace(@NotNull Project project2) {
        String creationTrace = project2 instanceof ProjectEx ? ((ProjectEx)project2).getCreationTrace() : null;
        return project2 + " " + (creationTrace == null ? " " : creationTrace);
    }

    @TestOnly
    public static void checkProjectLeak() throws AssertionError {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project2) -> !project2.isDefault() && !project2.isLight());
    }

    @TestOnly
    public static void checkNonDefaultProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project2) -> !project2.isDefault());
    }

    @TestOnly
    public static void checkLeak(@NotNull Object root, @NotNull Class<?> suspectClass) throws AssertionError {
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        LeakHunter.processLeaks(rootsSupplier, suspectClass, isReallyLeak, (leaked, backLink) -> {
            String place = leaked instanceof Project ? LeakHunter.getCreationPlace((Project)leaked) : "";
            String message = "Found leaked " + leaked.getClass() + ": " + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place + "\n" + backLink;
            System.out.println(message);
            System.out.println(";-----");
            ThreadUtil.printThreadDump();
            throw new AssertionError((Object)message);
        });
    }

    @TestOnly
    public static <T> void processLeaks(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak, @NotNull PairProcessor<? super T, Object> processor) throws AssertionError {
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorCache.clearCacheForTests();
        Runnable runnable = () -> {
            try (AccessToken ignored = ProhibitAWTEvents.start((String)"checking for leaks");){
                DebugReflectionUtil.walkObjects((int)10000, (Map)((Map)rootsSupplier.get()), (Class)suspectClass, __ -> true, (leaked, backLink) -> {
                    if (isReallyLeak == null || isReallyLeak.test(leaked)) {
                        return processor.process(leaked, backLink);
                    }
                    return true;
                });
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            runnable.run();
        } else {
            application.runReadAction(runnable);
        }
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        LeakHunter.checkLeak(() -> Collections.singletonMap(root, "Root object"), suspectClass, isReallyLeak);
    }

    @TestOnly
    @NotNull
    public static Supplier<Map<Object, String>> allRoots() {
        return () -> {
            ClassLoader classLoader = LeakHunter.class.getClassLoader();
            Collection allLoadedClasses = (Collection)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
            LaterInvocator.purgeExpiredItems();
            IdentityHashMap<Object, String> result2 = new IdentityHashMap<Object, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                result2.put(application, "ApplicationManager.getApplication()");
            }
            result2.put(Disposer.getTree(), "Disposer.getTree()");
            result2.put(IdeEventQueue.getInstance(), "IdeEventQueue.getInstance()");
            result2.put(LaterInvocator.getLaterInvocatorEdtQueue(), "LaterInvocator.getLaterInvocatorEdtQueue()");
            result2.put(ThreadLeakTracker.getThreads().values(), "all live threads");
            if (allLoadedClasses != null) {
                result2.put(allLoadedClasses, "all loaded classes statics");
            }
            return result2;
        };
    }
}

