/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaModuleTestCase
extends JavaProjectTestCase {
    protected final Collection<Module> myModulesToDispose = new ArrayList<Module>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myModulesToDispose.clear();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (!this.myModulesToDispose.isEmpty()) {
                WriteAction.run(() -> {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                    for (Module module2 : this.myModulesToDispose) {
                        try {
                            String moduleName = module2.getName();
                            if (moduleManager.findModuleByName(moduleName) == null) continue;
                            moduleManager.disposeModule(module2);
                        }
                        catch (Throwable e) {
                            this.addSuppressedException(e);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myModulesToDispose.clear();
            super.tearDown();
        }
    }

    @NotNull
    protected Module createModule(@NotNull Path moduleFile) {
        return this.createModule(moduleFile, StdModuleTypes.JAVA);
    }

    @NotNull
    protected Module createModule(@NotNull Path moduleFile, @NotNull ModuleType<?> moduleType) {
        Module module2 = (Module)WriteAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).newModule(moduleFile, moduleType.getId()));
        this.myModulesToDispose.add(module2);
        return module2;
    }

    @NotNull
    protected Module createModule(@NotNull String path, @NotNull ModuleType<?> moduleType) {
        Module module2 = (Module)WriteAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).newModule(path, moduleType.getId()));
        this.myModulesToDispose.add(module2);
        return module2;
    }

    @NotNull
    protected Module loadModule(@NotNull VirtualFile file2) {
        return this.loadModule(file2.toNioPath());
    }

    @NotNull
    protected final Module loadModule(@NotNull Path modulePath) {
        Module module2;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        try {
            module2 = (Module)ApplicationManager.getApplication().runWriteAction(() -> moduleManager.loadModule(modulePath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myModulesToDispose.add(module2);
        return module2;
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir) {
        return this.loadAllModulesUnder(rootDir, null);
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir, final @Nullable Consumer<? super Module> moduleConsumer) {
        final Ref result2 = Ref.create();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)rootDir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (!file2.isDirectory() && file2.getName().endsWith(".iml")) {
                    Module module2 = JavaModuleTestCase.this.loadModule(file2);
                    if (moduleConsumer != null) {
                        moduleConsumer.consume((Object)module2);
                    }
                    result2.setIfNull((Object)module2);
                }
                return true;
            }
        });
        return (Module)result2.get();
    }

    @NotNull
    protected final Module createModuleFromTestData(@NotNull String dirInTestData, @NotNull String newModuleFileName, @NotNull ModuleType<?> moduleType, boolean addSourceRoot2) throws IOException {
        VirtualFile moduleDir = this.getTempDir().createVirtualDir();
        FileUtil.copyDir((File)new File(dirInTestData), (File)moduleDir.toNioPath().toFile());
        moduleDir.refresh(false, true);
        Module module2 = this.createModule(moduleDir.toNioPath().resolve(newModuleFileName), moduleType);
        if (addSourceRoot2) {
            PsiTestUtil.addSourceContentToRoots(module2, moduleDir);
        } else {
            PsiTestUtil.addContentRoot(module2, moduleDir);
        }
        return module2;
    }
}

