/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.diagnostic.PluginException;
import com.intellij.idea.IdeaLogger;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableTracker;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.project.ProjectKt;
import com.intellij.project.TestProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.OpenProjectTaskBuilder;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UITestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.common.TestApplicationKt;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeavyPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    protected Project myProject;
    protected Module myModule;
    private final TemporaryDirectory temporaryDirectory = new TemporaryDirectory();
    protected boolean myAssertionsInTestDetected;
    private static TestCase ourTestCase;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private SdkLeakTracker myOldSdks;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private LibraryTableTracker myLibraryTableTracker;
    @Nullable
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private AccessToken projectTracker;

    @NotNull
    protected final TemporaryDirectory getTempDir() {
        return this.temporaryDirectory;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure() {
        return this.createTestProjectStructure(null, true);
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(@Nullable String rootPath) {
        return this.createTestProjectStructure(rootPath, true);
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(@Nullable String rootPath, boolean addProjectRoots) {
        Path dir = this.temporaryDirectory.newPath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        VirtualFile result2 = HeavyTestHelper.createTestProjectStructure(this.myModule, rootPath, dir, addProjectRoots);
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        return result2;
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@Nullable Module module2, @Nullable String rootPath, boolean addProjectRoots, @NotNull TemporaryDirectory temporaryDirectory) {
        Path dir = temporaryDirectory.newPath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return HeavyTestHelper.createTestProjectStructure(module2, rootPath, dir, addProjectRoots);
    }

    @NotNull
    protected VirtualFile createTestProjectStructure(@NotNull Project project2, @Nullable Module module2, @Nullable String rootPath, boolean addProjectRoots) {
        VirtualFile file2 = HeavyPlatformTestCase.createTestProjectStructure(module2, rootPath, addProjectRoots, this.getTempDir());
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        return file2;
    }

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    public static VirtualFile synchronizeTempDirVfs(@NotNull Path tempDir) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)tempDir.toString()));
        if (virtualFile != null) {
            HeavyPlatformTestCase.synchronizeTempDirVfs(virtualFile);
        }
        return virtualFile;
    }

    protected void initApplication() throws Exception {
        TestApplicationManager testAppManager = TestApplicationManager.getInstance();
        testAppManager.setDataProvider(this);
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    @NotNull
    final Path createGlobalTempDirectory() {
        Object testName2;
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        Object object = testName2 = policy == null ? null : policy.getPerTestTempDirName();
        if (testName2 == null) {
            testName2 = "unitTest_" + TemporaryDirectory.testNameToFileName(this.getName());
        }
        Path result2 = TemporaryDirectory.generateTemporaryPath((String)testName2);
        this.temporaryDirectory.scheduleDelete(result2);
        FileUtil.resetCanonicalTempPathCache((String)result2.toString());
        this.temporaryDirectory.init("", result2);
        return result2;
    }

    @Override
    final void removeGlobalTempDirectory(@NotNull Path dir) {
        this.temporaryDirectory.after();
    }

    @Override
    protected void addTmpFileToKeep(@NotNull Path file2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            HeavyPlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        this.projectTracker = ((TestProjectManager)ProjectManager.getInstance()).startTracking();
        if (this.myOldSdks == null) {
            this.myOldSdks = new SdkLeakTracker();
        }
        this.setUpProject();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        boolean isTrackCodeStyleChanges = !this.isStressTest() && ApplicationManager.getApplication() != null && !(ApplicationManager.getApplication() instanceof MockApplication);
        this.myCodeStyleSettingsTracker = isTrackCodeStyleChanges ? new CodeStyleSettingsTracker(CodeStyle::getDefaultSettings) : null;
        ourTestCase = this;
        if (this.myProject != null) {
            CodeStyle.setTemporarySettings((Project)this.myProject, (CodeStyleSettings)CodeStyle.createTestSettings());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.myProject);
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).clearUncommittedDocuments();
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            EDT.dispatchAllInvocationEvents();
        }
        this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
        this.myLibraryTableTracker = new LibraryTableTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProject = this.doCreateAndOpenProject();
        WriteAction.runAndWait(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            this.setUpModule();
            this.setUpJdk();
        }));
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    @NotNull
    protected OpenProjectTaskBuilder getOpenProjectOptions() {
        return new OpenProjectTaskBuilder().projectName(this.getProjectFilename());
    }

    @NotNull
    protected Project doCreateAndOpenProject() {
        OpenProjectTaskBuilder optionBuilder = this.getOpenProjectOptions();
        Path projectFile = this.getProjectDirOrFile(this.isCreateDirectoryBasedProject());
        return Objects.requireNonNull(ProjectManagerEx.getInstanceEx().openProject(projectFile, optionBuilder.build()));
    }

    protected boolean isCreateDirectoryBasedProject() {
        return false;
    }

    @NotNull
    protected final Path getProjectDirOrFile() {
        return this.getProjectDirOrFile(this.isCreateDirectoryBasedProject());
    }

    @NotNull
    protected Path getProjectDirOrFile(boolean isDirectoryBasedProject) {
        return this.temporaryDirectory.newPath(this.getProjectFilename() + (isDirectoryBasedProject ? "" : ".ipr"));
    }

    @Nullable
    private String getProjectFilename() {
        String testName2 = this.getName();
        return testName2 == null ? null : FileUtil.sanitizeFileName((String)testName2, (boolean)false);
    }

    protected void setUpModule() {
        try {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
                this.myModule = this.createMainModule();
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        return this.createModule(this.myProject.getName());
    }

    @NotNull
    protected Module createModule(@NonNls @NotNull String moduleName) {
        return this.doCreateRealModule(moduleName);
    }

    @NotNull
    protected Module doCreateRealModule(@NotNull String moduleName) {
        return this.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
    }

    @NotNull
    protected final Module doCreateRealModuleIn(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType) {
        return this.createModuleAt(moduleName, project2, moduleType, ProjectKt.getStateStore((Project)project2).getProjectBasePath());
    }

    @NotNull
    protected final Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType, @NotNull Path path) {
        Path moduleFile = path.resolve(moduleName + ".iml");
        return (Module)WriteAction.computeAndWait(() -> ModuleManager.getInstance((Project)project2).newModule(moduleFile, moduleType.getId()));
    }

    @NotNull
    protected ModuleType<?> getModuleType() {
        return EmptyModuleType.getInstance();
    }

    public static void cleanupApplicationCaches(@Nullable Project project2) {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (globalInstance != null) {
            globalInstance.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        TestApplicationKt.cleanupApplicationCaches(app);
    }

    @NotNull
    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            return ourEternallyLivingFilesCache;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file2 : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                HeavyPlatformTestCase.registerSurvivor(survivors, file2);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        return survivors;
    }

    public static void addSurvivingFiles(@NotNull Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile : files) {
            HeavyPlatformTestCase.registerSurvivor(HeavyPlatformTestCase.eternallyLivingFiles(), virtualFile);
        }
    }

    private static void registerSurvivor(@NotNull Set<? super VirtualFile> survivors, @NotNull VirtualFile file2) {
        HeavyPlatformTestCase.addSubTree(file2, survivors);
        while (file2 != null && survivors.add((VirtualFile)file2)) {
            file2 = file2.getParent();
        }
    }

    private static void addSubTree(@NotNull VirtualFile root, @NotNull Set<? super VirtualFile> to) {
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add((VirtualFile)child);
                HeavyPlatformTestCase.addSubTree(child, to);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        if (project2 != null && !project2.isDisposed()) {
            TestApplicationManager.waitForProjectLeakingThreads(project2);
        }
        RunAll.runAll(() -> this.disposeRootDisposable(), () -> {
            if (project2 != null) {
                TestApplicationManager.tearDownProjectAndApp(project2);
            }
            this.myProject = null;
        }, () -> {
            AccessToken projectTracker = this.projectTracker;
            if (projectTracker != null) {
                this.projectTracker = null;
                projectTracker.finish();
            }
        }, () -> UIUtil.dispatchAllInvocationEvents(), () -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }, () -> {
            JarFileSystemImpl.cleanupForNextTest();
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
        }, () -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }, () -> super.tearDown(), () -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }, () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> this.myOldSdks.checkForJdkTableLeaks(), () -> this.myVirtualFilePointerTracker.assertPointersAreDisposed(), () -> this.myLibraryTableTracker.assertDisposed(), () -> {
            this.myModule = null;
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        });
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    @NotNull
    protected final <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        Disposer.register((Disposable)this.myProject, disposable);
        return disposable;
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        try {
            HeavyPlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == HeavyPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    protected void registerTestProjectJdk(Sdk jdk) {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk existingSdk : jdkTable.getAllJdks()) {
            if (existingSdk != jdk) continue;
            return;
        }
        WriteAction.runAndWait(() -> jdkTable.addJdk(jdk, (Disposable)this.myProject));
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        if (jdk != null) {
            this.registerTestProjectJdk(jdk);
        }
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    protected void runBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        UITestUtil.replaceIdeEventQueueSafely();
        try {
            this.wrapTestRunnable((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.runBareImpl(testRunnable))).run();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait(() -> {
                    HeavyPlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                });
            }
            catch (Throwable throwable) {}
        }
    }

    private void runBareImpl(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        ThrowableRunnable runnable = () -> {
            try {
                this.myAssertionsInTestDetected = true;
                this.setUp();
                this.myAssertionsInTestDetected = false;
            }
            catch (Throwable e) {
                try {
                    this.tearDown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            Throwable exception = null;
            try {
                this.myAssertionsInTestDetected = true;
                this.runTestRunnable(testRunnable);
                this.myAssertionsInTestDetected = false;
            }
            catch (Throwable e) {
                exception = e;
            }
            finally {
                block17: {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable e) {
                        if (exception != null) break block17;
                        exception = e;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        };
        this.runBareRunnable((ThrowableRunnable<Throwable>)runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        HeavyPlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i2 = 0; i2 < 3; ++i2) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    @Deprecated
    protected boolean isRunInWriteAction() {
        PluginException.reportDeprecatedUsage((String)"this method", (String)"do not use. instead, start write action where necessary for the shortest time possible");
        return false;
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        boolean runInCommand = this.annotatedWith(WrapInCommand.class);
        if (runInCommand) {
            Ref e = new Ref();
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
                try {
                    super.runTestRunnable(testRunnable);
                }
                catch (Throwable throwable) {
                    e.set((Object)throwable);
                }
            }, null, null);
            if (!e.isNull()) {
                throw (Throwable)e.get();
            }
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    public Object getData(@NotNull String dataId) {
        return this.myProject == null || this.myProject.isDisposed() ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    @NotNull
    protected final File createTempDir(@NotNull String prefix) throws IOException {
        Path dir = this.temporaryDirectory.newPath(prefix, true);
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir.toFile();
    }

    @NotNull
    protected static VirtualFile getVirtualFile(@NotNull File file2) {
        return Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
    }

    @NotNull
    protected final File createTempDirectory() throws IOException {
        return this.createTempDir("");
    }

    @NotNull
    protected final File createTempFile(@NotNull String name, @Nullable String text) throws IOException {
        Path dir = this.temporaryDirectory.newPath("", true);
        Path file2 = dir.resolve(name);
        if (text == null) {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.createFile(file2, new FileAttribute[0]);
        } else {
            PathKt.write((Path)file2, (CharSequence)text);
        }
        return file2.toFile();
    }

    @NotNull
    public VirtualFile createTempVirtualFile(@NonNls @NotNull String fileName, byte @Nullable [] bom, @NonNls @NotNull String content, @NotNull Charset charset) throws IOException {
        File file2 = this.createTempFile(fileName, null);
        FileOutputStream stream = new FileOutputStream(file2);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content);
        }
        return HeavyPlatformTestCase.getVirtualFile(file2);
    }

    @Nullable
    protected final PsiFile getPsiFile(@NotNull Document document) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    @NotNull
    public static VirtualFile createChildData(@NotNull VirtualFile dir, @NotNull String name) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildData((Object)dir, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static VirtualFile createChildDirectory(@NotNull VirtualFile dir, @NotNull String name) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildDirectory((Object)dir, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void rename(@NotNull VirtualFile vFile1, @NotNull String newName) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.rename((Object)vFile1, newName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void delete(@NotNull VirtualFile file2) {
        VfsTestUtil.deleteFile(file2);
    }

    public static void move(@NotNull VirtualFile vFile1, @NotNull VirtualFile newFile) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.move((Object)vFile1, newFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile copy(@NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) {
        VirtualFile[] copy = new VirtualFile[1];
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                copy[0] = file2.copy((Object)file2, newParent, copyName);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return copy[0];
    }

    public static void copyDirContentsTo(@NotNull VirtualFile vTestRoot, @NotNull VirtualFile toDir) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                for (VirtualFile file2 : vTestRoot.getChildren()) {
                    VfsUtil.copy((Object)file2, (VirtualFile)file2, (VirtualFile)toDir);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFileText(@NotNull VirtualFile file2, @NotNull String text) {
        try {
            WriteAction.runAndWait(() -> LoadTextUtil.write(null, (VirtualFile)file2, (Object)file2, (String)text, (long)-1L));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content) {
        try {
            WriteAction.runAndWait(() -> file2.setBinaryContent(content));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object requestor) {
        try {
            WriteAction.runAndWait(() -> file2.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected final VirtualFile getOrCreateProjectBaseDir() {
        return HeavyTestHelper.getOrCreateProjectBaseDir(this.myProject);
    }

    @NotNull
    protected final Path createTempDirectoryWithSuffix(@Nullable String suffix) throws IOException {
        return FileUtilRt.createTempDirectory((String)this.getTestName(true), (String)suffix, (boolean)false).toPath();
    }

    @NotNull
    protected static VirtualFile getOrCreateModuleDir(@NotNull Module module2) throws IOException {
        Path moduleDir = module2.getModuleNioFile().getParent();
        Files.createDirectories(moduleDir, new FileAttribute[0]);
        return Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByNioFile(moduleDir));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

