/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStructureTestFixture
implements Disposable {
    private final CodeInsightTestFixture myFixture;
    private FileStructurePopup myPopup;
    private PsiFile myFile;

    public FileStructureTestFixture(@NotNull CodeInsightTestFixture fixture) {
        this.myFixture = fixture;
    }

    @Nullable
    public FilteringTreeStructure.FilteringNode update() {
        FileStructurePopup popup = this.getPopup();
        UIUtil.dispatchAllInvocationEvents();
        PlatformTestUtil.waitForPromise(popup.rebuildAndUpdate());
        TreePath path = (TreePath)PlatformTestUtil.waitForPromise(popup.select((Object)popup.getCurrentElement(this.myFile)));
        return (FilteringTreeStructure.FilteringNode)TreeUtil.getLastUserObject(FilteringTreeStructure.FilteringNode.class, (TreePath)path);
    }

    public Tree getTree() {
        return this.getPopup().getTree();
    }

    public TreeSpeedSearch getSpeedSearch() {
        return this.getPopup().getSpeedSearch();
    }

    public FilteringTreeStructure.FilteringNode getRootNode() {
        return (FilteringTreeStructure.FilteringNode)TreeUtil.getUserObject(FilteringTreeStructure.FilteringNode.class, (Object)this.getTree().getModel().getRoot());
    }

    @NotNull
    public FileStructurePopup getPopup() {
        if (this.myPopup == null || this.myFile != this.myFixture.getFile()) {
            if (this.myPopup != null) {
                Disposer.dispose((Disposable)this.myPopup);
                this.myPopup = null;
            }
            this.myFile = this.myFixture.getFile();
            this.myPopup = ViewStructureAction.createPopup((Project)this.myFixture.getProject(), (FileEditor)TextEditorProvider.getInstance().getTextEditor(this.myFixture.getEditor()));
            assert (this.myPopup != null);
            Disposer.register((Disposable)this, (Disposable)this.myPopup);
            this.myPopup.createCenterPanel();
        }
        return this.myPopup;
    }

    public void dispose() {
        this.myPopup = null;
        this.myFile = null;
    }
}

