/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerExImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.FileEditorManagerTestCase;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.common.RunAllKt;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.EDT;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0004J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0014R\u0012\u0010\u0003\u001a\u00020\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/testFramework/FileEditorManagerTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "initialContainers", "", "manager", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "createFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "content", "", "getFile", "openFiles", "", "femSerialisedText", "setUp", "tearDown", "intellij.platform.testFramework"})
public abstract class FileEditorManagerTestCase
extends BasePlatformTestCase {
    @JvmField
    @Nullable
    protected FileEditorManagerImpl manager;
    @JvmField
    protected int initialContainers;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = (FileEditorManagerImpl)new FileEditorManagerExImpl(this.getProject());
        ComponentManager componentManager = (ComponentManager)this.getProject();
        FileEditorManagerImpl fileEditorManagerImpl = this.manager;
        Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
        ServiceContainerUtil.registerComponentInstance(componentManager, FileEditorManager.class, fileEditorManagerImpl, this.getTestRootDisposable());
        FileEditorProviderManager fileEditorProviderManager = FileEditorProviderManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)fileEditorProviderManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl");
        ((FileEditorProviderManagerImpl)fileEditorProviderManager).clearSelectedProviders();
        this.initialContainers = DockManager.getInstance((Project)this.getProject()).getContainers().size();
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.getProject();
        Function0[] function0Array = new Function0[]{(Function0)new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileEditorManagerImpl fileEditorManagerImpl = this.this$0.manager;
                Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
                fileEditorManagerImpl.closeAllFiles();
            }
        }, (Function0)new Function0<Unit>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                if (this.$project != null) {
                    EditorHistoryManager.getInstance((Project)this.$project).removeAllFiles();
                }
            }
        }, tearDown.3.INSTANCE, (Function0)new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileEditorManagerImpl fileEditorManagerImpl = this.this$0.manager;
                Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
                Disposer.dispose((Disposable)((Disposable)fileEditorManagerImpl));
            }
        }, (Function0)new Function0<Unit>(this, project2){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                this.this$0.manager = null;
                if (this.$project != null) {
                    DockManager dockManager = (DockManager)this.$project.getServiceIfCreated(DockManager.class);
                    Object object = dockManager;
                    if (object == null || (object = object.getContainers()) == null) {
                        object = SetsKt.emptySet();
                    }
                    Object containers = object;
                    BasePlatformTestCase.assertSize(this.this$0.initialContainers, (Collection)containers);
                }
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileEditorManagerTestCase.access$tearDown$s497353094(this.this$0);
            }
        }};
        RunAllKt.runAll(function0Array);
    }

    @NotNull
    protected final VirtualFile getFile(@NotNull String path) {
        String fullPath = this.getTestDataPath() + path;
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        BasePlatformTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file2);
        VirtualFile virtualFile = file2;
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    @NotNull
    protected final VirtualFile createFile(@NotNull String path, @NotNull byte[] content) {
        Path io = Path.of(this.getTestDataPath() + path, new String[0]);
        PathKt.write$default((Path)io, (byte[])content, (int)0, (int)0, (int)6, null);
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(io);
        BasePlatformTestCase.assertNotNull((String)("Can't find " + io), (Object)file2);
        VirtualFile virtualFile = file2;
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    protected final void openFiles(@NotNull String femSerialisedText) {
        Element rootElement = JDOMUtil.load((CharSequence)femSerialisedText);
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        map.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map.substitute(rootElement, true, true);
        FileEditorManagerImpl fileEditorManagerImpl = this.manager;
        Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
        fileEditorManagerImpl.loadState(rootElement);
        FileEditorManagerImpl fileEditorManagerImpl2 = this.manager;
        Intrinsics.checkNotNull((Object)fileEditorManagerImpl2);
        CompletableFuture future = FutureKt.asCompletableFuture((Job)fileEditorManagerImpl2.getMainSplitters().openFilesAsync());
        while (true) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                EDT.dispatchAllInvocationEvents();
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void access$tearDown$s497353094(FileEditorManagerTestCase $this) {
        super.tearDown();
    }
}

