/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.Pair;
import com.intellij.testFramework.PerformanceTestInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class CpuUsageData {
    private static final ThreadMXBean ourThreadMXBean = ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> ourGcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private static final CompilationMXBean ourCompilationMXBean = ManagementFactory.getCompilationMXBean();
    private static final OperatingSystemMXBean ourOSBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    public final long durationMs;
    private final FreeMemorySnapshot myMemStart;
    private final FreeMemorySnapshot myMemEnd;
    private final long myCompilationTimeMs;
    private final long myProcessTimeMs;
    private final List<Pair<Long, String>> myGcTimes = new ArrayList<Pair<Long, String>>();
    private final List<Pair<Long, String>> myThreadTimes = new ArrayList<Pair<Long, String>>();

    private CpuUsageData(long durationMs, @NotNull Map<GarbageCollectorMXBean, Long> gcTimes, @NotNull Map<ThreadInfo, Long> threadTimes, long compilationTimeMs, long processTimeMs, @NotNull FreeMemorySnapshot memStart, @NotNull FreeMemorySnapshot memEnd) {
        this.durationMs = durationMs;
        this.myMemStart = memStart;
        this.myMemEnd = memEnd;
        this.myCompilationTimeMs = compilationTimeMs;
        this.myProcessTimeMs = processTimeMs;
        gcTimes.forEach((bean, value) -> this.myGcTimes.add((Pair<Long, String>)Pair.create((Object)value, (Object)bean.getName())));
        threadTimes.forEach((info, nanos) -> this.myThreadTimes.add((Pair<Long, String>)Pair.create((Object)TimeUnit.NANOSECONDS.toMillis((long)nanos), (Object)info.getThreadName())));
        assert (durationMs >= 0L) : durationMs;
        assert (compilationTimeMs >= 0L) : compilationTimeMs;
        assert (processTimeMs >= 0L) : processTimeMs;
    }

    @NotNull
    public String getGcStats() {
        return CpuUsageData.printLongestNames(this.myGcTimes) + "; free " + this.myMemStart + " -> " + this.myMemEnd + " MB";
    }

    @NotNull
    String getProcessCpuStats() {
        long gcTotal = this.myGcTimes.stream().mapToLong(p -> (Long)p.first).sum();
        return this.myCompilationTimeMs + "ms (" + this.myCompilationTimeMs * 100L / (this.myProcessTimeMs == 0L ? 1000000L : this.myProcessTimeMs) + "%) compilation" + (String)(gcTotal > 0L ? " and " + gcTotal + "ms (" + gcTotal * 100L / (this.myProcessTimeMs == 0L ? 1000000L : this.myProcessTimeMs) + "%) GC" : "") + " of " + this.myProcessTimeMs + "ms total";
    }

    @NotNull
    public String getThreadStats() {
        return CpuUsageData.printLongestNames(this.myThreadTimes);
    }

    public long getMemDelta() {
        long usedBefore = this.myMemStart.total - this.myMemStart.free;
        long usedAfter = this.myMemEnd.total - this.myMemEnd.free;
        return usedAfter - usedBefore;
    }

    @NotNull
    public String getSummary(@NotNull String indent) {
        return indent + "GC: " + this.getGcStats() + "\n" + indent + "Threads: " + this.getThreadStats() + "\n" + indent + "Process: " + this.getProcessCpuStats();
    }

    boolean hasAnyActivityBesides(@NotNull Thread thread) {
        return this.myCompilationTimeMs > 0L || this.myThreadTimes.stream().anyMatch(pair -> (Long)pair.first > 0L && !((String)pair.second).equals(thread.getName())) || this.myGcTimes.stream().anyMatch(pair -> (Long)pair.first > 0L);
    }

    @NotNull
    PerformanceTestInfo.IterationResult getIterationResult(int expectedOnMyMachine) {
        if (this.durationMs < (long)expectedOnMyMachine) {
            return PerformanceTestInfo.IterationResult.ACCEPTABLE;
        }
        if ((double)this.durationMs < (double)expectedOnMyMachine * 1.1) {
            return PerformanceTestInfo.IterationResult.BORDERLINE;
        }
        if (this.myCompilationTimeMs >= this.durationMs) {
            return PerformanceTestInfo.IterationResult.DISTRACTED;
        }
        return PerformanceTestInfo.IterationResult.SLOW;
    }

    @NotNull
    private static String printLongestNames(@NotNull List<? extends Pair<Long, String>> times) {
        String stats = times.stream().sorted(Comparator.comparingLong(p -> (Long)p.first).reversed()).filter(p -> (Long)p.first > 10L).limit(10L).map(p -> "\"" + (String)p.second + "\" took " + p.first + "ms").collect(Collectors.joining(", "));
        return stats.isEmpty() ? "insignificant" : stats;
    }

    @NotNull
    public static <E extends Throwable> CpuUsageData measureCpuUsage(@NotNull ThrowableRunnable<E> runnable) throws E {
        FreeMemorySnapshot memStart = new FreeMemorySnapshot();
        HashMap<GarbageCollectorMXBean, Long> gcTimes = new HashMap<GarbageCollectorMXBean, Long>();
        for (GarbageCollectorMXBean bean : ourGcBeans) {
            gcTimes.put(bean, bean.getCollectionTime());
        }
        HashingStrategy<ThreadInfo> byId = new HashingStrategy<ThreadInfo>(){

            public int hashCode(ThreadInfo object) {
                return (int)object.getThreadId();
            }

            public boolean equals(ThreadInfo o1, ThreadInfo o2) {
                return o1 == null || o2 == null ? o1 == o2 : o1.getThreadId() == o2.getThreadId();
            }
        };
        Map startTimes = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)byId);
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            ThreadInfo threadInfo = ourThreadMXBean.getThreadInfo(id);
            long start = ourThreadMXBean.getThreadUserTime(id);
            if (threadInfo == null || start == -1L) continue;
            startTimes.put(threadInfo, start);
        }
        long compStart = CpuUsageData.getTotalCompilationMillis();
        long processStart = ourOSBean.getProcessCpuTime();
        long start = System.nanoTime();
        runnable.run();
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        long processTime = TimeUnit.NANOSECONDS.toMillis(ourOSBean.getProcessCpuTime() - processStart);
        long compilationTime = CpuUsageData.getTotalCompilationMillis() - compStart;
        FreeMemorySnapshot memEnd = new FreeMemorySnapshot();
        Map threadTimes = CollectionFactory.createCustomHashingStrategyMap((int)startTimes.size(), (HashingStrategy)byId);
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            ThreadInfo info = ourThreadMXBean.getThreadInfo(id);
            if (info == null) continue;
            Long oldStart = (Long)startTimes.get(info);
            long end = ourThreadMXBean.getThreadUserTime(id);
            if (oldStart == null || end == -1L) continue;
            threadTimes.put(info, end - oldStart);
        }
        Object object = ourGcBeans.iterator();
        while (object.hasNext()) {
            GarbageCollectorMXBean bean = (GarbageCollectorMXBean)object.next();
            long time = (Long)ObjectUtils.notNull((Object)((Long)gcTimes.get(bean)), (Object)0L);
            gcTimes.put(bean, bean.getCollectionTime() - time);
        }
        return new CpuUsageData(duration, gcTimes, threadTimes, compilationTime, processTime, memStart, memEnd);
    }

    static long getTotalCompilationMillis() {
        return ourCompilationMXBean.getTotalCompilationTime();
    }

    private static class FreeMemorySnapshot {
        final long free = FreeMemorySnapshot.toMb(Runtime.getRuntime().freeMemory());
        final long total = FreeMemorySnapshot.toMb(Runtime.getRuntime().totalMemory());

        private FreeMemorySnapshot() {
        }

        private static long toMb(long bytes) {
            return bytes / 1024L / 1024L;
        }

        public String toString() {
            return this.free + "/" + this.total;
        }
    }
}

