/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.teamcity;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.TestCaseLoader;
import com.intellij.teamcity.TeamCityClient;
import com.intellij.tool.HttpClient;
import com.intellij.tool.RetryKt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.apache.http.HttpRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007J\u0016\u0010%\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020(0+J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020(0+2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020(0+J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020(0+2\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00102\b\u00100\u001a\u0004\u0018\u00010\u0007H\u0002J\u001b\u00101\u001a\u0002H2\"\b\b\u0000\u00102*\u000203*\u0002H2H\u0002\u00a2\u0006\u0002\u00104R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR'\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0015\u0010\tR\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u0018\u0010\tR\u0016\u0010\u001a\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000b\u001a\u0004\b\u001c\u0010\tR\u0016\u0010\u001e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000b\u001a\u0004\b \u0010\u0012R\u001b\u0010\"\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000b\u001a\u0004\b#\u0010\t\u00a8\u00065"}, d2={"Lcom/intellij/teamcity/TeamCityClient;", "", "()V", "baseUrl", "Ljava/net/URI;", "kotlin.jvm.PlatformType", "buildId", "", "getBuildId", "()Ljava/lang/String;", "buildId$delegate", "Lkotlin/Lazy;", "buildNumber", "getBuildNumber", "buildNumber$delegate", "buildParams", "", "getBuildParams", "()Ljava/util/Map;", "buildParams$delegate", "buildTypeId", "getBuildTypeId", "buildTypeId$delegate", "configurationName", "getConfigurationName", "configurationName$delegate", "guestAuthUrl", "password", "getPassword", "password$delegate", "restUrl", "systemProperties", "getSystemProperties", "systemProperties$delegate", "userName", "getUserName", "userName$delegate", "downloadChangesPatch", "modificationId", "get", "Lcom/fasterxml/jackson/databind/JsonNode;", "fullUrl", "getChanges", "", "getExistingParameter", "name", "getTestRunInfo", "loadProperties", "file", "withAuth", "T", "Lorg/apache/http/HttpRequest;", "(Lorg/apache/http/HttpRequest;)Lorg/apache/http/HttpRequest;", "intellij.platform.testFramework.core"})
public final class TeamCityClient {
    @NotNull
    public static final TeamCityClient INSTANCE = new TeamCityClient();
    @NotNull
    private static final Lazy systemProperties$delegate = LazyKt.lazy((Function0)systemProperties.2.INSTANCE);
    private static final URI baseUrl = new URI("https://buildserver.labs.intellij.net").normalize();
    private static final URI restUrl = baseUrl.resolve("/app/rest/");
    private static final URI guestAuthUrl = baseUrl.resolve("/guestAuth/app/rest/");
    @NotNull
    private static final Lazy buildNumber$delegate = LazyKt.lazy((Function0)buildNumber.2.INSTANCE);
    @NotNull
    private static final Lazy configurationName$delegate = LazyKt.lazy((Function0)configurationName.2.INSTANCE);
    @NotNull
    private static final Lazy buildParams$delegate = LazyKt.lazy((Function0)buildParams.2.INSTANCE);
    @NotNull
    private static final Lazy buildId$delegate = LazyKt.lazy((Function0)buildId.2.INSTANCE);
    @NotNull
    private static final Lazy buildTypeId$delegate = LazyKt.lazy((Function0)buildTypeId.2.INSTANCE);
    @NotNull
    private static final Lazy userName$delegate = LazyKt.lazy((Function0)userName.2.INSTANCE);
    @NotNull
    private static final Lazy password$delegate = LazyKt.lazy((Function0)password.2.INSTANCE);

    private TeamCityClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> loadProperties(String file2) {
        Object object;
        try {
            Map map;
            String string = file2;
            if (string == null) {
                throw new Error("No file!");
            }
            object = new File(string);
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object = (object3 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2)) instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                Map map2 = new LinkedHashMap();
                Properties ps = new Properties();
                ps.load(it);
                ps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> TeamCityClient.loadProperties$lambda$1$lambda$0(map2, arg_0, arg_1)));
                map = map2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = map;
        }
        catch (Throwable t) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private final Map<String, String> getSystemProperties() {
        Lazy lazy = systemProperties$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final String getBuildNumber() {
        Lazy lazy = buildNumber$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getConfigurationName() {
        Lazy lazy = configurationName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final Map<String, String> getBuildParams() {
        Lazy lazy = buildParams$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final String getExistingParameter(@NotNull String name) {
        String string = this.getBuildParams().get(name);
        if (string == null) {
            throw new IllegalStateException(("Parameter " + name + " is not specified in the build!").toString());
        }
        return string;
    }

    @NotNull
    public final String getBuildId() {
        Lazy lazy = buildId$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getBuildTypeId() {
        Lazy lazy = buildTypeId$delegate;
        return (String)lazy.getValue();
    }

    private final String getUserName() {
        Lazy lazy = userName$delegate;
        return (String)lazy.getValue();
    }

    private final String getPassword() {
        Lazy lazy = password$delegate;
        return (String)lazy.getValue();
    }

    private final <T extends HttpRequest> T withAuth(T $this$withAuth) {
        T t;
        T $this$withAuth_u24lambda_u242 = t = $this$withAuth;
        boolean bl = false;
        $this$withAuth_u24lambda_u242.addHeader(new BasicScheme().authenticate((Credentials)new UsernamePasswordCredentials(INSTANCE.getUserName(), INSTANCE.getPassword()), $this$withAuth_u24lambda_u242, null));
        return t;
    }

    @NotNull
    public final JsonNode get(@NotNull URI fullUrl) {
        JsonNode result2;
        HttpGet httpGet;
        HttpGet $this$get_u24lambda_u243 = httpGet = new HttpGet(fullUrl);
        boolean bl = false;
        $this$get_u24lambda_u243.addHeader("Content-Type", "application/json");
        $this$get_u24lambda_u243.addHeader("Accept", "application/json");
        INSTANCE.withAuth((HttpRequest)$this$get_u24lambda_u243);
        HttpGet request = httpGet;
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Request to TeamCity: " + fullUrl));
        }
        JsonNode jsonNode = result2 = (JsonNode)RetryKt.withRetry-exY8QGI$default(0L, null, 0L, (Function0)new Function0<JsonNode>(request){
            final /* synthetic */ HttpGet $request;
            {
                this.$request = $request;
                super(0);
            }

            public final JsonNode invoke() {
                return (JsonNode)HttpClient.INSTANCE.sendRequest((HttpUriRequest)this.$request, get.result.1.INSTANCE);
            }
        }, 7, null);
        if (jsonNode == null) {
            boolean bl2 = false;
            String string = "Request " + request.getURI() + " failed";
            throw new IllegalArgumentException(string.toString());
        }
        return jsonNode;
    }

    @NotNull
    public final String downloadChangesPatch(@NotNull String buildTypeId2, @NotNull String modificationId) {
        URI url = baseUrl.resolve("/downloadPatch.html?buildTypeId=" + buildTypeId2 + "&modId=" + modificationId);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (!HttpClient.INSTANCE.download((HttpUriRequest)this.withAuth((HttpRequest)new HttpGet(url)), outputStream, 3L)) {
            throw new RuntimeException("Couldn't download " + url + " in 3 attempts");
        }
        System.out.println((Object)("Downloading of " + url + " finished"));
        return outputStream.toString("UTF-8");
    }

    @NotNull
    public final String downloadChangesPatch(@NotNull String modificationId) {
        return this.downloadChangesPatch(this.getBuildTypeId(), modificationId);
    }

    @NotNull
    public final List<JsonNode> getChanges(@NotNull String buildId2) {
        URI fullUrl = restUrl.resolve("changes?locator=build:(id:" + buildId2 + ")");
        List changes2 = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)this.get(fullUrl).fields()), (Function1)getChanges.changes.1.INSTANCE), (Function1)getChanges.changes.2.INSTANCE));
        return changes2;
    }

    @NotNull
    public final List<JsonNode> getChanges() {
        return this.getChanges(this.getBuildId());
    }

    @NotNull
    public final List<JsonNode> getTestRunInfo(@NotNull String buildId2) {
        int countOfTestsOnPage = 200;
        int startPosition = 0;
        List accumulatedTests = new ArrayList();
        List currentTests = null;
        System.out.println((Object)"Getting test run info from TC ...");
        do {
            URI fullUrl = restUrl.resolve("testOccurrences?locator=build:(id:" + buildId2 + "),count:" + countOfTestsOnPage + ",start:" + startPosition);
            currentTests = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)this.get(fullUrl).fields()), (Function1)getTestRunInfo.1.INSTANCE), (Function1)getTestRunInfo.2.INSTANCE));
            accumulatedTests.addAll(currentTests);
            startPosition += countOfTestsOnPage;
        } while (!((Collection)currentTests).isEmpty());
        System.out.println((Object)("Test run info acquired. Count of tests " + accumulatedTests.size()));
        return accumulatedTests;
    }

    @NotNull
    public final List<JsonNode> getTestRunInfo() {
        return this.getTestRunInfo(this.getBuildId());
    }

    private static final void loadProperties$lambda$1$lambda$0(Map $map, Object k, Object v) {
        if (k != null && v != null) {
            $map.put(k.toString(), v.toString());
        }
    }

    public static final /* synthetic */ Map access$loadProperties(TeamCityClient $this, String file2) {
        return $this.loadProperties(file2);
    }

    public static final /* synthetic */ Map access$getSystemProperties(TeamCityClient $this) {
        return $this.getSystemProperties();
    }
}

