/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.SuperUserStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;

public final class IoTestUtil {
    @Nullable
    private static final Boolean symLinkMode = SystemInfo.isUnix ? Boolean.TRUE : IoTestUtil.canCreateSymlinks();
    public static final boolean isSymLinkCreationSupported = symLinkMode != null;
    private static final String[] UNICODE_PARTS = new String[]{"\u042e\u043d\u0438\u043a\u043e\u0434\u0435", "\u00da\u00f1\u00ed\u00e7\u00f8d\u00ea"};

    private IoTestUtil() {
    }

    @Nullable
    public static String getUnicodeName() {
        return IoTestUtil.filterParts(PathUtil::isValidFileName);
    }

    @Nullable
    public static String getUnicodeName(String forEncoding) {
        return IoTestUtil.filterParts(Charset.forName(forEncoding).newEncoder()::canEncode);
    }

    private static String filterParts(@NotNull Predicate<? super String> predicate) {
        return StringUtil.nullize((String)Stream.of(UNICODE_PARTS).filter(predicate).collect(Collectors.joining("_")));
    }

    @NotNull
    public static File getTempDirectory() {
        File dir = new File(FileUtil.getTempDirectory());
        dir = IoTestUtil.expandWindowsPath(dir);
        return dir;
    }

    private static File expandWindowsPath(File file2) {
        if (SystemInfo.isWindows && file2.getPath().indexOf(126) > 0) {
            try {
                return file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file2;
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link) {
        return IoTestUtil.createSymLink(target, link, Boolean.TRUE);
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link, boolean shouldExist) {
        return IoTestUtil.createSymLink(target, link, (Boolean)shouldExist);
    }

    @NotNull
    public static Path createSymbolicLink(@NotNull Path link, @NotNull Path target) throws IOException {
        try {
            return IoTestUtil.createSymLink(target.toString(), link.toString(), null).toPath();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static File createSymLink(String target, String link, @Nullable Boolean shouldExist) {
        File linkFile = IoTestUtil.getFullLinkPath(link);
        File targetFile = new File(target);
        try {
            if (symLinkMode == Boolean.TRUE) {
                Files.createSymbolicLink(linkFile.toPath(), targetFile.toPath(), new FileAttribute[0]);
            } else if (Files.isDirectory(targetFile.isAbsolute() ? targetFile.toPath() : linkFile.toPath().getParent().resolve(target), new LinkOption[0])) {
                IoTestUtil.runCommand("cmd", "/C", "mklink", "/D", linkFile.getPath(), targetFile.getPath());
            } else {
                IoTestUtil.runCommand("cmd", "/C", "mklink", linkFile.getPath(), targetFile.getPath());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (shouldExist != null) {
            Assert.assertEquals((String)("target=" + target + ", link=" + linkFile), (Object)shouldExist, (Object)linkFile.exists());
        }
        return linkFile;
    }

    public static void assumeSymLinkCreationIsSupported() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Can't create symlinks on " + SystemInfo.getOsNameAndVersion()), (boolean)isSymLinkCreationSupported);
    }

    public static void assumeNioSymLinkCreationIsSupported() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Can't create symlinks via NIO2 on " + SystemInfo.getOsNameAndVersion()), (symLinkMode == Boolean.TRUE ? 1 : 0) != 0);
    }

    public static void assumeWindows() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Windows, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isWindows);
    }

    public static void assumeMacOS() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need macOS, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isMac);
    }

    public static void assumeLinux() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Linux, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isLinux);
    }

    public static void assumeUnix() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Unix, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isUnix);
    }

    public static void assumeCaseSensitiveFS() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Assumed case sensitive FS but got " + SystemInfo.getOsNameAndVersion()), (boolean)SystemInfo.isFileSystemCaseSensitive);
    }

    public static void assumeCaseInsensitiveFS() throws AssumptionViolatedException {
        Assume.assumeFalse((String)("Assumed case insensitive FS but got " + SystemInfo.getOsNameAndVersion()), (boolean)SystemInfo.isFileSystemCaseSensitive);
    }

    public static void assumeWslPresence() throws AssumptionViolatedException {
        Assume.assumeTrue((String)"'wsl.exe' not found in %Path%", (WSLDistribution.findWslExe() != null ? 1 : 0) != 0);
    }

    @NotNull
    public static Path createWslTempDir(@NotNull String wsl, @NotNull String testName2) throws IOException {
        return Files.createTempDirectory(Paths.get("\\\\wsl$\\" + wsl + "\\tmp", new String[0]), "unitTest_" + testName2 + "_", new FileAttribute[0]);
    }

    @NotNull
    public static File createJunction(@NotNull String target, @NotNull String junction) {
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        File junctionFile = IoTestUtil.getFullLinkPath(junction);
        IoTestUtil.runCommand("cmd", "/C", "mklink", "/J", junctionFile.getPath(), targetFile.getPath());
        Assert.assertTrue((String)("target=" + targetFile + ", link=" + junctionFile), (boolean)junctionFile.isDirectory());
        return junctionFile;
    }

    public static void deleteJunction(@NotNull String junction) {
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        Assert.assertTrue((boolean)new File(junction).delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performTestOnWindowsSubst(@NotNull String target, @NotNull @NotNull Consumer<? super @NotNull File> createdSubstTester) {
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        String substRoot = IoTestUtil.getFirstFreeDriveLetter() + ":";
        IoTestUtil.runCommand("subst", substRoot, targetFile.getPath());
        File rootFile = new File(substRoot + "\\");
        Assert.assertTrue((String)("target=" + targetFile + ", subst=" + rootFile), (boolean)rootFile.isDirectory());
        try {
            createdSubstTester.accept(rootFile);
        }
        catch (Throwable throwable) {
            IoTestUtil.runCommand("subst", StringUtil.trimEnd((String)substRoot, (char)'\\'), "/d");
            throw throwable;
        }
        IoTestUtil.runCommand("subst", StringUtil.trimEnd((String)substRoot, (char)'\\'), "/d");
    }

    public static void createFifo(@NotNull String path) {
        IoTestUtil.runCommand("mkfifo", path);
    }

    private static char getFirstFreeDriveLetter() {
        Set roots = StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).map(root -> Character.valueOf(StringUtil.toUpperCase((String)root.toString()).charAt(0))).collect(Collectors.toSet());
        Logger.getInstance(IoTestUtil.class).debug("logical drives: " + roots);
        for (char c = 'E'; c <= 'Z'; c = (char)(c + '\u0001')) {
            if (roots.contains(Character.valueOf(c))) continue;
            return c;
        }
        throw new RuntimeException("No free roots");
    }

    private static File getFullLinkPath(String link) {
        File linkFile = new File(link);
        if (!linkFile.isAbsolute()) {
            linkFile = new File(IoTestUtil.getTempDirectory(), link);
        }
        Assert.assertTrue((String)link, (!linkFile.exists() || linkFile.delete() ? 1 : 0) != 0);
        File parentDir = linkFile.getParentFile();
        Assert.assertTrue((String)("link=" + link + ", parent=" + parentDir), (parentDir != null && (parentDir.isDirectory() || parentDir.mkdirs()) ? 1 : 0) != 0);
        return linkFile;
    }

    private static String runCommand(String ... command) {
        try {
            GeneralCommandLine cmd = new GeneralCommandLine(command).withRedirectErrorStream(true);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)30000);
            String out = output.getStdout().trim();
            if (output.getExitCode() != 0) {
                Assert.fail((String)("failed: " + cmd + "\nexit code: " + output.getExitCode() + "; output:\n" + out));
            }
            return out;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertTimestampsEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertEquals((String)("expected: " + expected + ", actual: " + actual), (long)roundedExpected, (long)roundedActual);
    }

    public static void assertTimestampsNotEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertTrue((String)("(un)expected: " + expected + ", actual: " + actual), (roundedExpected != roundedActual ? 1 : 0) != 0);
    }

    @NotNull
    public static File createTestJar(@NotNull File jarFile) {
        return IoTestUtil.createTestJar(jarFile, "META-INF/MANIFEST.MF", "");
    }

    @NotNull
    public static File createTestJar(@NotNull File jarFile, String ... namesAndTexts) {
        File file2;
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        try {
            for (int i2 = 0; i2 < namesAndTexts.length; i2 += 2) {
                stream.putNextEntry(new ZipEntry(namesAndTexts[i2]));
                if (namesAndTexts[i2 + 1] != null) {
                    stream.write(namesAndTexts[i2 + 1].getBytes(StandardCharsets.UTF_8));
                }
                stream.closeEntry();
            }
            file2 = jarFile;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return file2;
    }

    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull Collection<? extends Pair<String, byte[]>> namesAndContents) {
        File file2;
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        try {
            for (Pair<String, byte[]> pair : namesAndContents) {
                String name = (String)pair.first;
                byte[] content = (byte[])pair.second;
                stream.putNextEntry(new ZipEntry(name));
                stream.write(content);
                stream.closeEntry();
            }
            file2 = jarFile;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return file2;
    }

    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull File root) {
        File file3;
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        try {
            FileUtil.visitFiles((File)root, file2 -> {
                if (file2.isFile()) {
                    String path = FileUtil.toSystemIndependentName((String)Objects.requireNonNull(FileUtil.getRelativePath((File)root, (File)file2)));
                    try {
                        stream.putNextEntry(new ZipEntry(path));
                        try (FileInputStream is = new FileInputStream((File)file2);){
                            FileUtil.copy((InputStream)is, (OutputStream)stream);
                        }
                        stream.closeEntry();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            });
            file3 = jarFile;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return file3;
    }

    @NotNull
    public static File createTestDir(@NotNull String name) {
        return IoTestUtil.createTestDir(IoTestUtil.getTempDirectory(), name);
    }

    @NotNull
    public static File createTestDir(@NotNull File parent, @NotNull String name) {
        File dir = new File(parent, name);
        Assert.assertTrue((String)dir.getPath(), (boolean)dir.mkdirs());
        return dir;
    }

    @NotNull
    public static File createTestFile(@NotNull String name) {
        return IoTestUtil.createTestFile(name, null);
    }

    @NotNull
    public static File createTestFile(@NotNull String name, @Nullable String content) {
        return IoTestUtil.createTestFile(IoTestUtil.getTempDirectory(), name, content);
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name) {
        return IoTestUtil.createTestFile(parent, name, null);
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name, @Nullable String content) {
        try {
            Assert.assertTrue((String)parent.getPath(), (parent.isDirectory() || parent.mkdirs() ? 1 : 0) != 0);
            File file2 = new File(parent, name);
            Assert.assertTrue((String)file2.getPath(), (boolean)file2.createNewFile());
            if (content != null) {
                FileUtil.writeToFile((File)file2, (String)content);
            }
            return file2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void delete(File ... files) {
        for (File file2 : files) {
            if (file2 == null) continue;
            FileUtil.delete((File)file2);
        }
    }

    public static void writeToFile(@NotNull File file2, @NotNull String content) {
        try {
            FileUtil.writeToFile((File)file2, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static Boolean canCreateSymlinks() {
        try {
            Path target = Files.createTempFile("IOTestUtil_link_target.", ".txt", new FileAttribute[0]);
            try {
                Boolean bl;
                Path link = target.getParent().resolve("IOTestUtil_link");
                try {
                    Files.createSymbolicLink(link, target.getFileName(), new FileAttribute[0]);
                    bl = Boolean.TRUE;
                }
                catch (IOException e) {
                    Logger.getInstance(IoTestUtil.class).debug((Throwable)e);
                    IoTestUtil.runCommand("cmd", "/C", "mklink", link.toString(), target.getFileName().toString());
                    Boolean bl2 = Boolean.FALSE;
                    Files.deleteIfExists(link);
                    Files.delete(target);
                    return bl2;
                    {
                        catch (Throwable throwable) {
                            Files.deleteIfExists(link);
                            throw throwable;
                        }
                    }
                }
                Files.deleteIfExists(link);
                return bl;
            }
            finally {
                Files.delete(target);
            }
        }
        catch (Throwable t) {
            Logger.getInstance(IoTestUtil.class).debug(t);
            return null;
        }
    }

    @NotNull
    public static String toLocalUncPath(@NotNull String localPath) {
        return "\\\\127.0.0.1\\" + localPath.charAt(0) + "$" + localPath.substring(2);
    }

    @NotNull
    public static @NotNull List<@NotNull String> enumerateWslDistributions() {
        Assert.assertTrue((boolean)SystemInfo.isWin10OrNewer);
        try {
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"wsl", "-l", "-q"}).withRedirectErrorStream(true).withCharset(StandardCharsets.UTF_16LE);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)30000);
            if (output.getExitCode() == 0) {
                return output.getStdoutLines();
            }
            Logger.getInstance(IoTestUtil.class).debug(output.getExitCode() + " " + output.getStdout().trim());
        }
        catch (Exception e) {
            Logger.getInstance(IoTestUtil.class).debug((Throwable)e);
        }
        return Collections.emptyList();
    }

    public static boolean reanimateWslDistribution(@NotNull String name) {
        try {
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"wsl", "-d", name, "-e", "pwd"}).withRedirectErrorStream(true);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)30000);
            if (output.getExitCode() == 0) {
                return true;
            }
            Logger.getInstance(IoTestUtil.class).debug(output.getExitCode() + " " + output.getStdout().trim());
        }
        catch (Exception e) {
            Logger.getInstance(IoTestUtil.class).debug((Throwable)e);
        }
        return false;
    }

    @NotNull
    public static String assumeWorkingWslDistribution() {
        IoTestUtil.assumeWindows();
        IoTestUtil.assumeWslPresence();
        List<String> distributions = IoTestUtil.enumerateWslDistributions();
        Assume.assumeTrue((String)"No WSL distributions found", (!distributions.isEmpty() ? 1 : 0) != 0);
        for (String distribution : distributions) {
            if (!IoTestUtil.reanimateWslDistribution(distribution)) continue;
            return distribution;
        }
        Assume.assumeTrue((String)("Cannot find a working distribution among " + distributions), (boolean)false);
        return "";
    }

    public static void setCaseSensitivity(@NotNull File dir, boolean caseSensitive) throws IOException {
        Assert.assertTrue((String)"'fsutil.exe' needs elevated privileges to work", (boolean)SuperUserStatus.isSuperUser());
        String changeOut = IoTestUtil.runCommand("fsutil", "file", "setCaseSensitiveInfo", dir.getPath(), caseSensitive ? "enable" : "disable");
        String out = IoTestUtil.runCommand("fsutil", "file", "queryCaseSensitiveInfo", dir.getPath());
        if (!out.endsWith(caseSensitive ? "enabled." : "disabled.")) {
            throw new IOException("Can't setCaseSensitivity(" + dir + ", " + caseSensitive + "). 'fsutil.exe setCaseSensitiveInfo' output:" + changeOut + "; 'fsutil.exe getCaseSensitiveInfo' output:" + out);
        }
    }
}

