/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.nastradamus;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.TestCaseLoader;
import com.intellij.nastradamus.NastradamusClient;
import com.intellij.nastradamus.model.ChangeEntity;
import com.intellij.nastradamus.model.SortRequestEntity;
import com.intellij.nastradamus.model.TestCaseEntity;
import com.intellij.nastradamus.model.TestResultEntity;
import com.intellij.nastradamus.model.TestResultRequestEntity;
import com.intellij.nastradamus.model.TestStatus;
import com.intellij.teamcity.TeamCityClient;
import com.intellij.tool.HttpClient;
import com.intellij.tool.RetryKt;
import com.intellij.tool.TaskKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/nastradamus/NastradamusClient;", "", "baseUrl", "Ljava/net/URI;", "(Ljava/net/URI;)V", "getBaseUrl", "()Ljava/net/URI;", "collectTestRunResults", "Lcom/intellij/nastradamus/model/TestResultRequestEntity;", "getRankedClasses", "", "Ljava/lang/Class;", "", "unsortedClasses", "", "getTeamCityChangeset", "", "sendSortingRequest", "Lcom/intellij/nastradamus/model/TestCaseEntity;", "sortRequestEntity", "Lcom/intellij/nastradamus/model/SortRequestEntity;", "sendTestRunResults", "", "testResultRequestEntity", "intellij.platform.testFramework.core"})
public final class NastradamusClient {
    @NotNull
    private final URI baseUrl;

    public NastradamusClient(@NotNull URI baseUrl) {
        this.baseUrl = baseUrl;
    }

    public /* synthetic */ NastradamusClient(URI uRI, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uRI = new URI(System.getProperty("idea.nastradamus.url")).normalize();
        }
        this(uRI);
    }

    @NotNull
    public final URI getBaseUrl() {
        return this.baseUrl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestCaseEntity> sendSortingRequest(@NotNull SortRequestEntity sortRequestEntity) {
        void $this$mapTo$iv$iv;
        JsonNode jsonTree2;
        HttpPost httpPost;
        URI uri = new URIBuilder(this.baseUrl.resolve("/sort/").normalize()).addParameter("build_id", TeamCityClient.INSTANCE.getBuildId()).build();
        String stringJson = ExtensionsKt.jacksonObjectMapper().writeValueAsString((Object)sortRequestEntity);
        HttpPost $this$sendSortingRequest_u24lambda_u240 = httpPost = new HttpPost(uri);
        boolean bl = false;
        $this$sendSortingRequest_u24lambda_u240.addHeader("Content-Type", "application/json");
        $this$sendSortingRequest_u24lambda_u240.addHeader("Accept", "application/json");
        $this$sendSortingRequest_u24lambda_u240.setEntity((HttpEntity)new StringEntity(stringJson, ContentType.APPLICATION_JSON));
        HttpPost httpPost2 = httpPost;
        System.out.println((Object)"Fetching sorted test classes from Nastradamus ...");
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Requesting " + uri + " with payload " + stringJson));
        }
        if ((jsonTree2 = (JsonNode)RetryKt.withRetry-exY8QGI$default(0L, null, 0L, (Function0)new Function0<JsonNode>(httpPost2){
            final /* synthetic */ HttpPost $httpPost;
            {
                this.$httpPost = $httpPost;
                super(0);
            }

            public final JsonNode invoke() {
                return (JsonNode)HttpClient.INSTANCE.sendRequest((HttpUriRequest)this.$httpPost, sendSortingRequest.jsonTree.1.INSTANCE);
            }
        }, 7, null)) == null) {
            boolean $i$a$-requireNotNull-NastradamusClient$sendSortingRequest$22 = false;
            String $i$a$-requireNotNull-NastradamusClient$sendSortingRequest$22 = "Received data from " + uri + " must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-NastradamusClient$sendSortingRequest$22.toString());
        }
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Received data from " + uri + ": " + jsonTree2));
        }
        Sequence $this$single$iv = SequencesKt.asSequence((Iterator)jsonTree2.fields());
        boolean $i$f$single = false;
        Iterable<Object> single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual(it.getKey(), (Object)"sorted_tests")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Iterable $this$map$iv = (Iterable)((Map.Entry)((Object)single$iv)).getValue();
        boolean $i$f$map = false;
        single$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonNode bl2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new TestCaseEntity(it.findValue("name").asText()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TestResultRequestEntity collectTestRunResults() {
        void $this$mapTo$iv$iv;
        List<JsonNode> tests = TeamCityClient.INSTANCE.getTestRunInfo();
        Iterable $this$map$iv = tests;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TestResultEntity(it.findValue("name").asText(), TestStatus.Companion.fromString(it.findValue("status").asText())));
        }
        List testResultEntities = (List)destination$iv$iv;
        return new TestResultRequestEntity(testResultEntities);
    }

    public final void sendTestRunResults(@NotNull TestResultRequestEntity testResultRequestEntity) {
        HttpPost httpPost;
        URI uri = new URIBuilder(this.baseUrl.resolve("/result/").normalize()).addParameter("build_id", TeamCityClient.INSTANCE.getBuildId()).build();
        String stringJson = ExtensionsKt.jacksonObjectMapper().writeValueAsString((Object)testResultRequestEntity);
        HttpPost $this$sendTestRunResults_u24lambda_u245 = httpPost = new HttpPost(uri);
        boolean bl = false;
        $this$sendTestRunResults_u24lambda_u245.addHeader("Content-Type", "application/json");
        $this$sendTestRunResults_u24lambda_u245.addHeader("Accept", "application/json");
        $this$sendTestRunResults_u24lambda_u245.setEntity((HttpEntity)new StringEntity(stringJson, ContentType.APPLICATION_JSON));
        HttpPost httpPost2 = httpPost;
        System.out.println((Object)"Sending test run results to Nastradamus ...");
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Requesting " + uri + " with payload " + stringJson));
        }
        RetryKt.withRetry-exY8QGI$default(0L, null, 0L, (Function0)new Function0<Unit>(httpPost2){
            final /* synthetic */ HttpPost $httpPost;
            {
                this.$httpPost = $httpPost;
                super(0);
            }

            public final void invoke() {
                HttpClient.INSTANCE.sendRequest((HttpUriRequest)this.$httpPost, sendTestRunResults.1.INSTANCE);
            }
        }, 7, null);
    }

    private final List<String> getTeamCityChangeset() {
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(null){
            int label;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        System.out.println((Object)"Fetching changesets patches from TeamCity ...");
                        this.label = 1;
                        v0 = TaskKt.mapConcurrently((Iterable)TeamCityClient.INSTANCE.getChanges(), 10, (Function2)new Function2<JsonNode, Continuation<? super String>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        JsonNode change = (JsonNode)this.L$0;
                                        String modificationId = change.findValue("id").asText();
                                        return TeamCityClient.INSTANCE.downloadChangesPatch(modificationId);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull JsonNode p1, @Nullable Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        changesets = (List)v0;
                        System.out.println((Object)"Fetching changesets patches completed");
                        return changesets;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Class<?>, Integer> getRankedClasses(@NotNull List<? extends Class<?>> unsortedClasses) {
        Map map;
        System.out.println((Object)"Getting sorted test classes from Nastradamus ...");
        try {
            Object object;
            void $this$associateTo$iv$iv;
            Object item$iv$iv3;
            void $this$mapTo$iv$iv;
            Object object2;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = this.getTeamCityChangeset();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv2;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(new ChangeEntity((String)it));
            }
            List changesets2 = (List)destination$iv$iv;
            Iterable $this$map$iv2 = unsortedClasses;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void it;
                Class bl = (Class)item$iv$iv3;
                object2 = destination$iv$iv2;
                boolean bl2 = false;
                object2.add(new TestCaseEntity(it.getName()));
            }
            List cases = (List)destination$iv$iv2;
            List<TestCaseEntity> sortedCases = this.sendSortingRequest(new SortRequestEntity(changesets2, cases));
            int rank = 0;
            rank = 1;
            Iterable $this$associate$iv = sortedCases;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            item$iv$iv3 = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                object = destination$iv$iv3;
                TestCaseEntity testCaseEntity = (TestCaseEntity)element$iv$iv;
                boolean bl = false;
                int n = rank;
                rank = n + 1;
                testCaseEntity = TuplesKt.to((Object)testCaseEntity.getName(), (Object)n);
                object.put(testCaseEntity.getFirst(), testCaseEntity.getSecond());
            }
            Map ranked = destination$iv$iv3;
            Iterable $this$associateWith$iv = unsortedClasses;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo2 = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void clazz;
                object = (Class)element$iv$iv;
                Object t = element$iv$iv;
                object2 = result$iv;
                boolean bl = false;
                Integer n = (Integer)ranked.get(clazz.getName());
                Integer n2 = n != null ? n : -1;
                object2.put(t, n2);
            }
            Map sortedOriginalClasses = result$iv;
            System.out.println((Object)"Fetching sorted test classes from Nastradamus completed");
            map = sortedOriginalClasses;
        }
        catch (Exception e) {
            System.err.println("Failure during sorting test classes via Nastradamus. Fallback to simple shuffle sorting");
            System.err.println(e);
            int rank = 0;
            rank = 1;
            Iterable $this$associateWith$iv = CollectionsKt.shuffled((Iterable)unsortedClasses);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                Class $i$f$associateWithTo2 = (Class)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                int n = rank;
                rank = n + 1;
                Integer n3 = n;
                map2.put(t, n3);
            }
            map = result$iv;
        }
        return map;
    }

    public NastradamusClient() {
        this(null, 1, null);
    }
}

