/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class ProjectConversionTestUtil {
    private ProjectConversionTestUtil() {
    }

    public static void assertNoConversionNeeded(@NotNull Path projectPath) {
        MyConversionListener listener2 = new MyConversionListener();
        ConversionResult result2 = ConversionService.getInstance().convertSilently(projectPath, (ConversionListener)listener2);
        Assert.assertTrue((boolean)result2.conversionNotNeeded());
        Assert.assertFalse((boolean)listener2.isConversionNeeded());
        Assert.assertFalse((boolean)listener2.isConverted());
    }

    public static void convert(@NotNull Path projectPath) {
        MyConversionListener listener2 = new MyConversionListener();
        ConversionResult result2 = ConversionService.getInstance().convertSilently(projectPath, (ConversionListener)listener2);
        Assert.assertFalse((boolean)result2.conversionNotNeeded());
        Assert.assertFalse((boolean)result2.openingIsCanceled());
        Assert.assertTrue((boolean)listener2.isConversionNeeded());
        Assert.assertTrue((boolean)listener2.isConverted());
    }

    public static final class MyConversionListener
    implements ConversionListener {
        private boolean myConversionNeeded;
        private boolean myConverted;

        public void conversionNeeded() {
            this.myConversionNeeded = true;
        }

        public void successfullyConverted(@NotNull Path backupDir) {
            this.myConverted = true;
        }

        public void error(@NotNull String message) {
            Assert.fail((String)message);
        }

        public boolean isConversionNeeded() {
            return this.myConversionNeeded;
        }

        public boolean isConverted() {
            return this.myConverted;
        }
    }
}

