/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class CompilerTestUtil {
    private static final Logger LOG = Logger.getInstance(CompilerTestUtil.class);

    private CompilerTestUtil() {
    }

    @TestOnly
    public static void setupJavacForTests(Project project2) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        compilerConfiguration.setDefaultCompiler((BackendCompiler)compilerConfiguration.getJavacCompiler());
    }

    @TestOnly
    public static void saveApplicationSettings() {
        IComponentStore store = CompilerTestUtil.getApplicationStore();
        store.saveComponent((PersistentStateComponent)ProjectJdkTable.getInstance());
        store.saveComponent((PersistentStateComponent)FileTypeManager.getInstance());
        store.saveComponent((PersistentStateComponent)PathMacros.getInstance());
    }

    @NotNull
    public static IComponentStore getApplicationStore() {
        return ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
    }

    @TestOnly
    public static void saveApplicationComponent(@NotNull PersistentStateComponent<?> appComponent) {
        EdtTestUtil.runInEdtAndWait(() -> CompilerTestUtil.getApplicationStore().saveComponent(appComponent));
    }

    @TestOnly
    public static void enableExternalCompiler() {
        JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
        WriteAction.runAndWait(() -> table.addJdk(table.getInternalJdk()));
    }

    @TestOnly
    public static void disableExternalCompiler(@NotNull Project project2) {
        EdtTestUtil.runInEdtAndWait(() -> {
            JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
            ApplicationManager.getApplication().runWriteAction(() -> {
                Sdk internalJdk = table.getInternalJdk();
                for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                    if (sdk == null || !sdk.equals(internalJdk)) continue;
                    ModuleRootModificationUtil.setModuleSdk((Module)module2, null);
                }
                table.removeJdk(internalJdk);
                BuildManager.getInstance().clearState(project2);
            });
        });
    }

    public static void deleteBuildSystemDirectory(@NotNull Project project2) {
        BuildManager buildManager = BuildManager.getInstance();
        if (buildManager == null) {
            return;
        }
        Path buildSystemDirectory = buildManager.getBuildSystemDirectory(project2);
        try {
            PathKt.delete((Path)buildSystemDirectory);
            return;
        }
        catch (Exception exception) {
            try {
                FileUtil.delete((File)buildSystemDirectory.toFile());
            }
            catch (Exception e) {
                LOG.warn("Unable to remove build system directory.", (Throwable)e);
            }
            return;
        }
    }
}

