/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.quickFix.ActionHint;
import com.intellij.codeInsight.daemon.quickFix.LightQuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.FileBasedArgumentProvider;
import com.intellij.testFramework.FileBasedTestCaseHelperEx;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase5;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AssertionsKt;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0007H\u0007R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/daemon/quickFix/LightQuickFixParameterizedTestCase5;", "Lcom/intellij/testFramework/fixtures/LightJavaCodeInsightFixtureTestCase5;", "Lcom/intellij/testFramework/FileBasedTestCaseHelperEx;", "projectDescriptor", "Lcom/intellij/testFramework/LightProjectDescriptor;", "(Lcom/intellij/testFramework/LightProjectDescriptor;)V", "basePath", "", "getBasePath", "()Ljava/lang/String;", "getBaseName", "fileAfterSuffix", "getFileSuffix", "fileName", "getRelativeBasePath", "getRelativePath", "parameterized", "", "intellij.java.testFramework"})
public abstract class LightQuickFixParameterizedTestCase5
extends LightJavaCodeInsightFixtureTestCase5
implements FileBasedTestCaseHelperEx {
    public LightQuickFixParameterizedTestCase5(@Nullable LightProjectDescriptor projectDescriptor) {
        super(projectDescriptor);
    }

    public /* synthetic */ LightQuickFixParameterizedTestCase5(LightProjectDescriptor lightProjectDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            lightProjectDescriptor = null;
        }
        this(lightProjectDescriptor);
    }

    @NotNull
    protected abstract String getBasePath();

    @Override
    @NotNull
    protected String getRelativePath() {
        return super.getRelativePath() + this.getBasePath();
    }

    @Override
    @NotNull
    public String getRelativeBasePath() {
        return this.getBasePath();
    }

    @Override
    @Nullable
    public String getFileSuffix(@NotNull String fileName) {
        String string;
        if (!StringsKt.startsWith$default((String)fileName, (String)"before", (boolean)false, (int)2, null)) {
            string = null;
        } else {
            String string2 = fileName.substring(6);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    @Override
    @Nullable
    public String getBaseName(@NotNull String fileAfterSuffix) {
        String string;
        if (!StringsKt.startsWith$default((String)fileAfterSuffix, (String)"after", (boolean)false, (int)2, null)) {
            string = null;
        } else {
            String string2 = fileAfterSuffix.substring(5);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    @ParameterizedTest(name="{argumentsWithNames}")
    @ArgumentsSource(value=FileBasedArgumentProvider.class)
    public final void parameterized(@NotNull String fileName) throws Throwable {
        String filePath = "/before" + fileName;
        PsiFile file2 = this.getFixture().configureByFile(filePath);
        IntentionAction action = ActionHint.parse(file2, file2.getText()).findAndCheck((Collection<? extends IntentionAction>)this.getFixture().getAvailableIntentions(), () -> LightQuickFixParameterizedTestCase5.parameterized$lambda$0(this, filePath));
        if (action != null) {
            String text = action.getText();
            this.getFixture().launchAction(action);
            boolean $i$f$runInEdtAndWait = false;
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable)new ThrowableRunnable(){

                public final void run() {
                    boolean bl = false;
                    UIUtil.dispatchAllInvocationEvents();
                }
            });
            List<IntentionAction> intentions = this.getFixture().getAvailableIntentions();
            IntentionAction afterAction = CodeInsightTestUtil.findIntentionByText(intentions, text);
            if (afterAction != null) {
                AssertionsKt.fail$default((String)("Action '" + text + "' is still available after its invocation in test " + filePath), null, (int)2, null);
                throw new KotlinNothingValueException();
            }
            this.getFixture().checkResultByFile("/after" + fileName);
        }
    }

    private static final String parameterized$lambda$0(LightQuickFixParameterizedTestCase5 this$0, String $filePath) {
        String string = this$0.getRelativePath();
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((Project)this$0.getFixture().getProject());
        Module module2 = ModuleUtilCore.findModuleForFile((PsiFile)this$0.getFixture().getFile());
        Intrinsics.checkNotNull((Object)module2);
        return StringsKt.trimIndent((String)("\n             Test: " + string + $filePath + "\n             Language level: " + languageLevel + "\n             SDK: " + ModuleRootManager.getInstance((Module)module2).getSdk() + "\n             Infos: " + LightQuickFixTestCase.getCurrentHighlightingInfo(this$0.getFixture().doHighlighting()) + "\n             "));
    }

    public LightQuickFixParameterizedTestCase5() {
        this(null, 1, null);
    }
}

