/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.JavaCodeInsightTestCase;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.JavaExpectedHighlightingData;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.LightQuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.ExternalAnnotatorsFilter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.xml.XmlFileNSInfoProvider;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlSchemaProvider;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DaemonAnalyzerTestCase
extends JavaCodeInsightTestCase {
    private VirtualFileFilter myVirtualFileFilter = new FileTreeAccessFilter();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LocalInspectionTool[] tools = this.configureLocalInspectionTools();
        InspectionsKt.configureInspections((InspectionProfileEntry[])tools, this.getProject(), this.getTestRootDisposable());
        DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
        daemonCodeAnalyzer.prepareForTest();
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
        if (this.isStressTest()) {
            IntentionManager.getInstance().getAvailableIntentions();
            PathManagerEx.getTestDataPath();
            ReferenceProvidersRegistry.getInstance();
            InjectedLanguageManager.getInstance((Project)this.getProject());
            LanguageAnnotators.INSTANCE.allForLanguage((Language)JavaLanguage.INSTANCE);
            LanguageAnnotators.INSTANCE.allForLanguage((Language)XMLLanguage.INSTANCE);
            ProblemHighlightFilter.EP_NAME.getExtensions();
            ImplicitUsageProvider.EP_NAME.getExtensionList();
            XmlSchemaProvider.EP_NAME.getExtensionList();
            XmlFileNSInfoProvider.EP_NAME.getExtensionList();
            ExternalAnnotatorsFilter.EXTENSION_POINT_NAME.getExtensionList();
            IndexPatternBuilder.EP_NAME.getExtensionList();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(true);
            Project project2 = this.getProject();
            if (project2 != null) {
                ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).checkCleared();
                ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2)).cleanupAfterTest();
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        ((CoreProgressManager)ProgressManager.getInstance()).suppressAllDeprioritizationsDuringLongTestsExecutionIn(() -> {
            super.runTestRunnable(testRunnable);
            return null;
        });
    }

    protected final void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        InspectionsKt.enableInspectionTool(this.getProject(), tool, this.getTestRootDisposable());
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        InspectionsKt.enableInspectionTools(this.getProject(), this.getTestRootDisposable(), tools);
    }

    protected void enableInspectionToolsFromProvider(InspectionToolProvider toolProvider) {
        try {
            for (Class c : toolProvider.getInspectionClasses()) {
                this.enableInspectionTool((InspectionProfileEntry)InspectionTestUtil.instantiateTool(c));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void disableInspectionTool(@NotNull String shortName) {
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)this.getProject()).getCurrentProfile();
        if (profile.getInspectionTool(shortName, this.getProject()) != null) {
            profile.setToolEnabled(shortName, false);
        }
    }

    protected LocalInspectionTool[] configureLocalInspectionTools() {
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    protected static LocalInspectionTool[] createLocalInspectionTools(InspectionToolProvider ... provider) {
        ArrayList<LocalInspectionTool> result2 = new ArrayList<LocalInspectionTool>();
        for (InspectionToolProvider toolProvider : provider) {
            for (Class aClass : toolProvider.getInspectionClasses()) {
                try {
                    LocalInspectionTool tool = (LocalInspectionTool)InspectionTestUtil.instantiateTool(aClass);
                    result2.add(tool);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return result2.toArray(LocalInspectionTool.EMPTY_ARRAY);
    }

    protected void doTest(@NonNls @NotNull String filePath, boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) throws Exception {
        this.configureByFile(filePath);
        this.doDoTest(checkWarnings, checkInfos, checkWeakWarnings);
    }

    protected void doTest(@NonNls @NotNull String filePath, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.doTest(filePath, checkWarnings, checkInfos, false);
    }

    protected void doTest(@NonNls @NotNull String filePath, @NonNls String projectRoot, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.configureByFile(filePath, projectRoot);
        this.doDoTest(checkWarnings, checkInfos);
    }

    @NotNull
    protected HighlightTestInfo testFile(String ... filePath) {
        return new HighlightTestInfo(this.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                try {
                    DaemonAnalyzerTestCase.this.configureByFiles(this.projectRoot, this.filePaths);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                JavaExpectedHighlightingData data = new JavaExpectedHighlightingData(DaemonAnalyzerTestCase.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                DaemonAnalyzerTestCase.this.checkHighlighting(data);
                return this;
            }
        };
    }

    protected void doTest(@NotNull VirtualFile vFile, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.doTest(new VirtualFile[]{vFile}, checkWarnings, checkInfos);
    }

    protected void doTest(VirtualFile @NotNull [] vFile, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.configureByFiles(null, vFile);
        this.doDoTest(checkWarnings, checkInfos);
    }

    protected void doTest(boolean checkWarnings, boolean checkInfos, String ... files) throws Exception {
        this.configureByFiles(null, files);
        this.doDoTest(checkWarnings, checkInfos);
    }

    @NotNull
    protected Collection<HighlightInfo> doDoTest(boolean checkWarnings, boolean checkInfos) {
        return this.doDoTest(checkWarnings, checkInfos, false);
    }

    protected Collection<HighlightInfo> doDoTest(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return ContainerUtil.filter(this.checkHighlighting(new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos)), info -> info.getSeverity() == HighlightSeverity.INFORMATION && checkInfos || info.getSeverity() == HighlightSeverity.WARNING && checkWarnings || info.getSeverity() == HighlightSeverity.WEAK_WARNING && checkWeakWarnings || info.getSeverity().compareTo(HighlightSeverity.WARNING) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Collection<HighlightInfo> checkHighlighting(@NotNull ExpectedHighlightingData data) {
        data.init();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter(this.myVirtualFileFilter, this.getTestRootDisposable());
        try {
            List<HighlightInfo> infos = this.doHighlighting();
            String text = this.myEditor.getDocument().getText();
            this.doCheckResult(data, infos, text);
            List<HighlightInfo> list = infos;
            return list;
        }
        finally {
            PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.getTestRootDisposable());
        }
    }

    protected void doCheckResult(@NotNull ExpectedHighlightingData data, Collection<HighlightInfo> infos, String text) {
        PsiFile file2 = this.getFile();
        data.checkLineMarkers(file2, DaemonCodeAnalyzerImpl.getLineMarkers((Document)this.getDocument(file2), (Project)this.getProject()), text);
        data.checkResult(file2, infos, text);
    }

    @Override
    protected Editor createEditor(@NotNull VirtualFile file2) {
        if (this.myVirtualFileFilter instanceof FileTreeAccessFilter) {
            this.allowTreeAccessForFile(file2);
        }
        return super.createEditor(file2);
    }

    protected void setVirtualFileFilter(@NotNull VirtualFileFilter filter) {
        this.myVirtualFileFilter = filter;
    }

    protected void allowTreeAccessForFile(@NotNull VirtualFile file2) {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForFile(file2);
    }

    protected void allowTreeAccessForAllFiles() {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForAllFiles();
    }

    @NotNull
    protected List<HighlightInfo> highlightErrors() {
        return this.doHighlighting(HighlightSeverity.ERROR);
    }

    @NotNull
    protected List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity minSeverity) {
        return DaemonAnalyzerTestCase.filter(this.doHighlighting(), minSeverity);
    }

    @NotNull
    protected List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        IntArrayList toIgnore = new IntArrayList();
        if (!this.doTestLineMarkers()) {
            toIgnore.add(11);
            toIgnore.add(13);
        }
        if (!this.doExternalValidation()) {
            toIgnore.add(8);
        }
        if (this.forceExternalValidation()) {
            toIgnore.add(11);
            toIgnore.add(13);
            toIgnore.add(7);
            toIgnore.add(12);
            toIgnore.add(3);
            toIgnore.add(4);
        }
        boolean canChange = this.canChangeDocumentDuringHighlighting();
        List<HighlightInfo> infos = CodeInsightTestFixtureImpl.instantiateAndRun(this.getFile(), this.getEditor(), toIgnore.toIntArray(), canChange);
        if (!canChange) {
            Document document = this.getDocument(this.getFile());
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject);
            daemonCodeAnalyzer.getFileStatusMap().assertAllDirtyScopesAreNull(document);
        }
        return infos;
    }

    private boolean canChangeDocumentDuringHighlighting() {
        return this.annotatedWith(CanChangeDocumentDuringHighlighting.class);
    }

    @NotNull
    public static List<HighlightInfo> filter(@NotNull List<? extends HighlightInfo> infos, @NotNull HighlightSeverity minSeverity) {
        return ContainerUtil.filter(infos, info -> info.getSeverity().compareTo(minSeverity) >= 0);
    }

    protected boolean doTestLineMarkers() {
        return false;
    }

    protected boolean doExternalValidation() {
        return true;
    }

    protected boolean forceExternalValidation() {
        return false;
    }

    protected static void findAndInvokeIntentionAction(@NotNull Collection<? extends HighlightInfo> infos, @NotNull String intentionActionName, @NotNull Editor editor, @NotNull PsiFile file2) {
        List<IntentionAction> actions = DaemonAnalyzerTestCase.getIntentionActions(infos, editor, file2);
        IntentionAction intentionAction = LightQuickFixTestCase.findActionWithText(actions, intentionActionName);
        if (intentionAction == null) {
            DaemonAnalyzerTestCase.fail((String)("Could not find action '" + intentionActionName + "'.\nAvailable actions: [" + StringUtil.join((Collection)ContainerUtil.map(actions, c -> c.getText()), (String)", ") + "]\nHighlightInfos: [" + StringUtil.join(infos, (String)", ") + "]"));
        }
        CodeInsightTestFixtureImpl.invokeIntention(intentionAction, file2, editor);
    }

    @Nullable
    protected static IntentionAction findIntentionAction(@NotNull Collection<? extends HighlightInfo> infos, @NotNull String intentionActionName, @NotNull Editor editor, @NotNull PsiFile file2) {
        List<IntentionAction> actions = DaemonAnalyzerTestCase.getIntentionActions(infos, editor, file2);
        return LightQuickFixTestCase.findActionWithText(actions, intentionActionName);
    }

    @NotNull
    protected static List<IntentionAction> getIntentionActions(@NotNull Collection<? extends HighlightInfo> infos, @NotNull Editor editor, @NotNull PsiFile file2) {
        List<IntentionAction> actions = LightQuickFixTestCase.getAvailableActions(editor, file2);
        ArrayList quickFixActions = new ArrayList();
        for (HighlightInfo highlightInfo : infos) {
            highlightInfo.findRegisteredQuickFix((descriptor, range) -> {
                IntentionAction action = descriptor.getAction();
                if (!actions.contains(action) && action.isAvailable(file2.getProject(), editor, file2)) {
                    quickFixActions.add(action);
                }
                return null;
            });
        }
        return ContainerUtil.concat(actions, quickFixActions);
    }

    public void checkHighlighting(Editor editor, boolean checkWarnings, boolean checkInfos) {
        this.setActiveEditor(editor);
        this.doDoTest(checkWarnings, checkInfos);
    }

    @NotNull
    public PsiClass createClass(@NotNull @org.intellij.lang.annotations.Language(value="JAVA") String text) throws IOException {
        return (PsiClass)WriteCommandAction.writeCommandAction((Project)this.getProject()).compute(() -> {
            File dir;
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.getProject());
            PsiJavaFile javaFile = (PsiJavaFile)factory.createFileFromText("a.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text);
            String qname = javaFile.getClasses()[0].getQualifiedName();
            DaemonAnalyzerTestCase.assertNotNull((Object)qname);
            VirtualFile[] files = ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots();
            if (files.length > 0) {
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)files[0]);
            } else {
                dir = this.createTempDirectory();
                VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
                this.addSourceContentToRoots(this.myModule, vDir);
            }
            File file2 = new File(dir, qname.replace('.', '/') + ".java");
            FileUtil.createIfDoesntExist((File)file2);
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(file2.getCanonicalPath().replace(File.separatorChar, '/'));
            DaemonAnalyzerTestCase.assertNotNull((Object)vFile);
            VfsUtil.saveText((VirtualFile)vFile, (String)text);
            PsiJavaFile psiFile = (PsiJavaFile)this.myPsiManager.findFile(vFile);
            DaemonAnalyzerTestCase.assertNotNull((Object)psiFile);
            return psiFile.getClasses()[0];
        });
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface CanChangeDocumentDuringHighlighting {
    }
}

