/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision;

import com.intellij.codeInsight.codeVision.CodeVisionHost;
import com.intellij.codeInsight.codeVision.CodeVisionInitializer;
import com.intellij.codeInsight.codeVision.CodeVisionProvider;
import com.intellij.codeInsight.codeVision.CodeVisionTestCase;
import com.intellij.codeInsight.codeVision.settings.CodeVisionSettings;
import com.intellij.codeInsight.codeVision.ui.model.CodeVisionListData;
import com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J1\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\bH\u0004\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/codeVision/CodeVisionTestCase;", "Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase;", "()V", "onlyCodeVisionHintsAllowed", "", "getOnlyCodeVisionHintsAllowed", "()Z", "dumpCodeVisionHints", "", "sourceText", "setUp", "", "testProviders", "expectedText", "fileName", "enabledProviderIds", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "CodeVisionInlayData", "intellij.platform.testFramework"})
public abstract class CodeVisionTestCase
extends InlayHintsProviderTestCase {
    @Override
    protected void setUp() {
        Registry.get((String)"editor.codeVision.new").setValue(true, this.getTestRootDisposable());
        super.setUp();
    }

    protected boolean getOnlyCodeVisionHintsAllowed() {
        return true;
    }

    protected final void testProviders(@NotNull String expectedText, @NotNull String fileName, String ... enabledProviderIds) {
        CodeVisionSettings settings = CodeVisionSettings.Companion.instance();
        CodeVisionHost codeVisionHost = CodeVisionInitializer.Companion.getInstance(this.getProject()).getCodeVisionHost();
        Iterable $this$forEach$iv = codeVisionHost.getProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeVisionProvider it = (CodeVisionProvider)element$iv;
            boolean bl = false;
            settings.setProviderEnabled(it.getId(), ArraysKt.contains((Object[])enabledProviderIds, (Object)it.getId()));
        }
        String sourceText = CodeVisionInlayData.Companion.getPattern().matcher(expectedText).replaceAll("");
        this.myFixture.configureByText(fileName, sourceText);
        Editor editor = this.myFixture.getEditor();
        this.getProject().putUserData(CodeVisionHost.Companion.isCodeVisionTestKey(), (Object)true);
        Iterable $this$forEach$iv2 = codeVisionHost.getProviders();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CodeVisionProvider it = (CodeVisionProvider)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)"vcs.code.vision") || !ArraysKt.contains((Object[])enabledProviderIds, (Object)it.getId())) continue;
            it.preparePreview(this.myFixture.getEditor(), this.myFixture.getFile());
        }
        this.myFixture.doHighlighting();
        codeVisionHost.calculateCodeVisionSync(editor, this.getTestRootDisposable());
        String actualText = this.dumpCodeVisionHints(sourceText);
        BasePlatformTestCase.assertEquals((String)expectedText, (String)actualText);
    }

    private final String dumpCodeVisionHints(String sourceText) {
        StringBuilder stringBuilder;
        Inlay it;
        Collection collection;
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Editor editor = this.myFixture.getEditor();
        InlayModel model = editor.getInlayModel();
        TextRange range = file2.getTextRange();
        List inlineElements = model.getInlineElementsInRange(range.getStartOffset(), range.getEndOffset());
        List afterLineElements = model.getAfterLineEndElementsInRange(range.getStartOffset(), range.getEndOffset());
        List blockElements = model.getBlockElementsInRange(range.getStartOffset(), range.getEndOffset());
        List inlays = new ArrayList();
        Iterable $this$mapTo$iv = inlineElements;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Inlay inlay = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            collection.add(new CodeVisionInlayData(it, InlayHintsProviderTestCase.InlayType.Inline));
        }
        $this$mapTo$iv = afterLineElements;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            collection.add(new CodeVisionInlayData(it, InlayHintsProviderTestCase.InlayType.Inline));
        }
        $this$mapTo$iv = blockElements;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            collection.add(new CodeVisionInlayData(it, InlayHintsProviderTestCase.InlayType.Block));
        }
        Document document = this.myFixture.getDocument(file2);
        List $this$sortBy$iv = inlays;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(document){
                final /* synthetic */ Document $document$inlined;
                {
                    this.$document$inlined = document;
                }

                public final int compare(T a, T b) {
                    CodeVisionInlayData it = (CodeVisionInlayData)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.effectiveOffset(this.$document$inlined));
                    it = (CodeVisionInlayData)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.effectiveOffset(this.$document$inlined)));
                }
            });
        }
        StringBuilder $this$dumpCodeVisionHints_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int currentOffset = 0;
        for (CodeVisionInlayData inlay : inlays) {
            if (!(inlay.getInlay().getRenderer() instanceof CodeVisionRenderer)) {
                if (!this.getOnlyCodeVisionHintsAllowed()) continue;
                throw new IllegalStateException("renderer not supported".toString());
            }
            int nextOffset = inlay.effectiveOffset(document);
            $this$dumpCodeVisionHints_u24lambda_u246.append(sourceText.subSequence(currentOffset, nextOffset));
            $this$dumpCodeVisionHints_u24lambda_u246.append(inlay);
            currentOffset = nextOffset;
        }
        String string = sourceText.substring(currentOffset, sourceText.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$dumpCodeVisionHints_u24lambda_u246.append(string);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u000fH\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInsight/codeVision/CodeVisionTestCase$CodeVisionInlayData;", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "type", "Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;", "(Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;)V", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "getType", "()Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;", "component1", "component2", "copy", "effectiveOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.platform.testFramework"})
    private static final class CodeVisionInlayData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Inlay<?> inlay;
        @NotNull
        private final InlayHintsProviderTestCase.InlayType type;
        @NotNull
        private static final Pattern pattern = Pattern.compile("<# block ([^#]*)#>(\r\n|\r|\n)|<#([^#]*)#>");

        public CodeVisionInlayData(@NotNull Inlay<?> inlay, @NotNull InlayHintsProviderTestCase.InlayType type) {
            this.inlay = inlay;
            this.type = type;
        }

        @NotNull
        public final Inlay<?> getInlay() {
            return this.inlay;
        }

        @NotNull
        public final InlayHintsProviderTestCase.InlayType getType() {
            return this.type;
        }

        public final int effectiveOffset(@NotNull Document document) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1 -> this.inlay.getOffset();
                case 2 -> {
                    int offset = this.inlay.getOffset();
                    int lineNumber = document.getLineNumber(offset);
                    yield document.getLineStartOffset(lineNumber);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public String toString() {
            Object object;
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append("<# ");
            if (this.type == InlayHintsProviderTestCase.InlayType.Block) {
                $this$toString_u24lambda_u240.append("block ");
            }
            $this$toString_u24lambda_u240.append((object = (CodeVisionListData)this.inlay.getUserData(CodeVisionListData.KEY)) != null && (object = object.getVisibleLens()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"   ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)toString.1.1.INSTANCE, (int)24, null) : null);
            $this$toString_u24lambda_u240.append(" #>");
            if (this.type == InlayHintsProviderTestCase.InlayType.Block) {
                $this$toString_u24lambda_u240.append('\n');
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final Inlay<?> component1() {
            return this.inlay;
        }

        @NotNull
        public final InlayHintsProviderTestCase.InlayType component2() {
            return this.type;
        }

        @NotNull
        public final CodeVisionInlayData copy(@NotNull Inlay<?> inlay, @NotNull InlayHintsProviderTestCase.InlayType type) {
            return new CodeVisionInlayData(inlay, type);
        }

        public static /* synthetic */ CodeVisionInlayData copy$default(CodeVisionInlayData codeVisionInlayData, Inlay inlay, InlayHintsProviderTestCase.InlayType inlayType, int n, Object object) {
            if ((n & 1) != 0) {
                inlay = codeVisionInlayData.inlay;
            }
            if ((n & 2) != 0) {
                inlayType = codeVisionInlayData.type;
            }
            return codeVisionInlayData.copy(inlay, inlayType);
        }

        public int hashCode() {
            int result2 = this.inlay.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CodeVisionInlayData)) {
                return false;
            }
            CodeVisionInlayData codeVisionInlayData = (CodeVisionInlayData)other;
            if (!Intrinsics.areEqual(this.inlay, codeVisionInlayData.inlay)) {
                return false;
            }
            return this.type == codeVisionInlayData.type;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/codeVision/CodeVisionTestCase$CodeVisionInlayData$Companion;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "intellij.platform.testFramework"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Pattern getPattern() {
                return pattern;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[InlayHintsProviderTestCase.InlayType.values().length];
                try {
                    nArray[InlayHintsProviderTestCase.InlayType.Inline.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InlayHintsProviderTestCase.InlayType.Block.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

