/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightTestData;
import com.intellij.codeInsight.EditorInfo;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.ProjectScope;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.JavaPsiTestCase;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCodeInsightTestCase
extends JavaPsiTestCase {
    protected Editor myEditor;

    protected Editor createEditor(@NotNull VirtualFile file2) {
        FileEditorManager instance2 = FileEditorManager.getInstance((Project)this.myProject);
        if (file2.getFileType().isBinary()) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor = instance2.openTextEditor(new OpenFileDescriptor(this.myProject, file2, 0), false);
        ((EditorImpl)editor).setCaretActive();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myProject != null) {
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myProject);
                for (VirtualFile openFile : editorManager.getOpenFiles()) {
                    editorManager.closeFile(openFile);
                }
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myEditor = null;
            super.tearDown();
        }
    }

    @Override
    @NotNull
    protected PsiTestData createData() {
        return new CodeInsightTestData();
    }

    protected void configureByFile(String filePath) throws Exception {
        this.configureByFile(filePath, null);
    }

    protected VirtualFile configureByFiles(@Nullable String projectRoot, String ... files) {
        if (files.length == 0) {
            return null;
        }
        VirtualFile[] vFiles = new VirtualFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            vFiles[i2] = this.findVirtualFile(files[i2]);
            if (vFiles[i2] == null) continue;
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(vFiles[i2], files[i2]);
        }
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        try {
            return this.configureByFiles(projectFile, vFiles);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected VirtualFile configureByFile(@NotNull String filePath, @Nullable String projectRoot) throws Exception {
        VirtualFile vFile = this.findVirtualFile(filePath);
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        return this.configureByFile(vFile, projectFile);
    }

    protected PsiFile configureByText(@NotNull FileType fileType, @NotNull String text) {
        return this.configureByText(fileType, text, null);
    }

    protected PsiFile configureByText(@NotNull FileType fileType, @NotNull String text, @Nullable String _extension) {
        try {
            String extension = _extension == null ? fileType.getDefaultExtension() : _extension;
            File dir = this.createTempDirectory();
            File tempFile = FileUtil.createTempFile((File)dir, (String)"tempFile", (String)("." + extension), (boolean)true);
            CodeInsightTestFixtureImpl.associateExtensionTemporarily(fileType, extension, this.getTestRootDisposable());
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
            assert (vFile != null);
            WriteAction.runAndWait(() -> {
                vFile.setCharset(StandardCharsets.UTF_8);
                VfsUtil.saveText((VirtualFile)vFile, (String)text);
            });
            VirtualFile vdir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
            PsiTestUtil.addSourceRoot(this.myModule, vdir);
            this.configureByExistingFile(vFile);
            JavaCodeInsightTestCase.assertEquals((Object)fileType, (Object)this.myFile.getVirtualFile().getFileType());
            return this.myFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureByFile(@NotNull VirtualFile vFile) throws IOException {
        this.configureByFile(vFile, null);
    }

    protected void configureByExistingFile(@NotNull VirtualFile virtualFile) {
        this.myFile = null;
        this.myEditor = null;
        Editor editor = this.createEditor(virtualFile);
        Document document = editor.getDocument();
        EditorInfo editorInfo = new EditorInfo(document.getText());
        String newFileText = editorInfo.getNewFileText();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!document.getText().equals(newFileText)) {
                document.setText((CharSequence)newFileText);
            }
            PsiFile file2 = this.myPsiManager.findFile(virtualFile);
            if (this.myFile == null) {
                this.myFile = file2;
            }
            if (this.myEditor == null) {
                this.myEditor = editor;
            }
            editorInfo.applyToEditor(editor);
        });
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
    }

    public VirtualFile doConfigureByFiles(@Nullable File rawProjectRoot, VirtualFile ... vFiles) throws IOException {
        return this.configureByFiles(rawProjectRoot, vFiles);
    }

    protected VirtualFile configureByFiles(@Nullable File rawProjectRoot, VirtualFile ... vFiles) throws IOException {
        this.myFile = null;
        this.myEditor = null;
        VirtualFile toDir = this.createVirtualDirectoryForContentFile();
        Map editorInfos = (Map)WriteAction.compute(() -> {
            try {
                boolean bl;
                Map<VirtualFile, EditorInfo> editorInfos1;
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
                ModifiableRootModel rootModel = rootManager.getModifiableModel();
                if (this.clearModelBeforeConfiguring()) {
                    rootModel.clear();
                }
                Object[] reversed = (VirtualFile[])ArrayUtil.reverseArray((Object[])vFiles);
                if (rawProjectRoot != null) {
                    FileUtil.copyDir((File)rawProjectRoot, (File)toDir.toNioPath().toFile());
                    File file2 = rawProjectRoot.getCanonicalFile();
                    VirtualFile aNull = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
                    editorInfos1 = this.copyFilesFillingEditorInfos(aNull, toDir, (String[])ContainerUtil.map2Array((Object[])reversed, String.class, s -> s.getPath().substring(file2.getPath().length())));
                    toDir.refresh(false, true);
                } else {
                    editorInfos1 = new LinkedHashMap<VirtualFile, EditorInfo>();
                    for (VirtualFile virtualFile : reversed) {
                        VirtualFile parent = virtualFile.getParent();
                        assert (parent.isDirectory()) : parent;
                        editorInfos1.putAll(this.copyFilesFillingEditorInfos(parent, toDir, virtualFile.getName()));
                    }
                }
                boolean bl2 = false;
                if (this.isAddDirToContentRoot()) {
                    ContentEntry contentEntry = rootModel.addContentEntry(toDir);
                    if (this.isAddDirToSource()) {
                        bl = true;
                        contentEntry.addSourceFolder(toDir, this.isAddDirToTests());
                    }
                }
                this.doCommitModel(rootModel);
                if (bl) {
                    this.sourceRootAdded(toDir);
                }
                return editorInfos1;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        });
        if (editorInfos != null) {
            this.openEditorsAndActivateLast(editorInfos);
        }
        return toDir;
    }

    @NotNull
    protected VirtualFile createVirtualDirectoryForContentFile() {
        return this.getTempDir().createVirtualDir();
    }

    protected boolean isAddDirToTests() {
        return false;
    }

    protected void doCommitModel(@NotNull ModifiableRootModel rootModel) {
        rootModel.commit();
    }

    protected void sourceRootAdded(VirtualFile dir) {
    }

    @NotNull
    protected Map<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(@NotNull String testDataFromDir, @NotNull VirtualFile toDir, String ... relativePaths) throws IOException {
        if (!((String)testDataFromDir).startsWith("/")) {
            testDataFromDir = "/" + (String)testDataFromDir;
        }
        return this.copyFilesFillingEditorInfos(LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getTestDataPath() + (String)testDataFromDir), toDir, relativePaths);
    }

    @NotNull
    protected Map<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(@NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, String ... relativePaths) throws IOException {
        LinkedHashMap<VirtualFile, EditorInfo> editorInfos = new LinkedHashMap<VirtualFile, EditorInfo>();
        ArrayList streamsToClose = new ArrayList();
        for (String relativePath : relativePaths) {
            relativePath = StringUtil.trimStart((String)relativePath, (String)"/");
            VirtualFile fromFile = fromDir.findFileByRelativePath(relativePath);
            JavaCodeInsightTestCase.assertNotNull((String)(fromDir.getPath() + "/" + relativePath), (Object)fromFile);
            VirtualFile toFile = toDir.findFileByRelativePath(relativePath);
            if (toFile == null) {
                File file2 = new File(toDir.getPath(), relativePath);
                FileUtil.createIfDoesntExist((File)file2);
                toFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
                JavaCodeInsightTestCase.assertNotNull((String)file2.getCanonicalPath(), (Object)toFile);
            }
            toFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)FileUtil.toSystemDependentName((String)fromFile.getPath()));
            editorInfos.put(toFile, this.copyContent(fromFile, toFile, streamsToClose));
        }
        for (int i2 = streamsToClose.size() - 1; i2 >= 0; --i2) {
            ((OutputStream)streamsToClose.get(i2)).close();
        }
        return editorInfos;
    }

    private EditorInfo copyContent(@NotNull VirtualFile from, @NotNull VirtualFile to, @NotNull List<? super OutputStream> streamsToClose) throws IOException {
        byte[] content = from.getFileType().isBinary() ? from.contentsToByteArray() : null;
        String fileText = from.getFileType().isBinary() ? null : StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)from));
        EditorInfo editorInfo = fileText == null ? null : new EditorInfo(fileText);
        String newFileText = fileText == null ? null : editorInfo.getNewFileText();
        this.doWrite(newFileText, to, content, streamsToClose);
        return editorInfo;
    }

    protected final void setActiveEditor(@NotNull Editor editor) {
        this.myEditor = editor;
        this.myFile = this.getPsiFile(editor.getDocument());
    }

    @NotNull
    protected List<Editor> openEditorsAndActivateLast(@NotNull Map<VirtualFile, EditorInfo> editorInfos) {
        List<Editor> list = this.openEditors(editorInfos);
        this.setActiveEditor(list.get(list.size() - 1));
        return list;
    }

    @NotNull
    protected final List<Editor> openEditors(@NotNull Map<VirtualFile, EditorInfo> editorInfos) {
        return ContainerUtil.map(editorInfos.keySet(), newVFile -> {
            EditorInfo editorInfo;
            PsiFile file2 = this.myPsiManager.findFile(newVFile);
            if (this.myFile == null) {
                this.myFile = file2;
            }
            Editor editor = this.createEditor((VirtualFile)newVFile);
            if (this.myEditor == null) {
                this.myEditor = editor;
            }
            if ((editorInfo = (EditorInfo)editorInfos.get(newVFile)) != null) {
                editorInfo.applyToEditor(editor);
            }
            return editor;
        });
    }

    private void doWrite(String newFileText, @NotNull VirtualFile newVFile, byte[] content, @NotNull List<? super OutputStream> streamsToClose) throws IOException {
        if (newFileText == null) {
            OutputStream outputStream = newVFile.getOutputStream((Object)this, -1L, -1L);
            outputStream.write(content);
            streamsToClose.add(outputStream);
        } else {
            JavaCodeInsightTestCase.setFileText(newVFile, newFileText);
        }
    }

    protected boolean isAddDirToContentRoot() {
        return true;
    }

    protected boolean isAddDirToSource() {
        return true;
    }

    protected VirtualFile configureByFile(@NotNull VirtualFile vFile, File projectRoot) throws IOException {
        return this.configureByFiles(projectRoot, vFile);
    }

    protected boolean clearModelBeforeConfiguring() {
        return false;
    }

    protected void setupCursorAndSelection(@NotNull Editor editor) {
        Document document = editor.getDocument();
        EditorTestUtil.CaretAndSelectionState caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
        EditorTestUtil.setCaretsAndSelection(editor, caretState);
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    @Override
    protected void configure(@NotNull String path, String dataName) throws Exception {
        int selectionEnd;
        super.configure(path, dataName);
        this.myEditor = this.createEditor(this.myFile.getVirtualFile());
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataBefore;
        LogicalPosition pos = new LogicalPosition(data.getLineNumber() - 1, data.getColumnNumber() - 1);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        int selectionStart = selectionEnd = this.myEditor.getCaretModel().getOffset();
        if (data.getSelectionStartColumnNumber() >= 0) {
            selectionStart = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionStartColumnNumber() - 1));
            selectionEnd = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionEndColumnNumber() - 1));
        }
        this.myEditor.getSelectionModel().setSelection(selectionStart, selectionEnd);
    }

    protected void checkResultByFile(@NotNull String filePath) throws Exception {
        this.checkResultByFile(filePath, false);
    }

    protected void checkResultByFile(@NotNull String filePath, boolean stripTrailingSpaces) throws Exception {
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
            String expectedText;
            PostprocessReformattingAspect.getInstance((Project)this.getProject()).doPostponedFormatting();
            if (stripTrailingSpaces) {
                ((DocumentImpl)this.myEditor.getDocument()).stripTrailingSpaces(this.getProject());
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            VirtualFile vFile = this.findVirtualFile(filePath);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(vFile, filePath);
            try {
                expectedText = VfsUtilCore.loadText((VirtualFile)vFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            expectedText = StringUtil.convertLineSeparators((String)expectedText);
            Document document = EditorFactory.getInstance().createDocument((CharSequence)expectedText);
            EditorTestUtil.CaretAndSelectionState caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            expectedText = document.getText();
            if (stripTrailingSpaces) {
                Document document1 = EditorFactory.getInstance().createDocument((CharSequence)expectedText);
                ((DocumentImpl)document1).stripTrailingSpaces(this.getProject());
                expectedText = document1.getText();
            }
            if (this.myEditor instanceof EditorWindow) {
                this.myEditor = ((EditorWindow)this.myEditor).getDelegate();
            }
            this.myFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.myEditor.getDocument());
            String actualText = StringUtil.convertLineSeparators((String)this.myFile.getText());
            if (!Objects.equals(expectedText, actualText)) {
                throw new FileComparisonFailure("Text mismatch in file " + filePath, expectedText, actualText, vFile.getPath());
            }
            EditorTestUtil.verifyCaretAndSelectionState(this.myEditor, caretState);
        });
    }

    @Override
    protected void checkResult(String dataName) throws Exception {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        super.checkResult(dataName);
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataAfter;
        if (data.getColumnNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":caretColumn"), (int)data.getColumnNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
        if (data.getLineNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":caretLine"), (int)data.getLineNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().line + 1));
        }
        int selectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
        LogicalPosition startPosition = this.myEditor.offsetToLogicalPosition(selectionStart);
        LogicalPosition endPosition = this.myEditor.offsetToLogicalPosition(selectionEnd);
        if (data.getSelectionStartColumnNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartColumn"), (int)data.getSelectionStartColumnNumber(), (int)(startPosition.column + 1));
        }
        if (data.getSelectionStartLineNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartLine"), (int)data.getSelectionStartLineNumber(), (int)(startPosition.line + 1));
        }
        if (data.getSelectionEndColumnNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndColumn"), (int)data.getSelectionEndColumnNumber(), (int)(endPosition.column + 1));
        }
        if (data.getSelectionEndLineNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndLine"), (int)data.getSelectionEndLineNumber(), (int)(endPosition.line + 1));
        }
    }

    @NotNull
    protected VirtualFile findVirtualFile(@NotNull String filePath) {
        String absolutePath = this.getTestDataPath() + filePath;
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{absolutePath});
        return VfsTestUtil.findFileByCaseSensitivePath(absolutePath);
    }

    @NotNull
    protected String getTestRoot() {
        return FileUtil.toSystemIndependentName((String)this.getTestDataPath());
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    protected void type(char c) {
        LightPlatformCodeInsightTestCase.type(c, this.getEditor(), this.getProject());
    }

    protected void undo() {
        UndoManager undoManager = UndoManager.getInstance((Project)this.myProject);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(this.getEditor());
        undoManager.undo((FileEditor)textEditor);
    }

    protected void caretLeft() {
        this.caretLeft(this.getEditor());
    }

    protected void caretLeft(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.executeAction("EditorLeft", editor, this.getProject());
    }

    protected void caretRight() {
        this.caretRight(this.getEditor());
    }

    protected void caretRight(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.executeAction("EditorRight", editor, this.getProject());
    }

    protected void caretUp() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUp", this.myEditor, this.getProject());
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine(this.myEditor, this.getProject());
    }

    protected void type(@NotNull String s) {
        for (char c : s.toCharArray()) {
            this.type(c);
        }
    }

    protected void backspace() {
        this.backspace(this.getEditor());
    }

    protected void backspace(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.backspace(editor, this.getProject());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW(this.getEditor(), this.getProject());
    }

    protected void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD(this.getEditor(), this.getProject());
    }

    protected void delete(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.delete(editor, this.getProject());
    }

    @NotNull
    protected PsiClass findClass(@NotNull String name) {
        PsiClass aClass = this.myJavaFacade.findClass(name, ProjectScope.getProjectScope((Project)this.getProject()));
        JavaCodeInsightTestCase.assertNotNull((String)("Class " + name + " not found"), (Object)aClass);
        return aClass;
    }

    @NotNull
    protected PsiPackage findPackage(@NotNull String name) {
        PsiPackage aPackage = this.myJavaFacade.findPackage(name);
        JavaCodeInsightTestCase.assertNotNull((String)("Package " + name + " not found"), (Object)aPackage);
        return aPackage;
    }

    protected void setLanguageLevel(@NotNull LanguageLevel level) {
        LanguageLevelProjectExtension.getInstance((Project)this.getProject()).setLanguageLevel(level);
    }
}

