/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.ClassFinder;
import com.intellij.GroupBasedTestClassFilter;
import com.intellij.PatternListTestClassFilter;
import com.intellij.TestAll;
import com.intellij.TestClassesFilter;
import com.intellij.idea.Bombed;
import com.intellij.idea.ExcludeFromTestDiscovery;
import com.intellij.idea.HardwareAgentRequired;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.RunFirst;
import com.intellij.testFramework.SelfSeedingTestCase;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestSorter;
import com.intellij.util.MathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseLoader {
    public static final String PERFORMANCE_TESTS_ONLY_FLAG = "idea.performance.tests";
    public static final String INCLUDE_PERFORMANCE_TESTS_FLAG = "idea.include.performance.tests";
    public static final String INCLUDE_UNCONVENTIONALLY_NAMED_TESTS_FLAG = "idea.include.unconventionally.named.tests";
    public static final String RUN_ONLY_AFFECTED_TEST_FLAG = "idea.run.only.affected.tests";
    public static final String TEST_RUNNERS_COUNT_FLAG = "idea.test.runners.count";
    public static final String TEST_RUNNER_INDEX_FLAG = "idea.test.runner.index";
    public static final String HARDWARE_AGENT_REQUIRED_FLAG = "idea.hardware.agent.required";
    public static final String VERBOSE_LOG_ENABLED_FLAG = "idea.test.log.verbose";
    public static final String FAIR_BUCKETING_FLAG = "idea.fair.bucketing";
    public static final String NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED_FLAG = "idea.enable.nastradamus.test.distributor";
    private static final boolean PERFORMANCE_TESTS_ONLY = Boolean.getBoolean("idea.performance.tests");
    private static final boolean INCLUDE_PERFORMANCE_TESTS = Boolean.getBoolean("idea.include.performance.tests");
    private static final boolean INCLUDE_UNCONVENTIONALLY_NAMED_TESTS = Boolean.getBoolean("idea.include.unconventionally.named.tests");
    private static final boolean RUN_ONLY_AFFECTED_TESTS = Boolean.getBoolean("idea.run.only.affected.tests");
    private static final boolean RUN_WITH_TEST_DISCOVERY = System.getProperty("test.discovery.listener") != null;
    private static final boolean HARDWARE_AGENT_REQUIRED = Boolean.getBoolean("idea.hardware.agent.required");
    public static final boolean IS_VERBOSE_LOG_ENABLED = Boolean.getBoolean("idea.test.log.verbose");
    private static final int TEST_RUNNERS_COUNT = Integer.parseInt(System.getProperty("idea.test.runners.count", "1"));
    private static final int TEST_RUNNER_INDEX = Integer.parseInt(System.getProperty("idea.test.runner.index", "0"));
    private static final AtomicInteger CYCLIC_BUCKET_COUNTER = new AtomicInteger(0);
    private static final HashMap<String, Integer> BUCKETS = new HashMap();
    private static final boolean IS_FAIR_BUCKETING = Boolean.getBoolean("idea.fair.bucketing");
    public static final boolean IS_NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED = Boolean.getBoolean("idea.enable.nastradamus.test.distributor");
    private static final String ALL_TESTS_GROUP = "ALL";
    private static final boolean REVERSE_ORDER = SystemProperties.getBooleanProperty((String)"intellij.build.test.reverse.order", (boolean)false);
    private static final String PLATFORM_LITE_FIXTURE_NAME = "com.intellij.testFramework.PlatformLiteFixture";
    private final HashSet<Class<?>> myClassSet = new HashSet();
    private final List<Throwable> myClassLoadingErrors = new ArrayList<Throwable>();
    private Class<?> myFirstTestClass;
    private Class<?> myLastTestClass;
    private final TestClassesFilter myTestClassesFilter;
    private final boolean myForceLoadPerformanceTests;
    private static TestClassesFilter ourFilter;

    public TestCaseLoader(String classFilterName) {
        this(classFilterName, false);
    }

    public TestCaseLoader(String classFilterName, boolean forceLoadPerformanceTests) {
        this.myForceLoadPerformanceTests = forceLoadPerformanceTests;
        TestClassesFilter testClassesFilter = TestCaseLoader.calcTestClassFilter(classFilterName);
        TestClassesFilter affectedTestsFilter = TestCaseLoader.affectedTestsFilter();
        if (affectedTestsFilter != null) {
            testClassesFilter = new TestClassesFilter.And(testClassesFilter, affectedTestsFilter);
        }
        this.myTestClassesFilter = testClassesFilter;
        System.out.println(this.myTestClassesFilter);
    }

    private static TestClassesFilter calcTestClassFilter(String classFilterName) {
        String patterns = TestCaseLoader.getTestPatterns();
        if (!StringUtil.isEmpty((String)patterns)) {
            System.out.println("Using patterns: [" + patterns + "]");
            return new PatternListTestClassFilter(StringUtil.split((String)patterns, (String)";"));
        }
        List<String> testGroupNames = TestCaseLoader.getTestGroups();
        if (testGroupNames.contains(ALL_TESTS_GROUP)) {
            System.out.println("Using all classes");
            return TestClassesFilter.ALL_CLASSES;
        }
        List<URL> groupingFileUrls = Collections.emptyList();
        if (!StringUtil.isEmpty((String)classFilterName)) {
            try {
                groupingFileUrls = Collections.list(TestCaseLoader.getClassLoader().getResources(classFilterName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List<URL> finalGroupingFileUrls = groupingFileUrls;
        TeamCityLogger.block("Loading test groups from ...", () -> System.out.println("Loading test groups from: " + finalGroupingFileUrls));
        MultiMap groups = MultiMap.createLinked();
        for (URL fileUrl : groupingFileUrls) {
            try (InputStreamReader reader = new InputStreamReader(fileUrl.openStream(), StandardCharsets.UTF_8);){
                GroupBasedTestClassFilter.readGroups(reader, (MultiMap<String, String>)groups);
            }
            catch (IOException e) {
                System.err.println("Failed to load test groups from " + fileUrl);
                e.printStackTrace();
            }
        }
        System.out.println("Using test groups: " + testGroupNames);
        HashSet<String> testGroupNameSet = new HashSet<String>(testGroupNames);
        testGroupNameSet.removeAll(groups.keySet());
        if (!testGroupNameSet.isEmpty()) {
            System.err.println("Unknown test groups: " + testGroupNameSet);
        }
        return new GroupBasedTestClassFilter((MultiMap<String, String>)groups, testGroupNames);
    }

    @Nullable
    private static String getTestPatterns() {
        return System.getProperty("intellij.build.test.patterns", System.getProperty("idea.test.patterns"));
    }

    @Nullable
    private static TestClassesFilter affectedTestsFilter() {
        if (RUN_ONLY_AFFECTED_TESTS) {
            System.out.println("Trying to load affected tests.");
            File affectedTestClasses = new File(System.getProperty("idea.home.path"), "discoveredTestClasses.txt");
            if (affectedTestClasses.exists()) {
                System.out.println("Loading file with affected classes " + affectedTestClasses.getAbsolutePath());
                try {
                    return new PatternListTestClassFilter(FileUtil.loadLines((File)affectedTestClasses));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        } else {
            System.out.println("Affected tests discovery is disabled. Will run with the standard test filter");
        }
        return null;
    }

    private static List<String> getTestGroups() {
        return StringUtil.split((String)System.getProperty("intellij.build.test.groups", System.getProperty("idea.test.group", "")).trim(), (String)";");
    }

    private boolean isClassTestCase(Class<?> testCaseClass, String moduleName) {
        if (this.shouldAddTestCase(testCaseClass, moduleName, true) && testCaseClass != this.myFirstTestClass && testCaseClass != this.myLastTestClass && TestFrameworkUtil.canRunTest(testCaseClass)) {
            if (IS_FAIR_BUCKETING && BUCKETS.isEmpty()) {
                return true;
            }
            if (SelfSeedingTestCase.class.isAssignableFrom(testCaseClass) || TestCaseLoader.matchesCurrentBucket(testCaseClass.getName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean matchesCurrentBucket(@NotNull String testIdentifier) {
        if (!IS_FAIR_BUCKETING) {
            return MathUtil.nonNegativeAbs((int)testIdentifier.hashCode()) % TEST_RUNNERS_COUNT == TEST_RUNNER_INDEX;
        }
        TestCaseLoader.initFairBuckets();
        return TestCaseLoader.matchesCurrentBucketFair(testIdentifier, TEST_RUNNERS_COUNT, TEST_RUNNER_INDEX);
    }

    public static synchronized void initFairBuckets() {
        if (!IS_FAIR_BUCKETING || !BUCKETS.isEmpty()) {
            return;
        }
        System.out.println("Fair bucketing initialization started ...");
        TestCaseLoader groupsTestCaseLoader = new TestCaseLoader("tests/testGroups.properties");
        for (Path classesRoot : TestAll.getClassRoots()) {
            ClassFinder classFinder = new ClassFinder(classesRoot.toFile(), "", INCLUDE_UNCONVENTIONALLY_NAMED_TESTS);
            Collection<String> foundTestClasses = classFinder.getClasses();
            groupsTestCaseLoader.loadTestCases(classesRoot.getFileName().toString(), foundTestClasses);
        }
        List<Class<?>> testCaseClasses = groupsTestCaseLoader.getClasses();
        System.out.printf("Fair bucketing initialization. Found %s classes to sieve%n", testCaseClasses.size());
        if (testCaseClasses.isEmpty()) {
            throw new IllegalStateException("Fair bucketing is enabled, but 0 test classes were found to sieve");
        }
        testCaseClasses.forEach(testCaseClass -> TestCaseLoader.matchesCurrentBucketFair(testCaseClass.getName(), TEST_RUNNERS_COUNT, TEST_RUNNER_INDEX));
        System.out.println("Fair bucketing initialization finished.");
    }

    public static boolean matchesCurrentBucketFair(@NotNull String testIdentifier, int testRunnerCount, int testRunnerIndex) {
        boolean isMatchedBucket;
        Integer value;
        if (!IS_FAIR_BUCKETING) {
            System.err.printf("Unexpected fair bucketing method call. Either property '%s' should be set, or invoking this method must not be performed%n", FAIR_BUCKETING_FLAG);
        }
        if ((value = BUCKETS.get(testIdentifier)) != null) {
            boolean isMatchedBucket2;
            boolean bl = isMatchedBucket2 = value == testRunnerIndex;
            if (IS_VERBOSE_LOG_ENABLED) {
                System.out.printf("Fair bucket match: test identifier `%s` (already sieved to buckets), runner count %s, runner index %s, is matching bucket %s%n", testIdentifier, testRunnerCount, testRunnerIndex, isMatchedBucket2);
            }
            return isMatchedBucket2;
        }
        BUCKETS.put(testIdentifier, CYCLIC_BUCKET_COUNTER.getAndIncrement());
        if (CYCLIC_BUCKET_COUNTER.get() == testRunnerCount) {
            CYCLIC_BUCKET_COUNTER.set(0);
        }
        boolean bl = isMatchedBucket = BUCKETS.get(testIdentifier) == testRunnerIndex;
        if (IS_VERBOSE_LOG_ENABLED) {
            System.out.printf("Fair bucket match: test identifier `%s`, runner count %s, runner index %s, is matching bucket %s%n", testIdentifier, testRunnerCount, testRunnerIndex, isMatchedBucket);
        }
        return isMatchedBucket;
    }

    public static boolean shouldBucketTests() {
        return TEST_RUNNERS_COUNT > 1;
    }

    void addFirstTest(Class<?> aClass) {
        assert (this.myFirstTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myFirstTestClass = aClass;
    }

    void addLastTest(Class<?> aClass) {
        assert (this.myLastTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myLastTestClass = aClass;
    }

    private boolean shouldAddTestCase(Class<?> testCaseClass, String moduleName, boolean checkForExclusion) {
        if ((testCaseClass.getModifiers() & 0x400) != 0) {
            return false;
        }
        if (checkForExclusion) {
            boolean isHardwareAgentRequired;
            if (this.shouldExcludeTestClass(moduleName, testCaseClass)) {
                return false;
            }
            boolean bl = isHardwareAgentRequired = TestCaseLoader.getAnnotationInHierarchy(testCaseClass, HardwareAgentRequired.class) != null;
            if (isHardwareAgentRequired != HARDWARE_AGENT_REQUIRED) {
                return false;
            }
        }
        if (TestCase.class.isAssignableFrom(testCaseClass) || TestSuite.class.isAssignableFrom(testCaseClass)) {
            return true;
        }
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", new Class[0]);
            if (Test.class.isAssignableFrom(suiteMethod.getReturnType()) && (suiteMethod.getModifiers() & 8) != 0) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return TestFrameworkUtil.isJUnit4TestClass(testCaseClass, false) || TestFrameworkUtil.isJUnit5TestClass(testCaseClass, false);
    }

    private boolean shouldExcludeTestClass(String moduleName, Class<?> testCaseClass) {
        if (!this.myForceLoadPerformanceTests && !TestCaseLoader.shouldIncludePerformanceTestCase(testCaseClass.getSimpleName())) {
            return true;
        }
        String className = testCaseClass.getName();
        return !this.myTestClassesFilter.matches(className, moduleName) || TestCaseLoader.isBombed(testCaseClass) || TestCaseLoader.isExcludeFromTestDiscovery(testCaseClass);
    }

    private static boolean isExcludeFromTestDiscovery(Class<?> c) {
        return RUN_WITH_TEST_DISCOVERY && TestCaseLoader.getAnnotationInHierarchy(c, ExcludeFromTestDiscovery.class) != null;
    }

    public static boolean isBombed(AnnotatedElement element) {
        Bombed bombedAnnotation = element.getAnnotation(Bombed.class);
        if (bombedAnnotation == null) {
            return false;
        }
        return !TestFrameworkUtil.bombExplodes(bombedAnnotation);
    }

    public void loadTestCases(String moduleName, Collection<String> classNamesIterator) {
        for (String className : classNamesIterator) {
            try {
                Class<?> candidateClass = Class.forName(className, false, TestCaseLoader.getClassLoader());
                if (!this.isClassTestCase(candidateClass, moduleName)) continue;
                this.myClassSet.add(candidateClass);
            }
            catch (Throwable e) {
                String message = "Cannot load class " + className + ": " + e.getMessage();
                System.err.println(message);
                this.myClassLoadingErrors.add(new Throwable(message, e));
            }
        }
    }

    protected static ClassLoader getClassLoader() {
        return TestCaseLoader.class.getClassLoader();
    }

    public List<Throwable> getClassLoadingErrors() {
        return this.myClassLoadingErrors;
    }

    public static int getRank(Class<?> aClass) {
        if (TestCaseLoader.runFirst(aClass)) {
            return 0;
        }
        if (TestCaseLoader.isPlatformLiteFixture(aClass)) {
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    private static boolean runFirst(Class<?> testClass) {
        return TestCaseLoader.getAnnotationInHierarchy(testClass, RunFirst.class) != null;
    }

    private static boolean isPlatformLiteFixture(Class<?> aClass) {
        while (aClass != null) {
            if (PLATFORM_LITE_FIXTURE_NAME.equals(aClass.getName())) {
                return true;
            }
            aClass = aClass.getSuperclass();
        }
        return false;
    }

    public int getClassesCount() {
        return this.myClassSet.size();
    }

    public List<Class<?>> getClasses() {
        ArrayList result2 = new ArrayList(this.myClassSet.size());
        if (this.myFirstTestClass != null) {
            result2.add(this.myFirstTestClass);
        }
        result2.addAll(TestCaseLoader.loadTestSorter().sorted(this.myClassSet.stream().toList(), TestCaseLoader::getRank));
        if (this.myLastTestClass != null) {
            result2.add(this.myLastTestClass);
        }
        if (IS_VERBOSE_LOG_ENABLED) {
            System.out.println("Sorted classes: ");
            result2.forEach(clazz -> System.out.println(clazz.getName()));
        }
        return result2;
    }

    private static TestSorter loadTestSorter() {
        String sorter = System.getProperty("intellij.build.test.sorter");
        if (sorter == null && IS_NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED) {
            sorter = "com.intellij.nastradamus.NastradamusTestCaseSorter";
        }
        if (sorter != null) {
            try {
                TestSorter testSorter = (TestSorter)Class.forName(sorter).getConstructor(new Class[0]).newInstance(new Object[0]);
                System.out.printf("Using test sorter from %s%n", sorter);
                return testSorter;
            }
            catch (Throwable t) {
                System.err.println("Sorter initialization failed: " + sorter);
                t.printStackTrace();
            }
        }
        System.out.println("Using default test sorter (natural order)");
        final Comparator classNameComparator = REVERSE_ORDER ? Comparator.reverseOrder() : Comparator.naturalOrder();
        return new TestSorter(){

            @Override
            @NotNull
            public List<Class<?>> sorted(@NotNull List<Class<?>> testClasses, @NotNull ToIntFunction<? super Class<?>> ranker) {
                return ContainerUtil.sorted(testClasses, Comparator.comparingInt(ranker).thenComparing(Class::getName, classNameComparator));
            }
        };
    }

    private void clearClasses() {
        this.myClassSet.clear();
        this.myFirstTestClass = null;
        this.myLastTestClass = null;
    }

    static boolean isPerformanceTestsRun() {
        return PERFORMANCE_TESTS_ONLY;
    }

    static boolean isIncludingPerformanceTestsRun() {
        return INCLUDE_PERFORMANCE_TESTS;
    }

    public static boolean shouldIncludePerformanceTestCase(String className) {
        return TestCaseLoader.isIncludingPerformanceTestsRun() || TestCaseLoader.isPerformanceTestsRun() || !TestCaseLoader.isPerformanceTest(null, className);
    }

    static boolean isPerformanceTest(String methodName, String className) {
        return TestFrameworkUtil.isPerformanceTest(methodName, className);
    }

    public static boolean isClassIncluded(String className) {
        if (!INCLUDE_UNCONVENTIONALLY_NAMED_TESTS && !className.endsWith("Test")) {
            return false;
        }
        if (ourFilter == null) {
            ourFilter = TestCaseLoader.calcTestClassFilter("tests/testGroups.properties");
        }
        return (TestCaseLoader.isIncludingPerformanceTestsRun() || TestCaseLoader.isPerformanceTestsRun() == TestCaseLoader.isPerformanceTest(null, className)) && ourFilter.matches(className) && TestCaseLoader.matchesCurrentBucket(className);
    }

    public void fillTestCases(String rootPackage, List<Path> classesRoots) {
        long t = System.nanoTime();
        for (Path classesRoot : classesRoots) {
            int count = this.getClassesCount();
            ClassFinder classFinder = new ClassFinder(classesRoot.toFile(), rootPackage, INCLUDE_UNCONVENTIONALLY_NAMED_TESTS);
            this.loadTestCases(classesRoot.getFileName().toString(), classFinder.getClasses());
            count = this.getClassesCount() - count;
            if (count <= 0) continue;
            System.out.println("Loaded " + count + " classes from class root " + classesRoot);
        }
        if (this.myClassSet.isEmpty()) {
            this.clearClasses();
        }
        t = (System.nanoTime() - t) / 1000000L;
        System.out.println("Loaded " + this.getClassesCount() + " classes in " + t + " ms");
        if (!RUN_ONLY_AFFECTED_TESTS && this.getClassesCount() == 0 && !Boolean.getBoolean("idea.tests.ignoreJUnit3EmptySuite")) {
            System.out.println("##teamcity[message text='Expected some junit 3 or junit 4 tests to be executed, but no test classes were found. If all your tests are junit 5 and you do not expect old junit tests to be executed, please pass vm option -Didea.tests.ignoreJUnit3EmptySuite=true' status='ERROR']");
        }
    }

    @Nullable
    public static <T extends Annotation> T getAnnotationInHierarchy(@NotNull Class<?> clazz, @NotNull Class<T> annotationClass) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            T annotation = current.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    static {
        TestCaseLoader.initFairBuckets();
    }
}

