/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.checkerframework.checker.initialization.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import kotlin.annotations.jvm.MigrationStatus;

// NOTE: This is an autogenerated file. Do not modify its contents. See annotation_template.java and
// gen_annotations.sh under platform/external/exoplayer/annotation-stubs.

// This is an annotation stub to avoid dependencies on annotations that aren't
// in the Android platform source tree.

@Target({
  ElementType.ANNOTATION_TYPE,
  ElementType.CONSTRUCTOR,
  ElementType.FIELD,
  ElementType.LOCAL_VARIABLE,
  ElementType.METHOD,
  ElementType.PACKAGE,
  ElementType.PARAMETER,
  ElementType.TYPE,
  ElementType.TYPE_PARAMETER,
  ElementType.TYPE_USE
})
@Retention(RetentionPolicy.SOURCE)
public @interface UnknownInitialization {

  // These fields maintain API compatibility with annotations that expect arguments.

  String[] value() default {};

  boolean result() default false;

  String[] expression() default {};

  MigrationStatus status() default MigrationStatus.IGNORE;
}
