// This file was generated by
//     //third_party/jni_zero/jni_zero.py
// For
//     android.net.connectivity.org.chromium.net.NetworkChangeNotifier

#ifndef android_net_connectivity_org_chromium_net_NetworkChangeNotifier_JNI
#define android_net_connectivity_org_chromium_net_NetworkChangeNotifier_JNI

#include <jni.h>

#include "third_party/jni_zero/jni_export.h"
#include "third_party/jni_zero/jni_zero_internal.h"

// Class Accessors
#ifndef android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz_defined
#define android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz_defined
inline jclass android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(JNIEnv* env) {
  static const char kClassName[] = "android.net.connectivity.org.chromium.net.NetworkChangeNotifier";
  static std::atomic<jclass> cached_class;
  return jni_zero::internal::LazyGetClass(env, kClassName, &cached_class);
}
#endif


namespace net {

// Java to native functions
JNI_ZERO_BOUNDARY_EXPORT void Java_android_net_connectivity_J_N_MqtHu5YI(
    JNIEnv* env,
    jclass jcaller,
    jlong nativePtr,
    jobject caller,
    jint newConnectionCost) {
  reinterpret_cast<NetworkChangeNotifierDelegateAndroid*>(nativePtr)->NotifyConnectionCostChanged(
      env,
      jni_zero::JavaParamRef<jobject>(env, caller),
      newConnectionCost);
}

JNI_ZERO_BOUNDARY_EXPORT void Java_android_net_connectivity_J_N_M4XZFCk3(
    JNIEnv* env,
    jclass jcaller,
    jlong nativePtr,
    jobject caller,
    jint subType) {
  reinterpret_cast<NetworkChangeNotifierDelegateAndroid*>(nativePtr)->NotifyConnectionSubtypeChanged(
      env,
      jni_zero::JavaParamRef<jobject>(env, caller),
      subType);
}

JNI_ZERO_BOUNDARY_EXPORT void Java_android_net_connectivity_J_N_MKvWH5iI(
    JNIEnv* env,
    jclass jcaller,
    jlong nativePtr,
    jobject caller,
    jint newConnectionType,
    jlong defaultNetId) {
  reinterpret_cast<NetworkChangeNotifierDelegateAndroid*>(nativePtr)->NotifyConnectionTypeChanged(
      env,
      jni_zero::JavaParamRef<jobject>(env, caller),
      newConnectionType,
      defaultNetId);
}

JNI_ZERO_BOUNDARY_EXPORT void Java_android_net_connectivity_J_N_MzCImUcu(
    JNIEnv* env,
    jclass jcaller,
    jlong nativePtr,
    jobject caller,
    jlong netId,
    jint connectionType) {
  reinterpret_cast<NetworkChangeNotifierDelegateAndroid*>(nativePtr)->NotifyOfNetworkConnect(
      env,
      jni_zero::JavaParamRef<jobject>(env, caller),
      netId,
      connectionType);
}

JNI_ZERO_BOUNDARY_EXPORT void Java_android_net_connectivity_J_N_MMe9mIyq(
    JNIEnv* env,
    jclass jcaller,
    jlong nativePtr,
    jobject caller,
    jlong netId) {
  reinterpret_cast<NetworkChangeNotifierDelegateAndroid*>(nativePtr)->NotifyOfNetworkDisconnect(
      env,
      jni_zero::JavaParamRef<jobject>(env, caller),
      netId);
}

JNI_ZERO_BOUNDARY_EXPORT void Java_android_net_connectivity_J_N_MOFU0znc(
    JNIEnv* env,
    jclass jcaller,
    jlong nativePtr,
    jobject caller,
    jlong netId) {
  reinterpret_cast<NetworkChangeNotifierDelegateAndroid*>(nativePtr)->NotifyOfNetworkSoonToDisconnect(
      env,
      jni_zero::JavaParamRef<jobject>(env, caller),
      netId);
}

JNI_ZERO_BOUNDARY_EXPORT void Java_android_net_connectivity_J_N_MmdqE1Yd(
    JNIEnv* env,
    jclass jcaller,
    jlong nativePtr,
    jobject caller,
    jobject activeNetIds) {
  reinterpret_cast<NetworkChangeNotifierDelegateAndroid*>(nativePtr)->NotifyPurgeActiveNetworkList(
      env,
      jni_zero::JavaParamRef<jobject>(env, caller),
      jni_zero::JavaParamRef<jlongArray>(env, static_cast<jlongArray>(activeNetIds)));
}


// Native to Java functions
static void Java_NetworkChangeNotifier_addNativeObserver(
    JNIEnv* env,
    const jni_zero::JavaRef<jobject>& obj,
    jlong nativeChangeNotifier) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, obj.obj(), clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_INSTANCE>(
      env,
      clazz,
      "addNativeObserver",
      "(J)V",
      &cached_method_id);
  env->CallVoidMethod(obj.obj(), call_context.method_id(), nativeChangeNotifier);
}

static void Java_NetworkChangeNotifier_fakeConnectionCostChanged(
    JNIEnv* env,
    JniIntWrapper connectionCost) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "fakeConnectionCostChanged",
      "(I)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), as_jint(connectionCost));
}

static void Java_NetworkChangeNotifier_fakeConnectionSubtypeChanged(
    JNIEnv* env,
    JniIntWrapper connectionSubtype) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "fakeConnectionSubtypeChanged",
      "(I)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), as_jint(connectionSubtype));
}

static void Java_NetworkChangeNotifier_fakeDefaultNetwork(
    JNIEnv* env,
    jlong netId,
    JniIntWrapper connectionType) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "fakeDefaultNetwork",
      "(JI)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), netId, as_jint(connectionType));
}

static void Java_NetworkChangeNotifier_fakeNetworkConnected(
    JNIEnv* env,
    jlong netId,
    JniIntWrapper connectionType) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "fakeNetworkConnected",
      "(JI)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), netId, as_jint(connectionType));
}

static void Java_NetworkChangeNotifier_fakeNetworkDisconnected(JNIEnv* env, jlong netId) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "fakeNetworkDisconnected",
      "(J)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), netId);
}

static void Java_NetworkChangeNotifier_fakeNetworkSoonToBeDisconnected(JNIEnv* env, jlong netId) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "fakeNetworkSoonToBeDisconnected",
      "(J)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), netId);
}

static void Java_NetworkChangeNotifier_fakePurgeActiveNetworkList(
    JNIEnv* env,
    const jni_zero::JavaRef<jlongArray>& activeNetIds) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "fakePurgeActiveNetworkList",
      "([J)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), activeNetIds.obj());
}

static void Java_NetworkChangeNotifier_forceConnectivityState(
    JNIEnv* env,
    jboolean networkAvailable) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "forceConnectivityState",
      "(Z)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), networkAvailable);
}

static jint Java_NetworkChangeNotifier_getCurrentConnectionCost(
    JNIEnv* env,
    const jni_zero::JavaRef<jobject>& obj) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, obj.obj(), clazz, 0);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_INSTANCE>(
      env,
      clazz,
      "getCurrentConnectionCost",
      "()I",
      &cached_method_id);
  auto _ret = env->CallIntMethod(obj.obj(), call_context.method_id());
  return _ret;
}

static jint Java_NetworkChangeNotifier_getCurrentConnectionSubtype(
    JNIEnv* env,
    const jni_zero::JavaRef<jobject>& obj) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, obj.obj(), clazz, 0);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_INSTANCE>(
      env,
      clazz,
      "getCurrentConnectionSubtype",
      "()I",
      &cached_method_id);
  auto _ret = env->CallIntMethod(obj.obj(), call_context.method_id());
  return _ret;
}

static jint Java_NetworkChangeNotifier_getCurrentConnectionType(
    JNIEnv* env,
    const jni_zero::JavaRef<jobject>& obj) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, obj.obj(), clazz, 0);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_INSTANCE>(
      env,
      clazz,
      "getCurrentConnectionType",
      "()I",
      &cached_method_id);
  auto _ret = env->CallIntMethod(obj.obj(), call_context.method_id());
  return _ret;
}

static jlong Java_NetworkChangeNotifier_getCurrentDefaultNetId(
    JNIEnv* env,
    const jni_zero::JavaRef<jobject>& obj) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, obj.obj(), clazz, 0);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_INSTANCE>(
      env,
      clazz,
      "getCurrentDefaultNetId",
      "()J",
      &cached_method_id);
  auto _ret = env->CallLongMethod(obj.obj(), call_context.method_id());
  return _ret;
}

static jni_zero::ScopedJavaLocalRef<jlongArray> Java_NetworkChangeNotifier_getCurrentNetworksAndTypes(
    JNIEnv* env,
    const jni_zero::JavaRef<jobject>& obj) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, obj.obj(), clazz, nullptr);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_INSTANCE>(
      env,
      clazz,
      "getCurrentNetworksAndTypes",
      "()[J",
      &cached_method_id);
  auto _ret = env->CallObjectMethod(obj.obj(), call_context.method_id());
  jlongArray _ret2 = static_cast<jlongArray>(_ret);
  return jni_zero::ScopedJavaLocalRef<jlongArray>(env, _ret2);
}

static jni_zero::ScopedJavaLocalRef<jobject> Java_NetworkChangeNotifier_init(JNIEnv* env) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz, nullptr);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "init",
      "()Landroid/net/connectivity/org/chromium/net/NetworkChangeNotifier;",
      &cached_method_id);
  auto _ret = env->CallStaticObjectMethod(clazz, call_context.method_id());
  return jni_zero::ScopedJavaLocalRef<jobject>(env, _ret);
}

static jboolean Java_NetworkChangeNotifier_registerNetworkCallbackFailed(
    JNIEnv* env,
    const jni_zero::JavaRef<jobject>& obj) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, obj.obj(), clazz, false);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_INSTANCE>(
      env,
      clazz,
      "registerNetworkCallbackFailed",
      "()Z",
      &cached_method_id);
  auto _ret = env->CallBooleanMethod(obj.obj(), call_context.method_id());
  return _ret;
}

static void Java_NetworkChangeNotifier_removeNativeObserver(
    JNIEnv* env,
    const jni_zero::JavaRef<jobject>& obj,
    jlong nativeChangeNotifier) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, obj.obj(), clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_INSTANCE>(
      env,
      clazz,
      "removeNativeObserver",
      "(J)V",
      &cached_method_id);
  env->CallVoidMethod(obj.obj(), call_context.method_id(), nativeChangeNotifier);
}

static void Java_NetworkChangeNotifier_setAutoDetectConnectivityState(
    JNIEnv* env,
    jboolean shouldAutoDetect) {
  static std::atomic<jmethodID> cached_method_id(nullptr);
  jclass clazz = android_net_connectivity_org_chromium_net_NetworkChangeNotifier_clazz(env);
  CHECK_CLAZZ(env, clazz, clazz);
  jni_zero::internal::JniJavaCallContext<true> call_context;
  call_context.Init<jni_zero::MethodID::TYPE_STATIC>(
      env,
      clazz,
      "setAutoDetectConnectivityState",
      "(Z)V",
      &cached_method_id);
  env->CallStaticVoidMethod(clazz, call_context.method_id(), shouldAutoDetect);
}



}  // namespace net

#endif  // android_net_connectivity_org_chromium_net_NetworkChangeNotifier_JNI
