/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * Contains the collections framework, some internationalization support classes,
 * a service loader, properties, random number generation, string parsing
 * and scanning classes, base64 encoding and decoding, a bit array, and
 * several miscellaneous utility classes. This package also contains
 * legacy collection classes and legacy date and time classes.
 *
 * <h2><a id="CollectionsFramework"></a>"Java Collections Framework"</h2>
 * <p>For an overview, API outline, and design rationale, please see:
 * <ul>
 *   <li><a href="https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/doc-files/coll-index.html">
 *          <b>Collections Framework Documentation</b></a>
 * </ul>
 *
 * <p>For a tutorial and programming guide with examples of use
 * of the collections framework, please see:
 * <ul>
 *   <li><a href="http://docs.oracle.com/javase/tutorial/collections/index.html">
 *          <b>Collections Framework Tutorial</b></a>
 * </ul>
 *
 * @since 1.0
 */
package java.util;
