// This file is autogenerated

package com.android.os.coregraphics;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;


/**
 * Utility class for logging statistics events.
 * @hide
 */
public final class HwuiStatsLog {
    // Constants for atom codes.

    /**
     * HardwareRendererEvent hardware_renderer_event<br>
     * Usage: StatsLog.write(StatsLog.HARDWARE_RENDERER_EVENT, int uid, long time_since_last_event_millis, int previous_color_mode);<br>
     */
    public static final int HARDWARE_RENDERER_EVENT = 946;

    /**
     * TextureViewEvent texture_view_event<br>
     * Usage: StatsLog.write(StatsLog.TEXTURE_VIEW_EVENT, int uid, long time_since_last_event_millis, int previous_dataspace);<br>
     */
    public static final int TEXTURE_VIEW_EVENT = 947;

    /**
     * ImageDecoded image_decoded<br>
     * Usage: StatsLog.write(StatsLog.IMAGE_DECODED, int uid, int color_space_transfer, boolean has_gainmap, int format);<br>
     */
    public static final int IMAGE_DECODED = 977;

    /**
     * GraphicsStats graphics_stats<br>
     * Usage: StatsLog.write(StatsLog.GRAPHICS_STATS, java.lang.String package_name, long version_code, long start_millis, long end_millis, int pipeline, int total_frames, int missed_vsync_count, int high_input_latency_count, int slow_ui_thread_count, int slow_bitmap_upload_count, int slow_draw_count, int missed_deadline_count, byte[] cpu_histogram, byte[] gpu_histogram, long version_ui_module, boolean is_today, int uid);<br>
     */
    public static final int GRAPHICS_STATS = 10068;

    // Constants for enum values.

    // Values for HardwareRendererEvent.previous_color_mode
    public static final int HARDWARE_RENDERER_EVENT__PREVIOUS_COLOR_MODE__DEFAULT = 0;
    public static final int HARDWARE_RENDERER_EVENT__PREVIOUS_COLOR_MODE__WIDE_COLOR = 1;
    public static final int HARDWARE_RENDERER_EVENT__PREVIOUS_COLOR_MODE__HDR = 2;

    // Values for ImageDecoded.color_space_transfer
    public static final int IMAGE_DECODED__COLOR_SPACE_TRANSFER__COLOR_SPACE_TRANSFER_UNKNOWN = 0;
    public static final int IMAGE_DECODED__COLOR_SPACE_TRANSFER__COLOR_SPACE_TRANSFER_SRGBISH = 1;
    public static final int IMAGE_DECODED__COLOR_SPACE_TRANSFER__COLOR_SPACE_TRANSFER_PQISH = 2;
    public static final int IMAGE_DECODED__COLOR_SPACE_TRANSFER__COLOR_SPACE_TRANSFER_HLGISH = 3;

    // Values for ImageDecoded.format
    public static final int IMAGE_DECODED__FORMAT__BITMAP_FORMAT_UNKNOWN = 0;
    public static final int IMAGE_DECODED__FORMAT__BITMAP_FORMAT_A_8 = 1;
    public static final int IMAGE_DECODED__FORMAT__BITMAP_FORMAT_RGB_565 = 2;
    public static final int IMAGE_DECODED__FORMAT__BITMAP_FORMAT_ARGB_8888 = 3;
    public static final int IMAGE_DECODED__FORMAT__BITMAP_FORMAT_RGBA_F16 = 4;
    public static final int IMAGE_DECODED__FORMAT__BITMAP_FORMAT_RGBA_1010102 = 5;

    // Values for GraphicsStats.pipeline
    public static final int GRAPHICS_STATS__PIPELINE__UNKNOWN = 0;
    public static final int GRAPHICS_STATS__PIPELINE__GL = 1;
    public static final int GRAPHICS_STATS__PIPELINE__VULKAN = 2;

    // Annotation constants.
    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;


    // Write methods
    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (IMAGE_DECODED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (HARDWARE_RENDERER_EVENT == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (TEXTURE_VIEW_EVENT == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, long arg2, long arg3, long arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, byte[] arg13, byte[] arg14, long arg15, boolean arg16, int arg17) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeByteArray(null == arg13 ? new byte[0] : arg13);
        builder.writeByteArray(null == arg14 ? new byte[0] : arg14);
        builder.writeLong(arg15);
        builder.writeBoolean(arg16);
        builder.writeInt(arg17);
        if (GRAPHICS_STATS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        return builder.build();
    }

}
