// This file is autogenerated

package com.android.net.module.util;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;
import androidx.annotation.RequiresApi;


/**
 * Utility class for logging statistics events.
 * @hide
 */
public final class FrameworkConnectivityStatsLog {
    // Constants for atom codes.

    /**
     * DefaultNetworkRematchInfo default_network_rematch_info<br>
     * Usage: StatsLog.write(StatsLog.DEFAULT_NETWORK_REMATCH_INFO, long session_id, byte[] old_network, byte[] new_network, int rematch_reason, int time_duration_on_old_network_sec);<br>
     */
    public static final int DEFAULT_NETWORK_REMATCH_INFO = 525;

    /**
     * NetworkSelectionPerformance network_selection_performance<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_SELECTION_PERFORMANCE, int number_of_network_requests, byte[] networks, int selection_computed_latency_milli, int selection_applied_latency_milli, int selection_issued_latency_milli);<br>
     */
    public static final int NETWORK_SELECTION_PERFORMANCE = 526;

    /**
     * NetworkNsdReported network_nsd_reported<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_NSD_REPORTED, boolean is_legacy, int client_id, int transaction_id, boolean is_known_service, int type, long event_duration_millisec, int query_result, int found_service_count, int found_callback_count, int lost_callback_count, int replied_requests_count, int sent_query_count, int sent_packet_count, int conflict_during_probing_count, int conflict_after_probing_count, int random_number);<br>
     */
    public static final int NETWORK_NSD_REPORTED = 527;

    /**
     * NetworkSliceSessionEnded network_slice_session_ended<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_SLICE_SESSION_ENDED, long slice_id, int enterprise_id, long rx_bytes, long tx_bytes, int number_of_apps, int slice_connection_duration_sec);<br>
     */
    public static final int NETWORK_SLICE_SESSION_ENDED = 558;

    /**
     * NetworkSliceDailyDataUsageReported network_slice_daily_data_usage_reported<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_SLICE_DAILY_DATA_USAGE_REPORTED, long slice_id, int enterprise_id, long rx_bytes, long tx_bytes, int number_of_apps, int slice_connection_duration_sec);<br>
     */
    public static final int NETWORK_SLICE_DAILY_DATA_USAGE_REPORTED = 559;

    /**
     * NetworkValidationFailureStatsDailyReported network_validation_failure_stats_daily_reported<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_VALIDATION_FAILURE_STATS_DAILY_REPORTED, byte[] validation_failure_stats_per_rat_signal_pair);<br>
     */
    public static final int NETWORK_VALIDATION_FAILURE_STATS_DAILY_REPORTED = 601;

    /**
     * DailykeepaliveInfoReported daily_keepalive_info_reported<br>
     * Usage: StatsLog.write(StatsLog.DAILY_KEEPALIVE_INFO_REPORTED, byte[] duration_per_num_of_keepalive, byte[] keepalive_lifetime_per_carrier, int keepalive_requests, int automatic_keepalive_requests, int distinct_user_count, int[] uid);<br>
     */
    public static final int DAILY_KEEPALIVE_INFO_REPORTED = 650;

    /**
     * NetworkRequestStateChanged network_request_state_changed<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_REQUEST_STATE_CHANGED, int uid, int transport_types, boolean net_capability_not_metered, boolean net_capability_internet, int state, int duration_ms);<br>
     */
    public static final int NETWORK_REQUEST_STATE_CHANGED = 779;

    /**
     * NetworkStatsRecorderFileOperated network_stats_recorder_file_operated<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_STATS_RECORDER_FILE_OPERATED, int operation_type, int recorder_prefix, int operation_index, int operation_latency_milli_seconds, int file_count, int total_file_size_bytes, int key_count, int uid_count, int total_history_bucket_count, int fast_data_input_state);<br>
     */
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED = 783;

    /**
     * TetheringActiveSessionsReported tethering_active_sessions_reported<br>
     * Usage: StatsLog.write(StatsLog.TETHERING_ACTIVE_SESSIONS_REPORTED, int last_max_session_count);<br>
     */
    public static final int TETHERING_ACTIVE_SESSIONS_REPORTED = 925;

    /**
     * CoreNetworkingTerribleErrorOccurred core_networking_terrible_error_occurred<br>
     * Usage: StatsLog.write(StatsLog.CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED, int error_type);<br>
     */
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED = 979;

    /**
     * NetworkBpfMapInfo network_bpf_map_info<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_BPF_MAP_INFO, int cookie_tag_map_size, int uid_owner_map_size, int uid_permission_map_size);<br>
     */
    public static final int NETWORK_BPF_MAP_INFO = 10161;

    /**
     * ConnectivityStateSample connectivity_state_sample<br>
     * Usage: StatsLog.write(StatsLog.CONNECTIVITY_STATE_SAMPLE, byte[] network_count_per_transports, byte[] connection_duration_per_transports, byte[] network_request_count, byte[] networks);<br>
     */
    public static final int CONNECTIVITY_STATE_SAMPLE = 10163;

    /**
     * NetworkSelectionRematchReasonsInfo network_selection_rematch_reasons_info<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_SELECTION_REMATCH_REASONS_INFO, byte[] number_of_rematches_per_reason);<br>
     */
    public static final int NETWORK_SELECTION_REMATCH_REASONS_INFO = 10164;

    /**
     * NetworkSliceRequestCountSample network_slice_request_count<br>
     * Usage: StatsLog.write(StatsLog.NETWORK_SLICE_REQUEST_COUNT, long slice_id, int enterprise_id, int request_count, int distinct_app_count);<br>
     */
    public static final int NETWORK_SLICE_REQUEST_COUNT = 10168;

    // Constants for enum values.

    // Values for DefaultNetworkRematchInfo.rematch_reason
    public static final int DEFAULT_NETWORK_REMATCH_INFO__REMATCH_REASON__RMR_UNKNOWN = 0;
    public static final int DEFAULT_NETWORK_REMATCH_INFO__REMATCH_REASON__RMR_NETWORK_CONNECTED = 1;
    public static final int DEFAULT_NETWORK_REMATCH_INFO__REMATCH_REASON__RMR_NETWORK_DISCONNECTED = 2;
    public static final int DEFAULT_NETWORK_REMATCH_INFO__REMATCH_REASON__RMR_NETWORK_UPDATED_CAPS = 3;
    public static final int DEFAULT_NETWORK_REMATCH_INFO__REMATCH_REASON__RMR_NETWORK_UPDATED_SCORE = 4;

    // Values for NetworkNsdReported.type
    public static final int NETWORK_NSD_REPORTED__TYPE__NET_UNKNOWN = 0;
    public static final int NETWORK_NSD_REPORTED__TYPE__NET_REGISTER = 1;
    public static final int NETWORK_NSD_REPORTED__TYPE__NET_DISCOVER = 2;
    public static final int NETWORK_NSD_REPORTED__TYPE__NET_RESOLVE = 3;
    public static final int NETWORK_NSD_REPORTED__TYPE__NET_SERVICE_INFO_CALLBACK = 4;

    // Values for NetworkNsdReported.query_result
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_UNKNOWN = 0;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_REGISTERED = 1;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_UNREGISTERED = 2;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_REGISTRATION_FAILED = 3;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_DISCOVERY_STARTED = 4;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_DISCOVERY_FAILED = 5;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_DISCOVERY_STOP = 6;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_RESOLVED = 7;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_RESOLUTION_FAILED = 8;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_RESOLUTION_STOP = 9;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_INFO_CALLBACK_REGISTERED = 10;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_INFO_CALLBACK_REGISTRATION_FAILED = 11;
    public static final int NETWORK_NSD_REPORTED__QUERY_RESULT__MQR_SERVICE_INFO_CALLBACK_UNREGISTERED = 12;

    // Values for NetworkRequestStateChanged.state
    public static final int NETWORK_REQUEST_STATE_CHANGED__STATE__NETWORK_REQUEST_STATE_UNKNOWN = 0;
    public static final int NETWORK_REQUEST_STATE_CHANGED__STATE__NETWORK_REQUEST_STATE_RECEIVED = 1;
    public static final int NETWORK_REQUEST_STATE_CHANGED__STATE__NETWORK_REQUEST_STATE_REMOVED = 2;

    // Values for NetworkStatsRecorderFileOperated.operation_type
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__OPERATION_TYPE__ROT_UNKNOWN = 0;
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__OPERATION_TYPE__ROT_READ = 1;
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__OPERATION_TYPE__ROT_WRITE = 2;

    // Values for NetworkStatsRecorderFileOperated.recorder_prefix
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__RECORDER_PREFIX__PREFIX_UNKNOWN = 0;
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__RECORDER_PREFIX__PREFIX_XT = 1;
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__RECORDER_PREFIX__PREFIX_UID = 2;
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__RECORDER_PREFIX__PREFIX_UIDTAG = 3;

    // Values for NetworkStatsRecorderFileOperated.fast_data_input_state
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__FAST_DATA_INPUT_STATE__FDIS_UNKNOWN = 0;
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__FAST_DATA_INPUT_STATE__FDIS_ENABLED = 1;
    public static final int NETWORK_STATS_RECORDER_FILE_OPERATED__FAST_DATA_INPUT_STATE__FDIS_DISABLED = 2;

    // Values for CoreNetworkingTerribleErrorOccurred.error_type
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_UNKNOWN = 0;
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_MESSAGE_QUEUED_BEFORE_CONNECT = 1;
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_DISALLOW_BYPASS_VPN_FOR_DELEGATE_UID_ENOENT = 2;
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_LEGACY_TETHER_WITH_TYPE_WIFI = 3;
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_LEGACY_TETHER_WITH_TYPE_WIFI_P2P = 4;
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_LEGACY_TETHER_WITH_TYPE_WIFI_SUCCESS = 5;
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_LEGACY_TETHER_WITH_TYPE_WIFI_P2P_SUCCESS = 6;
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_ENTITLEMENT_CREATE_CONTEXT_AS_USER_THROWS = 7;
    public static final int CORE_NETWORKING_TERRIBLE_ERROR_OCCURRED__ERROR_TYPE__TYPE_TETHER_WITH_PLACEHOLDER_REQUEST = 8;

    // Annotation constants.
    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;


    // Write methods
    public static void write(int code, byte[] arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    @android.annotation.SuppressLint("ObsoleteSdkInt")
    @RequiresApi(Build.VERSION_CODES.TIRAMISU)
    public static void write(int code, byte[] arg1, byte[] arg2, int arg3, int arg4, int arg5, int[] arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);
        builder.writeByteArray(null == arg2 ? new byte[0] : arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeIntArray(null == arg6 ? new int[0] : arg6);
        if (DAILY_KEEPALIVE_INFO_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1, int arg2, int arg3, boolean arg4, int arg5, long arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, int arg13, int arg14, int arg15, int arg16) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeLong(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, byte[] arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeByteArray(null == arg2 ? new byte[0] : arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, boolean arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (NETWORK_REQUEST_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, byte[] arg2, byte[] arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeByteArray(null == arg2 ? new byte[0] : arg2);
        builder.writeByteArray(null == arg3 ? new byte[0] : arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, int arg2, long arg3, long arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static StatsEvent buildStatsEvent(int code, byte[] arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, byte[] arg1, byte[] arg2, byte[] arg3, byte[] arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);
        builder.writeByteArray(null == arg2 ? new byte[0] : arg2);
        builder.writeByteArray(null == arg3 ? new byte[0] : arg3);
        builder.writeByteArray(null == arg4 ? new byte[0] : arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        return builder.build();
    }

}
