// This file is autogenerated

package com.android.internal.statsd;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;
import androidx.annotation.RequiresApi;


/**
 * Utility class for logging statistics events.
 * @hide
 */
public final class StatsdStatsLog {
    // Constants for atom codes.

    /**
     * IsolatedUidChanged isolated_uid_changed<br>
     * Usage: StatsLog.write(StatsLog.ISOLATED_UID_CHANGED, int parent_uid, int isolated_uid, int event);<br>
     */
    public static final int ISOLATED_UID_CHANGED = 43;

    /**
     * AnomalyDetected anomaly_detected<br>
     * Usage: StatsLog.write(StatsLog.ANOMALY_DETECTED, int config_uid, long config_id, long alert_id);<br>
     */
    public static final int ANOMALY_DETECTED = 46;

    /**
     * AppBreadcrumbReported app_breadcrumb_reported<br>
     * Usage: StatsLog.write(StatsLog.APP_BREADCRUMB_REPORTED, int uid, int label, int state);<br>
     */
    public static final int APP_BREADCRUMB_REPORTED = 47;

    /**
     * BinaryPushStateChanged binary_push_state_changed<br>
     * Usage: StatsLog.write(StatsLog.BINARY_PUSH_STATE_CHANGED, java.lang.String train_name, long train_version_code, boolean requires_staging, boolean rollback_enabled, boolean requires_low_latency_monitor, int state, byte[] experiment_ids, int user_id, int reason, boolean is_rollback);<br>
     */
    public static final int BINARY_PUSH_STATE_CHANGED = 102;

    /**
     * WatchdogRollbackOccurred watchdog_rollback_occurred<br>
     * Usage: StatsLog.write(StatsLog.WATCHDOG_ROLLBACK_OCCURRED, int rollback_type, java.lang.String package_name, int package_version_code, int rollback_reason, java.lang.String failing_package_name, byte[] experiment_ids);<br>
     */
    public static final int WATCHDOG_ROLLBACK_OCCURRED = 147;

    /**
     * StatsSocketLossReported stats_socket_loss_reported<br>
     * Usage: StatsLog.write(StatsLog.STATS_SOCKET_LOSS_REPORTED, int uid, long first_timestamp_nanos, long last_timestamp_nanos, int overflow_count, int[] errors, int[] tags, int[] counts);<br>
     */
    public static final int STATS_SOCKET_LOSS_REPORTED = 752;

    /**
     * CpuTimePerUidFreq cpu_time_per_uid_freq<br>
     * Usage: StatsLog.write(StatsLog.CPU_TIME_PER_UID_FREQ, int uid, int freq_index, long time_millis);<br>
     */
    public static final int CPU_TIME_PER_UID_FREQ = 10010;

    /**
     * BinderCalls binder_calls<br>
     * Usage: StatsLog.write(StatsLog.BINDER_CALLS, int uid, java.lang.String service_class_name, java.lang.String service_method_name, long call_count, long recorded_exception_count, long recorded_total_latency_micros, long recorded_max_latency_micros, long recorded_total_cpu_micros, long recorded_max_cpu_micros, long recorded_max_reply_size_bytes, long recorded_max_request_size_bytes, long recorded_call_count, boolean screen_interactive, int direct_caller_uid);<br>
     */
    public static final int BINDER_CALLS = 10022;

    /**
     * LooperStats looper_stats<br>
     * Usage: StatsLog.write(StatsLog.LOOPER_STATS, int uid, java.lang.String handler_class_name, java.lang.String looper_thread_name, java.lang.String message_name, long message_count, long exception_count, long recorded_message_count, long recorded_total_latency_micros, long recorded_total_cpu_micros, boolean screen_interactive, long recorded_max_cpu_micros, long recorded_max_latency_micros, long recorded_delay_message_count, long recorded_total_delay_millis, long recorded_max_delay_millis);<br>
     */
    public static final int LOOPER_STATS = 10024;

    /**
     * TrainInfo train_info<br>
     * Usage: StatsLog.write(StatsLog.TRAIN_INFO, long train_version_code, byte[] train_experiment_id, java.lang.String train_name, int status);<br>
     */
    public static final int TRAIN_INFO = 10051;

    // Constants for enum values.

    // Values for IsolatedUidChanged.event
    public static final int ISOLATED_UID_CHANGED__EVENT__REMOVED = 0;
    public static final int ISOLATED_UID_CHANGED__EVENT__CREATED = 1;

    // Values for AppBreadcrumbReported.state
    public static final int APP_BREADCRUMB_REPORTED__STATE__UNKNOWN = 0;
    public static final int APP_BREADCRUMB_REPORTED__STATE__UNSPECIFIED = 1;
    public static final int APP_BREADCRUMB_REPORTED__STATE__STOP = 2;
    public static final int APP_BREADCRUMB_REPORTED__STATE__START = 3;

    // Values for BinaryPushStateChanged.state
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_REQUESTED = 1;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_STARTED = 2;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_STAGED_NOT_READY = 3;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_STAGED_READY = 4;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_SUCCESS = 5;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_FAILURE = 6;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_CANCELLED = 7;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_REQUESTED = 8;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_INITIATED = 9;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_INITIATED_FAILURE = 10;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_STAGED = 11;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_STAGED_FAILURE = 12;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_BOOT_TRIGGERED = 13;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_BOOT_TRIGGERED_FAILURE = 14;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_SUCCESS = 15;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_FAILURE = 16;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_STAGED_CANCEL_REQUESTED = 17;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_STAGED_CANCEL_SUCCESS = 18;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALLER_ROLLBACK_STAGED_CANCEL_FAILURE = 19;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_STAGED_CANCEL_REQUESTED = 20;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_STAGED_CANCEL_SUCCESS = 21;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_STAGED_CANCEL_FAILURE = 22;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_FAILURE_DOWNLOAD = 23;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_FAILURE_STATE_MISMATCH = 24;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__INSTALL_FAILURE_COMMIT = 25;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__REBOOT_TRIGGERED = 26;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__REBOOT_NOT_REQUIRED = 27;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__SOFT_RESTART_ELIGIBLE = 28;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__NOTIFICATION_RESTART_ELIGIBLE = 29;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__NO_REBOOT_PROMOTION_STRATEGY_ELIGIBLE = 30;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__REBOOT_TRIGGER_FAILURE = 31;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__UNATTENDED_REBOOT_ELIGIBLE = 32;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__LSKF_PREPARATION_INITITATED = 33;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__LSKF_PREPARATION_SUCCESS = 34;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__LSKF_PREPARATION_FAILURE = 35;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__UNATTENDED_REBOOT_NOT_TRIGGERED = 36;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__SIM_PIN_PREPARATION_SUCCESS = 37;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__SIM_PIN_PREPARATION_FAILURE = 38;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__UNATTENDED_REBOOT_ABORT = 39;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__LSKF_PREPARATION_RETRY = 40;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__CHECKPOINT_NOT_SUPPORTED = 41;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__PENDING_REBOOT_MARKED = 42;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__PENDING_REBOOT_CANCELLED = 43;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__SIGNAL_READY_TO_REBOOT_RECEIVED = 44;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__SIGNAL_NOT_READY_TO_REBOOT_RECEIVED = 45;
    public static final int BINARY_PUSH_STATE_CHANGED__STATE__UNTRACKED_TRAIN_CANCELLED = 46;

    // Values for WatchdogRollbackOccurred.rollback_type
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__UNKNOWN = 0;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__ROLLBACK_INITIATE = 1;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__ROLLBACK_SUCCESS = 2;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__ROLLBACK_FAILURE = 3;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__ROLLBACK_BOOT_TRIGGERED = 4;

    // Values for WatchdogRollbackOccurred.rollback_reason
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_UNKNOWN = 0;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_NATIVE_CRASH = 1;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_EXPLICIT_HEALTH_CHECK = 2;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_APP_CRASH = 3;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_APP_NOT_RESPONDING = 4;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_NATIVE_CRASH_DURING_BOOT = 5;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_NETWORK_RELATED_CRASH = 6;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_BOOT_LOOPING = 7;

    // Values for StatsSocketLossReported.errors
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EDQUOT = -122;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EDESTADDRREQ = -89;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EPIPE = -32;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_ENOSPC = -28;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EFBIG = -27;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EINVAL = -22;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_ENODEV = -19;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EFAULT = -14;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EAGAIN = -11;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EBADF = -9;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EIO = -5;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EINTR = -4;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_ON_WRITE_EPERM = -1;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_UNKNOWN = 0;
    public static final int STATS_SOCKET_LOSS_REPORTED__ERRORS__SOCKET_LOSS_ERROR_QUEUE_OVERFLOW = 1;

    // Values for TrainInfo.status
    public static final int TRAIN_INFO__STATUS__UNKNOWN = 0;
    public static final int TRAIN_INFO__STATUS__INSTALL_REQUESTED = 1;
    public static final int TRAIN_INFO__STATUS__INSTALL_STARTED = 2;
    public static final int TRAIN_INFO__STATUS__INSTALL_STAGED_NOT_READY = 3;
    public static final int TRAIN_INFO__STATUS__INSTALL_STAGED_READY = 4;
    public static final int TRAIN_INFO__STATUS__INSTALL_SUCCESS = 5;
    public static final int TRAIN_INFO__STATUS__INSTALL_FAILURE = 6;
    public static final int TRAIN_INFO__STATUS__INSTALL_CANCELLED = 7;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_REQUESTED = 8;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_INITIATED = 9;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_INITIATED_FAILURE = 10;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_STAGED = 11;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_STAGED_FAILURE = 12;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_BOOT_TRIGGERED = 13;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_BOOT_TRIGGERED_FAILURE = 14;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_SUCCESS = 15;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_FAILURE = 16;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_STAGED_CANCEL_REQUESTED = 17;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_STAGED_CANCEL_SUCCESS = 18;
    public static final int TRAIN_INFO__STATUS__INSTALLER_ROLLBACK_STAGED_CANCEL_FAILURE = 19;
    public static final int TRAIN_INFO__STATUS__INSTALL_STAGED_CANCEL_REQUESTED = 20;
    public static final int TRAIN_INFO__STATUS__INSTALL_STAGED_CANCEL_SUCCESS = 21;
    public static final int TRAIN_INFO__STATUS__INSTALL_STAGED_CANCEL_FAILURE = 22;
    public static final int TRAIN_INFO__STATUS__INSTALL_FAILURE_DOWNLOAD = 23;
    public static final int TRAIN_INFO__STATUS__INSTALL_FAILURE_STATE_MISMATCH = 24;
    public static final int TRAIN_INFO__STATUS__INSTALL_FAILURE_COMMIT = 25;
    public static final int TRAIN_INFO__STATUS__REBOOT_TRIGGERED = 26;

    // Annotation constants.
    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;


    // Write methods
    public static void write(int code, int arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (ISOLATED_UID_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (APP_BREADCRUMB_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        if (ISOLATED_UID_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (ANOMALY_DETECTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeLong(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    @android.annotation.SuppressLint("ObsoleteSdkInt")
    @RequiresApi(Build.VERSION_CODES.TIRAMISU)
    public static void write(int code, int arg1, long arg2, long arg3, int arg4, int[] arg5, int[] arg6, int[] arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (STATS_SOCKET_LOSS_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeInt(arg4);
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);
        builder.writeIntArray(null == arg6 ? new int[0] : arg6);
        builder.writeIntArray(null == arg7 ? new int[0] : arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, int arg4, java.lang.String arg5, byte[] arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeString(arg5);
        builder.writeByteArray(null == arg6 ? new byte[0] : arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, long arg2, boolean arg3, boolean arg4, boolean arg5, int arg6, byte[] arg7, int arg8, int arg9, boolean arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeByteArray(null == arg7 ? new byte[0] : arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeBoolean(arg10);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (CPU_TIME_PER_UID_FREQ == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeLong(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, long arg11, long arg12, boolean arg13, int arg14) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (BINDER_CALLS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeBoolean(arg13);
        builder.writeInt(arg14);
        if (BINDER_CALLS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, long arg5, long arg6, long arg7, long arg8, long arg9, boolean arg10, long arg11, long arg12, long arg13, long arg14, long arg15) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (LOOPER_STATS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeBoolean(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeLong(arg13);
        builder.writeLong(arg14);
        builder.writeLong(arg15);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, byte[] arg2, java.lang.String arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeByteArray(null == arg2 ? new byte[0] : arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);

        return builder.build();
    }

}
