// This file is autogenerated

package com.android.internal.net.ipsec.ike.utils;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;


/**
 * Utility class for logging statistics events.
 * @hide
 */
public final class IkeMetricsInterface {
    // Constants for atom codes.

    /**
     * IkeSessionTerminated ike_session_terminated<br>
     * Usage: StatsLog.write(StatsLog.IKE_SESSION_TERMINATED, int ike_caller, int session_type, int ike_state, int ike_error);<br>
     */
    public static final int IKE_SESSION_TERMINATED = 678;

    /**
     * IkeLivenessCheckSessionValidated ike_liveness_check_session_validated<br>
     * Usage: StatsLog.write(StatsLog.IKE_LIVENESS_CHECK_SESSION_VALIDATED, int ike_caller, int ike_task, int ike_underlying_network_type, int elapsed_time_in_millis, int number_of_on_going_status, boolean result_success, int ike_state);<br>
     */
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED = 760;

    /**
     * NegotiatedSecurityAssociation negotiated_security_association<br>
     * Usage: StatsLog.write(StatsLog.NEGOTIATED_SECURITY_ASSOCIATION, int ike_caller, int session_type, int ike_state, int dh_group, int encryption_algorithm, int key_length, int integrity_algorithm, int prf_algorithms, int ike_error);<br>
     */
    public static final int NEGOTIATED_SECURITY_ASSOCIATION = 821;

    // Constants for enum values.

    // Values for IkeSessionTerminated.ike_caller
    public static final int IKE_SESSION_TERMINATED__IKE_CALLER__CALLER_UNKNOWN = 0;
    public static final int IKE_SESSION_TERMINATED__IKE_CALLER__CALLER_IWLAN = 1;
    public static final int IKE_SESSION_TERMINATED__IKE_CALLER__CALLER_VCN = 2;
    public static final int IKE_SESSION_TERMINATED__IKE_CALLER__CALLER_VPN = 3;

    // Values for IkeSessionTerminated.session_type
    public static final int IKE_SESSION_TERMINATED__SESSION_TYPE__SESSION_UNKNOWN = 0;
    public static final int IKE_SESSION_TERMINATED__SESSION_TYPE__SESSION_IKE = 1;
    public static final int IKE_SESSION_TERMINATED__SESSION_TYPE__SESSION_CHILD = 2;

    // Values for IkeSessionTerminated.ike_state
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_UNKNOWN = 0;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_KILL = 1;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_INITIAL = 2;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_INIT = 3;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH = 4;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH_IN_EAP = 5;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH_POST_EAP = 6;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_IDLE = 7;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_CHILD_PROCEDURE_ONGOING = 8;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_RECEIVING = 9;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_REKEY_LOCAL_CREATE = 10;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_CREATE = 11;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_DELETE_REMOTE_DELETE = 12;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_DELETE = 13;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_REMOTE_DELETE = 14;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_REKEY_LOCAL_DELETE = 15;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_REKEY_REMOTE_DELETE = 16;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_DELETE_LOCAL_DELETE = 17;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_DPD_LOCAL_INFO = 18;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_MOBIKE_LOCAL_INFO = 19;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_IKE_DPD_ON_DEMAND_LOCAL_INFO = 20;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_KILL = 101;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_INITIAL = 102;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_CREATE_LOCAL_CREATE = 103;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_IDLE = 104;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_IDLE_WITH_DEFERRED_REQUEST = 105;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_CLOSE_AND_AWAIT_RESPONSE = 106;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_DELETE_LOCAL_DELETE = 107;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_DELETE_REMOTE_DELETE = 108;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_REKEY_LOCAL_CREATE = 109;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_MOBIKE_REKEY_LOCAL_CREATE = 110;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_REKEY_REMOTE_CREATE = 111;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_REKEY_LOCAL_DELETE = 112;
    public static final int IKE_SESSION_TERMINATED__IKE_STATE__STATE_CHILD_REKEY_REMOTE_DELETE = 113;

    // Values for IkeSessionTerminated.ike_error
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_NONE = 0;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_RESERVED_00004022 = 16418;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_INTERNAL = 65536;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_NETWORK_LOST = 131072;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_IO_GENERAL = 196608;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_IO_TIMEOUT = 196609;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_IO_DNS_FAILURE = 196610;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_UNKNOWN = 262144;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_UNSUPPORTED_CRITICAL_PAYLOAD = 262145;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_INVALID_IKE_SPI = 262148;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_INVALID_MAJOR_VERSION = 262149;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_INVALID_SYNTAX = 262151;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_INVALID_MESSAGE_ID = 262153;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_NO_PROPOSAL_CHOSEN = 262158;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_INVALID_KE_PAYLOAD = 262161;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_AUTHENTICATION_FAILED = 262168;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_SINGLE_PAIR_REQUIRED = 262178;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_NO_ADDITIONAL_SAS = 262179;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_INTERNAL_ADDRESS_FAILURE = 262180;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_FAILED_CP_REQUIRED = 262181;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_TS_UNACCEPTABLE = 262182;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_INVALID_SELECTORS = 262183;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_TEMPORARY_FAILURE = 262187;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_PROTOCOL_CHILD_SA_NOT_FOUND = 262188;
    public static final int IKE_SESSION_TERMINATED__IKE_ERROR__ERROR_UNKNOWN = 268435455;

    // Values for IkeLivenessCheckSessionValidated.ike_caller
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_CALLER__CALLER_UNKNOWN = 0;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_CALLER__CALLER_IWLAN = 1;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_CALLER__CALLER_VCN = 2;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_CALLER__CALLER_VPN = 3;

    // Values for IkeLivenessCheckSessionValidated.ike_task
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_TASK__IKE_TASK_UNSPECIFIED = 0;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_TASK__IKE_TASK_ON_DEMAND_DPD = 1;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_TASK__IKE_TASK_UNKNOWN_BUSY = 2;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_TASK__IKE_TASK_PERIODIC_DPD = 3;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_TASK__IKE_TASK_REKEY_IKE = 4;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_TASK__IKE_TASK_REKEY_CHILD = 5;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_TASK__IKE_TASK_MOBIKE = 6;

    // Values for IkeLivenessCheckSessionValidated.ike_underlying_network_type
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_UNDERLYING_NETWORK_TYPE__NETWORK_UNSPECIFIED = 0;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_UNDERLYING_NETWORK_TYPE__NETWORK_WIFI = 1;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_UNDERLYING_NETWORK_TYPE__NETWORK_CELLULAR = 2;

    // Values for IkeLivenessCheckSessionValidated.ike_state
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_UNKNOWN = 0;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_KILL = 1;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_INITIAL = 2;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_INIT = 3;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH = 4;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH_IN_EAP = 5;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH_POST_EAP = 6;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_IDLE = 7;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_CHILD_PROCEDURE_ONGOING = 8;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_RECEIVING = 9;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_REKEY_LOCAL_CREATE = 10;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_CREATE = 11;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_DELETE_REMOTE_DELETE = 12;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_DELETE = 13;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_REMOTE_DELETE = 14;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_REKEY_LOCAL_DELETE = 15;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_REKEY_REMOTE_DELETE = 16;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_DELETE_LOCAL_DELETE = 17;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_DPD_LOCAL_INFO = 18;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_MOBIKE_LOCAL_INFO = 19;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_IKE_DPD_ON_DEMAND_LOCAL_INFO = 20;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_KILL = 101;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_INITIAL = 102;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_CREATE_LOCAL_CREATE = 103;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_IDLE = 104;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_IDLE_WITH_DEFERRED_REQUEST = 105;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_CLOSE_AND_AWAIT_RESPONSE = 106;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_DELETE_LOCAL_DELETE = 107;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_DELETE_REMOTE_DELETE = 108;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_REKEY_LOCAL_CREATE = 109;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_MOBIKE_REKEY_LOCAL_CREATE = 110;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_REKEY_REMOTE_CREATE = 111;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_REKEY_LOCAL_DELETE = 112;
    public static final int IKE_LIVENESS_CHECK_SESSION_VALIDATED__IKE_STATE__STATE_CHILD_REKEY_REMOTE_DELETE = 113;

    // Values for NegotiatedSecurityAssociation.ike_caller
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_CALLER__CALLER_UNKNOWN = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_CALLER__CALLER_IWLAN = 1;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_CALLER__CALLER_VCN = 2;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_CALLER__CALLER_VPN = 3;

    // Values for NegotiatedSecurityAssociation.session_type
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__SESSION_TYPE__SESSION_UNKNOWN = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__SESSION_TYPE__SESSION_IKE = 1;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__SESSION_TYPE__SESSION_CHILD = 2;

    // Values for NegotiatedSecurityAssociation.ike_state
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_UNKNOWN = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_KILL = 1;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_INITIAL = 2;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_INIT = 3;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH = 4;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH_IN_EAP = 5;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_CREATE_LOCAL_IKE_AUTH_POST_EAP = 6;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_IDLE = 7;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_CHILD_PROCEDURE_ONGOING = 8;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_RECEIVING = 9;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_REKEY_LOCAL_CREATE = 10;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_CREATE = 11;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_DELETE_REMOTE_DELETE = 12;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_DELETE = 13;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_SIMULTANEOUS_REKEY_REMOTE_DELETE = 14;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_REKEY_LOCAL_DELETE = 15;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_REKEY_REMOTE_DELETE = 16;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_DELETE_LOCAL_DELETE = 17;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_DPD_LOCAL_INFO = 18;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_MOBIKE_LOCAL_INFO = 19;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_IKE_DPD_ON_DEMAND_LOCAL_INFO = 20;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_KILL = 101;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_INITIAL = 102;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_CREATE_LOCAL_CREATE = 103;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_IDLE = 104;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_IDLE_WITH_DEFERRED_REQUEST = 105;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_CLOSE_AND_AWAIT_RESPONSE = 106;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_DELETE_LOCAL_DELETE = 107;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_DELETE_REMOTE_DELETE = 108;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_REKEY_LOCAL_CREATE = 109;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_MOBIKE_REKEY_LOCAL_CREATE = 110;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_REKEY_REMOTE_CREATE = 111;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_REKEY_LOCAL_DELETE = 112;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_STATE__STATE_CHILD_REKEY_REMOTE_DELETE = 113;

    // Values for NegotiatedSecurityAssociation.dh_group
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__DH_GROUP__DH_GROUP_UNSPECIFIED = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__DH_GROUP__DH_GROUP_NONE = 1;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__DH_GROUP__DH_GROUP_1024_BIT_MODP = 2;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__DH_GROUP__DH_GROUP_1536_BIT_MODP = 5;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__DH_GROUP__DH_GROUP_2048_BIT_MODP = 14;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__DH_GROUP__DH_GROUP_3072_BIT_MODP = 15;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__DH_GROUP__DH_GROUP_4096_BIT_MODP = 16;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__DH_GROUP__DH_GROUP_CURVE_25519 = 31;

    // Values for NegotiatedSecurityAssociation.encryption_algorithm
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__ENCRYPTION_ALGORITHM__ENCRYPTION_ALGORITHM_UNSPECIFIED = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__ENCRYPTION_ALGORITHM__ENCRYPTION_ALGORITHM_3DES = 3;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__ENCRYPTION_ALGORITHM__ENCRYPTION_ALGORITHM_AES_CBC = 12;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__ENCRYPTION_ALGORITHM__ENCRYPTION_ALGORITHM_AES_CTR = 13;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__ENCRYPTION_ALGORITHM__ENCRYPTION_ALGORITHM_AES_GCM_8 = 18;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__ENCRYPTION_ALGORITHM__ENCRYPTION_ALGORITHM_AES_GCM_12 = 19;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__ENCRYPTION_ALGORITHM__ENCRYPTION_ALGORITHM_AES_GCM_16 = 20;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__ENCRYPTION_ALGORITHM__ENCRYPTION_ALGORITHM_CHACHA20_POLY1305 = 28;

    // Values for NegotiatedSecurityAssociation.key_length
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__KEY_LENGTH__KEY_LEN_UNSPECIFIED = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__KEY_LENGTH__KEY_LEN_UNUSED = 1;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__KEY_LENGTH__KEY_LEN_AES_128 = 128;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__KEY_LENGTH__KEY_LEN_AES_192 = 192;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__KEY_LENGTH__KEY_LEN_AES_256 = 256;

    // Values for NegotiatedSecurityAssociation.integrity_algorithm
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__INTEGRITY_ALGORITHM__INTEGRITY_ALGORITHM_UNSPECIFIED = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__INTEGRITY_ALGORITHM__INTEGRITY_ALGORITHM_NONE = 1;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__INTEGRITY_ALGORITHM__INTEGRITY_ALGORITHM_HMAC_SHA1_96 = 2;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__INTEGRITY_ALGORITHM__INTEGRITY_ALGORITHM_AES_XCBC_96 = 5;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__INTEGRITY_ALGORITHM__INTEGRITY_ALGORITHM_AES_CMAC_96 = 8;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__INTEGRITY_ALGORITHM__INTEGRITY_ALGORITHM_HMAC_SHA2_256_128 = 12;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__INTEGRITY_ALGORITHM__INTEGRITY_ALGORITHM_HMAC_SHA2_384_192 = 13;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__INTEGRITY_ALGORITHM__INTEGRITY_ALGORITHM_HMAC_SHA2_512_256 = 14;

    // Values for NegotiatedSecurityAssociation.prf_algorithms
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__PRF_ALGORITHMS__PSEUDORANDOM_FUNCTION_UNSPECIFIED = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__PRF_ALGORITHMS__PSEUDORANDOM_FUNCTION_HMAC_SHA1 = 2;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__PRF_ALGORITHMS__PSEUDORANDOM_FUNCTION_AES128_XCBC = 4;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__PRF_ALGORITHMS__PSEUDORANDOM_FUNCTION_SHA2_256 = 5;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__PRF_ALGORITHMS__PSEUDORANDOM_FUNCTION_SHA2_384 = 6;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__PRF_ALGORITHMS__PSEUDORANDOM_FUNCTION_SHA2_512 = 7;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__PRF_ALGORITHMS__PSEUDORANDOM_FUNCTION_AES128_CMAC = 8;

    // Values for NegotiatedSecurityAssociation.ike_error
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_NONE = 0;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_RESERVED_00004022 = 16418;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_INTERNAL = 65536;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_NETWORK_LOST = 131072;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_IO_GENERAL = 196608;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_IO_TIMEOUT = 196609;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_IO_DNS_FAILURE = 196610;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_UNKNOWN = 262144;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_UNSUPPORTED_CRITICAL_PAYLOAD = 262145;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_INVALID_IKE_SPI = 262148;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_INVALID_MAJOR_VERSION = 262149;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_INVALID_SYNTAX = 262151;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_INVALID_MESSAGE_ID = 262153;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_NO_PROPOSAL_CHOSEN = 262158;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_INVALID_KE_PAYLOAD = 262161;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_AUTHENTICATION_FAILED = 262168;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_SINGLE_PAIR_REQUIRED = 262178;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_NO_ADDITIONAL_SAS = 262179;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_INTERNAL_ADDRESS_FAILURE = 262180;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_FAILED_CP_REQUIRED = 262181;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_TS_UNACCEPTABLE = 262182;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_INVALID_SELECTORS = 262183;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_TEMPORARY_FAILURE = 262187;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_PROTOCOL_CHILD_SA_NOT_FOUND = 262188;
    public static final int NEGOTIATED_SECURITY_ASSOCIATION__IKE_ERROR__ERROR_UNKNOWN = 268435455;

    // Annotation constants.
    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;


    // Write methods
    public static void write(int code, int arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

}
