package android.provider;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.List;

/**
 * Contains the list of flags that can be written with WRITE_ALLOWLISTED_DEVICE_CONFIG.
 * <p>
 * A security review is required for any flag that's added to this list. To add to the
 * list, create a change and tag the OWNER. In the change description, include a
 * description of the flag's functionality, and a justification for why it needs to be
 * allowlisted.
 */
@RavenwoodKeepWholeClass
final class WritableFlags {
    public static final Set<String> ALLOWLIST =
            new HashSet<String>(Arrays.asList(
                "a.a.a/b.b",
                "a.a.a/b.b.b",
                "accessibility/enable_font_scaling_qs_tile",
                "accessibility/enable_magnifier_thumbnail",
                "activity_manager/am_block_activity_starts_after_home",
                "activity_manager/android_app_data_isolation_min_sdk",
                "activity_manager/background_activity_starts_package_names_whitelist",
                "activity_manager/bg_battery_exemption_enabled",
                "activity_manager/bg_abusive_notification_minimal_interval",
                "activity_manager/bg_auto_restricted_bucket_on_bg_restricted",
                "activity_manager/bg_bind_svc_monitor_enabled",
                "activity_manager/bg_bind_svc_window",
                "activity_manager/bg_broadcast_monitor_enabled",
                "activity_manager/bg_broadcast_window",
                "activity_manager/bg_current_drain_auto_restrict_abusive_apps_enabled",
                "activity_manager/bg_current_drain_decouple_thresholds",
                "activity_manager/bg_current_drain_event_duration_based_threshold_enabled",
                "activity_manager/bg_current_drain_exempted_types",
                "activity_manager/bg_current_drain_high_threshold_by_bg_location",
                "activity_manager/bg_current_drain_high_threshold_to_bg_restricted",
                "activity_manager/bg_current_drain_high_threshold_to_restricted_bucket",
                "activity_manager/bg_current_drain_interaction_grace_period",
                "activity_manager/bg_current_drain_location_min_duration",
                "activity_manager/bg_current_drain_media_playback_min_duration",
                "activity_manager/bg_current_drain_monitor_enabled",
                "activity_manager/bg_current_drain_threshold_to_bg_restricted",
                "activity_manager/bg_current_drain_threshold_to_restricted_bucket",
                "activity_manager/bg_current_drain_window",
                "activity_manager/bg_ex_bind_svc_threshold",
                "activity_manager/bg_ex_broadcast_threshold",
                "activity_manager/bg_fgs_location_threshold",
                "activity_manager/bg_fgs_long_running_threshold",
                "activity_manager/bg_fgs_long_running_window",
                "activity_manager/bg_fgs_media_playback_threshold",
                "activity_manager/bg_fgs_monitor_enabled",
                "activity_manager/bg_permission_monitor_enabled",
                "activity_manager/bg_prompt_abusive_apps_to_bg_restricted",
                "activity_manager/bg_prompt_fgs_on_long_running",
                "activity_manager/bg_prompt_fgs_with_noti_on_long_running",
                "activity_manager/bg_prompt_fgs_with_noti_to_bg_restricted",
                "activity_manager/compact_full_delta_rss_throttle_kb",
                "activity_manager/compact_full_rss_throttle_kb",
                "activity_manager/compact_proc_state_throttle",
                "activity_manager/compact_statsd_sample_rate",
                "activity_manager/containing",
                "activity_manager/data_sync_fgs_timeout_duration",
                "activity_manager/default_background_activity_starts_enabled",
                "activity_manager/default_background_fgs_starts_restriction_enabled",
                "activity_manager/default_fgs_starts_restriction_enabled",
                "activity_manager/enable_app_start_info",
                "activity_manager/enable_extra_delay_svc_restart_mem_pressure",
                "activity_manager/enforce_exported_flag_requirement",
                "activity_manager/extra_delay_svc_restart_mem_pressure",
                "activity_manager/fgs_crash_extra_wait_duration",
                "activity_manager/fgs_saw_restrictions_enabled",
                "activity_manager/fgs_start_foreground_timeout",
                "activity_manager/fgs_type_fg_perm_enforcement_flag",
                "activity_manager/fgs_type_perm_enforcement_flag_camera",
                "activity_manager/fgs_type_perm_enforcement_flag_connected_device",
                "activity_manager/fgs_type_perm_enforcement_flag_data_sync",
                "activity_manager/fgs_type_perm_enforcement_flag_health",
                "activity_manager/fgs_type_perm_enforcement_flag_location",
                "activity_manager/fgs_type_perm_enforcement_flag_media_playback",
                "activity_manager/fgs_type_perm_enforcement_flag_media_projection",
                "activity_manager/fgs_type_perm_enforcement_flag_microphone",
                "activity_manager/fgs_type_perm_enforcement_flag_phone_call",
                "activity_manager/fgs_type_perm_enforcement_flag_remote_messaging",
                "activity_manager/fgs_type_perm_enforcement_flag_special_use",
                "activity_manager/fgs_type_perm_enforcement_flag_system_exempted",
                "activity_manager/fg_to_bg_fgs_grace_duration",
                "activity_manager/low_swap_threshold_percent",
                "activity_manager/lru_weight",
                "activity_manager/max_cached_processes",
                "activity_manager/max_phantom_processes",
                "activity_manager/max_service_connections_per_process",
                "activity_manager/media_processing_fgs_timeout_duration",
                "activity_manager_native_boot/freeze_debounce_timeout",
                "activity_manager_native_boot/freeze_debounce_timeout_ms",
                "activity_manager_native_boot/freeze_exempt_inst_pkg",
                "activity_manager_native_boot/modern_queue_enabled",
                "activity_manager_native_boot/use_freezer",
                "activity_manager/no_kill_cached_processes_post_boot_completed_duration_millis",
                "activity_manager/no_kill_cached_processes_until_boot_completed",
                "activity_manager/number_to_re_rank",
                "activity_manager/proactive_kills_enabled",
                "activity_manager/push_messaging_over_quota_behavior",
                "activity_manager/rss_weight",
                "activity_manager/service_start_foreground_timeout_ms",
                "activity_manager/short_fgs_anr_extra_wait_duration",
                "activity_manager/short_fgs_proc_state_extra_wait_duration",
                "activity_manager/short_fgs_timeout_duration",
                "activity_manager/top_to_fgs_grace_duration",
                "activity_manager/use_compaction",
                "activity_manager/use_oom_re_ranking",
                "activity_manager/uses_weight",
                "adaptive_charging/adaptive_charging_enabled",
                "adaptive_charging/adaptive_charging_notification",
                "alarm_manager/allow_while_idle_compat_quota",
                "alarm_manager/allow_while_idle_compat_window",
                "alarm_manager/allow_while_idle_quota",
                "alarm_manager/allow_while_idle_window",
                "alarm_manager/app_standby_restricted_window",
                "alarm_manager/app_standby_window",
                "alarm_manager/lazy_batching",
                "alarm_manager/max_alarms_per_uid",
                "alarm_manager/min_futurity",
                "alarm_manager/min_interval",
                "alarm_manager/min_window",
                "alarm_manager/priority_alarm_delay",
                "alarm_manager/standby_quota_frequent",
                "alarm_manager/standby_quota_rare",
                "alarm_manager/standby_quota_working",
                "alarm_manager/temporary_quota_bump",
                "ambient_context/service_enabled",
                "android/system_gesture_exclusion_limit_dp",
                "app_cloning/cloned_apps_enabled",
                "app_cloning/enable_app_cloning_building_blocks",
                "app_compat/hidden_api_access_statslog_sampling_rate",
                "app_compat/hidden_api_log_sampling_rate",
                "app_compat/hidden_api_statslog_sampling_rate",
                "appfunctions/execute_app_function_cancellation_timeout_millis",
                "appfunctions/execute_app_function_timeout_millis",
                "app_hibernation/app_hibernation_enabled",
                "app_hibernation/app_hibernation_targets_pre_s_apps",
                "app_hibernation/auto_revoke_check_frequency_millis",
                "appsearch/app_function_call_timeout_millis",
                "appsearch/contacts_indexer_enabled",
                "app_standby/broadcast_response_fg_threshold_state",
                "app_standby/broadcast_response_window_timeout_ms",
                "app_standby/broadcast_sessions_duration_ms",
                "app_standby/broadcast_sessions_with_response_duration_ms",
                "app_standby/brodacast_response_exempted_permissions",
                "app_standby/brodacast_response_exempted_roles",
                "app_standby/note_response_event_for_all_broadcast_sessions",
                "app_standby/notification_seen_duration",
                "app_standby/notification_seen_duration_millis",
                "app_standby/notification_seen_promoted_bucket",
                "app_standby/retain_notification_seen_impact_for_pre_t_apps",
                "app_standby/strong_usage_duration",
                "app_standby/trigger_quota_bump_on_notification_seen",
                "attention_manager_service/enable_flip_to_screen_off",
                "attention_manager_service/keep_screen_on_enabled",
                "attention_manager_service/keep_screen_on_for_millis",
                "attention_manager_service/max_extension_millis",
                "attention_manager_service/post_dim_check_duration_millis",
                "attention_manager_service/pre_dim_check_duration_millis",
                "attention_manager_service/service_enabled",
                "attention_manager_service/stale_after_millis",
                "auto_pin_confirmation/enable_auto_pin_confirmation",
                "b.b.b/c.c",
                "backstage_power/min_consumed_power_threshold",
                "backup_and_restore/backup_transport_callback_timeout_millis",
                "backup_and_restore/backup_transport_callback_timeout_millis_new",
                "backup_and_restore/backup_transport_future_timeout_millis",
                "backup_and_restore/backup_transport_future_timeout_millis_new",
                "backup_and_restore/full_backup_utils_route_buffer_size_bytes",
                "backup_and_restore/full_backup_write_to_transport_buffer_size_bytes",
                "battery_saver/enable_night_mode",
                "battery_saver/location_mode",
                "biometrics/android.adaptiveauth.enable_adaptive_auth",
                "biometrics/android.adaptiveauth.report_biometric_auth_attempts",
                "biometrics/android.hardware.biometrics.add_key_agreement_crypto_object",
                "biometrics/android.security.clear_strong_auth_on_add_primary_credential",
                "biometrics/android.security.report_primary_auth_attempts",
                "biometrics/android.security.secure_lockdown",
                "biometrics/android.security.should_trust_manager_listen_for_primary_auth",
                "biometrics/android.security.significant_places",
                "biometrics/biometric_strengths",
                "biometrics/enable_biometric_property_verification",
                "biometrics_framework/com.android.server.biometrics.face_vhal_feature",
                "blobstore/delete_on_last_lease_delay_ms",
                "blobstore/lease_acquisition_wait_time_ms",
                "blobstore/max_active_sessions",
                "blobstore/max_committed_blobs",
                "blobstore/max_leased_blobs",
                "blobstore/max_permitted_pks",
                "blobstore/session_expiry_timeout_ms",
                "blobstore/total_bytes_per_app_limit_floor",
                "blobstore/total_bytes_per_app_limit_fraction",
                "bluetooth/acl",
                "bluetooth/apm_enhancement_enabled",
                "bluetooth/bt_audio_policy_ag",
                "bluetooth/bt_audio_policy_hf",
                "bluetooth/bt_default_apm_state",
                "bluetooth/com.android.bluetooth.flags.le_ase_read_multiple_variable",
                "bluetooth/controller",
                "bluetooth/device_name_bloomfilter",
                "bluetooth/enable_hci_logging",
                "bluetooth/hci",
                "bluetooth/location_denylist_advertising_data",
                "bluetooth/location_denylist_mac",
                "bluetooth/location_denylist_name",
                "bluetooth/logging_debug_disabled_for_tags",
                "bluetooth/logging_debug_enabled_for_all",
                "bluetooth/report_delay",
                "bluetooth/scanning",
                "bluetooth/scan_quota_count",
                "camera_native/sample_bool_flag",
                "camera_native/sample_int_flag",
                "car/bugreport_upload_destination",
                "cellular_security/enable_cipher_display",
                "cellular_security/enable_null_cipher_toggle",
                "clipboard/allow_virtualdevice_silos",
                "clipboard/auto_clear_enabled",
                "clipboard/auto_clear_timeout",
                "companion/enable_context_sync_telecom",
                "companion/permission_sync_enabled",
                "configuration/adb_writable_flags_list",
                "configuration/disable_rescue_party",
                "configuration/enable_my_feature",
                "configuration/minimum_dpi",
                "configuration/namespace_to_package_mapping",
                "configuration/test_flag",
                "configuration/test_flag_three",
                "configuration/test_flag_two",
                "configuration/version_test_flag",
                "connectivity_thermal_power_manager/cellular_thermal_adaptive_thermal_status_adaptive_action_list",
                "connectivity_thermal_power_manager/cellular_thermal_thermal_status_action_list_param",
                "connectivity_thermal_power_manager/cellular_thermal_thermal_status_per_shutdown_action_param",
                "constrain_display_apis/always_constrain_display_apis",
                "constrain_display_apis/never_constrain_display_apis",
                "constrain_display_apis/never_constrain_display_apis_all_packages",
                "contacts/android.provider.new_default_account_api_enabled",
                "contacts/com.android.providers.contacts.flags.disable_cp2_account_move_flag",
                "content_capture/enable_activity_start_assist_content",
                "content_capture/idle_flush_frequency",
                "content_capture/legacy_enable_contentcapture",
                "content_capture/logging_level",
                "content_capture/service_explicitly_enabled",
                "credential_manager/enable_credential_description_api",
                "credential_manager/enable_credential_manager",
                "cts/android.cts.flags.tests.readwrite_enabled_flag",
                "DeviceConfigBootstrapValues/processed_values",
                "device_config_overrides/",
                "device_config_overrides/:",
                "device_config_overrides/namespace1:",
                "device_idle/light_idle_to",
                "device_idle/light_idle_to_initial_flex",
                "device_idle/notification_allowlist_duration_ms",
                "device_personalization_services/Captions__disable_prod",
                "device_personalization_services/Echo__smartspace_enable_doorbell",
                "device_personalization_services/Overview__enable_superpacks_download",
                "device_policy_manager/add-isfinanced-device",
                "device_policy_manager/deprecate_usermanagerinternal_devicepolicy",
                "device_policy_manager/enable_coexistence",
                "device_policy_manager/enable_device_policy_engine",
                "device_policy_manager/enable_keep_profiles_running",
                "device_policy_manager/enable_permission_based_access",
                "device_policy_manager/enable_switch_to_managed_profile_dialog",
                "device_policy_manager/enable_work_profile_telephony",
                "display_manager/enabled",
                "display_manager/enable_hdr_output_control",
                "display_manager/fixed_refresh_rate_zones",
                "display_manager/high_refresh_rate_blacklist",
                "display_manager/peak_refresh_rate_default",
                "flipendo/default_savings_mode_launch",
                "flipendo/essential_apps",
                "flipendo/flipendo_enabled_launch",
                "flipendo/grayscale_enabled_launch",
                "flipendo/is_ask_feature_enabled_launch",
                "flipendo/lever_ble_scanning_enabled_launch",
                "flipendo/lever_hotspot_enabled_launch",
                "flipendo/lever_work_profile_enabled_launch",
                "flipendo/resuspend_delay_minutes",
                "flipendo/work_profile_tab_enabled",
                "game_driver/crosshatch_blacklists",
                "game_overlay/android.gameframerate.cts",
                "game_overlay/android.gamemanager.cts.app.gametestapp.performance",
                "game_overlay/com.android.server.cts.device.statsdatom",
                "halyard_demo/enable_test_param",
                "halyard_demo/enable_test_param_beta",
                "hdmi_control/enable_earc_tx",
                "hdmi_control/enable_numeric_soundbar_volume_ui_on_tv",
                "hdmi_control/enable_soundbar_mode",
                "hdmi_control/transition_arc_to_earc_tx",
                "health_connect/cloud_restore_enable",
                "health_connect/entry_points_enable",
                "health_connect/exercise_routes_enable",
                "health_connect/session_types_enable",
                "health_fitness/enable_complete_state_change_jobs",
                "health_fitness/enable_pause_state_change_jobs",
                "health_fitness/enable_rate_limiter",
                "health_fitness/exercise_routes_enable",
                "health_fitness/session_types_enable",
                "input_native_boot/deep_press_enabled",
                "input_native_boot/palm_rejection_enabled",
                "input_native_boot/slow_event_min_reporting_interval",
                "input_native_boot/slow_event_min_reporting_latency_millis",
                "input_native_boot/velocitytracker_strategy",
                "intelligence_bubbles/intelligence_bubbles_webref_superpacks_manifest_url_template",
                "intelligence_bubbles/intelligence_bubbles_webref_superpacks_manifest_version",
                "interaction_jank_monitor/enabled",
                "interaction_jank_monitor/sampling_interval",
                "interaction_jank_monitor/trace_threshold_frame_time_millis",
                "interaction_jank_monitor/trace_threshold_missed_frames",
                "ipsec/config_auto_natt_keepalives_cellular_timeout_override_seconds",
                "jobscheduler/aq_schedule_count",
                "jobscheduler/aq_schedule_return_failure",
                "jobscheduler/aq_schedule_throw_exception",
                "jobscheduler/aq_schedule_window_ms",
                "jobscheduler/conn_transport_batch_threshold",
                "jobscheduler/enable_api_quotas",
                "jobscheduler/fc_applied_constraints",
                "jobscheduler/min_ready_cpu_only_jobs_count",
                "jobscheduler/min_ready_non_active_jobs_count",
                "jobscheduler/qc_allowed_time_per_period_rare_ms",
                "jobscheduler/qc_max_session_count_restricted",
                "jobscheduler/qc_timing_session_coalescing_duration_ms",
                "jobscheduler/runtime_min_ej_guarantee_ms",
                "kiwi/enable_remapping_by_inputsdk_version",
                "kiwi/input_remapping_blocklist",
                "latency_tracker/action_request_ime_shown_enable",
                "latency_tracker/action_show_selection_toolbar_enable",
                "latency_tracker/action_show_voice_interaction_enable",
                "latency_tracker/action_show_voice_interaction_sample_interval",
                "latency_tracker/action_show_voice_interaction_trace_threshold",
                "latency_tracker/action_user_switch_enable",
                "latency_tracker/enabled",
                "latency_tracker/sampling_interval",
                "latency_tracker/trigger_action_check_credential",
                "latency_tracker/trigger_action_check_credential_unlocked",
                "latency_tracker/trigger_action_expand_panel",
                "latency_tracker/trigger_action_face_wake_and_unlock",
                "latency_tracker/trigger_action_fingerprint_wake_and_unlock",
                "latency_tracker/trigger_action_load_share_sheet",
                "latency_tracker/trigger_action_rotate_screen",
                "latency_tracker/trigger_action_show_voice_interaction",
                "latency_tracker/trigger_action_start_recents_animation",
                "latency_tracker/trigger_action_start_switch_display_unfold",
                "latency_tracker/trigger_action_toggle_recents",
                "latency_tracker/trigger_action_turn_on_screen",
                "launcher/enabled",
                "launcher/enable_ime_latency_logger",
                "launcher/enable_impression_logging",
                "launcher/enable_keyboard_transition_sync",
                "launcher/enable_one_search",
                "launcher/enable_quick_search",
                "launcher/enable_rich_answer",
                "launcher/inject_web_top",
                "launcher_lily/enable_camera_block",
                "launcher_lily/enable_feature",
                "launcher_lily/enable_files_block",
                "launcher_lily/enable_rani_block",
                "launcher/match_state_charlen",
                "launcher/medium_suggestion_cnt",
                "launcher/peek_and_match",
                "launcher/peek_blocklen",
                "launcher/peek_state_charlen",
                "launcher/qsb_web_cnt",
                "launcher/short_suggestion_cnt",
                "launcher/show_search_educard_qsb",
                "launcher/use_app_search_for_web",
                "launcher/use_fallback_app_search",
                "lmkd_native/filecache_min_kb",
                "lmkd_native/thrashing_limit_critical",
                "low_power_standby/enable_policy",
                "low_power_standby/enable_standby_ports",
                "media_better_together/scanning_package_minimum_importance",
                "media_tv/android.media.tv.flags.enable_ad_service_fw",
                "media_tv/android.media.tv.flags.tiaf_v_apis",
                "media/media_metrics_mode",
                "media/media_session_temp_user_engaged_duration_ms",
                "media/player_metrics_app_allowlist",
                "media/player_metrics_app_blocklist",
                "media/player_metrics_per_app_attribution_allowlist",
                "media/player_metrics_per_app_attribution_blocklist",
                "media/player_metrics_per_app_user_media_activity_allowlist",
                "media/player_metrics_per_app_user_media_activity_blocklist",
                "media/player_metrics_per_app_use_time_allowlist",
                "media/player_metrics_per_app_use_time_blocklist",
                "mediaprovider/allowed_cloud_providers",
                "mediaprovider/cloud_media_feature_enabled",
                "mediaprovider/com.android.providers.media.flags.enable_modern_photopicker",
                "mediaprovider/picker_pick_images_preload_selected",
                "memory_safety_native_boot/bootloader_override",
                "mglru_native/lru_gen_config",
                "namespace1/key1",
                "namespace1/key2",
                "namespace1/key3",
                "namespace1/key_non_existing",
                "namespace2/key1",
                "namespace2/key2",
                "namespace2/key3",
                "namespace3/key3",
                "namespace3/key4",
                "namespace4/key3",
                "namespace4/key4",
                "namespace/key",
                "nnapi_native/current_feature_level",
                "nnapi_native/telemetry_enable",
                "notification_assistant/generate_actions",
                "notification_assistant/generate_replies",
                "ondeviceintelligence/service_enabled",
                "oslo/mcc_whitelist",
                "oslo/media_app_whitelist",
                "ota/enable_server_based_ror",
                "ota/server_based_ror_enabled",
                "ota/wait_for_internet_ror",
                "package_manager_service/deferred_no_kill_post_delete_delay_ms_extended",
                "package_manager_service/dormant_app_threshold_days",
                "package_manager_service/downgrade_unused_apps_enabled",
                "package_manager_service/inactive_app_threshold_days",
                "package_manager_service/incfs_default_timeouts",
                "package_manager_service/install_block_enabled",
                "package_manager_service/install_block_strict_mode_enabled",
                "package_manager_service/is_preapproval_available",
                "package_manager_service/is_update_ownership_enforcement_available",
                "package_manager_service/known_digesters_list",
                "package_manager_service/low_storage_threshold_multiplier_for_downgrade",
                "package_manager_service/min_installable_target_sdk",
                "package_manager_service/MinInstallableTargetSdk__install_block_enabled",
                "package_manager_service/MinInstallableTargetSdk__install_block_strict_mode_enabled",
                "package_manager_service/MinInstallableTargetSdk__min_installable_target_sdk",
                "package_manager_service/MinInstallableTargetSdk__strict_mode_target_sdk",
                "package_manager_service/strict_mode_target_sdk",
                "package_manager_service/verification_request_timeout_millis",
                "package_manager_service/verifier_connection_timeout_millis",
                "permissions/auto_revoke_check_frequency_millis",
                "permissions/auto_revoke_unused_threshold_millis2",
                "permissions/one_time_permissions_killed_delay_millis",
                "permissions/one_time_permissions_timeout_millis",
                "permissions/permission_changes_store_exact_time",
                "pmw/vendor.google.aam.flags.enable_aam",
                "privacy/bg_location_check_is_enabled",
                "privacy/camera_mic_icons_enabled",
                "privacy/camera_toggle_enabled",
                "privacy/data_sharing_update_period_millis",
                "privacy/discrete_history_cutoff_millis",
                "privacy/discrete_history_op_flags",
                "privacy/discrete_history_ops_cslist",
                "privacy/discrete_history_quantization_millis",
                "privacy/location_access_check_delay_millis",
                "privacy/location_access_check_periodic_interval_millis",
                "privacy/location_indicators_enabled",
                "privacy/location_indicators_show_system",
                "privacy/location_indicators_small_enabled",
                "privacy/max_safety_labels_persisted_per_app",
                "privacy/mic_toggle_enabled",
                "privacy/notification_listener_check_enabled",
                "privacy/notification_listener_check_interval_millis",
                "privacy/param",
                "privacy/permission_rationale_enabled",
                "privacy/permissions_hub_subattribution_enabled",
                "privacy/photo_picker_prompt_enabled",
                "privacy/placeholder_safety_label_updates_enabled",
                "privacy/privacy_attribution_tag_full_log_enabled",
                "privacy/privacy_dashboard_7_day_toggle",
                "privacy/privacy_hub_enabled",
                "privacy/privacy_placeholder_safety_label_data_enabled",
                "privacy/safety_center_actions_to_override_with_default_intent",
                "privacy/safety_center_additional_allow_package_certs",
                "privacy/safety_center_allow_statsd_logging",
                "privacy/safety_center_background_refresh_denied_sources",
                "privacy/safety_center_background_refresh_is_enabled",
                "privacy/safety_center_background_requires_charging",
                "privacy/safety_center_hide_resolved_ui_transition_delay_millis",
                "privacy/safety_center_is_enabled",
                "privacy/safety_center_issue_category_allowlists",
                "privacy/safety_center_notification_resurface_interval",
                "privacy/safety_center_notifications_allowed_sources",
                "privacy/safety_center_notifications_enabled",
                "privacy/safety_center_notifications_immediate_behavior_issues",
                "privacy/safety_center_notifications_min_delay",
                "privacy/safety_center_override_refresh_on_page_open_sources",
                "privacy/safety_center_periodic_background_interval_millis",
                "privacy/safety_center_qs_tile_component_setting_flags",
                "privacy/safety_center_refresh_fgs_allowlist_duration_millis",
                "privacy/safety_center_refresh_sources_timeouts_millis",
                "privacy/safety_center_replace_lock_screen_icon_action",
                "privacy/safety_center_resolve_action_timeout_millis",
                "privacy/safety_center_resurface_issue_delays_millis",
                "privacy/safety_center_resurface_issue_max_counts",
                "privacy/safety_center_show_subpages",
                "privacy/safety_center_temp_hidden_issue_resurface_delay_millis",
                "privacy/safety_center_untracked_sources",
                "privacy/safety_label_change_notifications_enabled",
                "privacy/safety_label_changes_job_interval_millis",
                "privacy/safety_protection_enabled",
                "privacy/sc_accessibility_job_interval_millis",
                "privacy/sc_accessibility_listener_enabled",
                "profcollect_native_boot/enable",
                "profiling/cost_heap_profile",
                "profiling/cost_java_heap_dump",
                "profiling/cost_stack_sampling",
                "profiling/cost_system_trace",
                "profiling/cost_system_triggered_system_trace",
                "profiling/heap_profile_duration_ms_default",
                "profiling/heap_profile_duration_ms_max",
                "profiling/heap_profile_duration_ms_min",
                "profiling/java_heap_dump_data_source_stop_timeout_ms_default",
                "profiling/java_heap_dump_duration_ms_default",
                "profiling/killswitch_heap_profile",
                "profiling/killswitch_java_heap_dump",
                "profiling/killswitch_stack_sampling",
                "profiling/killswitch_system_trace",
                "profiling/max_cost_process_1_hour",
                "profiling/max_cost_process_24_hour",
                "profiling/max_cost_process_7_day",
                "profiling/max_cost_system_1_hour",
                "profiling/max_cost_system_24_hour",
                "profiling/max_cost_system_7_day",
                "profiling/max_result_redelivery_count",
                "profiling/persist_queue_to_disk_frequency_ms",
                "profiling/persist_to_disk_frequency_ms",
                "profiling/stack_sampling_duration_ms_default",
                "profiling/stack_sampling_duration_ms_max",
                "profiling/stack_sampling_duration_ms_min",
                "profiling/system_trace_duration_ms_default",
                "profiling/system_trace_duration_ms_max",
                "profiling/system_trace_duration_ms_min",
                "profiling/system_triggered_trace_max_period_seconds",
                "profiling/system_triggered_trace_min_period_seconds",
                "profiling_testing/rate_limiter.disabled",
                "profiling_testing/system_triggered_profiling.testing_package_name",
                "reboot_readiness/active_polling_interval_ms",
                "reboot_readiness/alarm_clock_threshold_ms",
                "reboot_readiness/disable_app_activity_check",
                "reboot_readiness/disable_interactivity_check",
                "reboot_readiness/disable_subsystems_check",
                "reboot_readiness/interactivity_threshold_ms",
                "reboot_readiness/logging_blocking_entity_threshold_ms",
                "remote_key_provisioning_native/enable_rkpd",
                "repair_mode/userdata_size_gb",
                "rollback_boot/rollback_lifetime_in_millis",
                "rollback/containing",
                "rollback/enable_rollback_timeout",
                "rollback/watchdog_explicit_health_check_enabled",
                "rollback/watchdog_request_timeout_millis",
                "rollback/watchdog_trigger_failure_count",
                "rollback/watchdog_trigger_failure_duration_millis",
                "rotation_resolver/service_enabled",
                "runtime_native_boot/blacklisted_packages",
                "runtime_native_boot/disable_lock_profiling",
                "runtime_native_boot/dummy_gc_flag",
                "runtime_native_boot/enable_apex_image",
                "runtime_native_boot/enable_camera_pinning",
                "runtime_native_boot/enable_generational_cc",
                "runtime_native_boot/enable_perfetto",
                "runtime_native_boot/enable_profile_boot_class_path",
                "runtime_native_boot/enable_profile_system_server",
                "runtime_native_boot/enable_readahead",
                "runtime_native_boot/gctype",
                "runtime_native_boot/is_uffd_gc_enabled",
                "runtime_native_boot/options",
                "runtime_native/metrics_reporting_mods",
                "runtime_native/metrics_reporting_mods_server",
                "runtime_native/metrics_reporting_num_mods",
                "runtime_native/metrics_reporting_num_mods_server",
                "runtime_native/metrics_reporting_spec",
                "runtime_native/metrics_reporting_spec_server",
                "runtime_native/metrics_write_to_statsd",
                "runtime_native/my_feature_test_flag",
                "runtime_native/usap_pool_enabled",
                "runtime_native/usap_pool_refill_delay_ms",
                "runtime_native/usap_pool_refill_threshold",
                "runtime_native/usap_pool_size_max",
                "runtime_native/usap_pool_size_min",
                "runtime_native/use_app_image_startup_cache",
                "settings_stats/boolean_whitelist",
                "settings_stats/float_whitelist",
                "settings_stats/GlobalFeature__boolean_whitelist",
                "settings_stats/GlobalFeature__float_whitelist",
                "settings_stats/GlobalFeature__integer_whitelist",
                "settings_stats/GlobalFeature__string_whitelist",
                "settings_stats/integer_whitelist",
                "settings_stats/string_whitelist",
                "settings_stats/testflag",
                "statsd_java/include_certificate_hash",
                "statsd_java/use_file_descriptor",
                "statsd_native/app_upgrade_bucket_split",
                "statsd_native_boot/aggregate_atoms",
                "statsd_native_boot/enable_restricted_metrics",
                "statsd_native_boot/optimization_atom_matcher_map",
                "statsd_native_boot/value_aggregation",
                "statsd_native/kll_metric",
                "statsd_native/partial_config_update",
                "storage_native_boot/allowed_cloud_providers",
                "storage_native_boot/anr_delay_millis",
                "storage_native_boot/anr_delay_notify_external_storage_service",
                "storage_native_boot/cache_reserve_percent_high",
                "storage_native_boot/cache_reserve_percent_low",
                "storage_native_boot/charging_required",
                "storage_native_boot/cloud_media_enforce_provider_allowlist",
                "storage_native_boot/cloud_media_feature_enabled",
                "storage_native_boot/dirty_reclaim_rate",
                "storage_native_boot/forced_scoped_storage_whitelist",
                "storage_native_boot/fuse_enabled",
                "storage_native_boot/is_sticky",
                "storage_native_boot/lifetime_threshold",
                "storage_native_boot/low_battery_level",
                "storage_native_boot/min_gc_sleeptime",
                "storage_native_boot/min_segments_threshold",
                "storage_native_boot/segment_reclaim_weight",
                "storage_native_boot/smart_idle_maint_enabled",
                "storage_native_boot/smart_idle_maint_period",
                "storage_native_boot/stabilize_volume_external",
                "storage_native_boot/stablise_volume_internal",
                "storage_native_boot/take_over_get_content",
                "storage_native_boot/target_dirty_ratio",
                "storage_native_boot/transcode_compat_manifest",
                "storage_native_boot/transcode_compat_stale",
                "storage_native_boot/transcode_default",
                "storage_native_boot/transcode_enabled",
                "storage/pickerdb.default_sync_delay_ms",
                "surface_flinger_native_boot/adpf_cpu_hint",
                "surface_flinger_native_boot/demo_flag",
                "surface_flinger_native_boot/max_frame_buffer_acquired_buffers",
                "surface_flinger_native_boot/use_skia_tracing",
                "system_scheduler/dummy_flag",
                "system_scheduler/enable_fast_metrics_collection",
                "system_scheduler/location_mode",
                "system_time/enhanced_metrics_collection_enabled",
                "system_time/location_time_zone_detection_feature_supported",
                "system_time/location_time_zone_detection_run_in_background_enabled",
                "system_time/location_time_zone_detection_setting_enabled_default",
                "system_time/location_time_zone_detection_setting_enabled_override",
                "system_time/location_time_zone_detection_uncertainty_delay_millis",
                "system_time/ltzp_event_filtering_age_threshold_millis",
                "system_time/ltzp_init_timeout_fuzz_millis",
                "system_time/ltzp_init_timeout_millis",
                "system_time/primary_location_time_zone_provider_mode_override",
                "system_time/secondary_location_time_zone_provider_mode_override",
                "system_time/time_detector_lower_bound_millis_override",
                "system_time/time_detector_origin_priorities_override",
                "system_time/time_zone_detector_auto_detection_enabled_default",
                "system_time/time_zone_detector_telephony_fallback_supported",
                "systemui/android.app.visit_person_uri",
                "systemui/apply_sharing_app_limits_in_sysui",
                "systemui/back_gesture_ml_name",
                "systemui/back_gesture_ml_threshold",
                "systemui/behavior_mode",
                "systemui/cursor_hover_states_enabled",
                "systemui/dark_launch_remote_prediction_service_enabled",
                "systemui/duration_per_px_fast",
                "systemui/duration_per_px_regular",
                "systemui/enabled",
                "systemui/enable_notification_memory_monitoring",
                "systemui/enable_screenshot_corner_flow",
                "systemui/enable_screenshot_notification_smart_actions",
                "systemui/enable_screenshot_scrolling",
                "systemui/exp_flag_release",
                "systemui/fade_in_duration",
                "systemui/generate_actions",
                "systemui/generated_preview_api_max_calls_per_interval",
                "systemui/generated_preview_api_reset_interval_ms",
                "systemui/generate_replies",
                "systemui/is_nearby_share_first_target_in_ranked_app",
                "systemui/learn_count",
                "systemui/learn_time",
                "systemui/long_press_duration_ms",
                "systemui/max_messages_to_extract",
                "systemui/max_num_actions",
                "systemui/max_squeeze_remeasure_attempts",
                "systemui/max_suggestions",
                "systemui/max_total_duration",
                "systemui/min_num_sys_gen_replies",
                "systemui/min_total_duration",
                "systemui/nas_generate_actions",
                "systemui/nas_generate_replies",
                "systemui/nas_max_messages_to_extract",
                "systemui/nas_max_suggestions",
                "systemui/predict_using_people_service_share",
                "systemui/replies_require_targeting_p",
                "systemui/scanner_activity_name",
                "systemui/screenshot_notification_smart_actions_timeout_ms",
                "systemui/share_sheet_direct_share_timeout",
                "systemui/show_and_go_delayed_long_delay",
                "systemui/show_and_go_delayed_short_delay",
                "systemui/show_and_go_delay_reset_timeout",
                "systemui/show_and_go_duration",
                "systemui/show_in_headsup",
                "systemui/shown_frequency",
                "systemui/suppress_on_apps",
                "systemui/suppress_on_launcher",
                "systemui/suppress_on_lockscreen",
                "systemui/tap_to_edit",
                "systemui/task_manager_enabled",
                "systemui/test_key",
                "systemui/use_back_gesture_ml",
                "systemui/use_unbundled_sharesheet",
                "systemui/volume_separate_notification",
                "tare/enable_tare",
                "telecom/com.android.server.telecom.flags.cache_call_audio_callbacks",
                "telecom/com.android.server.telecom.flags.get_registered_phone_accounts",
                "telecom/com.android.server.telecom.flags.telecom_main_user_in_block_check",
                "telecom/com.android.server.telecom.flags.telecom_main_user_in_get_respond_message_app",
                "telecom/com.android.server.telecom.flags.unregister_unresolvable_accounts",
                "telephony/anomaly_apn_config_enabled",
                "telephony/anomaly_ims_release_request",
                "telephony/anomaly_network_connecting_timeout",
                "telephony/anomaly_network_disconnecting_timeout",
                "telephony/anomaly_network_handover_timeout",
                "telephony/anomaly_network_unwanted",
                "telephony/anomaly_qns_change_network",
                "telephony/anomaly_qns_param",
                "telephony/anomaly_setup_data_call_failure",
                "telephony/auto_data_switch_availability_stability_time_threshold",
                "telephony/auto_data_switch_validation_max_retry",
                "telephony/com.android.internal.telephony.flags.carrier_enabled_satellite_flag",
                "telephony/com.android.internal.telephony.flags.carrier_roaming_nb_iot_ntn",
                "telephony/com.android.internal.telephony.flags.oem_enabled_satellite_flag",
                "telephony/config_satellite_carrier_roaming_esos_provisioned_class",
                "telephony/enable_logcat_collection_for_emergency_call_diagnostics",
                "telephony/enable_new_data_stack",
                "telephony/enable_slicing_upsell",
                "telephony/enable_subscription_manager_service",
                "telephony/enable_telecom_dump_collection_for_emergency_call_diagnostics",
                "telephony/enable_telephony_dump_collection_for_emergency_call_diagnostics",
                "telephony/enable_work_profile_telephony",
                "telephony/erase_modem_config",
                "telephony/is_telephony_anomaly_report_enabled",
                "telephony/ramping_ringer_duration",
                "telephony/ramping_ringer_enabled",
                "telephony/ramping_ringer_vibration_duration",
                "test_od_namespace/key1",
                "test_namespace/test_key",
                "testspace/another",
                "testspace/flagname",
                "textclassifier/ar_manifest",
                "textclassifier/da_manifest",
                "textclassifier/de_ch_manifest",
                "textclassifier/de_li_manifest",
                "textclassifier/de_manifest",
                "textclassifier/en_manifest",
                "textclassifier/es_manifest",
                "textclassifier/fr_manifest",
                "textclassifier/generate_links_max_text_length",
                "textclassifier/it_manifest",
                "textclassifier/ja_manifest",
                "textclassifier/key",
                "textclassifier/ko_manifest",
                "textclassifier/local_textclassifier_enabled",
                "textclassifier/manifest_download_max_attempts",
                "textclassifier/manifest_download_required_network_type",
                "textclassifier/manifest_url_actions_suggestions_de",
                "textclassifier/manifest_url_actions_suggestions_de-ch",
                "textclassifier/manifest_url_actions_suggestions_de-li",
                "textclassifier/manifest_url_actions_suggestions_en",
                "textclassifier/manifest_url_actions_suggestions_es",
                "textclassifier/manifest_url_actions_suggestions_fr",
                "textclassifier/manifest_url_actions_suggestions_it",
                "textclassifier/manifest_url_actions_suggestions_ja",
                "textclassifier/manifest_url_actions_suggestions_ko",
                "textclassifier/manifest_url_actions_suggestions_pt-br",
                "textclassifier/manifest_url_actions_suggestions_universal",
                "textclassifier/manifest_url_actions_suggestions_zh",
                "textclassifier/manifest_url_actions_suggestions_zh-hant",
                "textclassifier/manifest_url_annotator_ar",
                "textclassifier/manifest_url_annotator_da",
                "textclassifier/manifest_url_annotator_de",
                "textclassifier/manifest_url_annotator_en",
                "textclassifier/manifest_url_annotator_es",
                "textclassifier/manifest_url_annotator_fr",
                "textclassifier/manifest_url_annotator_it",
                "textclassifier/manifest_url_annotator_ja",
                "textclassifier/manifest_url_annotator_ko",
                "textclassifier/manifest_url_annotator_nb",
                "textclassifier/manifest_url_annotator_nl",
                "textclassifier/manifest_url_annotator_nn",
                "textclassifier/manifest_url_annotator_no",
                "textclassifier/manifest_url_annotator_pl",
                "textclassifier/manifest_url_annotator_pt",
                "textclassifier/manifest_url_annotator_ru",
                "textclassifier/manifest_url_annotator_sv",
                "textclassifier/manifest_url_annotator_th",
                "textclassifier/manifest_url_annotator_tr",
                "textclassifier/manifest_url_annotator_universal",
                "textclassifier/manifest_url_annotator_zh",
                "textclassifier/manifest_url_lang_id_universal",
                "textclassifier/model_download_backoff_delay_in_millis",
                "textclassifier/model_download_manager_enabled",
                "textclassifier/model_download_worker_max_attempts",
                "textclassifier/model_url_blocklist",
                "textclassifier/nb_manifest",
                "textclassifier/nl_manifest",
                "textclassifier/nn_manifest",
                "textclassifier/no_manifest",
                "textclassifier/pl_manifest",
                "textclassifier/pt_br_manifest",
                "textclassifier/pt_manifest",
                "textclassifier/ru_manifest",
                "textclassifier/sv_manifest",
                "textclassifier/system_textclassifier_api_timeout_in_second",
                "textclassifier/system_textclassifier_enabled",
                "textclassifier/textclassifier_service_package_override",
                "textclassifier/th_manifest",
                "textclassifier/tr_manifest",
                "textclassifier/universal_manifest",
                "textclassifier/zh_hant_manifest",
                "textclassifier/zh_manifest",
                "tv_hdr_output_control/enable_hdr_output_control",
                "uwb/device_error_bugreport_enabled",
                "vendor_system_native/background_cpuset",
                "vendor_system_native_boot/thermal_proactive_skin",
                "vendor_system_native_boot/zram_size",
                "vendor_system_native/foreground_cpuset",
                "vendor_system_native/restricted_cpuset",
                "virtualization_framework_native/isolated_compilation_enabled",
                "voice_interaction/restart_period_in_seconds",
                "vpn/enable_pixel_ppn_feature",
                "wallpaper_content/enabled",
                "wearable_sensing/service_enabled",
                "wearable_sensing/service_enabled_platforms",
                "wear/ambient_auto_resume_timeout_max_reset_count",
                "wear/bedtime_hard_mode_feature_enabled",
                "wear/enable_backup_service_in_wear_framework",
                "widget/enable_cursor_drag_from_anywhere",
                "widget/enable_insertion_handle_gestures",
                "widget/enable_new_magnifier",
                "widget/finger_to_cursor_distance",
                "widget/insertion_handle_delta_height",
                "widget/insertion_handle_opacity",
                "widget/magnifier_aspect_ratio",
                "widget/magnifier_zoom_factor",
                "wifi/abnormal_connection_bugreport_enabled",
                "wifi/abnormal_connection_duration_ms",
                "wifi/abnormal_connection_failure_bugreport_enabled",
                "wifi/abnormal_disconnection_bugreport_enabled",
                "wifi/adjust_poll_rssi_interval_enabled",
                "wifi/aggressive_randomization_ssid_allowlist",
                "wifi/allow_enhanced_mac_randomization_on_open_ssids",
                "wifi/apm_enhancement_enabled",
                "wifi/application_qos_policy_api_enabled",
                "wifi/assoc_rejection_count_min",
                "wifi/assoc_rejection_high_thr_percent",
                "wifi/assoc_timeout_count_min",
                "wifi/assoc_timeout_high_thr_percent",
                "wifi/auth_failure_count_min",
                "wifi/auth_failure_high_thr_percent",
                "wifi/aware_suspension_enabled",
                "wifi/bug_report_min_window_ms",
                "wifi/connection_failure_count_min",
                "wifi/connection_failure_disconnection_count_min",
                "wifi/connection_failure_disconnection_high_thr_percent",
                "wifi/connection_failure_high_thr_percent",
                "wifi/containing",
                "wifi/disconnection_nonlocal_count_min",
                "wifi/disconnection_nonlocal_high_thr_percent",
                "wifi/handle_rssi_organic_kernel_failures_enabled",
                "wifi/health_monitor_fw_alert_valid_time_ms",
                "wifi/health_monitor_min_num_connection_attempt",
                "wifi/health_monitor_min_rssi_thr_dbm",
                "wifi/health_monitor_ratio_thr_numerator",
                "wifi/health_monitor_rssi_poll_valid_time_ms",
                "wifi/health_monitor_short_connection_duration_thr_ms",
                "wifi/high_perf_lock_deprecated",
                "wifi/interface_failure_bugreport_enabled",
                "wifi/nonstationary_scan_rssi_valid_time_ms",
                "wifi/oob_pseudonym_enabled",
                "wifi/randomization_flaky_ssid_hotlist",
                "wifi/report_bug_report_threshold_extra_ratio",
                "wifi/short_connection_nonlocal_count_min",
                "wifi/short_connection_nonlocal_high_thr_percent",
                "wifi/software_pno_enabled",
                "wifi/stationary_scan_rssi_valid_time_ms",
                "wifi/wfd_failure_bugreport_enabled",
                "window_manager/ActivitySecurity__asm_restrictions_enabled",
                "window_manager/AlwaysOnMagnifier__enable_always_on_magnifier",
                "window_manager/asm_restrictions_enabled",
                "window_manager/asm_toasts_enabled",
                "window_manager/enable_always_on_magnifier",
                "window_manager/enable_camera_compat_treatment",
                "window_manager/enable_compat_fake_focus",
                "window_manager/enable_letterbox_reachability_education",
                "window_manager/enable_letterbox_restart_dialog",
                "window_manager/enable_non_linear_font_scaling",
                "window_manager/enable_translucent_activity_letterbox",
                "window_manager/splash_screen_exception_list",
                "wrong/nas_generate_replies"
            ));
}
