// This file is autogenerated

package android.health;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;
import androidx.annotation.RequiresApi;


/**
 * Utility class for logging statistics events.
 * @hide
 */
public final class HealthFitnessStatsLog {
    // Constants for atom codes.

    /**
     * HealthConnectApiCalled health_connect_api_called<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_API_CALLED, int api_method, int api_status, int error_code, long duration_millis, int number_of_records, int rate_limit, int caller_foreground_state, java.lang.String package_name);<br>
     */
    public static final int HEALTH_CONNECT_API_CALLED = 616;

    /**
     * HealthConnectUsageStats health_connect_usage_stats<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_USAGE_STATS, int connected_apps_count, int available_apps_count, boolean is_monthly_active_user);<br>
     */
    public static final int HEALTH_CONNECT_USAGE_STATS = 617;

    /**
     * HealthConnectStorageStats health_connect_storage_stats<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_STORAGE_STATS, long database_size, long instant_data_count, long interval_data_count, long series_data_count, long changelog_count);<br>
     */
    public static final int HEALTH_CONNECT_STORAGE_STATS = 618;

    /**
     * HealthConnectUiImpression health_connect_ui_impression<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_UI_IMPRESSION, int page, int element);<br>
     */
    public static final int HEALTH_CONNECT_UI_IMPRESSION = 623;

    /**
     * HealthConnectUiInteraction health_connect_ui_interaction<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_UI_INTERACTION, int page, int element, int action);<br>
     */
    public static final int HEALTH_CONNECT_UI_INTERACTION = 624;

    /**
     * HealthConnectAppOpenedReported health_connect_app_opened_reported<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_APP_OPENED_REPORTED, int source);<br>
     */
    public static final int HEALTH_CONNECT_APP_OPENED_REPORTED = 625;

    /**
     * HealthConnectApiInvoked health_connect_api_invoked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_API_INVOKED, int api_method, int api_status, int error_code, long duration_millis, java.lang.String package_name, int data_type_one, int data_type_two, int data_type_three, int data_type_four, int data_type_five, int data_type_six);<br>
     */
    public static final int HEALTH_CONNECT_API_INVOKED = 643;

    /**
     * ExerciseRouteApiCalled exercise_route_api_called<br>
     * Usage: StatsLog.write(StatsLog.EXERCISE_ROUTE_API_CALLED, int operation, java.lang.String package_name, int number_of_records);<br>
     */
    public static final int EXERCISE_ROUTE_API_CALLED = 654;

    /**
     * HealthConnectExportInvoked health_connect_export_invoked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_EXPORT_INVOKED, int status, int time_to_succeed_or_fail_millis, int original_data_size_kb, int compressed_data_size_kb, int repeat_error_on_retry_count);<br>
     */
    public static final int HEALTH_CONNECT_EXPORT_INVOKED = 907;

    /**
     * HealthConnectImportInvoked health_connect_import_invoked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_IMPORT_INVOKED, int status, int time_to_succeed_or_fail_millis, int original_data_size_kb, int compressed_data_size_kb);<br>
     */
    public static final int HEALTH_CONNECT_IMPORT_INVOKED = 918;

    /**
     * HealthConnectExportImportStatsReported health_connect_export_import_stats_reported<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_EXPORT_IMPORT_STATS_REPORTED, int export_frequency);<br>
     */
    public static final int HEALTH_CONNECT_EXPORT_IMPORT_STATS_REPORTED = 919;

    /**
     * HealthConnectPermissionStats health_connect_permission_stats<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_PERMISSION_STATS, java.lang.String package_name, java.lang.String[] permission_name);<br>
     */
    public static final int HEALTH_CONNECT_PERMISSION_STATS = 963;

    /**
     * HealthConnectPhrApiInvoked health_connect_phr_api_invoked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_PHR_API_INVOKED, int api_method, int api_status, java.lang.String package_name, int medical_resource_type);<br>
     */
    public static final int HEALTH_CONNECT_PHR_API_INVOKED = 980;

    /**
     * HealthConnectPhrUsageStats health_connect_phr_usage_stats<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_PHR_USAGE_STATS, int connected_medical_datasource_count, int medical_resource_count, boolean is_monthly_active_phr_user, int granted_phr_apps_count);<br>
     */
    public static final int HEALTH_CONNECT_PHR_USAGE_STATS = 981;

    /**
     * HealthConnectPhrStorageStats health_connect_phr_storage_stats<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_PHR_STORAGE_STATS, long phr_data_size);<br>
     */
    public static final int HEALTH_CONNECT_PHR_STORAGE_STATS = 984;

    /**
     * HealthConnectRestrictedEcosystemStats health_connect_restricted_ecosystem_stats<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS, java.lang.String package_name_one, java.lang.String package_name_two, int data_type, int metric_type);<br>
     */
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS = 985;

    /**
     * HealthConnectEcosystemStats health_connect_ecosystem_stats<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_ECOSYSTEM_STATS, int[] read_or_write, int[] read, int[] write, int[] shared, int number_of_app_pairings);<br>
     */
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS = 986;

    /**
     * HealthConnectDataBackupInvoked health_connect_data_backup_invoked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_DATA_BACKUP_INVOKED, int status, int time_to_succeed_or_fail_millis, int data_size_kb, int backup_type);<br>
     */
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED = 1023;

    /**
     * HealthConnectSettingsBackupInvoked health_connect_settings_backup_invoked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_SETTINGS_BACKUP_INVOKED, int status, int time_to_succeed_or_fail_millis, int settings_size_kb);<br>
     */
    public static final int HEALTH_CONNECT_SETTINGS_BACKUP_INVOKED = 1024;

    /**
     * HealthConnectDataRestoreInvoked health_connect_data_restore_invoked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_DATA_RESTORE_INVOKED, int status, int time_to_succeed_or_fail_millis, int data_size_kb);<br>
     */
    public static final int HEALTH_CONNECT_DATA_RESTORE_INVOKED = 1025;

    /**
     * HealthConnectSettingsRestoreInvoked health_connect_settings_restore_invoked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_SETTINGS_RESTORE_INVOKED, int status, int time_to_succeed_or_fail_millis, int settings_size_kb);<br>
     */
    public static final int HEALTH_CONNECT_SETTINGS_RESTORE_INVOKED = 1026;

    /**
     * HealthConnectRestoreEligibilityChecked health_connect_restore_eligibility_checked<br>
     * Usage: StatsLog.write(StatsLog.HEALTH_CONNECT_RESTORE_ELIGIBILITY_CHECKED, boolean is_eligible);<br>
     */
    public static final int HEALTH_CONNECT_RESTORE_ELIGIBILITY_CHECKED = 1027;

    // Constants for enum values.

    // Values for HealthConnectApiCalled.api_method
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__API_METHOD_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__DELETE_DATA = 1;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__GET_CHANGES = 2;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__GET_CHANGES_TOKEN = 3;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__GET_GRANTED_PERMISSIONS = 4;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__INSERT_DATA = 5;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__READ_AGGREGATED_DATA = 6;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__READ_DATA = 7;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__REVOKE_ALL_PERMISSIONS = 8;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__UPDATE_DATA = 9;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__CREATE_MEDICAL_DATA_SOURCE = 10;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__GET_MEDICAL_DATA_SOURCES_BY_IDS = 11;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__GET_MEDICAL_DATA_SOURCES_BY_REQUESTS = 12;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__DELETE_MEDICAL_DATA_SOURCE_WITH_DATA = 13;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__UPSERT_MEDICAL_RESOURCES = 14;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__READ_MEDICAL_RESOURCES_BY_IDS = 15;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__READ_MEDICAL_RESOURCES_BY_REQUESTS = 16;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__DELETE_MEDICAL_RESOURCES_BY_IDS = 17;
    public static final int HEALTH_CONNECT_API_CALLED__API_METHOD__DELETE_MEDICAL_RESOURCES_BY_REQUESTS = 18;

    // Values for HealthConnectApiCalled.api_status
    public static final int HEALTH_CONNECT_API_CALLED__API_STATUS__STATUS_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_CALLED__API_STATUS__SUCCESS = 1;
    public static final int HEALTH_CONNECT_API_CALLED__API_STATUS__ERROR = 2;

    // Values for HealthConnectApiCalled.rate_limit
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__NOT_DEFINED = 0;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__NOT_USED = 1;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_15_MIN_UNDER_1000 = 2;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_15_MIN_BW_1000_TO_2000 = 3;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_15_MIN_BW_2000_TO_3000 = 4;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_15_MIN_BW_3000_TO_4000 = 5;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_15_MIN_ABOVE_4000 = 6;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_15_MIN_UNDER_500 = 7;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_15_MIN_BW_500_TO_1000 = 8;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_15_MIN_BW_1000_TO_2000 = 9;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_15_MIN_BW_2000_TO_3000 = 10;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_15_MIN_ABOVE_3000 = 11;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_24_HRS_UNDER_2000 = 12;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_24_HRS_BW_2000_TO_3000 = 13;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_24_HRS_BW_3000_TO_4000 = 14;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_24_HRS_BW_4000_TO_5000 = 15;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_24_HRS_BW_5000_TO_6000 = 16;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_FOREGROUND_24_HRS_ABOVE_6000 = 17;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_24_HRS_UNDER_1000 = 18;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_24_HRS_BW_1000_TO_2000 = 19;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_24_HRS_BW_2000_TO_3000 = 20;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_24_HRS_BW_3000_TO_4000 = 21;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_24_HRS_BW_4000_TO_5000 = 22;
    public static final int HEALTH_CONNECT_API_CALLED__RATE_LIMIT__RATE_LIMIT_BACKGROUND_24_HRS_ABOVE_5000 = 23;

    // Values for HealthConnectApiCalled.caller_foreground_state
    public static final int HEALTH_CONNECT_API_CALLED__CALLER_FOREGROUND_STATE__UNSPECIFIED = 0;
    public static final int HEALTH_CONNECT_API_CALLED__CALLER_FOREGROUND_STATE__FOREGROUND = 1;
    public static final int HEALTH_CONNECT_API_CALLED__CALLER_FOREGROUND_STATE__BACKGROUND = 2;

    // Values for HealthConnectUiImpression.page
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__PAGE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__HOME_PAGE = 1;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__ONBOARDING_PAGE = 2;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__RECENT_ACCESS_PAGE = 3;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__APP_PERMISSIONS_PAGE = 4;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__APP_PERMISSIONS_EMPTY_STATE_PAGE = 5;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__HELP_AND_FEEDBACK_PAGE = 6;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__CATEGORIES_PAGE = 7;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__AUTO_DELETE_PAGE = 8;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__PERMISSION_TYPES_PAGE = 9;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__DATA_ACCESS_PAGE = 10;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__DATA_ENTRIES_PAGE = 11;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__ENTRY_DETAILS_PAGE = 12;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__APP_ACCESS_PAGE = 13;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__UNITS_PAGE = 14;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__ALL_CATEGORIES_PAGE = 15;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__REQUEST_PERMISSIONS_PAGE = 16;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__MANAGE_PERMISSIONS_PAGE = 19;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__SETTINGS_MANAGE_PERMISSIONS_PAGE = 20;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__MIGRATION_IN_PROGRESS_PAGE = 21;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__MIGRATION_APP_UPDATE_NEEDED_PAGE = 22;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__MIGRATION_MODULE_UPDATE_NEEDED_PAGE = 23;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__MIGRATION_PAUSED_PAGE = 25;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__MANAGE_DATA_PAGE = 26;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__DATA_SOURCES_PAGE = 27;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__ADD_AN_APP_PAGE = 28;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__DATA_RESTORE_IN_PROGRESS_PAGE = 29;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__ADDITIONAL_ACCESS_PAGE = 30;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__SETTINGS_MANAGE_APP_PERMISSIONS_PAGE = 31;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__SEARCH_APPS_PAGE = 32;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__REQUEST_COMBINED_ADDITIONAL_PERMISSIONS_PAGE = 33;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__REQUEST_BACKGROUND_READ_PERMISSION_PAGE = 34;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__REQUEST_HISTORY_READ_PERMISSION_PAGE = 35;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__BACKUP_AND_RESTORE_PAGE = 36;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__EXPORT_FREQUENCY_PAGE = 37;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__EXPORT_DESTINATION_PAGE = 38;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__EXPORT_SETTINGS_PAGE = 39;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__IMPORT_SOURCE_LOCATION_PAGE = 40;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__ALL_DATA_PAGE = 41;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__TAB_ENTRIES_PAGE = 42;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__TAB_ACCESS_PAGE = 43;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__APP_DATA_PAGE = 44;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__APP_ENTRIES_PAGE = 45;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__ALL_MEDICAL_DATA_PAGE = 46;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__TAB_MEDICAL_ENTRIES_PAGE = 47;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__TAB_MEDICAL_ACCESS_PAGE = 48;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__RAW_FHIR_PAGE = 49;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__REQUEST_MEDICAL_PERMISSIONS_PAGE = 50;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__COMBINED_APP_ACCESS_PAGE = 51;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__MEDICAL_APP_ACCESS_PAGE = 52;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__SETTINGS_MANAGE_COMBINED_APP_PERMISSIONS_PAGE = 53;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__SETTINGS_MANAGE_MEDICAL_APP_PERMISSIONS_PAGE = 54;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__PAGE__REQUEST_WRITE_MEDICAL_PERMISSION_PAGE = 55;

    // Values for HealthConnectUiImpression.element
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ELEMENT_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__APP_PERMISSIONS_BUTTON = 1;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_AND_ACCESS_BUTTON = 2;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEE_ALL_RECENT_ACCESS_BUTTON = 3;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__RECENT_ACCESS_ENTRY = 4;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__BACKUP_DATA_BUTTON = 5;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ONBOARDING_COMPLETED_BUTTON = 6;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ONBOARDING_GO_BACK_BUTTON = 7;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MANAGE_PERMISSIONS_FLOATING_BUTTON = 8;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEARCH_BUTTON = 9;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CONNECTED_APP_BUTTON = 10;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__NOT_CONNECTED_APP_BUTTON = 11;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__INACTIVE_APP_DELETE_BUTTON = 12;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__REMOVE_ALL_APPS_PERMISSIONS_BUTTON = 13;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__HELP_AND_FEEDBACK_BUTTON = 14;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CHECK_FOR_UPDATES_BUTTON = 15;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEE_ALL_COMPATIBLE_APPS_BUTTON = 16;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__INACTIVE_APP_DIALOG_CONTAINER = 18;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__INACTIVE_APP_DIALOG_REMOVE_PERMISSIONS_BUTTON = 19;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__INACTIVE_APP_DIALOG_GO_BACK_BUTTON = 20;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__INACTIVE_APP_DIALOG_DELETE_BUTTON = 21;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DENIED_APPS_BANNER = 22;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DENIED_APPS_SEE_DETAILS_BUTTON = 23;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DENIED_APPS_DIALOG_CONTAINER = 24;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DENIED_APPS_DIALOG_GOT_IT_BUTTON = 25;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__APP_DENIED_DIALOG_CONTAINER = 26;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__APP_DENIED_DIALOG_GOT_IT_BUTTON = 27;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__BLOCKED_APP_DIALOG_CONTAINER = 28;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__BLOCKED_APP_DIALOG_GOT_IT_BUTTON = 29;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CATEGORY_BUTTON = 30;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEE_ALL_CATEGORIES_BUTTON = 31;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_DATA_BUTTON = 32;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_BUTTON = 33;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETE_ALL_DATA_BUTTON = 34;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_THREE_MONTHS_BUTTON = 35;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_EIGHTEEN_MONTHS_BUTTON = 36;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_NEVER_BUTTON = 37;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_DIALOG_CONTAINER = 38;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_DIALOG_CANCEL_BUTTON = 39;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_DIALOG_CONFIRM_BUTTON = 40;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_CONFIRMATION_DIALOG_CONTAINER = 41;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AUTO_DELETE_CONFIRMATION_DIALOG_DONE_BUTTON = 42;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__APP_FILTER_BUTTON = 43;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PERMISSION_TYPE_BUTTON = 44;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SET_APP_PRIORITY_BUTTON = 45;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETE_CATEGORY_DATA_BUTTON = 46;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_ACCESS_APP_BUTTON = 47;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_ACCESS_INACTIVE_APP_BUTTON = 48;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEE_ALL_ENTRIES_BUTTON = 49;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETE_THIS_DATA_BUTTON = 50;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__AGGREGATION_DATA_VIEW = 51;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_ENTRY_VIEW = 52;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_SESSION_ENTRY_BUTTON = 53;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__NEXT_DAY_BUTTON = 54;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PREVIOUS_DAY_BUTTON = 55;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SELECT_DATE_BUTTON = 56;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CHANGE_UNITS_HEIGHT_BUTTON = 57;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CHANGE_UNITS_WEIGHT_BUTTON = 58;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CHANGE_UNITS_DISTANCE_BUTTON = 59;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CHANGE_UNITS_ENERGY_BUTTON = 60;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CHANGE_UNITS_TEMPERATURE_BUTTON = 61;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CANCEL_BUTTON = 62;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CENTIMETERS_BUTTON = 63;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__FEET_AND_INCHES_BUTTON = 64;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__KILOGRAMS_BUTTON = 65;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__POUNDS_BUTTON = 66;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__STONES_BUTTON = 67;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__KILOMETERS_BUTTON = 68;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MILES_BUTTON = 69;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CALORIES_BUTTON = 70;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__KILOJOULES_BUTTON = 71;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CELSIUS_BUTTON = 72;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__FAHRENHEIT_BUTTON = 73;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__KELVIN_BUTTON = 74;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ALLOW_ALL_PERMISSIONS_SWITCH_ACTIVE = 75;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ALLOW_ALL_PERMISSIONS_SWITCH_INACTIVE = 76;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PERMISSION_SWITCH_ACTIVE = 77;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PERMISSION_SWITCH_INACTIVE = 78;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETE_APP_DATA_BUTTON = 79;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PRIVACY_POLICY_LINK = 80;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISCONNECT_APP_DIALOG_CONTAINER = 81;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISCONNECT_APP_DIALOG_CANCEL_BUTTON = 82;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISCONNECT_APP_DIALOG_CONFIRM_BUTTON = 83;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISCONNECT_APP_DIALOG_DELETE_CHECKBOX = 84;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISCONNECT_ALL_APPS_DIALOG_CONTAINER = 85;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISCONNECT_ALL_APPS_DIALOG_CANCEL_BUTTON = 86;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISCONNECT_ALL_APPS_DIALOG_REMOVE_ALL_BUTTON = 87;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ALLOW_PERMISSIONS_BUTTON = 88;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CANCEL_PERMISSIONS_BUTTON = 89;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ALLOW_ALL_SWITCH = 90;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PERMISSION_SWITCH = 91;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__APP_RATIONALE_LINK = 92;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_TIME_RANGE_CONTAINER = 93;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_TIME_RANGE_LAST_24_HOURS_BUTTON = 94;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_TIME_RANGE_LAST_7_DAYS_BUTTON = 95;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_TIME_RANGE_LAST_30_DAYS_BUTTON = 96;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_TIME_RANGE_ALL_DATA_BUTTON = 97;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_TIME_RANGE_CANCEL_BUTTON = 98;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_TIME_RANGE_NEXT_BUTTON = 99;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_CONFIRMATION_CONTAINER = 100;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_CONFIRMATION_GO_BACK_BUTTON = 101;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_CONFIRMATION_CANCEL_BUTTON = 102;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_CONFIRMATION_DELETE_BUTTON = 103;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_CONFIRMATION_REMOVE_APP_PERMISSIONS_BUTTON = 104;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_IN_PROGRESS_CONTAINER = 105;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_SUCCESS_CONTAINER = 106;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_SUCCESS_DONE_BUTTON = 107;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_ERROR_CONTAINER = 108;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_ERROR_CLOSE_BUTTON = 109;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETION_DIALOG_ERROR_TRY_AGAIN_BUTTON = 110;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__TOOLBAR_HELP_BUTTON = 111;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__TOOLBAR_SETTINGS_BUTTON = 113;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__TOOLBAR_OPEN_SOURCE_LICENSE_BUTTON = 114;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_ENTRY_DELETE_BUTTON = 117;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SLEEP_SESSION_ENTRY_BUTTON = 118;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_SESSION_ENTRY_DETAILS_VIEW = 119;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SLEEP_SESSION_ENTRY_DETAILS_VIEW = 120;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SESSION_DETAIL_ENTRY_VIEW = 121;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SESSION_DETAIL_HEADER_VIEW = 122;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTE_DIALOG_CONTAINER = 123;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTE_DIALOG_INFORMATION_BUTTON = 124;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTE_DIALOG_ROUTE_VIEW = 125;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTE_DIALOG_ALLOW_BUTTON = 126;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTE_DIALOG_DONT_ALLOW_BUTTON = 127;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTE_EDUCATION_DIALOG_CONTAINER = 128;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTE_EDUCATION_DIALOG_BACK_BUTTON = 129;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SET_APP_PRIORITY_DIALOG_CONTAINER = 130;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SET_APP_PRIORITY_DIALOG_CANCEL_BUTTON = 131;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SET_APP_PRIORITY_DIALOG_SAVE_BUTTON = 132;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_UPDATE_NEEDED_UPDATE_BUTTON = 133;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_UPDATE_NEEDED_CANCEL_BUTTON = 134;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_DONE_DIALOG_CONTAINER = 137;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_DONE_DIALOG_BUTTON = 138;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_IN_PROGRESS_DIALOG_CONTAINER = 139;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_IN_PROGRESS_DIALOG_BUTTON = 140;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_PENDING_DIALOG_CONTAINER = 141;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_PENDING_DIALOG_CANCEL_BUTTON = 142;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_PENDING_DIALOG_CONTINUE_BUTTON = 143;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_NOT_COMPLETE_DIALOG_CONTAINER = 144;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_NOT_COMPLETE_DIALOG_BUTTON = 145;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_RESUME_BANNER = 146;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_RESUME_BANNER_BUTTON = 147;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_APP_UPDATE_BANNER = 148;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_APP_UPDATE_BUTTON = 149;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__LOADING_PAGE_STATE = 150;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ERROR_PAGE_STATE = 151;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__WITH_DATA_PAGE_STATE = 152;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MANAGE_DATA_BUTTON = 153;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_SOURCES_AND_PRIORITY_BUTTON = 154;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SET_UNITS_BUTTON = 155;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_TYPE_SPINNER_BUTTON = 156;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_TOTALS_CARD = 157;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__APP_SOURCE_BUTTON = 158;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ADD_AN_APP_BUTTON = 159;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EDIT_SOURCE_LIST_BUTTON = 160;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__POTENTIAL_PRIORITY_APP_BUTTON = 161;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__REORDER_APP_SOURCE_BUTTON = 162;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__REMOVE_APP_SOURCE_BUTTON = 163;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_UPDATE_NEEDED_BANNER = 164;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_UPDATE_NEEDED_BANNER_UPDATE_BUTTON = 165;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_UPDATE_NEEDED_CANCEL_RESTORE_BUTTON = 166;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_FAILED_BANNER = 167;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_FAILED_BANNER_BUTTON = 168;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_CANCEL_DIALOG = 169;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_CANCEL_DIALOG_CANCEL_BUTTON = 170;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_CANCEL_DIALOG_CONTINUE_BUTTON = 171;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_SUCCESS_SNACKBAR = 172;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_APP_UPDATE_APP_BUTTON = 173;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_APP_UPDATE_LEARN_MORE_BUTTON = 174;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ADDITIONAL_ACCESS_BUTTON = 175;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTES_BUTTON = 176;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTES_DIALOG_ALLOW_ALL_BUTTON = 177;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTES_DIALOG_ASK_BUTTON = 178;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTES_DIALOG_DENY_BUTTON = 179;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTES_DIALOG_CONTAINER = 180;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_APP_UPDATE_DISMISS_BUTTON = 181;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_IN_PROGRESS_DIALOG_CONTAINER = 182;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_RESTORE_IN_PROGRESS_DIALOG_BUTTON = 183;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_PAUSED_CONTINUE_BUTTON = 184;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MIGRATION_PAUSED_CANCEL_BUTTON = 185;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_SESSION_MAP_VIEW = 186;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__INACTIVE_APP_BUTTON = 187;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEND_FEEDBACK_BUTTON = 188;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ENABLE_EXERCISE_PERMISSION_DIALOG_CONTAINER = 189;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ENABLE_EXERCISE_PERMISSION_DIALOG_POSITIVE_BUTTON = 190;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ENABLE_EXERCISE_PERMISSION_DIALOG_NEGATIVE_BUTTON = 191;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISABLE_EXERCISE_PERMISSION_DIALOG_CONTAINER = 192;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISABLE_EXERCISE_PERMISSION_DIALOG_POSITIVE_BUTTON = 193;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISABLE_EXERCISE_PERMISSION_DIALOG_NEGATIVE_BUTTON = 194;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_ROUTE_DIALOG_ALWAYS_ALLOW_BUTTON = 195;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__REVERSE_SESSION_DETAIL_ENTRY_VIEW = 196;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__FORMATTED_SECTION_TITLE_VIEW = 197;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ALLOW_COMBINED_ADDITIONAL_PERMISSIONS_BUTTON = 198;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CANCEL_COMBINED_ADDITIONAL_PERMISSIONS_BUTTON = 199;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ALLOW_BACKGROUND_READ_BUTTON = 200;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CANCEL_BACKGROUND_READ_BUTTON = 201;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ALLOW_HISTORY_READ_BUTTON = 202;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CANCEL_HISTORY_READ_BUTTON = 203;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__BACKGROUND_READ_BUTTON = 204;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__HISTORY_READ_BUTTON = 205;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__FORMATTED_SECTION_CONTENT_VIEW = 207;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXERCISE_PERFORMANCE_GOAL_ENTRY_VIEW = 208;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PLANNED_EXERCISE_SESSION_ENTRY_BUTTON = 209;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PLANNED_EXERCISE_BLOCK_ENTRY_VIEW = 210;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PLANNED_EXERCISE_STEP_ENTRY_VIEW = 211;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__BACKUP_AND_RESTORE_BUTTON = 212;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SCHEDULED_EXPORT_BUTTON = 213;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__RESTORE_DATA_BUTTON = 214;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_FREQUENCY_DAILY_BUTTON = 215;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_FREQUENCY_WEEKLY_BUTTON = 216;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_FREQUENCY_MONTHLY_BUTTON = 217;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_FREQUENCY_BACK_BUTTON = 218;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_FREQUENCY_NEXT_BUTTON = 219;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_DESTINATION_BACK_BUTTON = 220;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_DESTINATION_NEXT_BUTTON = 221;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_DESTINATION_DOCUMENT_PROVIDER_BUTTON = 222;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_SOURCE_LOCATION_CANCEL_BUTTON = 223;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_SOURCE_LOCATION_NEXT_BUTTON = 224;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_SOURCE_LOCATION_DOCUMENT_PROVIDER_BUTTON = 225;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_CONFIRMATION_CANCEL_BUTTON = 226;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_CONFIRMATION_DONE_BUTTON = 227;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_CONFIRMATION_CONTAINER = 228;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_ERROR_BANNER = 229;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_GENERAL_ERROR_BANNER = 230;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_VERSION_MISMATCH_ERROR_BANNER = 231;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_WRONG_FILE_ERROR_BANNER = 232;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_CONTROL_SWITCH_ON = 233;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_CONTROL_SWITCH_OFF = 234;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_SETTINGS_FREQUENCY_DAILY = 235;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_SETTINGS_FREQUENCY_WEEKLY = 236;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_SETTINGS_FREQUENCY_MONTHLY = 237;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXPORT_ERROR_BANNER_BUTTON = 238;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_GENERAL_ERROR_BANNER_BUTTON = 239;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_VERSION_MISMATCH_ERROR_BANNER_BUTTON = 240;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__IMPORT_WRONG_FILE_ERROR_BANNER_BUTTON = 241;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__BROWSE_DATA_BUTTON = 242;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PERMISSION_TYPE_BUTTON_WITH_CHECKBOX = 243;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__PERMISSION_TYPE_BUTTON_NO_CHECKBOX = 244;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SELECT_ALL_BUTTON = 245;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SUCCESS_DELETION_DIALOG_SEE_CONNECTED_APPS_BUTTON = 246;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATA_SOURCES_MENU_BUTTON = 247;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ENTER_DELETION_STATE_MENU_BUTTON = 248;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__EXIT_DELETION_STATE_MENU_BUTTON = 249;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DELETE_MENU_BUTTON = 250;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ENTRY_BUTTON_WITH_CHECKBOX = 251;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ENTRY_BUTTON_NO_CHECKBOX = 252;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATE_VIEW_SPINNER_DAY = 253;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATE_VIEW_SPINNER_WEEK = 254;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DATE_VIEW_SPINNER_YEAR = 255;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEE_APP_DATA_BUTTON = 256;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_BANNER = 257;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_BANNER_BUTTON = 258;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_HEALTH_PREFERENCE = 259;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_DIALOG = 260;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_DIALOG_POSITIVE_BUTTON = 261;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_DIALOG_NEGATIVE_BUTTON = 262;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_DIALOG_NEUTRAL_BUTTON = 263;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_SWITCH_ACTIVE_PREFERENCE = 264;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_SWITCH_INACTIVE_PREFERENCE = 265;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__UNKNOWN_BUTTON = 266;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__START_USING_HC_BANNER = 267;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__START_USING_HC_BANNER_DISMISS_BUTTON = 268;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__START_USING_HC_BANNER_SET_UP_BUTTON = 269;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CONNECT_MORE_APPS_BANNER = 270;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CONNECT_MORE_APPS_BANNER_DISMISS_BUTTON = 271;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CONNECT_MORE_APPS_BANNER_SET_UP_BUTTON = 272;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEE_COMPATIBLE_APPS_BANNER = 273;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEE_COMPATIBLE_APPS_BANNER_DISMISS_BUTTON = 274;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__SEE_COMPATIBLE_APPS_BANNER_APP_STORE_BUTTON = 275;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ONBOARDING_MESSAGE_WITH_PHR = 276;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__BROWSE_HEALTH_RECORDS_BUTTON = 277;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__FITNESS_PERMISSIONS_BUTTON = 279;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__MEDICAL_PERMISSIONS_BUTTON = 280;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__REMOVE_ALL_PERMISSIONS_BUTTON = 281;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__LOCK_SCREEN_BANNER = 282;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__LOCK_SCREEN_BANNER_BUTTON = 283;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__LOCK_SCREEN_BANNER_DISMISS_BUTTON = 284;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__RAW_FHIR_RESOURCE = 285;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__ALLOW_WRITE_HEALTH_RECORDS_BUTTON = 286;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__CANCEL_WRITE_HEALTH_RECORDS_BUTTON = 287;
    public static final int HEALTH_CONNECT_UI_IMPRESSION__ELEMENT__DISCONNECT_ALL_APPS_DIALOG_DELETE_CHECKBOX = 288;

    // Values for HealthConnectUiInteraction.page
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__PAGE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__HOME_PAGE = 1;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__ONBOARDING_PAGE = 2;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__RECENT_ACCESS_PAGE = 3;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__APP_PERMISSIONS_PAGE = 4;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__APP_PERMISSIONS_EMPTY_STATE_PAGE = 5;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__HELP_AND_FEEDBACK_PAGE = 6;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__CATEGORIES_PAGE = 7;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__AUTO_DELETE_PAGE = 8;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__PERMISSION_TYPES_PAGE = 9;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__DATA_ACCESS_PAGE = 10;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__DATA_ENTRIES_PAGE = 11;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__ENTRY_DETAILS_PAGE = 12;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__APP_ACCESS_PAGE = 13;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__UNITS_PAGE = 14;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__ALL_CATEGORIES_PAGE = 15;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__REQUEST_PERMISSIONS_PAGE = 16;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__MANAGE_PERMISSIONS_PAGE = 19;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__SETTINGS_MANAGE_PERMISSIONS_PAGE = 20;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__MIGRATION_IN_PROGRESS_PAGE = 21;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__MIGRATION_APP_UPDATE_NEEDED_PAGE = 22;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__MIGRATION_MODULE_UPDATE_NEEDED_PAGE = 23;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__MIGRATION_PAUSED_PAGE = 25;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__MANAGE_DATA_PAGE = 26;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__DATA_SOURCES_PAGE = 27;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__ADD_AN_APP_PAGE = 28;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__DATA_RESTORE_IN_PROGRESS_PAGE = 29;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__ADDITIONAL_ACCESS_PAGE = 30;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__SETTINGS_MANAGE_APP_PERMISSIONS_PAGE = 31;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__SEARCH_APPS_PAGE = 32;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__REQUEST_COMBINED_ADDITIONAL_PERMISSIONS_PAGE = 33;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__REQUEST_BACKGROUND_READ_PERMISSION_PAGE = 34;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__REQUEST_HISTORY_READ_PERMISSION_PAGE = 35;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__BACKUP_AND_RESTORE_PAGE = 36;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__EXPORT_FREQUENCY_PAGE = 37;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__EXPORT_DESTINATION_PAGE = 38;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__EXPORT_SETTINGS_PAGE = 39;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__IMPORT_SOURCE_LOCATION_PAGE = 40;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__ALL_DATA_PAGE = 41;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__TAB_ENTRIES_PAGE = 42;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__TAB_ACCESS_PAGE = 43;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__APP_DATA_PAGE = 44;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__APP_ENTRIES_PAGE = 45;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__ALL_MEDICAL_DATA_PAGE = 46;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__TAB_MEDICAL_ENTRIES_PAGE = 47;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__TAB_MEDICAL_ACCESS_PAGE = 48;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__RAW_FHIR_PAGE = 49;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__REQUEST_MEDICAL_PERMISSIONS_PAGE = 50;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__COMBINED_APP_ACCESS_PAGE = 51;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__MEDICAL_APP_ACCESS_PAGE = 52;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__SETTINGS_MANAGE_COMBINED_APP_PERMISSIONS_PAGE = 53;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__SETTINGS_MANAGE_MEDICAL_APP_PERMISSIONS_PAGE = 54;
    public static final int HEALTH_CONNECT_UI_INTERACTION__PAGE__REQUEST_WRITE_MEDICAL_PERMISSION_PAGE = 55;

    // Values for HealthConnectUiInteraction.element
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ELEMENT_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__APP_PERMISSIONS_BUTTON = 1;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_AND_ACCESS_BUTTON = 2;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEE_ALL_RECENT_ACCESS_BUTTON = 3;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__RECENT_ACCESS_ENTRY = 4;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__BACKUP_DATA_BUTTON = 5;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ONBOARDING_COMPLETED_BUTTON = 6;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ONBOARDING_GO_BACK_BUTTON = 7;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MANAGE_PERMISSIONS_FLOATING_BUTTON = 8;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEARCH_BUTTON = 9;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CONNECTED_APP_BUTTON = 10;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__NOT_CONNECTED_APP_BUTTON = 11;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__INACTIVE_APP_DELETE_BUTTON = 12;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__REMOVE_ALL_APPS_PERMISSIONS_BUTTON = 13;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__HELP_AND_FEEDBACK_BUTTON = 14;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CHECK_FOR_UPDATES_BUTTON = 15;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEE_ALL_COMPATIBLE_APPS_BUTTON = 16;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__INACTIVE_APP_DIALOG_CONTAINER = 18;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__INACTIVE_APP_DIALOG_REMOVE_PERMISSIONS_BUTTON = 19;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__INACTIVE_APP_DIALOG_GO_BACK_BUTTON = 20;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__INACTIVE_APP_DIALOG_DELETE_BUTTON = 21;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DENIED_APPS_BANNER = 22;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DENIED_APPS_SEE_DETAILS_BUTTON = 23;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DENIED_APPS_DIALOG_CONTAINER = 24;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DENIED_APPS_DIALOG_GOT_IT_BUTTON = 25;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__APP_DENIED_DIALOG_CONTAINER = 26;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__APP_DENIED_DIALOG_GOT_IT_BUTTON = 27;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__BLOCKED_APP_DIALOG_CONTAINER = 28;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__BLOCKED_APP_DIALOG_GOT_IT_BUTTON = 29;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CATEGORY_BUTTON = 30;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEE_ALL_CATEGORIES_BUTTON = 31;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_DATA_BUTTON = 32;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_BUTTON = 33;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETE_ALL_DATA_BUTTON = 34;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_THREE_MONTHS_BUTTON = 35;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_EIGHTEEN_MONTHS_BUTTON = 36;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_NEVER_BUTTON = 37;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_DIALOG_CONTAINER = 38;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_DIALOG_CANCEL_BUTTON = 39;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_DIALOG_CONFIRM_BUTTON = 40;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_CONFIRMATION_DIALOG_CONTAINER = 41;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AUTO_DELETE_CONFIRMATION_DIALOG_DONE_BUTTON = 42;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__APP_FILTER_BUTTON = 43;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PERMISSION_TYPE_BUTTON = 44;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SET_APP_PRIORITY_BUTTON = 45;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETE_CATEGORY_DATA_BUTTON = 46;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_ACCESS_APP_BUTTON = 47;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_ACCESS_INACTIVE_APP_BUTTON = 48;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEE_ALL_ENTRIES_BUTTON = 49;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETE_THIS_DATA_BUTTON = 50;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__AGGREGATION_DATA_VIEW = 51;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_ENTRY_VIEW = 52;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_SESSION_ENTRY_BUTTON = 53;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__NEXT_DAY_BUTTON = 54;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PREVIOUS_DAY_BUTTON = 55;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SELECT_DATE_BUTTON = 56;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CHANGE_UNITS_HEIGHT_BUTTON = 57;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CHANGE_UNITS_WEIGHT_BUTTON = 58;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CHANGE_UNITS_DISTANCE_BUTTON = 59;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CHANGE_UNITS_ENERGY_BUTTON = 60;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CHANGE_UNITS_TEMPERATURE_BUTTON = 61;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CANCEL_BUTTON = 62;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CENTIMETERS_BUTTON = 63;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__FEET_AND_INCHES_BUTTON = 64;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__KILOGRAMS_BUTTON = 65;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__POUNDS_BUTTON = 66;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__STONES_BUTTON = 67;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__KILOMETERS_BUTTON = 68;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MILES_BUTTON = 69;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CALORIES_BUTTON = 70;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__KILOJOULES_BUTTON = 71;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CELSIUS_BUTTON = 72;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__FAHRENHEIT_BUTTON = 73;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__KELVIN_BUTTON = 74;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ALLOW_ALL_PERMISSIONS_SWITCH_ACTIVE = 75;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ALLOW_ALL_PERMISSIONS_SWITCH_INACTIVE = 76;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PERMISSION_SWITCH_ACTIVE = 77;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PERMISSION_SWITCH_INACTIVE = 78;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETE_APP_DATA_BUTTON = 79;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PRIVACY_POLICY_LINK = 80;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISCONNECT_APP_DIALOG_CONTAINER = 81;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISCONNECT_APP_DIALOG_CANCEL_BUTTON = 82;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISCONNECT_APP_DIALOG_CONFIRM_BUTTON = 83;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISCONNECT_APP_DIALOG_DELETE_CHECKBOX = 84;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISCONNECT_ALL_APPS_DIALOG_CONTAINER = 85;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISCONNECT_ALL_APPS_DIALOG_CANCEL_BUTTON = 86;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISCONNECT_ALL_APPS_DIALOG_REMOVE_ALL_BUTTON = 87;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ALLOW_PERMISSIONS_BUTTON = 88;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CANCEL_PERMISSIONS_BUTTON = 89;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ALLOW_ALL_SWITCH = 90;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PERMISSION_SWITCH = 91;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__APP_RATIONALE_LINK = 92;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_TIME_RANGE_CONTAINER = 93;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_TIME_RANGE_LAST_24_HOURS_BUTTON = 94;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_TIME_RANGE_LAST_7_DAYS_BUTTON = 95;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_TIME_RANGE_LAST_30_DAYS_BUTTON = 96;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_TIME_RANGE_ALL_DATA_BUTTON = 97;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_TIME_RANGE_CANCEL_BUTTON = 98;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_TIME_RANGE_NEXT_BUTTON = 99;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_CONFIRMATION_CONTAINER = 100;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_CONFIRMATION_GO_BACK_BUTTON = 101;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_CONFIRMATION_CANCEL_BUTTON = 102;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_CONFIRMATION_DELETE_BUTTON = 103;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_CONFIRMATION_REMOVE_APP_PERMISSIONS_BUTTON = 104;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_IN_PROGRESS_CONTAINER = 105;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_SUCCESS_CONTAINER = 106;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_SUCCESS_DONE_BUTTON = 107;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_ERROR_CONTAINER = 108;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_ERROR_CLOSE_BUTTON = 109;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETION_DIALOG_ERROR_TRY_AGAIN_BUTTON = 110;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__TOOLBAR_HELP_BUTTON = 111;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__TOOLBAR_SETTINGS_BUTTON = 113;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__TOOLBAR_OPEN_SOURCE_LICENSE_BUTTON = 114;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_ENTRY_DELETE_BUTTON = 117;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SLEEP_SESSION_ENTRY_BUTTON = 118;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_SESSION_ENTRY_DETAILS_VIEW = 119;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SLEEP_SESSION_ENTRY_DETAILS_VIEW = 120;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SESSION_DETAIL_ENTRY_VIEW = 121;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SESSION_DETAIL_HEADER_VIEW = 122;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTE_DIALOG_CONTAINER = 123;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTE_DIALOG_INFORMATION_BUTTON = 124;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTE_DIALOG_ROUTE_VIEW = 125;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTE_DIALOG_ALLOW_BUTTON = 126;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTE_DIALOG_DONT_ALLOW_BUTTON = 127;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTE_EDUCATION_DIALOG_CONTAINER = 128;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTE_EDUCATION_DIALOG_BACK_BUTTON = 129;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SET_APP_PRIORITY_DIALOG_CONTAINER = 130;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SET_APP_PRIORITY_DIALOG_CANCEL_BUTTON = 131;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SET_APP_PRIORITY_DIALOG_SAVE_BUTTON = 132;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_UPDATE_NEEDED_UPDATE_BUTTON = 133;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_UPDATE_NEEDED_CANCEL_BUTTON = 134;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_DONE_DIALOG_CONTAINER = 137;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_DONE_DIALOG_BUTTON = 138;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_IN_PROGRESS_DIALOG_CONTAINER = 139;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_IN_PROGRESS_DIALOG_BUTTON = 140;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_PENDING_DIALOG_CONTAINER = 141;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_PENDING_DIALOG_CANCEL_BUTTON = 142;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_PENDING_DIALOG_CONTINUE_BUTTON = 143;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_NOT_COMPLETE_DIALOG_CONTAINER = 144;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_NOT_COMPLETE_DIALOG_BUTTON = 145;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_RESUME_BANNER = 146;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_RESUME_BANNER_BUTTON = 147;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_APP_UPDATE_BANNER = 148;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_APP_UPDATE_BUTTON = 149;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__LOADING_PAGE_STATE = 150;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ERROR_PAGE_STATE = 151;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__WITH_DATA_PAGE_STATE = 152;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MANAGE_DATA_BUTTON = 153;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_SOURCES_AND_PRIORITY_BUTTON = 154;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SET_UNITS_BUTTON = 155;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_TYPE_SPINNER_BUTTON = 156;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_TOTALS_CARD = 157;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__APP_SOURCE_BUTTON = 158;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ADD_AN_APP_BUTTON = 159;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EDIT_SOURCE_LIST_BUTTON = 160;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__POTENTIAL_PRIORITY_APP_BUTTON = 161;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__REORDER_APP_SOURCE_BUTTON = 162;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__REMOVE_APP_SOURCE_BUTTON = 163;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_UPDATE_NEEDED_BANNER = 164;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_UPDATE_NEEDED_BANNER_UPDATE_BUTTON = 165;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_UPDATE_NEEDED_CANCEL_RESTORE_BUTTON = 166;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_FAILED_BANNER = 167;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_FAILED_BANNER_BUTTON = 168;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_CANCEL_DIALOG = 169;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_CANCEL_DIALOG_CANCEL_BUTTON = 170;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_CANCEL_DIALOG_CONTINUE_BUTTON = 171;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_SUCCESS_SNACKBAR = 172;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_APP_UPDATE_APP_BUTTON = 173;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_APP_UPDATE_LEARN_MORE_BUTTON = 174;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ADDITIONAL_ACCESS_BUTTON = 175;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTES_BUTTON = 176;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTES_DIALOG_ALLOW_ALL_BUTTON = 177;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTES_DIALOG_ASK_BUTTON = 178;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTES_DIALOG_DENY_BUTTON = 179;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTES_DIALOG_CONTAINER = 180;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_APP_UPDATE_DISMISS_BUTTON = 181;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_IN_PROGRESS_DIALOG_CONTAINER = 182;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_RESTORE_IN_PROGRESS_DIALOG_BUTTON = 183;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_PAUSED_CONTINUE_BUTTON = 184;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MIGRATION_PAUSED_CANCEL_BUTTON = 185;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_SESSION_MAP_VIEW = 186;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__INACTIVE_APP_BUTTON = 187;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEND_FEEDBACK_BUTTON = 188;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ENABLE_EXERCISE_PERMISSION_DIALOG_CONTAINER = 189;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ENABLE_EXERCISE_PERMISSION_DIALOG_POSITIVE_BUTTON = 190;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ENABLE_EXERCISE_PERMISSION_DIALOG_NEGATIVE_BUTTON = 191;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISABLE_EXERCISE_PERMISSION_DIALOG_CONTAINER = 192;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISABLE_EXERCISE_PERMISSION_DIALOG_POSITIVE_BUTTON = 193;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISABLE_EXERCISE_PERMISSION_DIALOG_NEGATIVE_BUTTON = 194;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_ROUTE_DIALOG_ALWAYS_ALLOW_BUTTON = 195;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__REVERSE_SESSION_DETAIL_ENTRY_VIEW = 196;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__FORMATTED_SECTION_TITLE_VIEW = 197;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ALLOW_COMBINED_ADDITIONAL_PERMISSIONS_BUTTON = 198;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CANCEL_COMBINED_ADDITIONAL_PERMISSIONS_BUTTON = 199;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ALLOW_BACKGROUND_READ_BUTTON = 200;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CANCEL_BACKGROUND_READ_BUTTON = 201;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ALLOW_HISTORY_READ_BUTTON = 202;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CANCEL_HISTORY_READ_BUTTON = 203;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__BACKGROUND_READ_BUTTON = 204;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__HISTORY_READ_BUTTON = 205;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__FORMATTED_SECTION_CONTENT_VIEW = 207;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXERCISE_PERFORMANCE_GOAL_ENTRY_VIEW = 208;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PLANNED_EXERCISE_SESSION_ENTRY_BUTTON = 209;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PLANNED_EXERCISE_BLOCK_ENTRY_VIEW = 210;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PLANNED_EXERCISE_STEP_ENTRY_VIEW = 211;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__BACKUP_AND_RESTORE_BUTTON = 212;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SCHEDULED_EXPORT_BUTTON = 213;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__RESTORE_DATA_BUTTON = 214;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_FREQUENCY_DAILY_BUTTON = 215;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_FREQUENCY_WEEKLY_BUTTON = 216;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_FREQUENCY_MONTHLY_BUTTON = 217;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_FREQUENCY_BACK_BUTTON = 218;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_FREQUENCY_NEXT_BUTTON = 219;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_DESTINATION_BACK_BUTTON = 220;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_DESTINATION_NEXT_BUTTON = 221;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_DESTINATION_DOCUMENT_PROVIDER_BUTTON = 222;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_SOURCE_LOCATION_CANCEL_BUTTON = 223;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_SOURCE_LOCATION_NEXT_BUTTON = 224;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_SOURCE_LOCATION_DOCUMENT_PROVIDER_BUTTON = 225;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_CONFIRMATION_CANCEL_BUTTON = 226;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_CONFIRMATION_DONE_BUTTON = 227;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_CONFIRMATION_CONTAINER = 228;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_ERROR_BANNER = 229;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_GENERAL_ERROR_BANNER = 230;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_VERSION_MISMATCH_ERROR_BANNER = 231;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_WRONG_FILE_ERROR_BANNER = 232;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_CONTROL_SWITCH_ON = 233;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_CONTROL_SWITCH_OFF = 234;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_SETTINGS_FREQUENCY_DAILY = 235;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_SETTINGS_FREQUENCY_WEEKLY = 236;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_SETTINGS_FREQUENCY_MONTHLY = 237;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXPORT_ERROR_BANNER_BUTTON = 238;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_GENERAL_ERROR_BANNER_BUTTON = 239;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_VERSION_MISMATCH_ERROR_BANNER_BUTTON = 240;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__IMPORT_WRONG_FILE_ERROR_BANNER_BUTTON = 241;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__BROWSE_DATA_BUTTON = 242;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PERMISSION_TYPE_BUTTON_WITH_CHECKBOX = 243;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__PERMISSION_TYPE_BUTTON_NO_CHECKBOX = 244;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SELECT_ALL_BUTTON = 245;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SUCCESS_DELETION_DIALOG_SEE_CONNECTED_APPS_BUTTON = 246;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATA_SOURCES_MENU_BUTTON = 247;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ENTER_DELETION_STATE_MENU_BUTTON = 248;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__EXIT_DELETION_STATE_MENU_BUTTON = 249;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DELETE_MENU_BUTTON = 250;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ENTRY_BUTTON_WITH_CHECKBOX = 251;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ENTRY_BUTTON_NO_CHECKBOX = 252;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATE_VIEW_SPINNER_DAY = 253;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATE_VIEW_SPINNER_WEEK = 254;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DATE_VIEW_SPINNER_YEAR = 255;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEE_APP_DATA_BUTTON = 256;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_BANNER = 257;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_BANNER_BUTTON = 258;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_HEALTH_PREFERENCE = 259;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_DIALOG = 260;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_DIALOG_POSITIVE_BUTTON = 261;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_DIALOG_NEGATIVE_BUTTON = 262;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_DIALOG_NEUTRAL_BUTTON = 263;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_SWITCH_ACTIVE_PREFERENCE = 264;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_SWITCH_INACTIVE_PREFERENCE = 265;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__UNKNOWN_BUTTON = 266;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__START_USING_HC_BANNER = 267;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__START_USING_HC_BANNER_DISMISS_BUTTON = 268;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__START_USING_HC_BANNER_SET_UP_BUTTON = 269;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CONNECT_MORE_APPS_BANNER = 270;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CONNECT_MORE_APPS_BANNER_DISMISS_BUTTON = 271;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CONNECT_MORE_APPS_BANNER_SET_UP_BUTTON = 272;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEE_COMPATIBLE_APPS_BANNER = 273;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEE_COMPATIBLE_APPS_BANNER_DISMISS_BUTTON = 274;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__SEE_COMPATIBLE_APPS_BANNER_APP_STORE_BUTTON = 275;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ONBOARDING_MESSAGE_WITH_PHR = 276;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__BROWSE_HEALTH_RECORDS_BUTTON = 277;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__FITNESS_PERMISSIONS_BUTTON = 279;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__MEDICAL_PERMISSIONS_BUTTON = 280;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__REMOVE_ALL_PERMISSIONS_BUTTON = 281;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__LOCK_SCREEN_BANNER = 282;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__LOCK_SCREEN_BANNER_BUTTON = 283;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__LOCK_SCREEN_BANNER_DISMISS_BUTTON = 284;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__RAW_FHIR_RESOURCE = 285;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__ALLOW_WRITE_HEALTH_RECORDS_BUTTON = 286;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__CANCEL_WRITE_HEALTH_RECORDS_BUTTON = 287;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ELEMENT__DISCONNECT_ALL_APPS_DIALOG_DELETE_CHECKBOX = 288;

    // Values for HealthConnectUiInteraction.action
    public static final int HEALTH_CONNECT_UI_INTERACTION__ACTION__ACTION_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ACTION__ACTION_CLICK = 1;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ACTION__ACTION_TOGGLE_ON = 2;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ACTION__ACTION_TOGGLE_OFF = 3;
    public static final int HEALTH_CONNECT_UI_INTERACTION__ACTION__ACTION_DISMISS = 4;

    // Values for HealthConnectAppOpenedReported.source
    public static final int HEALTH_CONNECT_APP_OPENED_REPORTED__SOURCE__SOURCE_UNKNOWN_ENTRY_POINT = 0;
    public static final int HEALTH_CONNECT_APP_OPENED_REPORTED__SOURCE__SOURCE_DEEP_LINK = 1;
    public static final int HEALTH_CONNECT_APP_OPENED_REPORTED__SOURCE__SOURCE_DYNAMIC_SETTINGS = 2;
    public static final int HEALTH_CONNECT_APP_OPENED_REPORTED__SOURCE__SOURCE_QUICK_SETTINGS = 3;
    public static final int HEALTH_CONNECT_APP_OPENED_REPORTED__SOURCE__SOURCE_MAIN_ACTION = 4;

    // Values for HealthConnectApiInvoked.api_method
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__API_METHOD_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__DELETE_DATA = 1;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__GET_CHANGES = 2;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__GET_CHANGES_TOKEN = 3;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__GET_GRANTED_PERMISSIONS = 4;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__INSERT_DATA = 5;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__READ_AGGREGATED_DATA = 6;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__READ_DATA = 7;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__REVOKE_ALL_PERMISSIONS = 8;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__UPDATE_DATA = 9;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__CREATE_MEDICAL_DATA_SOURCE = 10;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__GET_MEDICAL_DATA_SOURCES_BY_IDS = 11;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__GET_MEDICAL_DATA_SOURCES_BY_REQUESTS = 12;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__DELETE_MEDICAL_DATA_SOURCE_WITH_DATA = 13;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__UPSERT_MEDICAL_RESOURCES = 14;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__READ_MEDICAL_RESOURCES_BY_IDS = 15;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__READ_MEDICAL_RESOURCES_BY_REQUESTS = 16;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__DELETE_MEDICAL_RESOURCES_BY_IDS = 17;
    public static final int HEALTH_CONNECT_API_INVOKED__API_METHOD__DELETE_MEDICAL_RESOURCES_BY_REQUESTS = 18;

    // Values for HealthConnectApiInvoked.api_status
    public static final int HEALTH_CONNECT_API_INVOKED__API_STATUS__STATUS_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_INVOKED__API_STATUS__SUCCESS = 1;
    public static final int HEALTH_CONNECT_API_INVOKED__API_STATUS__ERROR = 2;

    // Values for HealthConnectApiInvoked.data_type_one
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__DISTANCE = 12;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__HEIGHT = 17;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__HYDRATION = 18;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__NUTRITION = 21;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__POWER = 24;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__SPEED = 28;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__STEPS = 29;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__WEIGHT = 33;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_ONE__NICOTINE_INTAKE = 44;

    // Values for HealthConnectApiInvoked.data_type_two
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__DISTANCE = 12;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__HEIGHT = 17;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__HYDRATION = 18;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__NUTRITION = 21;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__POWER = 24;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__SPEED = 28;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__STEPS = 29;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__WEIGHT = 33;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_TWO__NICOTINE_INTAKE = 44;

    // Values for HealthConnectApiInvoked.data_type_three
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__DISTANCE = 12;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__HEIGHT = 17;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__HYDRATION = 18;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__NUTRITION = 21;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__POWER = 24;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__SPEED = 28;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__STEPS = 29;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__WEIGHT = 33;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_THREE__NICOTINE_INTAKE = 44;

    // Values for HealthConnectApiInvoked.data_type_four
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__DISTANCE = 12;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__HEIGHT = 17;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__HYDRATION = 18;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__NUTRITION = 21;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__POWER = 24;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__SPEED = 28;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__STEPS = 29;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__WEIGHT = 33;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FOUR__NICOTINE_INTAKE = 44;

    // Values for HealthConnectApiInvoked.data_type_five
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__DISTANCE = 12;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__HEIGHT = 17;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__HYDRATION = 18;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__NUTRITION = 21;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__POWER = 24;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__SPEED = 28;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__STEPS = 29;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__WEIGHT = 33;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_FIVE__NICOTINE_INTAKE = 44;

    // Values for HealthConnectApiInvoked.data_type_six
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__DISTANCE = 12;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__HEIGHT = 17;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__HYDRATION = 18;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__NUTRITION = 21;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__POWER = 24;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__SPEED = 28;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__STEPS = 29;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__WEIGHT = 33;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_API_INVOKED__DATA_TYPE_SIX__NICOTINE_INTAKE = 44;

    // Values for ExerciseRouteApiCalled.operation
    public static final int EXERCISE_ROUTE_API_CALLED__OPERATION__OPERATION_READ = 0;
    public static final int EXERCISE_ROUTE_API_CALLED__OPERATION__OPERATION_UPSERT = 1;

    // Values for HealthConnectExportInvoked.status
    public static final int HEALTH_CONNECT_EXPORT_INVOKED__STATUS__EXPORT_STATUS_UNSPECIFIED = 0;
    public static final int HEALTH_CONNECT_EXPORT_INVOKED__STATUS__EXPORT_STATUS_STARTED = 1;
    public static final int HEALTH_CONNECT_EXPORT_INVOKED__STATUS__EXPORT_STATUS_ERROR_NONE = 2;
    public static final int HEALTH_CONNECT_EXPORT_INVOKED__STATUS__EXPORT_STATUS_ERROR_UNKNOWN = 3;
    public static final int HEALTH_CONNECT_EXPORT_INVOKED__STATUS__EXPORT_STATUS_ERROR_LOST_FILE_ACCESS = 4;
    public static final int HEALTH_CONNECT_EXPORT_INVOKED__STATUS__EXPORT_STATUS_ERROR_OUT_OF_STORAGE = 5;

    // Values for HealthConnectImportInvoked.status
    public static final int HEALTH_CONNECT_IMPORT_INVOKED__STATUS__IMPORT_STATUS_UNSPECIFIED = 0;
    public static final int HEALTH_CONNECT_IMPORT_INVOKED__STATUS__IMPORT_STATUS_STARTED = 1;
    public static final int HEALTH_CONNECT_IMPORT_INVOKED__STATUS__IMPORT_STATUS_ERROR_NONE = 2;
    public static final int HEALTH_CONNECT_IMPORT_INVOKED__STATUS__IMPORT_STATUS_ERROR_UNKNOWN = 3;
    public static final int HEALTH_CONNECT_IMPORT_INVOKED__STATUS__IMPORT_STATUS_ERROR_WRONG_FILE = 4;
    public static final int HEALTH_CONNECT_IMPORT_INVOKED__STATUS__IMPORT_STATUS_ERROR_VERSION_MISMATCH = 5;

    // Values for HealthConnectPhrApiInvoked.api_method
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__API_METHOD_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__DELETE_DATA = 1;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__GET_CHANGES = 2;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__GET_CHANGES_TOKEN = 3;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__GET_GRANTED_PERMISSIONS = 4;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__INSERT_DATA = 5;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__READ_AGGREGATED_DATA = 6;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__READ_DATA = 7;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__REVOKE_ALL_PERMISSIONS = 8;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__UPDATE_DATA = 9;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__CREATE_MEDICAL_DATA_SOURCE = 10;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__GET_MEDICAL_DATA_SOURCES_BY_IDS = 11;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__GET_MEDICAL_DATA_SOURCES_BY_REQUESTS = 12;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__DELETE_MEDICAL_DATA_SOURCE_WITH_DATA = 13;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__UPSERT_MEDICAL_RESOURCES = 14;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__READ_MEDICAL_RESOURCES_BY_IDS = 15;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__READ_MEDICAL_RESOURCES_BY_REQUESTS = 16;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__DELETE_MEDICAL_RESOURCES_BY_IDS = 17;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_METHOD__DELETE_MEDICAL_RESOURCES_BY_REQUESTS = 18;

    // Values for HealthConnectPhrApiInvoked.api_status
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_STATUS__STATUS_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_STATUS__SUCCESS = 1;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__API_STATUS__ERROR = 2;

    // Values for HealthConnectPhrApiInvoked.medical_resource_type
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_VACCINES = 1;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES = 2;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_PREGNANCY = 3;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY = 4;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_VITAL_SIGNS = 5;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS = 6;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_CONDITIONS = 7;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_PROCEDURES = 8;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_MEDICATIONS = 9;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS = 10;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS = 11;
    public static final int HEALTH_CONNECT_PHR_API_INVOKED__MEDICAL_RESOURCE_TYPE__MEDICAL_RESOURCE_TYPE_VISITS = 12;

    // Values for HealthConnectRestrictedEcosystemStats.data_type
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__DISTANCE = 12;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__HEIGHT = 17;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__HYDRATION = 18;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__NUTRITION = 21;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__POWER = 24;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__SPEED = 28;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__STEPS = 29;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__WEIGHT = 33;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__DATA_TYPE__NICOTINE_INTAKE = 44;

    // Values for HealthConnectRestrictedEcosystemStats.metric_type
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__METRIC_TYPE__METRIC_TYPE_DIRECTIONAL_PAIRING_PER_DATA_TYPE = 0;
    public static final int HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS__METRIC_TYPE__METRIC_TYPE_DIRECTIONAL_PAIRING = 1;

    // Values for HealthConnectEcosystemStats.read_or_write
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__DISTANCE = 12;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__HEIGHT = 17;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__HYDRATION = 18;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__NUTRITION = 21;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__POWER = 24;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__SPEED = 28;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__STEPS = 29;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__WEIGHT = 33;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ_OR_WRITE__NICOTINE_INTAKE = 44;

    // Values for HealthConnectEcosystemStats.read
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__DISTANCE = 12;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__HEIGHT = 17;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__HYDRATION = 18;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__NUTRITION = 21;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__POWER = 24;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__SPEED = 28;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__STEPS = 29;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__WEIGHT = 33;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__READ__NICOTINE_INTAKE = 44;

    // Values for HealthConnectEcosystemStats.write
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__DISTANCE = 12;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__HEIGHT = 17;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__HYDRATION = 18;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__NUTRITION = 21;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__POWER = 24;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__SPEED = 28;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__STEPS = 29;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__WEIGHT = 33;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__WRITE__NICOTINE_INTAKE = 44;

    // Values for HealthConnectEcosystemStats.shared
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__DATA_TYPE_UNKNOWN = 0;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__DATA_TYPE_NOT_ASSIGNED = 1;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__ACTIVE_CALORIES_BURNED = 2;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__BASAL_BODY_TEMPERATURE = 3;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__BASAL_METABOLIC_RATE = 4;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__BLOOD_GLUCOSE = 5;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__BLOOD_PRESSURE = 6;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__BODY_FAT = 7;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__BODY_TEMPERATURE = 8;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__BONE_MASS = 9;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__CERVICAL_MUCUS = 10;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__CYCLING_PEDALING_CADENCE = 11;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__DISTANCE = 12;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__ELEVATION_GAINED = 13;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__EXERCISE_SESSION = 14;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__FLOORS_CLIMBED = 15;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__HEART_RATE = 16;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__HEIGHT = 17;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__HYDRATION = 18;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__LEAN_BODY_MASS = 19;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__MENSTRUATION_FLOW = 20;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__NUTRITION = 21;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__OVULATION_TEST = 22;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__OXYGEN_SATURATION = 23;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__POWER = 24;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__RESPIRATORY_RATE = 25;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__RESTING_HEART_RATE = 26;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__SEXUAL_ACTIVITY = 27;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__SPEED = 28;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__STEPS = 29;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__STEPS_CADENCE = 30;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__TOTAL_CALORIES_BURNED = 31;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__VO2_MAX = 32;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__WEIGHT = 33;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__WHEELCHAIR_PUSHES = 34;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__SKIN_TEMPERATURE = 35;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__PLANNED_EXERCISE_SESSION = 36;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__MINDFULNESS_SESSION = 37;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__BODY_WATER_MASS = 38;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__HEART_RATE_VARIABILITY_RMSSD = 39;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__INTERMENSTRUAL_BLEEDING = 40;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__MENSTRUATION_PERIOD = 41;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__SLEEP_SESSION = 42;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__ACTIVITY_INTENSITY = 43;
    public static final int HEALTH_CONNECT_ECOSYSTEM_STATS__SHARED__NICOTINE_INTAKE = 44;

    // Values for HealthConnectDataBackupInvoked.status
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED__STATUS__DATA_BACKUP_STATUS_ERROR_UNSPECIFIED = 0;
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED__STATUS__DATA_BACKUP_STATUS_ERROR_NONE = 1;
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED__STATUS__DATA_BACKUP_STATUS_ERROR_UNKNOWN = 2;
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED__STATUS__DATA_BACKUP_STATUS_ERROR_PARTIAL_BACKUP = 3;
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED__STATUS__DATA_BACKUP_STATUS_STARTED = 4;

    // Values for HealthConnectDataBackupInvoked.backup_type
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED__BACKUP_TYPE__DATA_BACKUP_TYPE_UNSPECIFIED = 0;
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED__BACKUP_TYPE__DATA_BACKUP_TYPE_FULL = 1;
    public static final int HEALTH_CONNECT_DATA_BACKUP_INVOKED__BACKUP_TYPE__DATA_BACKUP_TYPE_INCREMENTAL = 2;

    // Values for HealthConnectSettingsBackupInvoked.status
    public static final int HEALTH_CONNECT_SETTINGS_BACKUP_INVOKED__STATUS__SETTINGS_BACKUP_STATUS_ERROR_UNSPECIFIED = 0;
    public static final int HEALTH_CONNECT_SETTINGS_BACKUP_INVOKED__STATUS__SETTINGS_BACKUP_STATUS_ERROR_NONE = 1;
    public static final int HEALTH_CONNECT_SETTINGS_BACKUP_INVOKED__STATUS__SETTINGS_BACKUP_STATUS_ERROR_UNKNOWN = 2;
    public static final int HEALTH_CONNECT_SETTINGS_BACKUP_INVOKED__STATUS__SETTINGS_BACKUP_STATUS_ERROR_COLLATION_FAILED = 3;
    public static final int HEALTH_CONNECT_SETTINGS_BACKUP_INVOKED__STATUS__SETTINGS_BACKUP_STATUS_ERROR_PARTIAL_BACKUP = 4;
    public static final int HEALTH_CONNECT_SETTINGS_BACKUP_INVOKED__STATUS__SETTINGS_BACKUP_STATUS_STARTED = 5;

    // Values for HealthConnectDataRestoreInvoked.status
    public static final int HEALTH_CONNECT_DATA_RESTORE_INVOKED__STATUS__DATA_RESTORE_STATUS_ERROR_UNSPECIFIED = 0;
    public static final int HEALTH_CONNECT_DATA_RESTORE_INVOKED__STATUS__DATA_RESTORE_STATUS_ERROR_NONE = 1;
    public static final int HEALTH_CONNECT_DATA_RESTORE_INVOKED__STATUS__DATA_RESTORE_STATUS_ERROR_UNKNOWN = 2;
    public static final int HEALTH_CONNECT_DATA_RESTORE_INVOKED__STATUS__DATA_RESTORE_STATUS_ERROR_CONVERSION_FAILED = 3;
    public static final int HEALTH_CONNECT_DATA_RESTORE_INVOKED__STATUS__DATA_RESTORE_STATUS_ERROR_PARTIAL_RESTORE = 4;
    public static final int HEALTH_CONNECT_DATA_RESTORE_INVOKED__STATUS__DATA_RESTORE_STATUS_STARTED = 5;

    // Values for HealthConnectSettingsRestoreInvoked.status
    public static final int HEALTH_CONNECT_SETTINGS_RESTORE_INVOKED__STATUS__SETTINGS_RESTORE_STATUS_ERROR_UNSPECIFIED = 0;
    public static final int HEALTH_CONNECT_SETTINGS_RESTORE_INVOKED__STATUS__SETTINGS_RESTORE_STATUS_ERROR_NONE = 1;
    public static final int HEALTH_CONNECT_SETTINGS_RESTORE_INVOKED__STATUS__SETTINGS_RESTORE_STATUS_ERROR_UNKNOWN = 2;
    public static final int HEALTH_CONNECT_SETTINGS_RESTORE_INVOKED__STATUS__SETTINGS_RESTORE_STATUS_ERROR_CONVERSION_FAILED = 3;
    public static final int HEALTH_CONNECT_SETTINGS_RESTORE_INVOKED__STATUS__SETTINGS_RESTORE_STATUS_ERROR_PARTIAL_RESTORE = 4;
    public static final int HEALTH_CONNECT_SETTINGS_RESTORE_INVOKED__STATUS__SETTINGS_RESTORE_STATUS_STARTED = 5;

    // Annotation constants.
    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;


    // Write methods
    public static void write(int code, boolean arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, long arg4, int arg5, int arg6, int arg7, java.lang.String arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeString(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    @android.annotation.SuppressLint("ObsoleteSdkInt")
    @RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
    public static void write(int code, int arg1, int arg2, int arg3, long arg4, java.lang.String arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (HEALTH_CONNECT_API_INVOKED == code) {
            builder.addIntAnnotation(StatsLog.ANNOTATION_ID_RESTRICTION_CATEGORY,
                                     StatsLog.RESTRICTION_CATEGORY_DIAGNOSTIC);
        }
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeString(arg5);
        builder.writeInt(arg6);
        if (HEALTH_CONNECT_API_INVOKED == code) {
            builder.addBooleanAnnotation(StatsLog.ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT, true);
        }
        builder.writeInt(arg7);
        if (HEALTH_CONNECT_API_INVOKED == code) {
            builder.addBooleanAnnotation(StatsLog.ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT, true);
        }
        builder.writeInt(arg8);
        if (HEALTH_CONNECT_API_INVOKED == code) {
            builder.addBooleanAnnotation(StatsLog.ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT, true);
        }
        builder.writeInt(arg9);
        if (HEALTH_CONNECT_API_INVOKED == code) {
            builder.addBooleanAnnotation(StatsLog.ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT, true);
        }
        builder.writeInt(arg10);
        if (HEALTH_CONNECT_API_INVOKED == code) {
            builder.addBooleanAnnotation(StatsLog.ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT, true);
        }
        builder.writeInt(arg11);
        if (HEALTH_CONNECT_API_INVOKED == code) {
            builder.addBooleanAnnotation(StatsLog.ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    @android.annotation.SuppressLint("ObsoleteSdkInt")
    @RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (HEALTH_CONNECT_PHR_API_INVOKED == code) {
            builder.addIntAnnotation(StatsLog.ANNOTATION_ID_RESTRICTION_CATEGORY,
                                     StatsLog.RESTRICTION_CATEGORY_DIAGNOSTIC);
        }
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        if (HEALTH_CONNECT_PHR_API_INVOKED == code) {
            builder.addBooleanAnnotation(StatsLog.ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    @android.annotation.SuppressLint("ObsoleteSdkInt")
    @RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
    public static void write(int code, int arg1, java.lang.String arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (EXERCISE_ROUTE_API_CALLED == code) {
            builder.addIntAnnotation(StatsLog.ANNOTATION_ID_RESTRICTION_CATEGORY,
                                     StatsLog.RESTRICTION_CATEGORY_DIAGNOSTIC);
        }
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, long arg2, long arg3, long arg4, long arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    @android.annotation.SuppressLint("ObsoleteSdkInt")
    @RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
    public static void write(int code, java.lang.String arg1, java.lang.String arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS == code) {
            builder.addIntAnnotation(StatsLog.ANNOTATION_ID_RESTRICTION_CATEGORY,
                                     StatsLog.RESTRICTION_CATEGORY_DIAGNOSTIC);
        }
        builder.writeString(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        if (HEALTH_CONNECT_RESTRICTED_ECOSYSTEM_STATS == code) {
            builder.addBooleanAnnotation(StatsLog.ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT, true);
        }
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    @android.annotation.SuppressLint("ObsoleteSdkInt")
    @RequiresApi(Build.VERSION_CODES.TIRAMISU)
    public static void write(int code, java.lang.String arg1, java.lang.String[] arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeStringArray(null == arg2 ? new String[0] : arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    @android.annotation.SuppressLint("ObsoleteSdkInt")
    @RequiresApi(Build.VERSION_CODES.TIRAMISU)
    public static void write(int code, int[] arg1, int[] arg2, int[] arg3, int[] arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeIntArray(null == arg1 ? new int[0] : arg1);
        builder.writeIntArray(null == arg2 ? new int[0] : arg2);
        builder.writeIntArray(null == arg3 ? new int[0] : arg3);
        builder.writeIntArray(null == arg4 ? new int[0] : arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

}
