// This file is autogenerated

package android.graphics.pdf;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;


/**
 * Utility class for logging statistics events.
 * @hide
 */
public final class PdfStatsLog {
    // Constants for atom codes.

    /**
     * UiEventReported ui_event_reported<br>
     * Usage: StatsLog.write(StatsLog.UI_EVENT_REPORTED, int event_id, int uid, java.lang.String package_name, int instance_id);<br>
     */
    public static final int UI_EVENT_REPORTED = 90;

    /**
     * MediaProviderScanOccurred media_provider_scan_occurred<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_PROVIDER_SCAN_OCCURRED, int volume_type, int reason, long item_count, float normalized_duration_millis, float normalized_insert_count, float normalized_update_count, float normalized_delete_count);<br>
     */
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED = 233;

    /**
     * MediaContentDeleted media_content_deleted<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_CONTENT_DELETED, int volume_type, int uid, int item_count);<br>
     */
    public static final int MEDIA_CONTENT_DELETED = 234;

    /**
     * MediaProviderPermissionRequested media_provider_permission_requested<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_PROVIDER_PERMISSION_REQUESTED, int volume_type, int uid, int item_count, int result);<br>
     */
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED = 235;

    /**
     * MediaProviderSchemaChanged media_provider_schema_changed<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_PROVIDER_SCHEMA_CHANGED, int volume_type, int version_from, int version_to, long item_count, float normalized_duration_millis);<br>
     */
    public static final int MEDIA_PROVIDER_SCHEMA_CHANGED = 236;

    /**
     * MediaProviderIdleMaintenanceFinished media_provider_idle_maintenance_finished<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_PROVIDER_IDLE_MAINTENANCE_FINISHED, int volume_type, long item_count, float normalized_duration_millis, float normalized_stale_thumbnails, float normalized_expired_media);<br>
     */
    public static final int MEDIA_PROVIDER_IDLE_MAINTENANCE_FINISHED = 237;

    /**
     * RankingSelected ranking_selected<br>
     * Usage: StatsLog.write(StatsLog.RANKING_SELECTED, int event_id, java.lang.String package_name, int instance_id, int position_picked, boolean is_pinned);<br>
     */
    public static final int RANKING_SELECTED = 260;

    /**
     * TranscodingData transcoding_data<br>
     * Usage: StatsLog.write(StatsLog.TRANSCODING_DATA, java.lang.String requestor_package, int access_type, long file_size_bytes, int transcode_result, long transcode_duration_millis, long file_duration_millis, long file_framerate_fps, int access_reason, long width, long height, boolean hit_anr, int failure_cause, long transcoding_service_error_code);<br>
     */
    public static final int TRANSCODING_DATA = 330;

    /**
     * MediaProviderVolumeRecoveryReported media_provider_volume_recovery_reported<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED, int volume, float recovery_time_millis, long rows_recovered, long dirty_rows_found, long total_leveldb_rows, long insertionFailures, int status);<br>
     */
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED = 586;

    /**
     * MediaProviderDatabaseRollbackReported media_provider_database_rollback_reported<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_PROVIDER_DATABASE_ROLLBACK_REPORTED, int database_name);<br>
     */
    public static final int MEDIA_PROVIDER_DATABASE_ROLLBACK_REPORTED = 784;

    /**
     * BackupSetupStatusReported backup_setup_status_reported<br>
     * Usage: StatsLog.write(StatsLog.BACKUP_SETUP_STATUS_REPORTED, int status, int volume);<br>
     */
    public static final int BACKUP_SETUP_STATUS_REPORTED = 785;

    /**
     * PdfLoadReported pdf_load_reported<br>
     * Usage: StatsLog.write(StatsLog.PDF_LOAD_REPORTED, int uid, long duration_millis, float file_size_in_kb, int load_result, int type, int number_of_pages, long doc_id);<br>
     */
    public static final int PDF_LOAD_REPORTED = 859;

    /**
     * PdfApiUsageReported pdf_api_usage_reported<br>
     * Usage: StatsLog.write(StatsLog.PDF_API_USAGE_REPORTED, int uid, long doc_id, int api_type, int api_response_status);<br>
     */
    public static final int PDF_API_USAGE_REPORTED = 860;

    /**
     * PdfSearchReported pdf_search_reported<br>
     * Usage: StatsLog.write(StatsLog.PDF_SEARCH_REPORTED, int uid, long duration_millis, int query_length, int query_page_number, int api_response_status, long doc_id, int num_pages, int match_count);<br>
     */
    public static final int PDF_SEARCH_REPORTED = 861;

    /**
     * PhotopickerSessionInfoReported photopicker_session_info_reported<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_SESSION_INFO_REPORTED, int session_id, int package_uid, int picker_permitted_selection, int cloud_provider_uid, int user_profile, int picker_status, int picked_items_count, int picked_items_size, boolean is_profile_switch_button_visible, int picker_mode, int picker_close_method);<br>
     */
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED = 886;

    /**
     * PhotopickerApiInfoReported photopicker_api_info_reported<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_API_INFO_REPORTED, int session_id, int picker_intent_action, int screen_size, int media_filter, int max_picked_item_count, int selected_tab, int selected_album, boolean is_ordered_selection_set, boolean is_accent_color_set, boolean is_default_tab_set, boolean is_search_enabled, boolean is_cloud_search_enabled, boolean is_local_search_enabled);<br>
     */
    public static final int PHOTOPICKER_API_INFO_REPORTED = 887;

    /**
     * PhotopickerUIEventLogged photopicker_ui_event_logged<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_UI_EVENT_LOGGED, int session_id, int package_uid, int ui_event);<br>
     */
    public static final int PHOTOPICKER_UI_EVENT_LOGGED = 888;

    /**
     * PhotopickerMediaItemStatusReported photopicker_media_item_status_reported<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED, int session_id, int media_status, int media_location, int item_position, int selected_album, int media_type, boolean cloud_only, int picker_size);<br>
     */
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED = 889;

    /**
     * PhotopickerPreviewInfoLogged photopicker_preview_info_logged<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_PREVIEW_INFO_LOGGED, int session_id, int preview_mode_entry, int preview_item_count, int media_type, int video_interactions);<br>
     */
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED = 890;

    /**
     * PhotopickerMenuInteractionLogged photopicker_menu_interaction_logged<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_MENU_INTERACTION_LOGGED, int session_id, int package_uid, int menu_item_selected);<br>
     */
    public static final int PHOTOPICKER_MENU_INTERACTION_LOGGED = 891;

    /**
     * PhotopickerBannerInteractionLogged photopicker_banner_interaction_logged<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_BANNER_INTERACTION_LOGGED, int session_id, int banner_type, int user_banner_interaction);<br>
     */
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED = 892;

    /**
     * PhotopickerMediaLibraryInfoLogged photopicker_media_library_info_logged<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_MEDIA_LIBRARY_INFO_LOGGED, int session_id, int cloud_provider_uid, int library_size, int media_count);<br>
     */
    public static final int PHOTOPICKER_MEDIA_LIBRARY_INFO_LOGGED = 893;

    /**
     * PhotopickerPageInfoLogged photopicker_page_info_logged<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_PAGE_INFO_LOGGED, int session_id, int page_number, int items_loaded_in_page);<br>
     */
    public static final int PHOTOPICKER_PAGE_INFO_LOGGED = 894;

    /**
     * PhotopickerMediaGridSyncInfoReported photopicker_media_grid_sync_info_reported<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_MEDIA_GRID_SYNC_INFO_REPORTED, int session_id, int media_collection_info_start_time_millis, int media_collection_info_end_time_millis, int media_sync_start_time_millis, int media_sync_end_time_millis, int incremental_media_sync_start_time_millis, int incremental_media_sync_end_time_millis, int incremental_deleted_media_sync_start_time_millis, int incremental_deleted_media_sync_end_time_millis);<br>
     */
    public static final int PHOTOPICKER_MEDIA_GRID_SYNC_INFO_REPORTED = 895;

    /**
     * PhotopickerAlbumSyncInfoReported photopicker_album_sync_info_reported<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_ALBUM_SYNC_INFO_REPORTED, int session_id_time_millis, int get_albums_start_time_millis, int get_albums_end_time_millis, int get_album_media_start_time_millis, int get_album_media_end_time_millis);<br>
     */
    public static final int PHOTOPICKER_ALBUM_SYNC_INFO_REPORTED = 896;

    /**
     * PhotopickerSearchInfoReported photopicker_search_info_reported<br>
     * Usage: StatsLog.write(StatsLog.PHOTOPICKER_SEARCH_INFO_REPORTED, int session_id, int search_method, int picked_items, int start_time_millis, int end_time_millis);<br>
     */
    public static final int PHOTOPICKER_SEARCH_INFO_REPORTED = 897;

    /**
     * SearchDataExtractionDetailsReported search_data_extraction_details_reported<br>
     * Usage: StatsLog.write(StatsLog.SEARCH_DATA_EXTRACTION_DETAILS_REPORTED, int session_id, int unprocessed_images_count, int processing_start_time_millis, int processing_end_time_millis, boolean is_processing_successful, boolean is_response_received);<br>
     */
    public static final int SEARCH_DATA_EXTRACTION_DETAILS_REPORTED = 898;

    /**
     * EmbeddedPhotopickerInfoReported embedded_photopicker_info_reported<br>
     * Usage: StatsLog.write(StatsLog.EMBEDDED_PHOTOPICKER_INFO_REPORTED, int session_id, boolean is_surface_package_creation_successful, int surface_package_delivery_start_time_millis, int surface_package_delivery_end_time_millis);<br>
     */
    public static final int EMBEDDED_PHOTOPICKER_INFO_REPORTED = 899;

    /**
     * GeneralExternalStorageAccessStats general_external_storage_access_stats<br>
     * Usage: StatsLog.write(StatsLog.GENERAL_EXTERNAL_STORAGE_ACCESS_STATS, int uid, int total_accesses, int file_path_accesses, int secondary_storage_accesses, byte[] mime_types_accessed);<br>
     */
    public static final int GENERAL_EXTERNAL_STORAGE_ACCESS_STATS = 10085;

    // Constants for enum values.

    // Values for MediaProviderScanOccurred.volume_type
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED__VOLUME_TYPE__UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED__VOLUME_TYPE__INTERNAL = 1;
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED__VOLUME_TYPE__EXTERNAL_PRIMARY = 2;
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED__VOLUME_TYPE__EXTERNAL_OTHER = 3;

    // Values for MediaProviderScanOccurred.reason
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED__REASON__UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED__REASON__MOUNTED = 1;
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED__REASON__DEMAND = 2;
    public static final int MEDIA_PROVIDER_SCAN_OCCURRED__REASON__IDLE = 3;

    // Values for MediaContentDeleted.volume_type
    public static final int MEDIA_CONTENT_DELETED__VOLUME_TYPE__UNKNOWN = 0;
    public static final int MEDIA_CONTENT_DELETED__VOLUME_TYPE__INTERNAL = 1;
    public static final int MEDIA_CONTENT_DELETED__VOLUME_TYPE__EXTERNAL_PRIMARY = 2;
    public static final int MEDIA_CONTENT_DELETED__VOLUME_TYPE__EXTERNAL_OTHER = 3;

    // Values for MediaProviderPermissionRequested.volume_type
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__VOLUME_TYPE__UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__VOLUME_TYPE__INTERNAL = 1;
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__VOLUME_TYPE__EXTERNAL_PRIMARY = 2;
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__VOLUME_TYPE__EXTERNAL_OTHER = 3;

    // Values for MediaProviderPermissionRequested.result
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__RESULT__UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__RESULT__USER_GRANTED = 1;
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__RESULT__AUTO_GRANTED = 2;
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__RESULT__USER_DENIED = 3;
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__RESULT__USER_DENIED_WITH_PREJUDICE = 4;
    public static final int MEDIA_PROVIDER_PERMISSION_REQUESTED__RESULT__AUTO_DENIED = 5;

    // Values for MediaProviderSchemaChanged.volume_type
    public static final int MEDIA_PROVIDER_SCHEMA_CHANGED__VOLUME_TYPE__UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_SCHEMA_CHANGED__VOLUME_TYPE__INTERNAL = 1;
    public static final int MEDIA_PROVIDER_SCHEMA_CHANGED__VOLUME_TYPE__EXTERNAL_PRIMARY = 2;
    public static final int MEDIA_PROVIDER_SCHEMA_CHANGED__VOLUME_TYPE__EXTERNAL_OTHER = 3;

    // Values for MediaProviderIdleMaintenanceFinished.volume_type
    public static final int MEDIA_PROVIDER_IDLE_MAINTENANCE_FINISHED__VOLUME_TYPE__UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_IDLE_MAINTENANCE_FINISHED__VOLUME_TYPE__INTERNAL = 1;
    public static final int MEDIA_PROVIDER_IDLE_MAINTENANCE_FINISHED__VOLUME_TYPE__EXTERNAL_PRIMARY = 2;
    public static final int MEDIA_PROVIDER_IDLE_MAINTENANCE_FINISHED__VOLUME_TYPE__EXTERNAL_OTHER = 3;

    // Values for TranscodingData.access_type
    public static final int TRANSCODING_DATA__ACCESS_TYPE__HEVC_WRITE = 1;
    public static final int TRANSCODING_DATA__ACCESS_TYPE__READ_DIRECT = 2;
    public static final int TRANSCODING_DATA__ACCESS_TYPE__READ_CACHE = 3;
    public static final int TRANSCODING_DATA__ACCESS_TYPE__READ_TRANSCODE = 4;
    public static final int TRANSCODING_DATA__ACCESS_TYPE__WRITE_CACHE = 5;
    public static final int TRANSCODING_DATA__ACCESS_TYPE__AVC_WRITE = 6;

    // Values for TranscodingData.transcode_result
    public static final int TRANSCODING_DATA__TRANSCODE_RESULT__SUCCESS = 0;
    public static final int TRANSCODING_DATA__TRANSCODE_RESULT__FAIL = 1;
    public static final int TRANSCODING_DATA__TRANSCODE_RESULT__UNDEFINED = 2;

    // Values for TranscodingData.access_reason
    public static final int TRANSCODING_DATA__ACCESS_REASON__UNKNOWN = 0;
    public static final int TRANSCODING_DATA__ACCESS_REASON__SYSTEM_DEFAULT = 1;
    public static final int TRANSCODING_DATA__ACCESS_REASON__SYSTEM_CONFIG = 2;
    public static final int TRANSCODING_DATA__ACCESS_REASON__APP_MANIFEST = 3;
    public static final int TRANSCODING_DATA__ACCESS_REASON__APP_COMPAT = 4;
    public static final int TRANSCODING_DATA__ACCESS_REASON__APP_EXTRA = 5;

    // Values for TranscodingData.failure_cause
    public static final int TRANSCODING_DATA__FAILURE_CAUSE__CAUSE_UNKNOWN = 0;
    public static final int TRANSCODING_DATA__FAILURE_CAUSE__TRANSCODING_SERVICE_ERROR = 1;
    public static final int TRANSCODING_DATA__FAILURE_CAUSE__TRANSCODING_CLIENT_TIMEOUT = 2;
    public static final int TRANSCODING_DATA__FAILURE_CAUSE__TRANSCODING_SESSION_CANCELED = 3;

    // Values for MediaProviderVolumeRecoveryReported.volume
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__VOLUME__UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__VOLUME__INTERNAL = 1;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__VOLUME__EXTERNAL_PRIMARY = 2;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__VOLUME__PUBLIC = 3;

    // Values for MediaProviderVolumeRecoveryReported.status
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__STATUS__STATUS_UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__STATUS__SUCCESS = 1;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__STATUS__BACKUP_MISSING = 2;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__STATUS__VOLUME_NOT_ATTACHED = 3;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__STATUS__FUSE_DAEMON_TIMEOUT = 4;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__STATUS__GET_BACKUP_DATA_FAILURE = 5;
    public static final int MEDIA_PROVIDER_VOLUME_RECOVERY_REPORTED__STATUS__OTHER_ERROR = 6;

    // Values for MediaProviderDatabaseRollbackReported.database_name
    public static final int MEDIA_PROVIDER_DATABASE_ROLLBACK_REPORTED__DATABASE_NAME__UNKNOWN = 0;
    public static final int MEDIA_PROVIDER_DATABASE_ROLLBACK_REPORTED__DATABASE_NAME__INTERNAL = 1;
    public static final int MEDIA_PROVIDER_DATABASE_ROLLBACK_REPORTED__DATABASE_NAME__EXTERNAL = 2;

    // Values for BackupSetupStatusReported.status
    public static final int BACKUP_SETUP_STATUS_REPORTED__STATUS__UNKNOWN = 0;
    public static final int BACKUP_SETUP_STATUS_REPORTED__STATUS__ATTEMPTED = 1;
    public static final int BACKUP_SETUP_STATUS_REPORTED__STATUS__SUCCESS = 2;
    public static final int BACKUP_SETUP_STATUS_REPORTED__STATUS__FAILURE = 3;

    // Values for BackupSetupStatusReported.volume
    public static final int BACKUP_SETUP_STATUS_REPORTED__VOLUME__UNKNOWN_VOLUME = 0;
    public static final int BACKUP_SETUP_STATUS_REPORTED__VOLUME__INTERNAL = 1;
    public static final int BACKUP_SETUP_STATUS_REPORTED__VOLUME__EXTERNAL_PRIMARY = 2;
    public static final int BACKUP_SETUP_STATUS_REPORTED__VOLUME__PUBLIC = 3;

    // Values for PdfLoadReported.load_result
    public static final int PDF_LOAD_REPORTED__LOAD_RESULT__RESULT_UNKNOWN = 0;
    public static final int PDF_LOAD_REPORTED__LOAD_RESULT__RESULT_LOADED = 1;
    public static final int PDF_LOAD_REPORTED__LOAD_RESULT__RESULT_ERROR = 2;
    public static final int PDF_LOAD_REPORTED__LOAD_RESULT__RESULT_WRONG_PASSWORD = 3;

    // Values for PdfLoadReported.type
    public static final int PDF_LOAD_REPORTED__TYPE__UNKNOWN_TYPE = 0;
    public static final int PDF_LOAD_REPORTED__TYPE__LINEARIZED_TYPE = 1;
    public static final int PDF_LOAD_REPORTED__TYPE__NON_LINEARIZED_TYPE = 2;

    // Values for PdfApiUsageReported.api_type
    public static final int PDF_API_USAGE_REPORTED__API_TYPE__API_TYPE_UNKNOWN = 0;
    public static final int PDF_API_USAGE_REPORTED__API_TYPE__API_TYPE_SELECT_CONTENT = 1;

    // Values for PdfApiUsageReported.api_response_status
    public static final int PDF_API_USAGE_REPORTED__API_RESPONSE_STATUS__RESPONSE_UNKNOWN = 0;
    public static final int PDF_API_USAGE_REPORTED__API_RESPONSE_STATUS__RESPONSE_SUCCESS = 1;
    public static final int PDF_API_USAGE_REPORTED__API_RESPONSE_STATUS__RESPONSE_FAILURE = 2;

    // Values for PdfSearchReported.api_response_status
    public static final int PDF_SEARCH_REPORTED__API_RESPONSE_STATUS__RESPONSE_UNKNOWN = 0;
    public static final int PDF_SEARCH_REPORTED__API_RESPONSE_STATUS__RESPONSE_SUCCESS = 1;
    public static final int PDF_SEARCH_REPORTED__API_RESPONSE_STATUS__RESPONSE_FAILURE = 2;

    // Values for PhotopickerSessionInfoReported.picker_permitted_selection
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_PERMITTED_SELECTION__SINGLE = 0;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_PERMITTED_SELECTION__MULTIPLE = 1;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_PERMITTED_SELECTION__UNSET_PICKER_PERMITTED_SELECTION = 2;

    // Values for PhotopickerSessionInfoReported.user_profile
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__USER_PROFILE__WORK = 0;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__USER_PROFILE__PERSONAL = 1;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__USER_PROFILE__PRIVATE_SPACE = 2;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__USER_PROFILE__UNKNOWN = 3;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__USER_PROFILE__UNSET_USER_PROFILE = 4;

    // Values for PhotopickerSessionInfoReported.picker_status
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_STATUS__OPENED = 0;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_STATUS__CANCELED = 1;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_STATUS__CONFIRMED = 2;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_STATUS__UNSET_PICKER_STATUS = 3;

    // Values for PhotopickerSessionInfoReported.picker_mode
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_MODE__REGULAR_PICKER = 0;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_MODE__EMBEDDED_PICKER = 1;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_MODE__PERMISSION_MODE_PICKER = 2;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_MODE__UNSET_PICKER_MODE = 3;

    // Values for PhotopickerSessionInfoReported.picker_close_method
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_CLOSE_METHOD__SWIPE_DOWN = 0;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_CLOSE_METHOD__CROSS_BUTTON = 1;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_CLOSE_METHOD__BACK_BUTTON = 2;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_CLOSE_METHOD__PICKER_SELECTION_CONFIRMED = 3;
    public static final int PHOTOPICKER_SESSION_INFO_REPORTED__PICKER_CLOSE_METHOD__UNSET_PICKER_CLOSE_METHOD = 4;

    // Values for PhotopickerApiInfoReported.picker_intent_action
    public static final int PHOTOPICKER_API_INFO_REPORTED__PICKER_INTENT_ACTION__ACTION_PICK_IMAGES = 0;
    public static final int PHOTOPICKER_API_INFO_REPORTED__PICKER_INTENT_ACTION__ACTION_GET_CONTENT = 1;
    public static final int PHOTOPICKER_API_INFO_REPORTED__PICKER_INTENT_ACTION__ACTION_USER_SELECT = 2;
    public static final int PHOTOPICKER_API_INFO_REPORTED__PICKER_INTENT_ACTION__UNSET_PICKER_INTENT_ACTION = 3;

    // Values for PhotopickerApiInfoReported.screen_size
    public static final int PHOTOPICKER_API_INFO_REPORTED__SCREEN_SIZE__COLLAPSED = 0;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SCREEN_SIZE__EXPANDED = 1;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SCREEN_SIZE__UNSET_PICKER_SIZE = 2;

    // Values for PhotopickerApiInfoReported.media_filter
    public static final int PHOTOPICKER_API_INFO_REPORTED__MEDIA_FILTER__PHOTO = 0;
    public static final int PHOTOPICKER_API_INFO_REPORTED__MEDIA_FILTER__VIDEO = 1;
    public static final int PHOTOPICKER_API_INFO_REPORTED__MEDIA_FILTER__PHOTO_VIDEO = 2;
    public static final int PHOTOPICKER_API_INFO_REPORTED__MEDIA_FILTER__GIF = 3;
    public static final int PHOTOPICKER_API_INFO_REPORTED__MEDIA_FILTER__LIVE_PHOTO = 4;
    public static final int PHOTOPICKER_API_INFO_REPORTED__MEDIA_FILTER__OTHER = 5;
    public static final int PHOTOPICKER_API_INFO_REPORTED__MEDIA_FILTER__UNSET_MEDIA_TYPE = 6;

    // Values for PhotopickerApiInfoReported.selected_tab
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_TAB__PHOTOS = 0;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_TAB__ALBUMS = 1;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_TAB__COLLECTIONS = 2;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_TAB__UNSET_SELECTED_TAB = 3;

    // Values for PhotopickerApiInfoReported.selected_album
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_ALBUM__FAVORITES = 0;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_ALBUM__CAMERA = 1;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_ALBUM__DOWNLOADS = 2;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_ALBUM__SCREENSHOTS = 3;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_ALBUM__VIDEOS = 4;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_ALBUM__UNDEFINED_LOCAL = 5;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_ALBUM__UNDEFINED_CLOUD = 6;
    public static final int PHOTOPICKER_API_INFO_REPORTED__SELECTED_ALBUM__UNSET_SELECTED_ALBUM = 7;

    // Values for PhotopickerUIEventLogged.ui_event
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_MENU_CLICKED = 0;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ENTER_PICKER_PREVIEW_MODE = 1;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__SWITCH_PICKER_TAB = 2;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__SWITCH_USER_PROFILE = 3;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_MAIN_GRID_INTERACTION = 4;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_ALBUMS_INTERACTION = 5;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_CLICK_ADD_BUTTON = 6;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_CLICK_VIEW_SELECTED = 7;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_LONG_SELECT_MEDIA_ITEM = 8;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__EXPAND_PICKER = 9;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__COLLAPSE_PICKER = 10;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PROFILE_SWITCH_BUTTON_CLICK = 11;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ACTION_BAR_HOME_BUTTON_CLICK = 12;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_BACK_GESTURE_CLICK = 13;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_MENU_CLICK = 14;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__MAIN_GRID_OPEN = 15;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ALBUM_FAVOURITES_OPEN = 16;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ALBUM_CAMERA_OPEN = 17;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ALBUM_DOWNLOADS_OPEN = 18;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ALBUM_SCREENSHOTS_OPEN = 19;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ALBUM_VIDEOS_OPEM = 20;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ALBUM_FROM_CLOUD_OPEN = 21;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_PHOTOS = 22;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_ALBUMS = 23;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_ALBUM_CONTENTS = 24;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__CREATE_SURFACE_CONTROLLER_START = 25;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__CREATE_SURFACE_CONTROLLER_END = 26;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_PRELOADING_START = 27;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_PRELOADING_FINISHED = 28;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_PRELOADING_FAILED = 29;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_PRELOADING_CANCELLED = 30;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_BROWSE_DOCUMENTS_UI = 31;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__ENTER_PICKER_SEARCH = 32;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__SELECT_SEARCH_CATEGORY = 33;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UNSET_UI_EVENT = 34;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__SELECT_SEARCH_RESULT = 35;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__PICKER_CATEGORIES_INTERACTION = 36;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__CATEGORIES_PEOPLEPET_OPEN = 37;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__CATEGORIES_MEDIA_SETS_OPEN = 38;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_CATEGORIES_AND_ALBUMS = 39;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_MEDIA_SETS = 40;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_MEDIA_SETS_CONTENTS = 41;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_SEARCH_SUGGESTIONS = 42;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_SEARCH_RESULTS = 43;
    public static final int PHOTOPICKER_UIEVENT_LOGGED__UI_EVENT__UI_LOADED_EMPTY_STATE = 44;

    // Values for PhotopickerMediaItemStatusReported.media_status
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_STATUS__SELECTED = 0;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_STATUS__UNSELECTED = 1;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_STATUS__UNSET_MEDIA_STATUS = 2;

    // Values for PhotopickerMediaItemStatusReported.media_location
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_LOCATION__MAIN_GRID = 0;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_LOCATION__ALBUM = 1;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_LOCATION__GROUP = 2;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_LOCATION__UNSET_MEDIA_LOCATION = 3;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_LOCATION__CATEGORY = 4;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_LOCATION__SEARCH_GRID = 5;

    // Values for PhotopickerMediaItemStatusReported.selected_album
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__SELECTED_ALBUM__FAVORITES = 0;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__SELECTED_ALBUM__CAMERA = 1;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__SELECTED_ALBUM__DOWNLOADS = 2;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__SELECTED_ALBUM__SCREENSHOTS = 3;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__SELECTED_ALBUM__VIDEOS = 4;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__SELECTED_ALBUM__UNDEFINED_LOCAL = 5;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__SELECTED_ALBUM__UNDEFINED_CLOUD = 6;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__SELECTED_ALBUM__UNSET_SELECTED_ALBUM = 7;

    // Values for PhotopickerMediaItemStatusReported.media_type
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_TYPE__PHOTO = 0;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_TYPE__VIDEO = 1;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_TYPE__PHOTO_VIDEO = 2;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_TYPE__GIF = 3;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_TYPE__LIVE_PHOTO = 4;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_TYPE__OTHER = 5;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__MEDIA_TYPE__UNSET_MEDIA_TYPE = 6;

    // Values for PhotopickerMediaItemStatusReported.picker_size
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__PICKER_SIZE__COLLAPSED = 0;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__PICKER_SIZE__EXPANDED = 1;
    public static final int PHOTOPICKER_MEDIA_ITEM_STATUS_REPORTED__PICKER_SIZE__UNSET_PICKER_SIZE = 2;

    // Values for PhotopickerPreviewInfoLogged.preview_mode_entry
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__PREVIEW_MODE_ENTRY__VIEW_SELECTED = 0;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__PREVIEW_MODE_ENTRY__LONG_PRESS = 1;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__PREVIEW_MODE_ENTRY__UNSET_PREVIEW_MODE_ENTRY = 2;

    // Values for PhotopickerPreviewInfoLogged.media_type
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__MEDIA_TYPE__PHOTO = 0;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__MEDIA_TYPE__VIDEO = 1;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__MEDIA_TYPE__PHOTO_VIDEO = 2;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__MEDIA_TYPE__GIF = 3;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__MEDIA_TYPE__LIVE_PHOTO = 4;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__MEDIA_TYPE__OTHER = 5;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__MEDIA_TYPE__UNSET_MEDIA_TYPE = 6;

    // Values for PhotopickerPreviewInfoLogged.video_interactions
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__VIDEO_INTERACTIONS__PLAY = 0;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__VIDEO_INTERACTIONS__PAUSE = 1;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__VIDEO_INTERACTIONS__MUTE = 2;
    public static final int PHOTOPICKER_PREVIEW_INFO_LOGGED__VIDEO_INTERACTIONS__UNSET_VIDEO_PLAYBACK_INTERACTION = 3;

    // Values for PhotopickerMenuInteractionLogged.menu_item_selected
    public static final int PHOTOPICKER_MENU_INTERACTION_LOGGED__MENU_ITEM_SELECTED__BROWSE = 0;
    public static final int PHOTOPICKER_MENU_INTERACTION_LOGGED__MENU_ITEM_SELECTED__CLOUD_SETTINGS = 1;
    public static final int PHOTOPICKER_MENU_INTERACTION_LOGGED__MENU_ITEM_SELECTED__UNSET_MENU_ITEM_SELECTED = 2;

    // Values for PhotopickerBannerInteractionLogged.banner_type
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__BANNER_TYPE__CLOUD_MEDIA_AVAILABLE = 0;
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__BANNER_TYPE__ACCOUNT_UPDATED = 1;
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__BANNER_TYPE__CHOOSE_ACCOUNT = 2;
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__BANNER_TYPE__CHOOSE_APP = 3;
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__BANNER_TYPE__UNSET_BANNER_TYPE = 4;

    // Values for PhotopickerBannerInteractionLogged.user_banner_interaction
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__USER_BANNER_INTERACTION__CLICK_BANNER_ACTION_BUTTON = 0;
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__USER_BANNER_INTERACTION__CLICK_BANNER_DISMISS_BUTTON = 1;
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__USER_BANNER_INTERACTION__CLICK_BANNER = 2;
    public static final int PHOTOPICKER_BANNER_INTERACTION_LOGGED__USER_BANNER_INTERACTION__UNSET_USER_BANNER_INTERACTION = 3;

    // Values for PhotopickerSearchInfoReported.search_method
    public static final int PHOTOPICKER_SEARCH_INFO_REPORTED__SEARCH_METHOD__SEARCH_QUERY = 0;
    public static final int PHOTOPICKER_SEARCH_INFO_REPORTED__SEARCH_METHOD__COLLECTION = 1;
    public static final int PHOTOPICKER_SEARCH_INFO_REPORTED__SEARCH_METHOD__SUGGESTED_SEARCHES = 2;
    public static final int PHOTOPICKER_SEARCH_INFO_REPORTED__SEARCH_METHOD__UNSET_SEARCH_METHOD = 3;
    public static final int PHOTOPICKER_SEARCH_INFO_REPORTED__SEARCH_METHOD__CATEGORY_SEARCH = 4;

    // Annotation constants.
    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;

    @android.annotation.SuppressLint("InlinedApi")
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;


    // Write methods
    public static void write(int code, int arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, boolean arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (MEDIA_CONTENT_DELETED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (PHOTOPICKER_UI_EVENT_LOGGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (PHOTOPICKER_MENU_INTERACTION_LOGGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (MEDIA_PROVIDER_PERMISSION_REQUESTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (PHOTOPICKER_MEDIA_LIBRARY_INFO_LOGGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5, boolean arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, boolean arg7, int arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, boolean arg8, boolean arg9, boolean arg10, boolean arg11, boolean arg12, boolean arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeBoolean(arg8);
        builder.writeBoolean(arg9);
        builder.writeBoolean(arg10);
        builder.writeBoolean(arg11);
        builder.writeBoolean(arg12);
        builder.writeBoolean(arg13);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, boolean arg9, int arg10, int arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (PHOTOPICKER_SESSION_INFO_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        if (PHOTOPICKER_SESSION_INFO_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeBoolean(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, long arg4, float arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeFloat(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, long arg3, float arg4, float arg5, float arg6, float arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeFloat(arg4);
        builder.writeFloat(arg5);
        builder.writeFloat(arg6);
        builder.writeFloat(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (UI_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PDF_API_USAGE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, int arg3, int arg4, int arg5, long arg6, int arg7, int arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PDF_SEARCH_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeLong(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, float arg3, int arg4, int arg5, int arg6, long arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PDF_LOAD_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeFloat(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeLong(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, float arg3, float arg4, float arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeFloat(arg3);
        builder.writeFloat(arg4);
        builder.writeFloat(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, float arg2, long arg3, long arg4, long arg5, long arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeFloat(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, int arg4, boolean arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, long arg3, int arg4, long arg5, long arg6, long arg7, int arg8, long arg9, long arg10, boolean arg11, int arg12, long arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeInt(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeBoolean(arg11);
        builder.writeInt(arg12);
        builder.writeLong(arg13);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, byte[] arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (GENERAL_EXTERNAL_STORAGE_ACCESS_STATS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeByteArray(null == arg5 ? new byte[0] : arg5);

        return builder.build();
    }

}
