/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.federatedcompute.common;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.internal.util.Preconditions;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * A container for information regarding an example store access, including the task name, the
 * selection criteria and the number of examples which has been used.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public class ExampleConsumption implements Parcelable {
    @NonNull private String mTaskId;

    @Nullable private byte[] mSelectionCriteria;

    private int mExampleCount;

    @Nullable private byte[] mResumptionToken;

    @Nullable private String mCollectionUri;

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/federatedcompute/common/ExampleConsumption.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @DataClass.Generated.Member
    /* package-private */ ExampleConsumption(
            @NonNull String taskId,
            @Nullable byte[] selectionCriteria,
            int exampleCount,
            @Nullable byte[] resumptionToken,
            @Nullable String collectionUri) {
        this.mTaskId = taskId;
        AnnotationValidations.validate(NonNull.class, null, mTaskId);
        this.mSelectionCriteria = selectionCriteria;
        this.mExampleCount = exampleCount;
        this.mResumptionToken = resumptionToken;
        this.mCollectionUri = collectionUri;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @NonNull String getTaskId() {
        return mTaskId;
    }

    @DataClass.Generated.Member
    public @Nullable byte[] getSelectionCriteria() {
        return mSelectionCriteria;
    }

    @DataClass.Generated.Member
    public int getExampleCount() {
        return mExampleCount;
    }

    @DataClass.Generated.Member
    public @Nullable byte[] getResumptionToken() {
        return mResumptionToken;
    }

    @DataClass.Generated.Member
    public @Nullable String getCollectionUri() {
        return mCollectionUri;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(ExampleConsumption other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        ExampleConsumption that = (ExampleConsumption) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mTaskId, that.mTaskId)
                && java.util.Arrays.equals(mSelectionCriteria, that.mSelectionCriteria)
                && mExampleCount == that.mExampleCount
                && java.util.Arrays.equals(mResumptionToken, that.mResumptionToken)
                && java.util.Objects.equals(mCollectionUri, that.mCollectionUri);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mTaskId);
        _hash = 31 * _hash + java.util.Arrays.hashCode(mSelectionCriteria);
        _hash = 31 * _hash + mExampleCount;
        _hash = 31 * _hash + java.util.Arrays.hashCode(mResumptionToken);
        _hash = 31 * _hash + java.util.Objects.hashCode(mCollectionUri);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mCollectionUri != null) flg |= 0x10;
        dest.writeByte(flg);
        dest.writeString(mTaskId);
        dest.writeByteArray(mSelectionCriteria);
        dest.writeInt(mExampleCount);
        dest.writeByteArray(mResumptionToken);
        if (mCollectionUri != null) dest.writeString(mCollectionUri);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() {
        return 0;
    }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    protected ExampleConsumption(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        String taskId = in.readString();
        byte[] selectionCriteria = in.createByteArray();
        int exampleCount = in.readInt();
        byte[] resumptionToken = in.createByteArray();
        String collectionUri = (flg & 0x10) == 0 ? null : in.readString();

        this.mTaskId = taskId;
        AnnotationValidations.validate(NonNull.class, null, mTaskId);
        this.mSelectionCriteria = selectionCriteria;
        this.mExampleCount = exampleCount;
        this.mResumptionToken = resumptionToken;
        this.mCollectionUri = collectionUri;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<ExampleConsumption> CREATOR =
            new Parcelable.Creator<ExampleConsumption>() {
                @Override
                public ExampleConsumption[] newArray(int size) {
                    return new ExampleConsumption[size];
                }

                @Override
                public ExampleConsumption createFromParcel(@NonNull android.os.Parcel in) {
                    return new ExampleConsumption(in);
                }
            };

    /** A builder for {@link ExampleConsumption} */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static class Builder {

        private @NonNull String mTaskId;
        private @Nullable byte[] mSelectionCriteria;
        private int mExampleCount;
        private @Nullable byte[] mResumptionToken;
        private @Nullable String mCollectionUri;

        private long mBuilderFieldsSet = 0L;

        public Builder() {}

        @DataClass.Generated.Member
        public @NonNull Builder setTaskId(@NonNull String value) {
            checkNotUsed();
            Preconditions.checkStringNotEmpty(value);
            mBuilderFieldsSet |= 0x1;
            mTaskId = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setSelectionCriteria(@NonNull byte... value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mSelectionCriteria = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setExampleCount(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mExampleCount = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setResumptionToken(@NonNull byte... value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mResumptionToken = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setCollectionUri(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10;
            mCollectionUri = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull ExampleConsumption build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x20; // Mark builder used

            ExampleConsumption o =
                    new ExampleConsumption(
                            mTaskId,
                            mSelectionCriteria,
                            mExampleCount,
                            mResumptionToken,
                            mCollectionUri);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x20) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1714846062890L,
            codegenVersion = "1.0.23",
            sourceFile =
                    "packages/modules/OnDevicePersonalization/framework/java/android/federatedcompute/common/ExampleConsumption.java",
            inputSignatures =
                    "private @android.annotation.NonNull java.lang.String mTaskId\nprivate @android.annotation.Nullable byte[] mSelectionCriteria\nprivate  int mExampleCount\nprivate @android.annotation.Nullable byte[] mResumptionToken\nprivate @android.annotation.Nullable java.lang.String mCollectionUri\nclass ExampleConsumption extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}

    // @formatter:on
    // End of generated code

}
