/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.bluetooth;

import android.annotation.SystemApi;

/**
 * Bluetooth Assigned Numbers.
 *
 * <p>For now we only include Company ID values.
 *
 * @see <a href="https://www.bluetooth.org/technical/assignednumbers/identifiers.htm">The Official
 *     Bluetooth SIG Member Website | Company Identifiers</a>
 */
public class BluetoothAssignedNumbers {

    // Bluetooth SIG Company ID values
    /*
     * Ericsson Technology Licensing.
     */
    public static final int ERICSSON_TECHNOLOGY = 0x0000;

    /*
     * Nokia Mobile Phones.
     */
    public static final int NOKIA_MOBILE_PHONES = 0x0001;

    /*
     * Intel Corp.
     */
    public static final int INTEL = 0x0002;

    /*
     * IBM Corp.
     */
    public static final int IBM = 0x0003;

    /*
     * Toshiba Corp.
     */
    public static final int TOSHIBA = 0x0004;

    /*
     * 3Com.
     */
    public static final int THREECOM = 0x0005;

    /*
     * Microsoft.
     */
    public static final int MICROSOFT = 0x0006;

    /*
     * Lucent.
     */
    public static final int LUCENT = 0x0007;

    /*
     * Motorola.
     */
    public static final int MOTOROLA = 0x0008;

    /*
     * Infineon Technologies AG.
     */
    public static final int INFINEON_TECHNOLOGIES = 0x0009;

    /*
     * Cambridge Silicon Radio.
     */
    public static final int CAMBRIDGE_SILICON_RADIO = 0x000A;

    /*
     * Silicon Wave.
     */
    public static final int SILICON_WAVE = 0x000B;

    /*
     * Digianswer A/S.
     */
    public static final int DIGIANSWER = 0x000C;

    /*
     * Texas Instruments Inc.
     */
    public static final int TEXAS_INSTRUMENTS = 0x000D;

    /*
     * Parthus Technologies Inc.
     */
    public static final int PARTHUS_TECHNOLOGIES = 0x000E;

    /*
     * Broadcom Corporation.
     */
    public static final int BROADCOM = 0x000F;

    /*
     * Mitel Semiconductor.
     */
    public static final int MITEL_SEMICONDUCTOR = 0x0010;

    /*
     * Widcomm, Inc.
     */
    public static final int WIDCOMM = 0x0011;

    /*
     * Zeevo, Inc.
     */
    public static final int ZEEVO = 0x0012;

    /*
     * Atmel Corporation.
     */
    public static final int ATMEL = 0x0013;

    /*
     * Mitsubishi Electric Corporation.
     */
    public static final int MITSUBISHI_ELECTRIC = 0x0014;

    /*
     * RTX Telecom A/S.
     */
    public static final int RTX_TELECOM = 0x0015;

    /*
     * KC Technology Inc.
     */
    public static final int KC_TECHNOLOGY = 0x0016;

    /*
     * Newlogic.
     */
    public static final int NEWLOGIC = 0x0017;

    /*
     * Transilica, Inc.
     */
    public static final int TRANSILICA = 0x0018;

    /*
     * Rohde & Schwarz GmbH & Co. KG.
     */
    public static final int ROHDE_AND_SCHWARZ = 0x0019;

    /*
     * TTPCom Limited.
     */
    public static final int TTPCOM = 0x001A;

    /*
     * Signia Technologies, Inc.
     */
    public static final int SIGNIA_TECHNOLOGIES = 0x001B;

    /*
     * Conexant Systems Inc.
     */
    public static final int CONEXANT_SYSTEMS = 0x001C;

    /*
     * Qualcomm.
     */
    public static final int QUALCOMM = 0x001D;

    /*
     * Inventel.
     */
    public static final int INVENTEL = 0x001E;

    /*
     * AVM Berlin.
     */
    public static final int AVM_BERLIN = 0x001F;

    /*
     * BandSpeed, Inc.
     */
    public static final int BANDSPEED = 0x0020;

    /*
     * Mansella Ltd.
     */
    public static final int MANSELLA = 0x0021;

    /*
     * NEC Corporation.
     */
    public static final int NEC = 0x0022;

    /*
     * WavePlus Technology Co., Ltd.
     */
    public static final int WAVEPLUS_TECHNOLOGY = 0x0023;

    /*
     * Alcatel.
     */
    public static final int ALCATEL = 0x0024;

    /*
     * Philips Semiconductors.
     */
    public static final int PHILIPS_SEMICONDUCTORS = 0x0025;

    /*
     * C Technologies.
     */
    public static final int C_TECHNOLOGIES = 0x0026;

    /*
     * Open Interface.
     */
    public static final int OPEN_INTERFACE = 0x0027;

    /*
     * R F Micro Devices.
     */
    public static final int RF_MICRO_DEVICES = 0x0028;

    /*
     * Hitachi Ltd.
     */
    public static final int HITACHI = 0x0029;

    /*
     * Symbol Technologies, Inc.
     */
    public static final int SYMBOL_TECHNOLOGIES = 0x002A;

    /*
     * Tenovis.
     */
    public static final int TENOVIS = 0x002B;

    /*
     * Macronix International Co. Ltd.
     */
    public static final int MACRONIX = 0x002C;

    /*
     * GCT Semiconductor.
     */
    public static final int GCT_SEMICONDUCTOR = 0x002D;

    /*
     * Norwood Systems.
     */
    public static final int NORWOOD_SYSTEMS = 0x002E;

    /*
     * MewTel Technology Inc.
     */
    public static final int MEWTEL_TECHNOLOGY = 0x002F;

    /*
     * ST Microelectronics.
     */
    public static final int ST_MICROELECTRONICS = 0x0030;

    /*
     * Synopsys.
     */
    public static final int SYNOPSYS = 0x0031;

    /*
     * Red-M (Communications) Ltd.
     */
    public static final int RED_M = 0x0032;

    /*
     * Commil Ltd.
     */
    public static final int COMMIL = 0x0033;

    /*
     * Computer Access Technology Corporation (CATC).
     */
    public static final int CATC = 0x0034;

    /*
     * Eclipse (HQ Espana) S.L.
     */
    public static final int ECLIPSE = 0x0035;

    /*
     * Renesas Technology Corp.
     */
    public static final int RENESAS_TECHNOLOGY = 0x0036;

    /*
     * Mobilian Corporation.
     */
    public static final int MOBILIAN_CORPORATION = 0x0037;

    /*
     * Terax.
     */
    public static final int TERAX = 0x0038;

    /*
     * Integrated System Solution Corp.
     */
    public static final int INTEGRATED_SYSTEM_SOLUTION = 0x0039;

    /*
     * Matsushita Electric Industrial Co., Ltd.
     */
    public static final int MATSUSHITA_ELECTRIC = 0x003A;

    /*
     * Gennum Corporation.
     */
    public static final int GENNUM = 0x003B;

    /*
     * Research In Motion.
     */
    public static final int RESEARCH_IN_MOTION = 0x003C;

    /*
     * IPextreme, Inc.
     */
    public static final int IPEXTREME = 0x003D;

    /*
     * Systems and Chips, Inc.
     */
    public static final int SYSTEMS_AND_CHIPS = 0x003E;

    /*
     * Bluetooth SIG, Inc.
     */
    public static final int BLUETOOTH_SIG = 0x003F;

    /*
     * Seiko Epson Corporation.
     */
    public static final int SEIKO_EPSON = 0x0040;

    /*
     * Integrated Silicon Solution Taiwan, Inc.
     */
    public static final int INTEGRATED_SILICON_SOLUTION = 0x0041;

    /*
     * CONWISE Technology Corporation Ltd.
     */
    public static final int CONWISE_TECHNOLOGY = 0x0042;

    /*
     * PARROT SA.
     */
    public static final int PARROT = 0x0043;

    /*
     * Socket Mobile.
     */
    public static final int SOCKET_MOBILE = 0x0044;

    /*
     * Atheros Communications, Inc.
     */
    public static final int ATHEROS_COMMUNICATIONS = 0x0045;

    /*
     * MediaTek, Inc.
     */
    public static final int MEDIATEK = 0x0046;

    /*
     * Bluegiga.
     */
    public static final int BLUEGIGA = 0x0047;

    /*
     * Marvell Technology Group Ltd.
     */
    public static final int MARVELL = 0x0048;

    /*
     * 3DSP Corporation.
     */
    public static final int THREE_DSP = 0x0049;

    /*
     * Accel Semiconductor Ltd.
     */
    public static final int ACCEL_SEMICONDUCTOR = 0x004A;

    /*
     * Continental Automotive Systems.
     */
    public static final int CONTINENTAL_AUTOMOTIVE = 0x004B;

    /*
     * Apple, Inc.
     */
    public static final int APPLE = 0x004C;

    /*
     * Staccato Communications, Inc.
     */
    public static final int STACCATO_COMMUNICATIONS = 0x004D;

    /*
     * Avago Technologies.
     */
    public static final int AVAGO = 0x004E;

    /*
     * APT Licensing Ltd.
     */
    public static final int APT_LICENSING = 0x004F;

    /*
     * SiRF Technology, Inc.
     */
    public static final int SIRF_TECHNOLOGY = 0x0050;

    /*
     * Tzero Technologies, Inc.
     */
    public static final int TZERO_TECHNOLOGIES = 0x0051;

    /*
     * J&M Corporation.
     */
    public static final int J_AND_M = 0x0052;

    /*
     * Free2move AB.
     */
    public static final int FREE2MOVE = 0x0053;

    /*
     * 3DiJoy Corporation.
     */
    public static final int THREE_DIJOY = 0x0054;

    /*
     * Plantronics, Inc.
     */
    public static final int PLANTRONICS = 0x0055;

    /*
     * Sony Ericsson Mobile Communications.
     */
    public static final int SONY_ERICSSON = 0x0056;

    /*
     * Harman International Industries, Inc.
     */
    public static final int HARMAN_INTERNATIONAL = 0x0057;

    /*
     * Vizio, Inc.
     */
    public static final int VIZIO = 0x0058;

    /*
     * Nordic Semiconductor ASA.
     */
    public static final int NORDIC_SEMICONDUCTOR = 0x0059;

    /*
     * EM Microelectronic-Marin SA.
     */
    public static final int EM_MICROELECTRONIC_MARIN = 0x005A;

    /*
     * Ralink Technology Corporation.
     */
    public static final int RALINK_TECHNOLOGY = 0x005B;

    /*
     * Belkin International, Inc.
     */
    public static final int BELKIN_INTERNATIONAL = 0x005C;

    /*
     * Realtek Semiconductor Corporation.
     */
    public static final int REALTEK_SEMICONDUCTOR = 0x005D;

    /*
     * Stonestreet One, LLC.
     */
    public static final int STONESTREET_ONE = 0x005E;

    /*
     * Wicentric, Inc.
     */
    public static final int WICENTRIC = 0x005F;

    /*
     * RivieraWaves S.A.S.
     */
    public static final int RIVIERAWAVES = 0x0060;

    /*
     * RDA Microelectronics.
     */
    public static final int RDA_MICROELECTRONICS = 0x0061;

    /*
     * Gibson Guitars.
     */
    public static final int GIBSON_GUITARS = 0x0062;

    /*
     * MiCommand Inc.
     */
    public static final int MICOMMAND = 0x0063;

    /*
     * Band XI International, LLC.
     */
    public static final int BAND_XI_INTERNATIONAL = 0x0064;

    /*
     * Hewlett-Packard Company.
     */
    public static final int HEWLETT_PACKARD = 0x0065;

    /*
     * 9Solutions Oy.
     */
    public static final int NINE_SOLUTIONS = 0x0066;

    /*
     * GN Netcom A/S.
     */
    public static final int GN_NETCOM = 0x0067;

    /*
     * General Motors.
     */
    public static final int GENERAL_MOTORS = 0x0068;

    /*
     * A&D Engineering, Inc.
     */
    public static final int A_AND_D_ENGINEERING = 0x0069;

    /*
     * MindTree Ltd.
     */
    public static final int MINDTREE = 0x006A;

    /*
     * Polar Electro OY.
     */
    public static final int POLAR_ELECTRO = 0x006B;

    /*
     * Beautiful Enterprise Co., Ltd.
     */
    public static final int BEAUTIFUL_ENTERPRISE = 0x006C;

    /*
     * BriarTek, Inc.
     */
    public static final int BRIARTEK = 0x006D;

    /*
     * Summit Data Communications, Inc.
     */
    public static final int SUMMIT_DATA_COMMUNICATIONS = 0x006E;

    /*
     * Sound ID.
     */
    public static final int SOUND_ID = 0x006F;

    /*
     * Monster, LLC.
     */
    public static final int MONSTER = 0x0070;

    /*
     * connectBlue AB.
     */
    public static final int CONNECTBLUE = 0x0071;

    /*
     * ShangHai Super Smart Electronics Co. Ltd.
     */
    public static final int SHANGHAI_SUPER_SMART_ELECTRONICS = 0x0072;

    /*
     * Group Sense Ltd.
     */
    public static final int GROUP_SENSE = 0x0073;

    /*
     * Zomm, LLC.
     */
    public static final int ZOMM = 0x0074;

    /*
     * Samsung Electronics Co. Ltd.
     */
    public static final int SAMSUNG_ELECTRONICS = 0x0075;

    /*
     * Creative Technology Ltd.
     */
    public static final int CREATIVE_TECHNOLOGY = 0x0076;

    /*
     * Laird Technologies.
     */
    public static final int LAIRD_TECHNOLOGIES = 0x0077;

    /*
     * Nike, Inc.
     */
    public static final int NIKE = 0x0078;

    /*
     * lesswire AG.
     */
    public static final int LESSWIRE = 0x0079;

    /*
     * MStar Semiconductor, Inc.
     */
    public static final int MSTAR_SEMICONDUCTOR = 0x007A;

    /*
     * Hanlynn Technologies.
     */
    public static final int HANLYNN_TECHNOLOGIES = 0x007B;

    /*
     * A & R Cambridge.
     */
    public static final int A_AND_R_CAMBRIDGE = 0x007C;

    /*
     * Seers Technology Co. Ltd.
     */
    public static final int SEERS_TECHNOLOGY = 0x007D;

    /*
     * Sports Tracking Technologies Ltd.
     */
    public static final int SPORTS_TRACKING_TECHNOLOGIES = 0x007E;

    /*
     * Autonet Mobile.
     */
    public static final int AUTONET_MOBILE = 0x007F;

    /*
     * DeLorme Publishing Company, Inc.
     */
    public static final int DELORME_PUBLISHING_COMPANY = 0x0080;

    /*
     * WuXi Vimicro.
     */
    public static final int WUXI_VIMICRO = 0x0081;

    /*
     * Sennheiser Communications A/S.
     */
    public static final int SENNHEISER_COMMUNICATIONS = 0x0082;

    /*
     * TimeKeeping Systems, Inc.
     */
    public static final int TIMEKEEPING_SYSTEMS = 0x0083;

    /*
     * Ludus Helsinki Ltd.
     */
    public static final int LUDUS_HELSINKI = 0x0084;

    /*
     * BlueRadios, Inc.
     */
    public static final int BLUERADIOS = 0x0085;

    /*
     * equinox AG.
     */
    public static final int EQUINOX_AG = 0x0086;

    /*
     * Garmin International, Inc.
     */
    public static final int GARMIN_INTERNATIONAL = 0x0087;

    /*
     * Ecotest.
     */
    public static final int ECOTEST = 0x0088;

    /*
     * GN ReSound A/S.
     */
    public static final int GN_RESOUND = 0x0089;

    /*
     * Jawbone.
     */
    public static final int JAWBONE = 0x008A;

    /*
     * Topcorn Positioning Systems, LLC.
     */
    public static final int TOPCORN_POSITIONING_SYSTEMS = 0x008B;

    /*
     * Qualcomm Labs, Inc.
     */
    public static final int QUALCOMM_LABS = 0x008C;

    /*
     * Zscan Software.
     */
    public static final int ZSCAN_SOFTWARE = 0x008D;

    /*
     * Quintic Corp.
     */
    public static final int QUINTIC = 0x008E;

    /*
     * Stollman E+V GmbH.
     */
    public static final int STOLLMAN_E_PLUS_V = 0x008F;

    /*
     * Funai Electric Co., Ltd.
     */
    public static final int FUNAI_ELECTRIC = 0x0090;

    /*
     * Advanced PANMOBIL Systems GmbH & Co. KG.
     */
    public static final int ADVANCED_PANMOBIL_SYSTEMS = 0x0091;

    /*
     * ThinkOptics, Inc.
     */
    public static final int THINKOPTICS = 0x0092;

    /*
     * Universal Electronics, Inc.
     */
    public static final int UNIVERSAL_ELECTRONICS = 0x0093;

    /*
     * Airoha Technology Corp.
     */
    public static final int AIROHA_TECHNOLOGY = 0x0094;

    /*
     * NEC Lighting, Ltd.
     */
    public static final int NEC_LIGHTING = 0x0095;

    /*
     * ODM Technology, Inc.
     */
    public static final int ODM_TECHNOLOGY = 0x0096;

    /*
     * Bluetrek Technologies Limited.
     */
    public static final int BLUETREK_TECHNOLOGIES = 0x0097;

    /*
     * zer01.tv GmbH.
     */
    public static final int ZER01_TV = 0x0098;

    /*
     * i.Tech Dynamic Global Distribution Ltd.
     */
    public static final int I_TECH_DYNAMIC_GLOBAL_DISTRIBUTION = 0x0099;

    /*
     * Alpwise.
     */
    public static final int ALPWISE = 0x009A;

    /*
     * Jiangsu Toppower Automotive Electronics Co., Ltd.
     */
    public static final int JIANGSU_TOPPOWER_AUTOMOTIVE_ELECTRONICS = 0x009B;

    /*
     * Colorfy, Inc.
     */
    public static final int COLORFY = 0x009C;

    /*
     * Geoforce Inc.
     */
    public static final int GEOFORCE = 0x009D;

    /*
     * Bose Corporation.
     */
    public static final int BOSE = 0x009E;

    /*
     * Suunto Oy.
     */
    public static final int SUUNTO = 0x009F;

    /*
     * Kensington Computer Products Group.
     */
    public static final int KENSINGTON_COMPUTER_PRODUCTS_GROUP = 0x00A0;

    /*
     * SR-Medizinelektronik.
     */
    public static final int SR_MEDIZINELEKTRONIK = 0x00A1;

    /*
     * Vertu Corporation Limited.
     */
    public static final int VERTU = 0x00A2;

    /*
     * Meta Watch Ltd.
     */
    public static final int META_WATCH = 0x00A3;

    /*
     * LINAK A/S.
     */
    public static final int LINAK = 0x00A4;

    /*
     * OTL Dynamics LLC.
     */
    public static final int OTL_DYNAMICS = 0x00A5;

    /*
     * Panda Ocean Inc.
     */
    public static final int PANDA_OCEAN = 0x00A6;

    /*
     * Visteon Corporation.
     */
    public static final int VISTEON = 0x00A7;

    /*
     * ARP Devices Limited.
     */
    public static final int ARP_DEVICES = 0x00A8;

    /*
     * Magneti Marelli S.p.A.
     */
    public static final int MAGNETI_MARELLI = 0x00A9;

    /*
     * CAEN RFID srl.
     */
    public static final int CAEN_RFID = 0x00AA;

    /*
     * Ingenieur-Systemgruppe Zahn GmbH.
     */
    public static final int INGENIEUR_SYSTEMGRUPPE_ZAHN = 0x00AB;

    /*
     * Green Throttle Games.
     */
    public static final int GREEN_THROTTLE_GAMES = 0x00AC;

    /*
     * Peter Systemtechnik GmbH.
     */
    public static final int PETER_SYSTEMTECHNIK = 0x00AD;

    /*
     * Omegawave Oy.
     */
    public static final int OMEGAWAVE = 0x00AE;

    /*
     * Cinetix.
     */
    public static final int CINETIX = 0x00AF;

    /*
     * Passif Semiconductor Corp.
     */
    public static final int PASSIF_SEMICONDUCTOR = 0x00B0;

    /*
     * Saris Cycling Group, Inc.
     */
    public static final int SARIS_CYCLING_GROUP = 0x00B1;

    /*
     * Bekey A/S.
     */
    public static final int BEKEY = 0x00B2;

    /*
     * Clarinox Technologies Pty. Ltd.
     */
    public static final int CLARINOX_TECHNOLOGIES = 0x00B3;

    /*
     * BDE Technology Co., Ltd.
     */
    public static final int BDE_TECHNOLOGY = 0x00B4;

    /*
     * Swirl Networks.
     */
    public static final int SWIRL_NETWORKS = 0x00B5;

    /*
     * Meso international.
     */
    public static final int MESO_INTERNATIONAL = 0x00B6;

    /*
     * TreLab Ltd.
     */
    public static final int TRELAB = 0x00B7;

    /*
     * Qualcomm Innovation Center, Inc. (QuIC).
     */
    public static final int QUALCOMM_INNOVATION_CENTER = 0x00B8;

    /*
     * Johnson Controls, Inc.
     */
    public static final int JOHNSON_CONTROLS = 0x00B9;

    /*
     * Starkey Laboratories Inc.
     */
    public static final int STARKEY_LABORATORIES = 0x00BA;

    /*
     * S-Power Electronics Limited.
     */
    public static final int S_POWER_ELECTRONICS = 0x00BB;

    /*
     * Ace Sensor Inc.
     */
    public static final int ACE_SENSOR = 0x00BC;

    /*
     * Aplix Corporation.
     */
    public static final int APLIX = 0x00BD;

    /*
     * AAMP of America.
     */
    public static final int AAMP_OF_AMERICA = 0x00BE;

    /*
     * Stalmart Technology Limited.
     */
    public static final int STALMART_TECHNOLOGY = 0x00BF;

    /*
     * AMICCOM Electronics Corporation.
     */
    public static final int AMICCOM_ELECTRONICS = 0x00C0;

    /*
     * Shenzhen Excelsecu Data Technology Co.,Ltd.
     */
    public static final int SHENZHEN_EXCELSECU_DATA_TECHNOLOGY = 0x00C1;

    /*
     * Geneq Inc.
     */
    public static final int GENEQ = 0x00C2;

    /*
     * adidas AG.
     */
    public static final int ADIDAS = 0x00C3;

    /*
     * LG Electronics.
     */
    public static final int LG_ELECTRONICS = 0x00C4;

    /*
     * Onset Computer Corporation.
     */
    public static final int ONSET_COMPUTER = 0x00C5;

    /*
     * Selfly BV.
     */
    public static final int SELFLY = 0x00C6;

    /*
     * Quuppa Oy.
     */
    public static final int QUUPPA = 0x00C7;

    /*
     * GeLo Inc.
     */
    public static final int GELO = 0x00C8;

    /*
     * Evluma.
     */
    public static final int EVLUMA = 0x00C9;

    /*
     * MC10.
     */
    public static final int MC10 = 0x00CA;

    /*
     * Binauric SE.
     */
    public static final int BINAURIC = 0x00CB;

    /*
     * Beats Electronics.
     */
    public static final int BEATS_ELECTRONICS = 0x00CC;

    /*
     * Microchip Technology Inc.
     */
    public static final int MICROCHIP_TECHNOLOGY = 0x00CD;

    /*
     * Elgato Systems GmbH.
     */
    public static final int ELGATO_SYSTEMS = 0x00CE;

    /*
     * ARCHOS SA.
     */
    public static final int ARCHOS = 0x00CF;

    /*
     * Dexcom, Inc.
     */
    public static final int DEXCOM = 0x00D0;

    /*
     * Polar Electro Europe B.V.
     */
    public static final int POLAR_ELECTRO_EUROPE = 0x00D1;

    /*
     * Dialog Semiconductor B.V.
     */
    public static final int DIALOG_SEMICONDUCTOR = 0x00D2;

    /*
     * Taixingbang Technology (HK) Co,. LTD.
     */
    public static final int TAIXINGBANG_TECHNOLOGY = 0x00D3;

    /*
     * Kawantech.
     */
    public static final int KAWANTECH = 0x00D4;

    /*
     * Austco Communication Systems.
     */
    public static final int AUSTCO_COMMUNICATION_SYSTEMS = 0x00D5;

    /*
     * Timex Group USA, Inc.
     */
    public static final int TIMEX_GROUP_USA = 0x00D6;

    /*
     * Qualcomm Technologies, Inc.
     */
    public static final int QUALCOMM_TECHNOLOGIES = 0x00D7;

    /*
     * Qualcomm Connected Experiences, Inc.
     */
    public static final int QUALCOMM_CONNECTED_EXPERIENCES = 0x00D8;

    /*
     * Voyetra Turtle Beach.
     */
    public static final int VOYETRA_TURTLE_BEACH = 0x00D9;

    /*
     * txtr GmbH.
     */
    public static final int TXTR = 0x00DA;

    /*
     * Biosentronics.
     */
    public static final int BIOSENTRONICS = 0x00DB;

    /*
     * Procter & Gamble.
     */
    public static final int PROCTER_AND_GAMBLE = 0x00DC;

    /*
     * Hosiden Corporation.
     */
    public static final int HOSIDEN = 0x00DD;

    /*
     * Muzik LLC.
     */
    public static final int MUZIK = 0x00DE;

    /*
     * Misfit Wearables Corp.
     */
    public static final int MISFIT_WEARABLES = 0x00DF;

    /*
     * Google.
     */
    public static final int GOOGLE = 0x00E0;

    /*
     * Danlers Ltd.
     */
    public static final int DANLERS = 0x00E1;

    /*
     * Semilink Inc.
     */
    public static final int SEMILINK = 0x00E2;

    /*
     * You can't instantiate one of these.
     */
    private BluetoothAssignedNumbers() {}

    /**
     * The values of {@code OrganizationId} are assigned by Bluetooth SIG. For more details refer to
     * Transport Discovery Service Organization IDs.
     * (https://www.bluetooth.com/specifications/assigned-numbers/)
     *
     * @hide
     */
    @SystemApi
    public static class OrganizationId {
        /*
         * This is for Bluetooth SIG Organization ID .
         */
        public static final int BLUETOOTH_SIG = 0x01;

        /*
         * This is for Wi-Fi Alliance Neighbor Awareness Networking Organization ID.
         */
        public static final int WIFI_ALLIANCE_NEIGHBOR_AWARENESS_NETWORKING = 0x02;

        /** This is for WiFi Alliance Service Advertisement Organization ID. */
        public static final int WIFI_ALLIANCE_SERVICE_ADVERTISEMENT = 0x03;

        private OrganizationId() {}
    }
}
