/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

import java.util.Collections;
import java.util.List;

/**
 * Parcelable version of {@link WebTriggerOutput}.
 * @hide
 */
@DataClass(genAidl = false, genBuilder = false)
public final class WebTriggerOutputParcel implements Parcelable {
    /**
     * Persistent data to be written to the REQUESTS table after
     * {@link IsolatedWorker#onWebTrigger(WebTriggerInput, android.os.OutcomeReceiver)}
     * completes. If null, no persistent data will be written.
     */
    @Nullable private RequestLogRecord mRequestLogRecord = null;

    /**
     * A list of {@link EventLogRecord}. Writes events to the EVENTS table and associates
     * them with requests with the specified corresponding {@link RequestLogRecord} from
     * {@link EventLogRecord#getRequestLogRecord()}.
     * If the event does not contain a {@link RequestLogRecord} that was previously written
     * by this service, the {@link EventLogRecord} is not written.
     *
     */
    @DataClass.PluralOf("eventLogRecord")
    @NonNull private List<EventLogRecord> mEventLogRecords = Collections.emptyList();

    /** @hide */
    public WebTriggerOutputParcel(@NonNull WebTriggerOutput value) {
        this(value.getRequestLogRecord(), value.getEventLogRecords());
    }



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/WebTriggerOutputParcel.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new WebTriggerOutputParcel.
     *
     * @param requestLogRecord
     *   Persistent data to be written to the REQUESTS table after
     *   {@link IsolatedWorker#onWebTrigger(WebTriggerInput, android.os.OutcomeReceiver)}
     *   completes. If null, no persistent data will be written.
     * @param eventLogRecords
     *   A list of {@link EventLogRecord}. Writes events to the EVENTS table and associates
     *   them with requests with the specified corresponding {@link RequestLogRecord} from
     *   {@link EventLogRecord#getRequestLogRecord()}.
     *   If the event does not contain a {@link RequestLogRecord} that was previously written
     *   by this service, the {@link EventLogRecord} is not written.
     */
    @DataClass.Generated.Member
    public WebTriggerOutputParcel(
            @Nullable RequestLogRecord requestLogRecord,
            @NonNull List<EventLogRecord> eventLogRecords) {
        this.mRequestLogRecord = requestLogRecord;
        this.mEventLogRecords = eventLogRecords;
        AnnotationValidations.validate(
                NonNull.class, null, mEventLogRecords);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Persistent data to be written to the REQUESTS table after
     * {@link IsolatedWorker#onWebTrigger(WebTriggerInput, android.os.OutcomeReceiver)}
     * completes. If null, no persistent data will be written.
     */
    @DataClass.Generated.Member
    public @Nullable RequestLogRecord getRequestLogRecord() {
        return mRequestLogRecord;
    }

    /**
     * A list of {@link EventLogRecord}. Writes events to the EVENTS table and associates
     * them with requests with the specified corresponding {@link RequestLogRecord} from
     * {@link EventLogRecord#getRequestLogRecord()}.
     * If the event does not contain a {@link RequestLogRecord} that was previously written
     * by this service, the {@link EventLogRecord} is not written.
     */
    @DataClass.Generated.Member
    public @NonNull List<EventLogRecord> getEventLogRecords() {
        return mEventLogRecords;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mRequestLogRecord != null) flg |= 0x1;
        dest.writeByte(flg);
        if (mRequestLogRecord != null) dest.writeTypedObject(mRequestLogRecord, flags);
        dest.writeParcelableList(mEventLogRecords, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ WebTriggerOutputParcel(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        RequestLogRecord requestLogRecord = (flg & 0x1) == 0 ? null : (RequestLogRecord) in.readTypedObject(RequestLogRecord.CREATOR);
        List<EventLogRecord> eventLogRecords = new java.util.ArrayList<>();
        in.readParcelableList(eventLogRecords, EventLogRecord.class.getClassLoader());

        this.mRequestLogRecord = requestLogRecord;
        this.mEventLogRecords = eventLogRecords;
        AnnotationValidations.validate(
                NonNull.class, null, mEventLogRecords);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<WebTriggerOutputParcel> CREATOR
            = new Parcelable.Creator<WebTriggerOutputParcel>() {
        @Override
        public WebTriggerOutputParcel[] newArray(int size) {
            return new WebTriggerOutputParcel[size];
        }

        @Override
        public WebTriggerOutputParcel createFromParcel(@NonNull android.os.Parcel in) {
            return new WebTriggerOutputParcel(in);
        }
    };

    @DataClass.Generated(
            time = 1704482141383L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/WebTriggerOutputParcel.java",
            inputSignatures = "private @android.annotation.Nullable android.adservices.ondevicepersonalization.RequestLogRecord mRequestLogRecord\nprivate @com.android.ondevicepersonalization.internal.util.DataClass.PluralOf(\"eventLogRecord\") @android.annotation.NonNull java.util.List<android.adservices.ondevicepersonalization.EventLogRecord> mEventLogRecords\nclass WebTriggerOutputParcel extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genAidl=false, genBuilder=false)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
