/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.NonNull;
import android.net.Uri;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Parcelable version of {@link WebTriggerInput}.
 * @hide
 */
@DataClass(genAidl = false, genHiddenBuilder = true)
public final class WebTriggerInputParcel implements Parcelable {
    /** The destination URL (landing page) where the trigger registration occurred. */
    @NonNull private Uri mDestinationUrl;

    /** The app where the trigger registration occurred */
    @NonNull private String mAppPackageName;

    /** The data to be sent to the isolated service.  */
    @NonNull private byte[] mData;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/WebTriggerInputParcel.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ WebTriggerInputParcel(
            @NonNull Uri destinationUrl,
            @NonNull String appPackageName,
            @NonNull byte[] data) {
        this.mDestinationUrl = destinationUrl;
        AnnotationValidations.validate(
                NonNull.class, null, mDestinationUrl);
        this.mAppPackageName = appPackageName;
        AnnotationValidations.validate(
                NonNull.class, null, mAppPackageName);
        this.mData = data;
        AnnotationValidations.validate(
                NonNull.class, null, mData);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The destination URL (landing page) where the trigger registration occurred.
     */
    @DataClass.Generated.Member
    public @NonNull Uri getDestinationUrl() {
        return mDestinationUrl;
    }

    /**
     * The app where the trigger registration occurred
     */
    @DataClass.Generated.Member
    public @NonNull String getAppPackageName() {
        return mAppPackageName;
    }

    /**
     * The data to be sent to the isolated service.
     */
    @DataClass.Generated.Member
    public @NonNull byte[] getData() {
        return mData;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeTypedObject(mDestinationUrl, flags);
        dest.writeString(mAppPackageName);
        dest.writeByteArray(mData);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ WebTriggerInputParcel(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        Uri destinationUrl = (Uri) in.readTypedObject(Uri.CREATOR);
        String appPackageName = in.readString();
        byte[] data = in.createByteArray();

        this.mDestinationUrl = destinationUrl;
        AnnotationValidations.validate(
                NonNull.class, null, mDestinationUrl);
        this.mAppPackageName = appPackageName;
        AnnotationValidations.validate(
                NonNull.class, null, mAppPackageName);
        this.mData = data;
        AnnotationValidations.validate(
                NonNull.class, null, mData);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<WebTriggerInputParcel> CREATOR
            = new Parcelable.Creator<WebTriggerInputParcel>() {
        @Override
        public WebTriggerInputParcel[] newArray(int size) {
            return new WebTriggerInputParcel[size];
        }

        @Override
        public WebTriggerInputParcel createFromParcel(@NonNull android.os.Parcel in) {
            return new WebTriggerInputParcel(in);
        }
    };

    /**
     * A builder for {@link WebTriggerInputParcel}
     * @hide
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull Uri mDestinationUrl;
        private @NonNull String mAppPackageName;
        private @NonNull byte[] mData;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         *
         * @param destinationUrl
         *   The destination URL (landing page) where the trigger registration occurred.
         * @param appPackageName
         *   The app where the trigger registration occurred
         * @param data
         *   The data to be sent to the isolated service.
         */
        public Builder(
                @NonNull Uri destinationUrl,
                @NonNull String appPackageName,
                @NonNull byte[] data) {
            mDestinationUrl = destinationUrl;
            AnnotationValidations.validate(
                    NonNull.class, null, mDestinationUrl);
            mAppPackageName = appPackageName;
            AnnotationValidations.validate(
                    NonNull.class, null, mAppPackageName);
            mData = data;
            AnnotationValidations.validate(
                    NonNull.class, null, mData);
        }

        /**
         * The destination URL (landing page) where the trigger registration occurred.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setDestinationUrl(@NonNull Uri value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mDestinationUrl = value;
            return this;
        }

        /**
         * The app where the trigger registration occurred
         */
        @DataClass.Generated.Member
        public @NonNull Builder setAppPackageName(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mAppPackageName = value;
            return this;
        }

        /**
         * The data to be sent to the isolated service.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setData(@NonNull byte... value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mData = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull WebTriggerInputParcel build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8; // Mark builder used

            WebTriggerInputParcel o = new WebTriggerInputParcel(
                    mDestinationUrl,
                    mAppPackageName,
                    mData);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x8) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1707510196470L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/WebTriggerInputParcel.java",
            inputSignatures = "private @android.annotation.NonNull android.net.Uri mDestinationUrl\nprivate @android.annotation.NonNull java.lang.String mAppPackageName\nprivate @android.annotation.NonNull byte[] mData\nclass WebTriggerInputParcel extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genAidl=false, genHiddenBuilder=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
