/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.DataClass;
import com.android.ondevicepersonalization.internal.util.OdpParceledListSlice;

/**
 * Parcelable version of {@link TrainingExamplesOutput}
 *
 * @hide
 */
@DataClass(genAidl = false, genHiddenBuilder = true, genEqualsHashCode = true)
public class TrainingExamplesOutputParcel implements Parcelable {
    /** List of training example records. */
    @Nullable OdpParceledListSlice<TrainingExampleRecord> mTrainingExampleRecords = null;

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/TrainingExamplesOutputParcel.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @DataClass.Generated.Member
    /* package-private */ TrainingExamplesOutputParcel(
            @Nullable OdpParceledListSlice<TrainingExampleRecord> trainingExampleRecords) {
        this.mTrainingExampleRecords = trainingExampleRecords;

        // onConstructed(); // You can define this method to get a callback
    }

    /** List of training example records. */
    @DataClass.Generated.Member
    public @Nullable OdpParceledListSlice<TrainingExampleRecord> getTrainingExampleRecords() {
        return mTrainingExampleRecords;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(TrainingExamplesOutputParcel other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        TrainingExamplesOutputParcel that = (TrainingExamplesOutputParcel) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mTrainingExampleRecords, that.mTrainingExampleRecords);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mTrainingExampleRecords);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mTrainingExampleRecords != null) flg |= 0x1;
        dest.writeByte(flg);
        if (mTrainingExampleRecords != null) dest.writeTypedObject(mTrainingExampleRecords, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() {
        return 0;
    }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    protected TrainingExamplesOutputParcel(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        OdpParceledListSlice<TrainingExampleRecord> trainingExampleRecords =
                (flg & 0x1) == 0
                        ? null
                        : (OdpParceledListSlice) in.readTypedObject(OdpParceledListSlice.CREATOR);

        this.mTrainingExampleRecords = trainingExampleRecords;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<TrainingExamplesOutputParcel>
            CREATOR =
                    new Parcelable.Creator<TrainingExamplesOutputParcel>() {
                        @Override
                        public TrainingExamplesOutputParcel[] newArray(int size) {
                            return new TrainingExamplesOutputParcel[size];
                        }

                        @Override
                        public TrainingExamplesOutputParcel createFromParcel(
                                @android.annotation.NonNull android.os.Parcel in) {
                            return new TrainingExamplesOutputParcel(in);
                        }
                    };

    /**
     * A builder for {@link TrainingExamplesOutputParcel}
     *
     * @hide
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static class Builder {

        private @Nullable OdpParceledListSlice<TrainingExampleRecord> mTrainingExampleRecords;

        private long mBuilderFieldsSet = 0L;

        public Builder() {}

        /** List of training example records. */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setTrainingExampleRecords(
                @android.annotation.NonNull OdpParceledListSlice<TrainingExampleRecord> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mTrainingExampleRecords = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull TrainingExamplesOutputParcel build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mTrainingExampleRecords = null;
            }
            TrainingExamplesOutputParcel o =
                    new TrainingExamplesOutputParcel(mTrainingExampleRecords);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x2) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1704916269933L,
            codegenVersion = "1.0.23",
            sourceFile =
                    "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/TrainingExamplesOutputParcel.java",
            inputSignatures =
                    " @android.annotation.Nullable"
                        + " com.android.ondevicepersonalization.internal.util.OdpParceledListSlice<android.adservices.ondevicepersonalization.TrainingExampleRecord>"
                        + " mTrainingExampleRecords\n"
                        + "class TrainingExamplesOutputParcel extends java.lang.Object implements"
                        + " [android.os.Parcelable]\n"
                        + "@com.android.ondevicepersonalization.internal.util.DataClass(genAidl=false,"
                        + " genHiddenBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}

    // @formatter:on
    // End of generated code

}
