/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Parcelable version of {@link TrainingExamplesInput}
 *
 * @hide
 */
@DataClass(genAidl = false, genHiddenBuilder = true)
public final class TrainingExamplesInputParcel implements Parcelable {
    /** The name of the federated compute population. */
    @NonNull private String mPopulationName = "";

    /**
     * The name of the task within the population. One population may have multiple tasks. The task
     * name can be used to uniquely identify the job.
     */
    @NonNull private String mTaskName = "";

    /** Token used to support the resumption of training. */
    @Nullable private byte[] mResumptionToken = null;

    /** The data collection name to use to create training examples. */
    @Nullable private String mCollectionName;

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/TrainingExamplesInputParcel.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @DataClass.Generated.Member
    /* package-private */ TrainingExamplesInputParcel(
            @NonNull String populationName,
            @NonNull String taskName,
            @Nullable byte[] resumptionToken,
            @Nullable String collectionName) {
        this.mPopulationName = populationName;
        AnnotationValidations.validate(NonNull.class, null, mPopulationName);
        this.mTaskName = taskName;
        AnnotationValidations.validate(NonNull.class, null, mTaskName);
        this.mResumptionToken = resumptionToken;
        this.mCollectionName = collectionName;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The name of the federated compute population.
     */
    @DataClass.Generated.Member
    public @NonNull String getPopulationName() {
        return mPopulationName;
    }

    /**
     * The name of the task within the population. One population may have multiple tasks. The task
     * name can be used to uniquely identify the job.
     */
    @DataClass.Generated.Member
    public @NonNull String getTaskName() {
        return mTaskName;
    }

    /**
     * Token used to support the resumption of training.
     */
    @DataClass.Generated.Member
    public @Nullable byte[] getResumptionToken() {
        return mResumptionToken;
    }

    /** The data collection name to use to create training examples. */
    @DataClass.Generated.Member
    public @Nullable String getCollectionName() {
        return mCollectionName;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mCollectionName != null) flg |= 0x8;
        dest.writeByte(flg);
        dest.writeString(mPopulationName);
        dest.writeString(mTaskName);
        dest.writeByteArray(mResumptionToken);
        if (mCollectionName != null) dest.writeString(mCollectionName);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ TrainingExamplesInputParcel(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        String populationName = in.readString();
        String taskName = in.readString();
        byte[] resumptionToken = in.createByteArray();
        String collectionName = (flg & 0x8) == 0 ? null : in.readString();

        this.mPopulationName = populationName;
        AnnotationValidations.validate(NonNull.class, null, mPopulationName);
        this.mTaskName = taskName;
        AnnotationValidations.validate(
                NonNull.class, null, mTaskName);
        this.mResumptionToken = resumptionToken;
        this.mCollectionName = collectionName;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<TrainingExamplesInputParcel> CREATOR =
            new Parcelable.Creator<TrainingExamplesInputParcel>() {
                @Override
                public TrainingExamplesInputParcel[] newArray(int size) {
                    return new TrainingExamplesInputParcel[size];
                }

                @Override
                public TrainingExamplesInputParcel createFromParcel(@NonNull android.os.Parcel in) {
                    return new TrainingExamplesInputParcel(in);
                }
            };

    /**
     * A builder for {@link TrainingExamplesInputParcel}
     * @hide
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull String mPopulationName;
        private @NonNull String mTaskName;
        private @Nullable byte[] mResumptionToken;
        private @Nullable String mCollectionName;

        private long mBuilderFieldsSet = 0L;

        public Builder() {}

        /**
         * The name of the federated compute population.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setPopulationName(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mPopulationName = value;
            return this;
        }

        /**
         * The name of the task within the population. One population may have multiple tasks. The
         * task name can be used to uniquely identify the job.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setTaskName(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mTaskName = value;
            return this;
        }

        /**
         * Token used to support the resumption of training.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setResumptionToken(@NonNull byte... value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mResumptionToken = value;
            return this;
        }

        /** The data collection name to use to create training examples. */
        @DataClass.Generated.Member
        public @NonNull Builder setCollectionName(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mCollectionName = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull TrainingExamplesInputParcel build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mPopulationName = "";
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mTaskName = "";
            }
            if ((mBuilderFieldsSet & 0x4) == 0) {
                mResumptionToken = null;
            }
            TrainingExamplesInputParcel o =
                    new TrainingExamplesInputParcel(
                            mPopulationName, mTaskName, mResumptionToken, mCollectionName);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x10) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1717526633865L,
            codegenVersion = "1.0.23",
            sourceFile =
                    "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/TrainingExamplesInputParcel.java",
            inputSignatures =
                    "private @android.annotation.NonNull java.lang.String mPopulationName\nprivate @android.annotation.NonNull java.lang.String mTaskName\nprivate @android.annotation.Nullable byte[] mResumptionToken\nprivate @android.annotation.Nullable java.lang.String mCollectionName\nclass TrainingExamplesInputParcel extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genAidl=false, genHiddenBuilder=true)")
    @Deprecated
    private void __metadata() {}

    //@formatter:on
    // End of generated code

}
